/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.Menu;
import com.kuaike.scrm.dal.permission.entity.MenuCustomized;
import com.kuaike.scrm.dal.permission.mapper.MenuCustomizedMapper;
import com.kuaike.scrm.dal.permission.mapper.MenuMapper;
import com.kuaike.scrm.dal.permission.mapper.MenuPermissionMapper;
import com.kuaike.scrm.dal.permission.mapper.PermissionMapper;
import com.kuaike.scrm.system.dto.request.DashboardListReqDto;
import com.kuaike.scrm.system.dto.request.DashboardModReqDto;
import com.kuaike.scrm.system.dto.request.DashboardResetReqDto;
import com.kuaike.scrm.system.dto.request.MenuAddReqDto;
import com.kuaike.scrm.system.dto.request.MenuPermissionReqDto;
import com.kuaike.scrm.system.dto.response.DashboardMenuRespDto;
import com.kuaike.scrm.system.dto.response.MenuPermissionRespDto;
import com.kuaike.scrm.system.dto.response.MenuRespDto;
import com.kuaike.scrm.system.dto.response.PackageMenuRespDto;
import com.kuaike.scrm.system.service.MenuService;
import com.kuaike.scrm.system.service.PackageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final Logger log = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private MenuCustomizedMapper menuCustomizedMapper;
    @Autowired
    private MenuPermissionMapper menuPermissionMapper;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private PackageService packageService;

    @Override
    public List<MenuRespDto> treeList() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("treeList operatorId={}", (Object)currentUserInfo.getId());
        Set<String> menuCodes = this.getPackageMenuCodes(currentUserInfo.getBizId());
        if (CollectionUtils.isEmpty(menuCodes)) {
            log.warn("\u5546\u6237:{}\u6ca1\u6709\u914d\u7f6e\u83dc\u5355", (Object)currentUserInfo.getBizId());
            return Collections.emptyList();
        }
        List versionMenus = this.menuMapper.selectByCodes(menuCodes);
        if (CollectionUtils.isEmpty((Collection)versionMenus)) {
            log.warn("\u6839\u636e\u83dc\u5355\u7f16\u7801:{}\u672a\u83b7\u53d6\u5230\u83dc\u5355", menuCodes);
            return Collections.emptyList();
        }
        return MenuRespDto.buildMenuTrees(MenuRespDto.from(versionMenus));
    }

    @Override
    public List<MenuRespDto> systemMenus() {
        List menus = this.menuMapper.getAllMenu();
        if (CollectionUtils.isEmpty((Collection)menus)) {
            return Collections.emptyList();
        }
        return MenuRespDto.buildMenuTrees(MenuRespDto.from(menus));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setMenuPermissions(MenuPermissionReqDto reqDto) {
        log.info("set menu permissions, reqDto:{}", (Object)reqDto);
        reqDto.validate();
        Boolean menuIsExist = this.menuMapper.checkMenuIsExist(reqDto.getMenuCode());
        Preconditions.checkArgument((boolean)menuIsExist, (Object)"\u83dc\u5355\u4e0d\u5b58\u5728");
        int count = this.permissionMapper.getCountByPermissionCodes(reqDto.getPermissionCodes());
        Preconditions.checkArgument((count == reqDto.getPermissionCodes().size() ? 1 : 0) != 0, (Object)"\u6743\u9650\u7f16\u7801\u4e0d\u5bf9");
        Menu menu = this.menuMapper.selectByCode(reqDto.getMenuCode());
        Menu m = new Menu();
        m.setId(menu.getId());
        m.setName(reqDto.getName());
        m.setRemark(reqDto.getRemark());
        if (reqDto.getIsDashboard() != null && reqDto.getIsDashboard() == 1) {
            m.setIsDashboard(Integer.valueOf(1));
            m.setUrl(reqDto.getUrl());
        } else {
            m.setIsDashboard(Integer.valueOf(0));
            m.setUrl("");
        }
        m.setUpdateBy(Long.valueOf(-1L));
        m.setUpdateTime(new Date());
        this.menuMapper.updateByPrimaryKeySelective((Object)m);
        this.menuPermissionMapper.deleteByMenuCode(reqDto.getMenuCode());
        if (CollectionUtils.isNotEmpty(reqDto.getPermissionCodes())) {
            this.menuPermissionMapper.save(reqDto.getMenuCode(), reqDto.getPermissionCodes());
        }
    }

    @Override
    public MenuPermissionRespDto getMenuPermissions(MenuPermissionReqDto reqDto) {
        log.info("getMenuPermissions, reqDto:{}", (Object)reqDto);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getMenuCode()), (Object)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List permissionCodes = this.menuPermissionMapper.getPermissionCodesByMenuCode(reqDto.getMenuCode());
        MenuPermissionRespDto menuPermissionRespDto = new MenuPermissionRespDto();
        menuPermissionRespDto.setPermissionCodes(permissionCodes);
        return menuPermissionRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMenu(MenuAddReqDto reqDto) {
        log.info("addMenu, reqDto:{}", (Object)reqDto);
        reqDto.validate();
        Boolean menuIsExist = this.menuMapper.checkMenuIsExist(reqDto.getMenuCode());
        Preconditions.checkArgument((menuIsExist == false ? 1 : 0) != 0, (Object)"\u83dc\u5355\u5df2\u5b58\u5728");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getParentCode())) {
            Boolean pMenuIsExist = this.menuMapper.checkPMenuIsExist(reqDto.getParentCode());
            Preconditions.checkArgument((boolean)pMenuIsExist, (Object)"\u7236\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty(reqDto.getPermissionCodes())) {
            int count = this.permissionMapper.getCountByPermissionCodes(reqDto.getPermissionCodes());
            Preconditions.checkArgument((count == reqDto.getPermissionCodes().size() ? 1 : 0) != 0, (Object)"\u6743\u9650\u7f16\u7801\u4e0d\u5bf9");
        }
        Menu menu = new Menu();
        menu.setName(reqDto.getName());
        menu.setCode(reqDto.getMenuCode());
        menu.setPCode(StringUtils.isNotBlank((CharSequence)reqDto.getParentCode()) ? reqDto.getParentCode() : "");
        menu.setRemark(reqDto.getRemark());
        if (reqDto.getIsDashboard() != null && reqDto.getIsDashboard() == 1) {
            menu.setIsDashboard(Integer.valueOf(1));
            menu.setUrl(reqDto.getUrl());
        } else {
            menu.setIsDashboard(Integer.valueOf(0));
            menu.setUrl("");
        }
        menu.setIsDeleted(Integer.valueOf(0));
        menu.setCreateBy(Long.valueOf(-1L));
        menu.setUpdateBy(Long.valueOf(-1L));
        menu.setCreateTime(new Date());
        menu.setUpdateTime(new Date());
        this.menuMapper.insertSelective((Object)menu);
        if (CollectionUtils.isNotEmpty(reqDto.getPermissionCodes())) {
            this.menuPermissionMapper.save(reqDto.getMenuCode(), reqDto.getPermissionCodes());
        }
    }

    @Override
    public List<DashboardMenuRespDto> getCurrentDashboardMenu() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("get current dashboard menu, operatorId={}", (Object)currentUserInfo.getId());
        Long bizId = LoginUtils.getCurrentUserBizId();
        Set menuCodes = currentUserInfo.getMenuCodes();
        if (CollectionUtils.isEmpty((Collection)menuCodes)) {
            log.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u83dc\u5355, bizId:{}, userId:{}", (Object)bizId, (Object)currentUserInfo.getId());
            return Collections.emptyList();
        }
        List menus = this.menuMapper.selectDashboardMenuByCodes((Collection)menuCodes);
        if (CollectionUtils.isEmpty((Collection)menus)) {
            log.warn("\u6839\u636e\u83dc\u5355\u7f16\u7801:{}\u672a\u83b7\u53d6\u5230\u83dc\u5355", (Object)menuCodes);
            return Collections.emptyList();
        }
        List codes = menus.stream().map(Menu::getCode).collect(Collectors.toList());
        Map customizedUrl = this.menuCustomizedMapper.selectByCodes(bizId, codes);
        log.info("\u5546\u6237\u81ea\u5b9a\u4e49\u83dc\u5355url:{}", (Object)customizedUrl);
        ArrayList result = Lists.newArrayListWithCapacity((int)menus.size());
        for (Menu u : menus) {
            DashboardMenuRespDto dto = this.newDashboardMenuRespDto(u, customizedUrl);
            result.add(dto);
        }
        return result;
    }

    private Set<String> getPackageMenuCodes(Long bizId) {
        log.info("get package menu code, bizId:{}", (Object)bizId);
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        Set<String> menuCodes = new HashSet<String>();
        String pkgIds = biz.getPkgIds();
        log.info("biz menu pkgIds:{}", (Object)pkgIds);
        if (StringUtils.isNotBlank((CharSequence)pkgIds)) {
            ArrayList<Long> pkgIdList = new ArrayList<Long>();
            if (pkgIds.contains(",")) {
                for (String s : pkgIds.split(",")) {
                    Long parseLong = Long.parseLong(s);
                    pkgIdList.add(parseLong);
                }
            } else {
                pkgIdList.add(Long.parseLong(pkgIds));
            }
            PackageMenuRespDto respDto = this.packageService.packageMenuInfo(pkgIdList);
            if (respDto != null) {
                menuCodes = respDto.getMenuCodes();
            }
        }
        return menuCodes;
    }

    @Override
    public List<DashboardMenuRespDto> getBizDashboardMenu(DashboardListReqDto params) {
        List menus;
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        log.info("query biz dashboard menu, bizId:{}", (Object)params.getBizId());
        if (params.getIsPackageOnly() == null || params.getIsPackageOnly() == 0) {
            menus = this.menuMapper.selectAllDashboardMenu();
        } else {
            Set<String> menuCodes = this.getPackageMenuCodes(params.getBizId());
            if (CollectionUtils.isEmpty(menuCodes)) {
                log.warn("\u5546\u6237:{}\u6ca1\u6709\u914d\u7f6e\u83dc\u5355", (Object)params.getBizId());
                return Collections.emptyList();
            }
            menus = this.menuMapper.selectDashboardMenuByCodes(menuCodes);
        }
        if (CollectionUtils.isEmpty((Collection)menus)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u83dc\u5355, bizId:{}", (Object)params.getBizId());
            return Collections.emptyList();
        }
        List codes = menus.stream().map(Menu::getCode).collect(Collectors.toList());
        Map customizedUrl = this.menuCustomizedMapper.selectByCodes(params.getBizId(), codes);
        log.info("\u5546\u6237\u81ea\u5b9a\u4e49\u83dc\u5355url:{}", (Object)customizedUrl);
        ArrayList result = Lists.newArrayListWithCapacity((int)menus.size());
        for (Menu u : menus) {
            DashboardMenuRespDto dto = this.newDashboardMenuRespDto(u, customizedUrl);
            result.add(dto);
        }
        return result;
    }

    private DashboardMenuRespDto newDashboardMenuRespDto(Menu menu, Map<String, String> customizedUrl) {
        DashboardMenuRespDto dto = new DashboardMenuRespDto();
        dto.setCode(menu.getCode());
        dto.setName(menu.getName());
        dto.setUrl(menu.getUrl());
        dto.setIsCustomized(0);
        if (customizedUrl == null) {
            return dto;
        }
        String url = customizedUrl.get(menu.getCode());
        if (StringUtils.isNotBlank((CharSequence)url)) {
            dto.setUrl(url);
            dto.setIsCustomized(1);
        }
        return dto;
    }

    @Override
    public void modifyBizDashboardUrl(DashboardModReqDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCode()), (Object)"\u83dc\u5355\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        log.info("mod biz dashboard menu, params:{}", (Object)params);
        Boolean menuIsExist = this.menuMapper.checkMenuIsExist(params.getCode());
        Preconditions.checkArgument((boolean)menuIsExist, (Object)("\u83dc\u5355\u4e0d\u5b58\u5728:" + params.getCode()));
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)params.getUrl())) {
            this.menuCustomizedMapper.deleteByCode(params.getBizId(), params.getCode());
        } else {
            MenuCustomized customized = this.menuCustomizedMapper.selectByCode(params.getBizId(), params.getCode());
            if (customized == null) {
                customized = new MenuCustomized();
                customized.setBizId(params.getBizId());
                customized.setCode(params.getCode());
                customized.setUrl(params.getUrl());
                customized.setCreateBy(Long.valueOf(-1L));
                customized.setCreateTime(now);
                customized.setUpdateBy(Long.valueOf(-1L));
                customized.setUpdateTime(now);
                this.menuCustomizedMapper.insertSelective((Object)customized);
            } else {
                customized.setUrl(params.getUrl());
                customized.setUpdateBy(Long.valueOf(-1L));
                customized.setUpdateTime(now);
                this.menuCustomizedMapper.updateByPrimaryKeySelective((Object)customized);
            }
        }
    }

    @Override
    public void resetBizDashboardUrl(DashboardResetReqDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCode()), (Object)"\u83dc\u5355\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        log.info("reset biz dashboard menu, params:{}", (Object)params);
        Boolean menuIsExist = this.menuMapper.checkMenuIsExist(params.getCode());
        Preconditions.checkArgument((boolean)menuIsExist, (Object)("\u83dc\u5355\u4e0d\u5b58\u5728:" + params.getCode()));
        this.menuCustomizedMapper.deleteByCode(params.getBizId(), params.getCode());
    }
}

