/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.response;

import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.permission.entity.Menu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class MenuRespDto
implements Serializable {
    private static final long serialVersionUID = 111669474930084039L;
    private Long id;
    private String name;
    private String code;
    private Integer isDashboard;
    private String url;
    private List<MenuRespDto> children;
    private String pCode;

    public static List<MenuRespDto> buildMenuTrees(List<MenuRespDto> menus) {
        if (CollectionUtils.isEmpty(menus)) {
            return Lists.newArrayList();
        }
        ArrayList menuTrees = Lists.newArrayList();
        Map map = menus.stream().collect(Collectors.toMap(a -> a.getCode(), Function.identity()));
        for (MenuRespDto MenuRespDto2 : menus) {
            if (!map.containsKey(MenuRespDto2.getPCode())) {
                menuTrees.add(MenuRespDto2);
                continue;
            }
            MenuRespDto parent = (MenuRespDto)map.get(MenuRespDto2.getPCode());
            parent.getChildren().add(MenuRespDto2);
        }
        return menuTrees;
    }

    public static List<MenuRespDto> from(List<Menu> menus) {
        ArrayList menuRespDtos = Lists.newArrayList();
        for (Menu menu : menus) {
            menuRespDtos.add(MenuRespDto.from(menu));
        }
        return menuRespDtos;
    }

    public static MenuRespDto from(Menu menu) {
        MenuRespDto dto = new MenuRespDto();
        dto.setId(menu.getId());
        dto.setName(menu.getName());
        dto.setCode(menu.getCode());
        dto.setChildren(Lists.newArrayList());
        dto.setPCode(menu.getPCode());
        if (menu.getIsDashboard() != null && menu.getIsDashboard() == 1) {
            dto.setIsDashboard(1);
            dto.setUrl(menu.getUrl());
        } else {
            dto.setIsDashboard(0);
            dto.setUrl("");
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getIsDashboard() {
        return this.isDashboard;
    }

    public String getUrl() {
        return this.url;
    }

    public List<MenuRespDto> getChildren() {
        return this.children;
    }

    public String getPCode() {
        return this.pCode;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setIsDashboard(Integer isDashboard) {
        this.isDashboard = isDashboard;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setChildren(List<MenuRespDto> children) {
        this.children = children;
    }

    public void setPCode(String pCode) {
        this.pCode = pCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuRespDto)) {
            return false;
        }
        MenuRespDto other = (MenuRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$isDashboard = this.getIsDashboard();
        Integer other$isDashboard = other.getIsDashboard();
        if (this$isDashboard == null ? other$isDashboard != null : !((Object)this$isDashboard).equals(other$isDashboard)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<MenuRespDto> this$children = this.getChildren();
        List<MenuRespDto> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        String this$pCode = this.getPCode();
        String other$pCode = other.getPCode();
        return !(this$pCode == null ? other$pCode != null : !this$pCode.equals(other$pCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MenuRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $isDashboard = this.getIsDashboard();
        result = result * 59 + ($isDashboard == null ? 43 : ((Object)$isDashboard).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<MenuRespDto> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        String $pCode = this.getPCode();
        result = result * 59 + ($pCode == null ? 43 : $pCode.hashCode());
        return result;
    }

    public String toString() {
        return "MenuRespDto(id=" + this.getId() + ", name=" + this.getName() + ", code=" + this.getCode() + ", isDashboard=" + this.getIsDashboard() + ", url=" + this.getUrl() + ", children=" + this.getChildren() + ", pCode=" + this.getPCode() + ")";
    }
}

