/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.channel.dto.ChannelQueryParams;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ChannelReqDto {
    private String id;
    private String name;
    private String desc;
    private Integer level;
    private Integer isEnabled;
    private PageDto pageDto;
    private Integer showInner;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAddParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.level == null) {
            this.level = 1;
        } else {
            Preconditions.checkArgument((this.level > 0 ? 1 : 0) != 0, (Object)"\u6570\u636e\u7b49\u7ea7\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public void validateModeParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.id), (Object)"\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.level == null) {
            this.level = 1;
        } else {
            Preconditions.checkArgument((this.level > 0 ? 1 : 0) != 0, (Object)"\u6570\u636e\u7b49\u7ea7\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public void validateDelParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.id), (Object)"\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ChannelQueryParams convert2QueryCondition(Long bizId, String corpId) {
        ChannelQueryParams channelQueryParams = new ChannelQueryParams();
        channelQueryParams.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        channelQueryParams.setLimit(this.pageDto.getPageSize());
        channelQueryParams.setBizId(bizId);
        channelQueryParams.setCorpId(corpId);
        channelQueryParams.setIsEnabled(this.getIsEnabled());
        return channelQueryParams;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getLevel() {
        return this.level;
    }

    public Integer getIsEnabled() {
        return this.isEnabled;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public Integer getShowInner() {
        return this.showInner;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setIsEnabled(Integer isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setShowInner(Integer showInner) {
        this.showInner = showInner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelReqDto)) {
            return false;
        }
        ChannelReqDto other = (ChannelReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Integer this$isEnabled = this.getIsEnabled();
        Integer other$isEnabled = other.getIsEnabled();
        if (this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled)) {
            return false;
        }
        Integer this$showInner = this.getShowInner();
        Integer other$showInner = other.getShowInner();
        if (this$showInner == null ? other$showInner != null : !((Object)this$showInner).equals(other$showInner)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Integer $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        Integer $showInner = this.getShowInner();
        result = result * 59 + ($showInner == null ? 43 : ((Object)$showInner).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "ChannelReqDto(id=" + this.getId() + ", name=" + this.getName() + ", desc=" + this.getDesc() + ", level=" + this.getLevel() + ", isEnabled=" + this.getIsEnabled() + ", pageDto=" + this.getPageDto() + ", showInner=" + this.getShowInner() + ")";
    }
}

