/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.dto;

import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.sms.entity.SmsTemplate;
import com.kuaike.scrm.dal.sms.entity.SmsTemplateUseScope;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.sms.service.impl.AuditStatusEnum;
import com.kuaike.scrm.sms.service.impl.SmsTemplateUseScopeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class SmsTemplateRespDto {
    private Long id;
    private String content;
    private Date createTime;
    private String name;
    private String createName;
    private String signature;
    private EnumDto auditStatus;
    private String bjyTemplateId;
    private List<StrIdAndNameDto> deptDtos;
    private List<StrIdAndNameDto> userDtos;

    public static SmsTemplateRespDto from(SmsTemplate template, List<SmsTemplateUseScope> useScopes, Map<Long, User> userId2UserMap, Map<Long, Organization> orgId2OrganizationMap) {
        SmsTemplateRespDto dto = new SmsTemplateRespDto();
        dto.setId(template.getId());
        dto.setCreateTime(template.getCreateTime());
        dto.setCreateName(template.getCreateName());
        dto.setContent(template.getContent());
        dto.setName(template.getName());
        dto.setSignature(template.getSignatureId());
        dto.setBjyTemplateId(template.getBjyTemplateId());
        AuditStatusEnum auditStatus = AuditStatusEnum.get(template.getAuditStatus());
        dto.setAuditStatus(EnumDto.from((EnumService)auditStatus));
        if (CollectionUtils.isEmpty(useScopes)) {
            return dto;
        }
        ArrayList deptDtos = Lists.newArrayList();
        ArrayList userDtos = Lists.newArrayList();
        for (SmsTemplateUseScope useScope : useScopes) {
            StrIdAndNameDto strIdAndNameDto = new StrIdAndNameDto();
            if (SmsTemplateUseScopeEnum.USER.getValue() == useScope.getFkType().intValue()) {
                if (!MapUtils.isNotEmpty(userId2UserMap) || !userId2UserMap.containsKey(useScope.getFkId())) continue;
                User user = userId2UserMap.get(useScope.getFkId());
                strIdAndNameDto.setId(user.getNum());
                strIdAndNameDto.setName(user.getName());
                userDtos.add(strIdAndNameDto);
                continue;
            }
            if (!MapUtils.isNotEmpty(orgId2OrganizationMap) || !orgId2OrganizationMap.containsKey(useScope.getFkId())) continue;
            Organization organization = orgId2OrganizationMap.get(useScope.getFkId());
            strIdAndNameDto.setId(organization.getNum());
            strIdAndNameDto.setName(organization.getName());
            deptDtos.add(strIdAndNameDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)deptDtos)) {
            dto.setDeptDtos(deptDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)userDtos)) {
            dto.setUserDtos(userDtos);
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getName() {
        return this.name;
    }

    public String getCreateName() {
        return this.createName;
    }

    public String getSignature() {
        return this.signature;
    }

    public EnumDto getAuditStatus() {
        return this.auditStatus;
    }

    public String getBjyTemplateId() {
        return this.bjyTemplateId;
    }

    public List<StrIdAndNameDto> getDeptDtos() {
        return this.deptDtos;
    }

    public List<StrIdAndNameDto> getUserDtos() {
        return this.userDtos;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setAuditStatus(EnumDto auditStatus) {
        this.auditStatus = auditStatus;
    }

    public void setBjyTemplateId(String bjyTemplateId) {
        this.bjyTemplateId = bjyTemplateId;
    }

    public void setDeptDtos(List<StrIdAndNameDto> deptDtos) {
        this.deptDtos = deptDtos;
    }

    public void setUserDtos(List<StrIdAndNameDto> userDtos) {
        this.userDtos = userDtos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsTemplateRespDto)) {
            return false;
        }
        SmsTemplateRespDto other = (SmsTemplateRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$createName = this.getCreateName();
        String other$createName = other.getCreateName();
        if (this$createName == null ? other$createName != null : !this$createName.equals(other$createName)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        EnumDto this$auditStatus = this.getAuditStatus();
        EnumDto other$auditStatus = other.getAuditStatus();
        if (this$auditStatus == null ? other$auditStatus != null : !this$auditStatus.equals(other$auditStatus)) {
            return false;
        }
        String this$bjyTemplateId = this.getBjyTemplateId();
        String other$bjyTemplateId = other.getBjyTemplateId();
        if (this$bjyTemplateId == null ? other$bjyTemplateId != null : !this$bjyTemplateId.equals(other$bjyTemplateId)) {
            return false;
        }
        List<StrIdAndNameDto> this$deptDtos = this.getDeptDtos();
        List<StrIdAndNameDto> other$deptDtos = other.getDeptDtos();
        if (this$deptDtos == null ? other$deptDtos != null : !((Object)this$deptDtos).equals(other$deptDtos)) {
            return false;
        }
        List<StrIdAndNameDto> this$userDtos = this.getUserDtos();
        List<StrIdAndNameDto> other$userDtos = other.getUserDtos();
        return !(this$userDtos == null ? other$userDtos != null : !((Object)this$userDtos).equals(other$userDtos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsTemplateRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $createName = this.getCreateName();
        result = result * 59 + ($createName == null ? 43 : $createName.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        EnumDto $auditStatus = this.getAuditStatus();
        result = result * 59 + ($auditStatus == null ? 43 : $auditStatus.hashCode());
        String $bjyTemplateId = this.getBjyTemplateId();
        result = result * 59 + ($bjyTemplateId == null ? 43 : $bjyTemplateId.hashCode());
        List<StrIdAndNameDto> $deptDtos = this.getDeptDtos();
        result = result * 59 + ($deptDtos == null ? 43 : ((Object)$deptDtos).hashCode());
        List<StrIdAndNameDto> $userDtos = this.getUserDtos();
        result = result * 59 + ($userDtos == null ? 43 : ((Object)$userDtos).hashCode());
        return result;
    }

    public String toString() {
        return "SmsTemplateRespDto(id=" + this.getId() + ", content=" + this.getContent() + ", createTime=" + this.getCreateTime() + ", name=" + this.getName() + ", createName=" + this.getCreateName() + ", signature=" + this.getSignature() + ", auditStatus=" + this.getAuditStatus() + ", bjyTemplateId=" + this.getBjyTemplateId() + ", deptDtos=" + this.getDeptDtos() + ", userDtos=" + this.getUserDtos() + ")";
    }
}

