/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.dto.SmsTemplateQueryParams;
import com.kuaike.scrm.dal.sms.entity.SmsTemplate;
import com.kuaike.scrm.dal.sms.entity.SmsTemplateCriteria;
import com.kuaike.scrm.dal.sms.entity.SmsTemplateUseScope;
import com.kuaike.scrm.dal.sms.mapper.SmsTemplateMapper;
import com.kuaike.scrm.dal.sms.mapper.SmsTemplateUseScopeMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.sms.dto.BjyTemplateDto;
import com.kuaike.scrm.sms.dto.SmsTemplateOptionRespDto;
import com.kuaike.scrm.sms.dto.SmsTemplateReqDto;
import com.kuaike.scrm.sms.dto.SmsTemplateRespDto;
import com.kuaike.scrm.sms.service.SmsTemplateService;
import com.kuaike.scrm.sms.service.impl.AuditStatusEnum;
import com.kuaike.scrm.sms.service.impl.SmsTemplateUseScopeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SmsTemplateServiceImpl
implements SmsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SmsTemplateServiceImpl.class);
    private static final int ID_LIMIT = 100;
    private static final String TEMPLATE_ID = "template_id";
    @Value(value="${app.sms.appCode}")
    private String appCode;
    @Value(value="${app.sms.templateUploadUrl}")
    private String templateUploadUrl;
    @Value(value="${app.sms.templateDeleteUrl}")
    private String templateDeleteUrl;
    @Value(value="${app.sms.templateInfoUrl}")
    private String templateInfoUrl;
    @Resource
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private IdGen idGen;
    @Resource
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private SmsTemplateUseScopeMapper useScopeMapper;
    @Resource
    private OrgService orgService;

    @Override
    public void addTemplate(SmsTemplateReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateAddParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("addTemplate reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        Map<String, String> params = this.getTemplateUploadParams(reqDto.getContent());
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.templateUploadUrl, params);
        String bjyTemplateId = jsonObject.getJSONObject("data").getString(TEMPLATE_ID);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bjyTemplateId), (Object)"\u6a21\u677f\u4e0a\u4f20\u5931\u8d25");
        SmsTemplate smsTemplate = reqDto.backward(this.idGen.getNum(), bjyTemplateId);
        this.smsTemplateMapper.insertSelective((Object)smsTemplate);
        this.addSaveUseScope(reqDto.getDeptIds(), reqDto.getUserIds(), currentUserInfo, smsTemplate.getId());
    }

    @Override
    public List<SmsTemplateRespDto> templateList(SmsTemplateReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        SmsTemplateQueryParams params = reqDto.to(bizId);
        List smsTemplates = this.smsTemplateMapper.queryList(params);
        ArrayList<SmsTemplateRespDto> resultList = new ArrayList<SmsTemplateRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)smsTemplates)) {
            List smsTemplateIds = smsTemplates.stream().map(SmsTemplate::getId).collect(Collectors.toList());
            List useScopes = this.useScopeMapper.selectByBizIdAndSmsTemplateIds(bizId, smsTemplateIds);
            HashMap smsTemplateId2UseScopesMap = Maps.newHashMap();
            HashSet userIds = Sets.newHashSet();
            HashSet deptIds = Sets.newHashSet();
            for (SmsTemplateUseScope useScope : useScopes) {
                Long smsTemplateId = useScope.getSmsTemplateId();
                List smsTemplateUseScopes = smsTemplateId2UseScopesMap.containsKey(useScope.getSmsTemplateId()) ? (List)smsTemplateId2UseScopesMap.get(useScope.getSmsTemplateId()) : Lists.newArrayList();
                smsTemplateUseScopes.add(useScope);
                smsTemplateId2UseScopesMap.put(smsTemplateId, smsTemplateUseScopes);
                if (SmsTemplateUseScopeEnum.USER.getValue() == useScope.getFkType().intValue()) {
                    userIds.add(useScope.getFkId());
                    continue;
                }
                deptIds.add(useScope.getFkId());
            }
            Map<Object, Object> userId2UserMap = Maps.newHashMap();
            Map<Object, Object> orgId2OrganizationMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                List users = this.userMapper.getUserInfoByIds((Collection)userIds);
                userId2UserMap = users.stream().collect(Collectors.toMap(User::getId, Functions.identity()));
            }
            if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
                List organizations = this.organizationMapper.queryByIds((Collection)deptIds);
                orgId2OrganizationMap = organizations.stream().collect(Collectors.toMap(Organization::getId, Functions.identity()));
            }
            for (SmsTemplate smsTemplate : smsTemplates) {
                resultList.add(SmsTemplateRespDto.from(smsTemplate, (List)smsTemplateId2UseScopesMap.get(smsTemplate.getId()), userId2UserMap, orgId2OrganizationMap));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.smsTemplateMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }

    @Override
    public List<SmsTemplateOptionRespDto> optionList() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        SmsTemplateQueryParams params = new SmsTemplateQueryParams();
        params.setBizId(userInfo.getBizId());
        params.setAuditStatus(Integer.valueOf(AuditStatusEnum.PASS.getValue()));
        params.setUserId(userInfo.getId());
        User user = this.userMapper.getUserInfoById(userInfo.getId());
        if (Objects.nonNull(user.getNodeId())) {
            ArrayList nodeIds = Lists.newArrayList();
            nodeIds.add(user.getNodeId());
            List pidIds = this.orgService.getParentNodeIdsByBizIdAndNodeId(userInfo.getBizId(), user.getNodeId());
            if (CollectionUtils.isNotEmpty((Collection)pidIds)) {
                nodeIds.addAll(pidIds);
            }
            params.setNodeIds((List)nodeIds);
        }
        List smsTemplates = this.smsTemplateMapper.optionList(params);
        ArrayList<SmsTemplateOptionRespDto> resultList = new ArrayList<SmsTemplateOptionRespDto>();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)smsTemplates)) {
            for (SmsTemplate smsTemplate : smsTemplates) {
                resultList.add(SmsTemplateOptionRespDto.to(smsTemplate));
            }
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modTemplate(SmsTemplateReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateAddParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        log.info("mod template : {}", (Object)reqDto);
        SmsTemplate template = SmsTemplate.builder().id(reqDto.getId()).bizId(bizId).build();
        SmsTemplate smsTemplate = (SmsTemplate)this.smsTemplateMapper.selectOne((Object)template);
        if (ObjectUtils.isEmpty((Object)smsTemplate)) {
            log.info("template not found, bizId:{}, id:{}", (Object)template.getBizId(), (Object)template.getId());
            return;
        }
        if (!smsTemplate.getContent().equals(reqDto.getContent())) {
            Map<String, String> uploadParams;
            JSONObject jsonObject;
            String bjyTemplateId;
            if (StringUtils.isNotBlank((CharSequence)template.getBjyTemplateId())) {
                Map<String, String> deleteParams = this.getTemplateDeleteParams(smsTemplate.getBjyTemplateId());
                this.bjyPartnerService.bjyPost(bizId, this.templateDeleteUrl, deleteParams);
            }
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)(bjyTemplateId = (jsonObject = this.bjyPartnerService.bjyPost(bizId, this.templateUploadUrl, uploadParams = this.getTemplateUploadParams(reqDto.getContent()))).getJSONObject("data").getString(TEMPLATE_ID))) ? 1 : 0) != 0, (Object)"\u6a21\u677f\u4e0a\u4f20\u5931\u8d25");
            smsTemplate.setBjyTemplateId(bjyTemplateId);
            smsTemplate.setAuditStatus(Integer.valueOf(AuditStatusEnum.WAIT.getValue()));
        }
        smsTemplate.setContent(reqDto.getContent());
        smsTemplate.setSignatureId(reqDto.getSignatureId());
        smsTemplate.setName(reqDto.getName());
        smsTemplate.setUpdateTime(new Date());
        smsTemplate.setUpdateBy(currentUserInfo.getId());
        smsTemplate.setWeworkAcquisitionLinks(JSONObject.toJSONString(reqDto.getAcquisitionLinkIds()));
        this.smsTemplateMapper.updateByPrimaryKey((Object)smsTemplate);
        this.useScopeMapper.deleteByBizIdAndSmsTemplateId(bizId, smsTemplate.getId());
        this.addSaveUseScope(reqDto.getDeptIds(), reqDto.getUserIds(), currentUserInfo, smsTemplate.getId());
    }

    @Override
    public void delTemplate(SmsTemplateReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("delTemplate reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        SmsTemplate template = SmsTemplate.builder().id(reqDto.getId()).bizId(bizId).build();
        SmsTemplate smsTemplate = (SmsTemplate)this.smsTemplateMapper.selectOne((Object)template);
        if (ObjectUtils.isEmpty((Object)smsTemplate)) {
            log.info("template not found, bizId:{}, id:{}", (Object)template.getBizId(), (Object)template.getId());
            return;
        }
        smsTemplate.setIsDeleted(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)template.getBjyTemplateId())) {
            Map<String, String> params = this.getTemplateDeleteParams(template.getBjyTemplateId());
            this.bjyPartnerService.bjyPost(bizId, this.templateDeleteUrl, params);
        }
        this.smsTemplateMapper.updateByPrimaryKey((Object)smsTemplate);
        this.useScopeMapper.deleteByBizIdAndSmsTemplateId(bizId, smsTemplate.getId());
    }

    @Override
    public void updateAuditStatus() {
        log.info("updateAuditStatus ");
        SmsTemplate template = SmsTemplate.builder().auditStatus(Integer.valueOf(AuditStatusEnum.WAIT.getValue())).build();
        List smsTemplates = this.smsTemplateMapper.select((Object)template);
        if (CollectionUtils.isEmpty((Collection)smsTemplates)) {
            log.info("wait audit template not found, return");
            return;
        }
        Map<Long, List<SmsTemplate>> bizTemplates = smsTemplates.stream().collect(Collectors.groupingBy(SmsTemplate::getBizId));
        for (Map.Entry<Long, List<SmsTemplate>> templateEntry : bizTemplates.entrySet()) {
            Long bizId = templateEntry.getKey();
            List<SmsTemplate> templates = templateEntry.getValue();
            if (CollectionUtils.isEmpty(templates)) {
                log.info("wait audit template not found bizId:{}, return", (Object)bizId);
                continue;
            }
            List<String> bjyTemplateIds = templates.stream().map(SmsTemplate::getBjyTemplateId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bjyTemplateIds)) {
                log.info("wait audit template bjyTemplateIds is empty bizId:{}, return", (Object)bizId);
                continue;
            }
            int size = bjyTemplateIds.size();
            if (size <= 100) {
                Map<String, String> params = this.getTemplateInfoParams(bjyTemplateIds);
                JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.templateInfoUrl, params);
                this.updateTemplateStatus(jsonObject);
                continue;
            }
            for (int num = 0; num < size; num += 100) {
                int temp = Math.min(num + 100, size);
                List<String> idsTemp = bjyTemplateIds.subList(num, temp);
                Map<String, String> params = this.getTemplateInfoParams(idsTemp);
                JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.templateInfoUrl, params);
                this.updateTemplateStatus(jsonObject);
            }
        }
    }

    private void updateTemplateStatus(JSONObject jsonObject) {
        log.info("updateTemplateStatus jsonObject:{}", (Object)jsonObject);
        List templateDtos = null;
        try {
            templateDtos = JacksonUtil.str2List((String)jsonObject.getString("data"), BjyTemplateDto.class);
        }
        catch (IOException e) {
            log.info("updateTemplateStatus str2List error ", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)templateDtos)) {
            log.info("updateTemplateStatus templateDtos is empty , return");
            return;
        }
        List passIds = templateDtos.stream().filter(bjyTemplateDto -> Integer.parseInt(bjyTemplateDto.getState()) == AuditStatusEnum.PASS.getValue()).map(BjyTemplateDto::getTemplateid).collect(Collectors.toList());
        List rejectIds = templateDtos.stream().filter(bjyTemplateDto -> Integer.parseInt(bjyTemplateDto.getState()) == AuditStatusEnum.REJECT.getValue()).map(BjyTemplateDto::getTemplateid).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(passIds)) {
            SmsTemplate template = SmsTemplate.builder().auditStatus(Integer.valueOf(AuditStatusEnum.PASS.getValue())).build();
            SmsTemplateCriteria smsTemplateCriteria = new SmsTemplateCriteria();
            smsTemplateCriteria.createCriteria().andBjyTemplateIdIn(passIds);
            this.smsTemplateMapper.updateByExampleSelective((Object)template, (Object)smsTemplateCriteria);
        }
        if (CollectionUtils.isNotEmpty(rejectIds)) {
            SmsTemplate rejectTemplate = SmsTemplate.builder().auditStatus(Integer.valueOf(AuditStatusEnum.REJECT.getValue())).build();
            SmsTemplateCriteria rejectSmsTemplateCriteria = new SmsTemplateCriteria();
            rejectSmsTemplateCriteria.createCriteria().andBjyTemplateIdIn(rejectIds);
            this.smsTemplateMapper.updateByExampleSelective((Object)rejectTemplate, (Object)rejectSmsTemplateCriteria);
        }
    }

    @Override
    public void backfill() {
        List bindingsList = this.bindingsMapper.select((Object)AppBindings.builder().appCode(this.appCode).build());
        String key = "signature";
        for (AppBindings bindings : bindingsList) {
            String signature;
            Map map;
            String configJson = bindings.getConfigJson();
            if (StringUtils.isEmpty((CharSequence)configJson) || MapUtils.isEmpty((Map)(map = JacksonUtil.toMap((String)bindings.getConfigJson()))) || !map.containsKey(key) || !(signature = String.valueOf(map.get(key))).contains("id")) continue;
            List strIdAndNames = (List)map.get(key);
            log.info("backfill, strIdAndNames:{}", (Object)strIdAndNames);
            if (CollectionUtils.isEmpty((Collection)strIdAndNames)) continue;
            Map<String, String> nameMap = strIdAndNames.stream().collect(Collectors.toMap(StrIdAndNameDto::getId, StrIdAndNameDto::getName));
            List names = strIdAndNames.stream().map(StrIdAndNameDto::getName).collect(Collectors.toList());
            map.put(key, names);
            log.info("backfill, JacksonUtil.obj2Str(map):{}", (Object)JacksonUtil.obj2Str((Object)map));
            bindings.setConfigJson(JacksonUtil.obj2Str((Object)map));
            bindings.setUpdateTime(new Date());
            this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
            List templates = this.smsTemplateMapper.select((Object)SmsTemplate.builder().bizId(bindings.getBizId()).build());
            if (CollectionUtils.isEmpty((Collection)templates)) {
                log.info("template not found, continue");
                continue;
            }
            for (SmsTemplate template : templates) {
                template.setSignatureId(nameMap.get(template.getSignatureId()));
                template.setUpdateTime(new Date());
                this.smsTemplateMapper.updateByPrimaryKeySelective((Object)template);
            }
        }
    }

    @Override
    public void templateUpload() {
        log.info("templateUpload");
        CompletableFuture.runAsync(() -> {
            List businessCustomers = this.businessCustomerMapper.selectAll();
            for (BusinessCustomer businessCustomer : businessCustomers) {
                SmsTemplateCriteria templateCriteria = new SmsTemplateCriteria();
                templateCriteria.createCriteria().andBizIdEqualTo(businessCustomer.getId()).andBjyTemplateIdEqualTo("").andIsDeletedEqualTo(Integer.valueOf(0));
                List smsTemplates = this.smsTemplateMapper.selectByExample((Object)templateCriteria);
                if (CollectionUtils.isEmpty((Collection)smsTemplates)) {
                    log.info("wait upload template not found bizId:{}, continue", (Object)businessCustomer.getId());
                    continue;
                }
                for (SmsTemplate smsTemplate : smsTemplates) {
                    Map<String, String> uploadParams = this.getTemplateUploadParams(smsTemplate.getContent());
                    JSONObject jsonObject = this.bjyPartnerService.bjyPost(smsTemplate.getBizId(), this.templateUploadUrl, uploadParams);
                    String bjyTemplateId = jsonObject.getJSONObject("data").getString(TEMPLATE_ID);
                    if (StringUtils.isBlank((CharSequence)bjyTemplateId)) {
                        log.warn("upload template fail content:{},bizId:{}, continue", (Object)smsTemplate.getContent(), (Object)smsTemplate.getBizId());
                        continue;
                    }
                    smsTemplate.setBjyTemplateId(bjyTemplateId);
                    smsTemplate.setAuditStatus(Integer.valueOf(AuditStatusEnum.WAIT.getValue()));
                    smsTemplate.setUpdateTime(new Date());
                    smsTemplate.setUpdateBy(Long.valueOf(-1L));
                    this.smsTemplateMapper.updateByPrimaryKeySelective((Object)smsTemplate);
                }
            }
        });
    }

    private Map<String, String> getTemplateUploadParams(String content) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("content", content);
        return map;
    }

    private Map<String, String> getTemplateDeleteParams(String bjyTemplateId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("template_ids", bjyTemplateId);
        return map;
    }

    private Map<String, String> getTemplateInfoParams(List<String> bjyTemplateIds) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("template_ids", StringUtils.join((Object[])bjyTemplateIds.toArray(), (String)","));
        return map;
    }

    private void addSaveUseScope(List<String> deptNums, List<String> userNums, CurrentUserInfo userInfo, Long smsTemplateId) {
        List userIds;
        SmsTemplateUseScope useScope;
        if (CollectionUtils.isEmpty(deptNums) && CollectionUtils.isEmpty(userNums)) {
            return;
        }
        Date curTime = new Date();
        ArrayList useScopes = Lists.newArrayList();
        List orgIds = this.organizationMapper.queryIdsByNums(userInfo.getBizId(), deptNums);
        if (CollectionUtils.isNotEmpty((Collection)orgIds)) {
            for (Long orgId : orgIds) {
                useScope = this.buildSmsTemplateUseScope(userInfo.getBizId(), userInfo.getId(), smsTemplateId, orgId, SmsTemplateUseScopeEnum.DEPT.getValue(), curTime);
                useScopes.add(useScope);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(userIds = this.userMapper.queryUserIdsByNums(userInfo.getBizId(), userNums)))) {
            for (Long userId : userIds) {
                useScope = this.buildSmsTemplateUseScope(userInfo.getBizId(), userInfo.getId(), smsTemplateId, userId, SmsTemplateUseScopeEnum.USER.getValue(), curTime);
                useScopes.add(useScope);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)useScopes)) {
            Lists.partition((List)useScopes, (int)200).forEach(pus -> this.useScopeMapper.batchInsert((Collection)pus));
        }
    }

    private SmsTemplateUseScope buildSmsTemplateUseScope(Long bizId, Long userId, Long smsTemplateId, Long fkId, Integer fkType, Date curTime) {
        SmsTemplateUseScope useScope = new SmsTemplateUseScope();
        useScope.setNum(this.idGen.getNum());
        useScope.setBizId(bizId);
        useScope.setSmsTemplateId(smsTemplateId);
        useScope.setFkId(fkId);
        useScope.setFkType(fkType);
        useScope.setCreateBy(userId);
        useScope.setCreateTime(curTime);
        useScope.setUpdateBy(userId);
        useScope.setUpdateTime(curTime);
        useScope.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return useScope;
    }
}

