/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.ScrmSmsService;
import com.kuaike.scrm.common.service.dto.AppSmsRespDto;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.service.dto.req.SmsSendReqDto;
import com.kuaike.scrm.common.service.dto.resp.SmsCountRespDto;
import com.kuaike.scrm.common.service.dto.resp.SmsRecordDto;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.sms.dto.SmsTaskQueryParams;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskDetailMapper;
import com.kuaike.scrm.sms.dto.SmsTaskDetailRespDto;
import com.kuaike.scrm.sms.dto.SmsTaskReqDto;
import com.kuaike.scrm.sms.service.SmsTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmSmsServiceImpl
implements ScrmSmsService {
    private static final Logger log = LoggerFactory.getLogger(ScrmSmsServiceImpl.class);
    @Autowired
    private SmsTaskService smsTaskService;
    @Autowired
    private SmsTaskDetailMapper smsTaskDetailMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Value(value="${app.sms.appCode}")
    private String appCode;

    public AppSmsRespDto recordList(List<String> phones, PageDto pageDto) {
        return this.resultList(phones, pageDto);
    }

    public AppSmsRespDto recordList(String phone, PageDto pageDto) {
        return this.resultList(Lists.newArrayList((Object[])new String[]{phone}), pageDto);
    }

    public Long sendCustomSms(ScrmSendSmsReqDto reqDto) {
        log.info("sendCustomSms, reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        return this.smsTaskService.sendCustomSms(reqDto);
    }

    public Long sendNoticeSms(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSms, reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        return this.smsTaskService.sendNoticeSms(reqDto);
    }

    public Long sendNoticeSmsBatch(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSmsBatch, reqDto:{}", (Object)reqDto);
        reqDto.validateBatchParams();
        return this.smsTaskService.sendNoticeSmsBatch(reqDto);
    }

    public Map<Long, Integer> getSendStatusBySmsTaskDetailIds(Collection<Long> ids) {
        return this.smsTaskService.getSendStatusBySmsTaskDetailIds(ids);
    }

    public List<SmsCountRespDto> smsCount(SmsSendReqDto reqDto) {
        Map<Object, Object> latestRecordMap;
        log.info("smsCount: reqDto:{}", (Object)reqDto);
        reqDto.validate();
        if (CollectionUtils.isEmpty((Collection)reqDto.getPhones())) {
            return Lists.newArrayList();
        }
        SmsTaskQueryParams params = new SmsTaskQueryParams();
        params.setBizId(reqDto.getBizId());
        params.setPhones((Collection)reqDto.getPhones());
        List detailList = this.smsTaskDetailMapper.querySmsCountDetail(params);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return Lists.newArrayList();
        }
        List ids = this.smsTaskDetailMapper.queryLatestSmsRecordIds(params);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            List latestSmsRecords = this.smsTaskDetailMapper.selectByIds((Collection)ids);
            latestRecordMap = latestSmsRecords.stream().collect(Collectors.toMap(SmsTaskDetail::getPhone, Function.identity()));
        } else {
            latestRecordMap = Collections.emptyMap();
        }
        ArrayList<SmsCountRespDto> resultList = new ArrayList<SmsCountRespDto>();
        for (SmsTaskDetail smsTaskDetail : detailList) {
            SmsCountRespDto respDto = new SmsCountRespDto();
            respDto.setPhone(smsTaskDetail.getPhone());
            respDto.setSmsCount(smsTaskDetail.getSmsCount());
            respDto.setSmsSuccessCount(smsTaskDetail.getSmsSuccessCount());
            respDto.setSmsFailCount(smsTaskDetail.getSmsFailCount());
            SmsTaskDetail latestRecord = (SmsTaskDetail)latestRecordMap.get(smsTaskDetail.getPhone());
            if (latestRecord != null) {
                respDto.setLatestSmsId(latestRecord.getNum());
                respDto.setLatestSmsTime(latestRecord.getUpdateTime());
            }
            resultList.add(respDto);
        }
        return resultList;
    }

    public List<SmsRecordDto> recordListByTime(Long bizId, Collection<String> phones, Date startTime, Date endTime) {
        log.info("recordListByTime,bizId:{},phones:{},startTime:{},endTime:{}", new Object[]{bizId, phones, startTime, endTime});
        if (bizId == null || CollectionUtils.isEmpty(phones) || startTime == null && endTime == null) {
            return Collections.emptyList();
        }
        SmsTaskQueryParams params = new SmsTaskQueryParams();
        params.setBizId(bizId);
        params.setPhones(phones);
        params.setStartDate(startTime);
        params.setEndDate(endTime);
        List smsTaskDetails = this.smsTaskDetailMapper.selectByTime(params);
        if (CollectionUtils.isEmpty((Collection)smsTaskDetails)) {
            return Collections.emptyList();
        }
        ArrayList<SmsRecordDto> list = new ArrayList<SmsRecordDto>();
        for (SmsTaskDetail smsTaskDetail : smsTaskDetails) {
            String phone = smsTaskDetail.getPhone();
            Long createBy = smsTaskDetail.getCreateBy();
            SmsRecordDto dto = new SmsRecordDto();
            dto.setPhone(phone);
            dto.setUserId(createBy);
            list.add(dto);
        }
        return list;
    }

    private AppSmsRespDto resultList(List<String> phones, PageDto pageDto) {
        SmsTaskReqDto reqDto = new SmsTaskReqDto();
        reqDto.setPageDto(pageDto);
        reqDto.setPhones(phones);
        List<SmsTaskDetailRespDto> list = this.smsTaskService.taskDetail(reqDto);
        ArrayList<SmsRecordDto> resultList = new ArrayList<SmsRecordDto>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SmsTaskDetailRespDto smsTaskDetailRespDto : list) {
                SmsRecordDto smsRecordDto = new SmsRecordDto();
                BeanUtils.copyProperties((Object)smsTaskDetailRespDto, (Object)smsRecordDto);
                resultList.add(smsRecordDto);
            }
        }
        return new AppSmsRespDto(resultList, reqDto.getPageDto());
    }

    public Boolean isOpenSms(Long bizId) {
        if (bizId == null || bizId <= NumberUtils.LONG_ZERO) {
            return false;
        }
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        if (bindings != null && bindings.getIsOpen() == 1) {
            return true;
        }
        return false;
    }
}

