/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.dto;

import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import com.kuaike.scrm.sms.service.impl.StatusEnum;
import java.util.Date;
import java.util.List;

public class SmsTaskDetailRespDto {
    private Date createTime;
    private String phone;
    private String taskId;
    private EnumDto status;
    private String result;
    private String reason;
    private String content;
    private String userName;
    private Integer isOpenAcquisitionLink;
    private Integer addWeworkStatus;
    private List<String> acquisitionName;

    public static SmsTaskDetailRespDto from(SmsTaskDetail detail, boolean mobileEncrypt) {
        SmsTaskDetailRespDto dto = new SmsTaskDetailRespDto();
        dto.setPhone(mobileEncrypt ? MobileUtils.encryptMobile((String)detail.getPhone()) : detail.getPhone());
        dto.setCreateTime(detail.getCreateTime());
        dto.setTaskId(detail.getBjyTaskId());
        StatusEnum status = StatusEnum.get(detail.getStatus());
        dto.setStatus(EnumDto.from((EnumService)status));
        dto.setResult(detail.getBjyResult());
        dto.setReason(detail.getReason());
        dto.setContent(detail.getContent());
        dto.setUserName(detail.getUserName());
        dto.setIsOpenAcquisitionLink(detail.getIsOpenWeworkAcquisitionLink());
        dto.setAddWeworkStatus(detail.getAddWeworkStatus());
        return dto;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public EnumDto getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getReason() {
        return this.reason;
    }

    public String getContent() {
        return this.content;
    }

    public String getUserName() {
        return this.userName;
    }

    public Integer getIsOpenAcquisitionLink() {
        return this.isOpenAcquisitionLink;
    }

    public Integer getAddWeworkStatus() {
        return this.addWeworkStatus;
    }

    public List<String> getAcquisitionName() {
        return this.acquisitionName;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setStatus(EnumDto status) {
        this.status = status;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setIsOpenAcquisitionLink(Integer isOpenAcquisitionLink) {
        this.isOpenAcquisitionLink = isOpenAcquisitionLink;
    }

    public void setAddWeworkStatus(Integer addWeworkStatus) {
        this.addWeworkStatus = addWeworkStatus;
    }

    public void setAcquisitionName(List<String> acquisitionName) {
        this.acquisitionName = acquisitionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsTaskDetailRespDto)) {
            return false;
        }
        SmsTaskDetailRespDto other = (SmsTaskDetailRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isOpenAcquisitionLink = this.getIsOpenAcquisitionLink();
        Integer other$isOpenAcquisitionLink = other.getIsOpenAcquisitionLink();
        if (this$isOpenAcquisitionLink == null ? other$isOpenAcquisitionLink != null : !((Object)this$isOpenAcquisitionLink).equals(other$isOpenAcquisitionLink)) {
            return false;
        }
        Integer this$addWeworkStatus = this.getAddWeworkStatus();
        Integer other$addWeworkStatus = other.getAddWeworkStatus();
        if (this$addWeworkStatus == null ? other$addWeworkStatus != null : !((Object)this$addWeworkStatus).equals(other$addWeworkStatus)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        EnumDto this$status = this.getStatus();
        EnumDto other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        List<String> this$acquisitionName = this.getAcquisitionName();
        List<String> other$acquisitionName = other.getAcquisitionName();
        return !(this$acquisitionName == null ? other$acquisitionName != null : !((Object)this$acquisitionName).equals(other$acquisitionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsTaskDetailRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isOpenAcquisitionLink = this.getIsOpenAcquisitionLink();
        result = result * 59 + ($isOpenAcquisitionLink == null ? 43 : ((Object)$isOpenAcquisitionLink).hashCode());
        Integer $addWeworkStatus = this.getAddWeworkStatus();
        result = result * 59 + ($addWeworkStatus == null ? 43 : ((Object)$addWeworkStatus).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        EnumDto $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        List<String> $acquisitionName = this.getAcquisitionName();
        result = result * 59 + ($acquisitionName == null ? 43 : ((Object)$acquisitionName).hashCode());
        return result;
    }

    public String toString() {
        return "SmsTaskDetailRespDto(createTime=" + this.getCreateTime() + ", phone=" + this.getPhone() + ", taskId=" + this.getTaskId() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ", reason=" + this.getReason() + ", content=" + this.getContent() + ", userName=" + this.getUserName() + ", isOpenAcquisitionLink=" + this.getIsOpenAcquisitionLink() + ", addWeworkStatus=" + this.getAddWeworkStatus() + ", acquisitionName=" + this.getAcquisitionName() + ")";
    }
}

