/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.FollowRecordMsgService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.FollowRecordMsg;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.sms.dto.SmsTaskQueryParams;
import com.kuaike.scrm.dal.sms.dto.SmsTemplateQueryParams;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.entity.SmsTask;
import com.kuaike.scrm.dal.sms.entity.SmsTaskCriteria;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetailCriteria;
import com.kuaike.scrm.dal.sms.entity.SmsTemplate;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskDetailMapper;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskMapper;
import com.kuaike.scrm.dal.sms.mapper.SmsTemplateMapper;
import com.kuaike.scrm.sms.dto.SendDetail;
import com.kuaike.scrm.sms.dto.SmsTaskDetailRespDto;
import com.kuaike.scrm.sms.dto.SmsTaskReqDto;
import com.kuaike.scrm.sms.dto.SmsTaskRespDto;
import com.kuaike.scrm.sms.dto.SmsTemplateOptionRespDto;
import com.kuaike.scrm.sms.service.SmsTaskService;
import com.kuaike.scrm.sms.service.impl.AuditStatusEnum;
import com.kuaike.scrm.sms.service.impl.SmsChannelEnum;
import com.kuaike.scrm.sms.service.impl.StatusEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SmsTaskServiceImpl
implements SmsTaskService {
    private static final Logger log = LoggerFactory.getLogger(SmsTaskServiceImpl.class);
    private static final int SEND_LIMIT = 100000;
    private static final int SEND_DETAIL_LIMIT = 100;
    private static final int HEADER_ROWS = 1;
    private static final int MAX_ROWS = 5000;
    private static final int SHORT_MSG_LIMIT = 70;
    private static final int LONG_MSG_LIMIT = 67;
    private static final String SEND_ID = "send_id";
    private static final String CONTENT = "content";
    private static final String CORP_ID = "corp_id";
    private static final String SMS_SIGN = "sms_sign";
    private static final String CUSTOMER_NAME_STR = "{\u5ba2\u6237\u540d\u79f0}";
    private static final String CUSTOMER_PHONE_STR = "{\u624b\u673a\u53f7}";
    private static final String TEMPLATE_NAME_STR = "${0,20}";
    private static final String TEMPLATE_PHONE_STR = "${10,11}";
    private static final String HEADER_FIRST_CELL_STR = "\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_SECOND_CELL_STR = "\u5ba2\u6237\u540d\u79f0";
    private static final String IMPORT_FILE_DIR = "./importDir/sms";
    private static final String[] HEADERS = new String[]{"\u65e5\u671f", "\u6210\u529f\u6b21\u6570", "\u5931\u8d25\u6b21\u6570"};
    @Value(value="${app.sms.appCode}")
    private String appCode;
    @Value(value="${app.sms.checkUrl:scrm/sms/availableQuantity}")
    private String checkUrl;
    @Value(value="${app.sms.sendUrl:scrm/sms/send}")
    private String sendUrl;
    @Value(value="${app.sms.noticeSendUrl}")
    private String noticeSendUrl;
    @Value(value="${app.sms.noticeSendInfoUrl}")
    private String noticeSendInfoUrl;
    @Value(value="${app.sms.sendDetailUrl:scrm/sms/sendDetail}")
    private String sendDetailUrl;
    @Autowired
    private SmsTaskMapper smsTaskMapper;
    @Autowired
    private SmsTaskDetailMapper smsTaskDetailMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private FollowRecordMsgService followRecordMsgService;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createTask(SmsTaskReqDto smsTaskReqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = smsTaskReqDto.getBizId() == null ? currentUser.getBizId() : smsTaskReqDto.getBizId();
        smsTaskReqDto.validateAddParams(currentUser);
        log.info("save task : {}", (Object)smsTaskReqDto);
        List customers = smsTaskReqDto.getCustomers();
        if (StringUtils.isNotBlank((CharSequence)smsTaskReqDto.getBatchId())) {
            customers = this.cachePhoneService.getCustomer(smsTaskReqDto.getBatchId());
        } else if (!CollectionUtils.isEmpty(customers)) {
            HashSet customerSet = new HashSet(customers);
            customers = Lists.newArrayList(customerSet);
        } else if (!CollectionUtils.isEmpty(smsTaskReqDto.getPhones())) {
            customers = Lists.newArrayList();
            for (String phone : smsTaskReqDto.getPhones()) {
                customers.add(new CustomerDto(phone, ""));
            }
        } else {
            throw new IllegalArgumentException("\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int nums = customers.size();
        String content = smsTaskReqDto.getContent();
        if (2 == smsTaskReqDto.getContentType()) {
            List<SmsTemplateOptionRespDto> smsTemplates = this.optionTemplate(bizId);
            Long templateId = Long.valueOf(content);
            SmsTemplateOptionRespDto respDto = smsTemplates.stream().filter(template -> template.getId().longValue() == templateId.longValue()).findAny().orElse(null);
            Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)respDto) ? 1 : 0) != 0, (Object)"\u6a21\u677fid\u9519\u8bef");
            content = respDto.getContent();
            smsTaskReqDto.setContent(content);
        }
        String signatureId = smsTaskReqDto.getSignatureId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)signatureId), (Object)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        smsTaskReqDto.setSignature(signatureId);
        this.checkSms(bizId, nums, content, signatureId);
        smsTaskReqDto.setIdGen(this.idGen);
        smsTaskReqDto.setCustomers(customers);
        SmsTask smsTask = smsTaskReqDto.backward();
        this.smsTaskMapper.insertSelective((Object)smsTask);
        List<SmsTaskDetail> smsTaskDetailList = this.buildSmsTaskDetailList(smsTaskReqDto, smsTask.getId(), "", "", customers);
        if (smsTask.getSendType() == 1) {
            this.smsTaskDetailMapper.batchInsert(smsTaskDetailList);
            return smsTask.getId();
        }
        if (nums <= 100000) {
            this.sendAndSave(smsTaskDetailList, smsTask);
            return smsTask.getId();
        }
        for (int num = 0; num < nums; num += 100000) {
            int temp = Math.min(num + 100000, nums);
            List<SmsTaskDetail> customersTemp = smsTaskDetailList.subList(num, temp);
            this.sendAndSave(customersTemp, smsTask);
        }
        return smsTask.getId();
    }

    @Override
    public List<SmsTaskRespDto> taskList(SmsTaskReqDto smsTaskReqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        smsTaskReqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("taskList reqDto:{}, bizId:{}, corpId:{}", new Object[]{smsTaskReqDto, bizId, corpId});
        SmsTaskQueryParams params = smsTaskReqDto.to(bizId);
        Set<Long> userIds = Sets.newHashSet();
        if (StringUtils.isEmpty((CharSequence)smsTaskReqDto.getNodeId()) && StringUtils.isEmpty((CharSequence)smsTaskReqDto.getUserId())) {
            userIds = this.userRoleCommonService.getManageUserIds();
            userIds.add(-1L);
        }
        if (!StringUtils.isEmpty((CharSequence)smsTaskReqDto.getNodeId())) {
            Long nodeId = this.nodeService.getIdByNum(bizId, smsTaskReqDto.getNodeId());
            Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
            if (!manageNodeIds.contains(nodeId)) {
                return Collections.emptyList();
            }
            manageNodeIds = this.nodeService.getPosterityIds(nodeId, bizId);
            userIds = this.scrmUserService.queryIdsByNodeIds((Collection)manageNodeIds);
        }
        if (!StringUtils.isEmpty((CharSequence)smsTaskReqDto.getUserId())) {
            Long userId = this.scrmUserService.getIdByNum(smsTaskReqDto.getUserId());
            Set manageUserIds = this.userRoleCommonService.getManageUserIds();
            if (!manageUserIds.contains(userId)) {
                return Collections.emptyList();
            }
            userIds.add(userId);
        }
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Collections.emptyList();
        }
        params.setUserIds(userIds);
        List smsTasks = this.smsTaskMapper.queryTaskList(params);
        ArrayList<SmsTaskRespDto> resultList = new ArrayList<SmsTaskRespDto>();
        if (!CollectionUtils.isEmpty((Collection)smsTasks)) {
            for (SmsTask smsTask : smsTasks) {
                resultList.add(SmsTaskRespDto.from(smsTask));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.smsTaskMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }

    @Override
    public List<SmsTaskDetailRespDto> taskDetail(SmsTaskReqDto smsTaskReqDto) {
        boolean mobileEncrypt;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        smsTaskReqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("taskDetail reqDto:{}, bizId:{}, corpId:{}", new Object[]{smsTaskReqDto, bizId, corpId});
        SmsTaskQueryParams params = smsTaskReqDto.to(bizId);
        if (!CollectionUtils.isEmpty(smsTaskReqDto.getPhones())) {
            params.setPhones(smsTaskReqDto.getPhones());
        }
        List smsTaskDetails = this.smsTaskDetailMapper.queryTaskDetailList(params);
        ArrayList<SmsTaskDetailRespDto> resultList = new ArrayList<SmsTaskDetailRespDto>();
        String paramValue = this.settingService.getSettingDetail(bizId, SettingEnum.MOBILE_ENCRYPT.getName());
        boolean bl = mobileEncrypt = paramValue != null && paramValue.equals("1");
        if (!CollectionUtils.isEmpty((Collection)smsTaskDetails)) {
            for (SmsTaskDetail smsTaskDetail : smsTaskDetails) {
                resultList.add(SmsTaskDetailRespDto.from(smsTaskDetail, mobileEncrypt));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.smsTaskDetailMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }

    @Override
    public List<CustomerDto> importExcelFile(InputStream inp) {
        List<CustomerDto> customers;
        FileOutputStream outputStream = null;
        try {
            Workbook workbook = SmsTaskServiceImpl.create(inp);
            customers = this.parseExcel(workbook);
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
            String fileName = IMPORT_FILE_DIR + File.pathSeparator + simpleDateFormat.format(new Date()) + "_\u624b\u673a\u53f7\u5bfc\u5165\u7ed3\u679c.xlsx";
            File file = new File(fileName);
            outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (file.exists()) {
                Path path = file.toPath();
                Files.delete(path);
            }
        }
        catch (BusinessException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return customers;
    }

    @Override
    public void callback() {
        log.info("update marketing sms status start");
        List unProcessedList = this.smsTaskDetailMapper.unProcessedList(Integer.valueOf(SmsChannelEnum.MARKETING.getValue()));
        unProcessedList.forEach(detail -> {
            int total = detail.getTotal();
            int totalPage = total / 100 + 1;
            for (int page = 1; page <= totalPage; ++page) {
                Map<String, String> params = this.getSendDetailParams(detail.getBjyTaskId(), page, detail.getPartnerId());
                List sendDetails = Collections.emptyList();
                try {
                    JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.sendDetailUrl, params, (Map)Maps.newHashMap());
                    JSONObject data = jsonObject.getJSONObject("data");
                    if (CollectionUtils.isEmpty((Map)data)) continue;
                    JSONArray jsonArray = data.getJSONArray("list");
                    sendDetails = JSONArray.parseArray((String)jsonArray.toJSONString(), SendDetail.class);
                }
                catch (Exception e) {
                    log.error("get marketing sms detail error", (Throwable)e);
                }
                if (!CollectionUtils.isEmpty(sendDetails)) {
                    this.updateStatusBySendDetail(sendDetails, detail.getSmsTaskId());
                    continue;
                }
                log.info("callback bjyTaskId:{} result is empty", (Object)detail.getBjyTaskId());
            }
        });
    }

    @Override
    public void noticePull() {
        log.info("update notice sms status start");
        List unProcessedList = this.smsTaskDetailMapper.unProcessedList(Integer.valueOf(SmsChannelEnum.NOTICE.getValue()));
        for (SmsTaskDetail detail : unProcessedList) {
            Map<String, String> params = this.getNoticeSendInfoParams(detail.getBjyTaskId(), detail.getPhone(), detail.getPartnerId());
            SendDetail sendDetail = null;
            try {
                JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.noticeSendInfoUrl, params, (Map)Maps.newHashMap());
                JSONObject data = jsonObject.getJSONObject("data");
                if (CollectionUtils.isEmpty((Map)data)) continue;
                sendDetail = (SendDetail)JSONObject.parseObject((String)data.toJSONString(), SendDetail.class);
            }
            catch (Exception e) {
                log.error("get notice sms detail error", (Throwable)e);
            }
            if (ObjectUtils.isEmpty(sendDetail)) continue;
            this.updateStatusBySendDetail(sendDetail, detail.getSmsTaskId(), detail.getPhone());
        }
    }

    @Override
    public void send() {
        log.info("auto send sms start");
        SmsTaskCriteria smsTaskCriteria = new SmsTaskCriteria();
        smsTaskCriteria.createCriteria().andSendTypeEqualTo(Integer.valueOf(1)).andStatusEqualTo(Integer.valueOf(0)).andSendTimeLessThan(new Date());
        List unProcessedTasks = this.smsTaskMapper.selectByExample((Object)smsTaskCriteria);
        for (SmsTask smsTask : unProcessedTasks) {
            SmsTaskDetailCriteria smsTaskDetailCriteria = new SmsTaskDetailCriteria();
            smsTaskDetailCriteria.createCriteria().andStatusEqualTo(Integer.valueOf(StatusEnum.WAIT_SEND.getValue())).andSmsTaskIdEqualTo(smsTask.getId());
            List unProcessedList = this.smsTaskDetailMapper.selectByExample((Object)smsTaskDetailCriteria);
            int nums = unProcessedList.size();
            if (nums <= 100000) {
                this.sendAndSave(unProcessedList, smsTask);
                smsTask.setUpdateTime(new Date());
                smsTask.setStatus(Integer.valueOf(1));
                this.smsTaskMapper.updateByPrimaryKeySelective((Object)smsTask);
                continue;
            }
            for (int num = 0; num < nums; num += 100000) {
                int temp = num + 100000 > nums ? nums : num + 100000;
                List<SmsTaskDetail> customersTemp = unProcessedList.subList(num, temp);
                this.sendAndSave(customersTemp, smsTask);
            }
            smsTask.setUpdateTime(new Date());
            smsTask.setStatus(Integer.valueOf(1));
            this.smsTaskMapper.updateByPrimaryKeySelective((Object)smsTask);
        }
    }

    @Override
    public void cancel(String num) {
        log.info("cancel sms task");
        SmsTask smsTask = new SmsTask();
        smsTask.setNum(num);
        SmsTask smsTaskDb = (SmsTask)this.smsTaskMapper.selectOne((Object)smsTask);
        if (ObjectUtils.isEmpty((Object)smsTaskDb)) {
            throw new IllegalArgumentException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        smsTaskDb.setUpdateTime(new Date());
        smsTaskDb.setStatus(Integer.valueOf(2));
        this.smsTaskMapper.updateByPrimaryKeySelective((Object)smsTaskDb);
        SmsTaskDetailCriteria smsTaskDetailCriteria = new SmsTaskDetailCriteria();
        smsTaskDetailCriteria.createCriteria().andStatusEqualTo(Integer.valueOf(StatusEnum.WAIT_SEND.getValue())).andSmsTaskIdEqualTo(smsTask.getId());
        SmsTaskDetail smsTaskDetail = new SmsTaskDetail();
        smsTaskDetail.setUpdateTime(new Date());
        smsTaskDetail.setStatus(Integer.valueOf(StatusEnum.CANCEL.getValue()));
        this.smsTaskDetailMapper.updateByExampleSelective((Object)smsTaskDetail, (Object)smsTaskDb);
    }

    private void updateStatusBySendDetail(List<SendDetail> sendDetails, Long smsTaskId) {
        Map taskDetailMap = this.smsTaskDetailMapper.queryTaskDetailIdMap(smsTaskId);
        for (SendDetail sendDetail : sendDetails) {
            log.info("updateStatusBySendDetail,sendDetail:{}", (Object)sendDetail);
            SmsTaskDetail item = new SmsTaskDetail();
            item.setStatus(Integer.valueOf(sendDetail.getStatus()));
            item.setBjyResult(sendDetail.getOrgMsg());
            item.setUpdateBy(Long.valueOf(-1L));
            item.setUpdateTime(new Date());
            SmsTaskDetailCriteria criteria = new SmsTaskDetailCriteria();
            criteria.createCriteria().andSmsTaskIdEqualTo(smsTaskId).andPhoneEqualTo(sendDetail.getMobile());
            Long taskDetailId = (Long)taskDetailMap.get(sendDetail.getMobile());
            this.smsTaskDetailMapper.updateByExampleSelective((Object)item, (Object)criteria);
            if (item.getStatus() == 1) {
                this.sopTaskStatusService.sendSopTaskStatusMsg(smsTaskId, taskDetailId, SopTaskType.SMS, sendDetail.getMobile(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, item.getUpdateTime());
                continue;
            }
            if (item.getStatus() != 2) continue;
            this.sopTaskStatusService.sendSopTaskStatusMsg(smsTaskId, taskDetailId, SopTaskType.SMS, sendDetail.getMobile(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), item.getBjyResult(), null);
        }
        int successCount = this.smsTaskDetailMapper.selectCount((Object)SmsTaskDetail.builder().smsTaskId(smsTaskId).status(Integer.valueOf(1)).build());
        int failCount = this.smsTaskDetailMapper.selectCount((Object)SmsTaskDetail.builder().smsTaskId(smsTaskId).status(Integer.valueOf(2)).build());
        this.smsTaskMapper.updateByPrimaryKeySelective((Object)SmsTask.builder().id(smsTaskId).successCount(Integer.valueOf(successCount)).failCount(Integer.valueOf(failCount)).updateBy(Long.valueOf(-1L)).updateTime(new Date()).build());
    }

    private void updateStatusBySendDetail(SendDetail sendDetail, Long smsTaskId, String phone) {
        SmsTaskDetail item = new SmsTaskDetail();
        item.setStatus(Integer.valueOf(sendDetail.getStatus()));
        item.setBjyResult(sendDetail.getOrgMsg());
        item.setUpdateBy(Long.valueOf(-1L));
        item.setUpdateTime(new Date());
        SmsTaskDetailCriteria criteria = new SmsTaskDetailCriteria();
        criteria.createCriteria().andSmsTaskIdEqualTo(smsTaskId).andPhoneEqualTo(phone);
        this.smsTaskDetailMapper.updateByExampleSelective((Object)item, (Object)criteria);
        int successCount = this.smsTaskDetailMapper.selectCount((Object)SmsTaskDetail.builder().smsTaskId(smsTaskId).status(Integer.valueOf(1)).build());
        int failCount = this.smsTaskDetailMapper.selectCount((Object)SmsTaskDetail.builder().smsTaskId(smsTaskId).status(Integer.valueOf(2)).build());
        this.smsTaskMapper.updateByPrimaryKeySelective((Object)SmsTask.builder().id(smsTaskId).successCount(Integer.valueOf(successCount)).failCount(Integer.valueOf(failCount)).updateBy(Long.valueOf(-1L)).updateTime(new Date()).build());
    }

    @Override
    public List<SmsTaskRespDto> statistic(SmsTaskReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("statistic reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        SmsTaskQueryParams params = reqDto.to(bizId);
        Set<Long> userIds = Sets.newHashSet();
        if (StringUtils.isEmpty((CharSequence)reqDto.getNodeId()) && StringUtils.isEmpty((CharSequence)reqDto.getUserId())) {
            userIds = this.userRoleCommonService.getManageUserIds();
        }
        if (!StringUtils.isEmpty((CharSequence)reqDto.getNodeId())) {
            Long nodeId = this.nodeService.getIdByNum(bizId, reqDto.getNodeId());
            Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
            if (!manageNodeIds.contains(nodeId)) {
                return Collections.emptyList();
            }
            manageNodeIds = this.nodeService.getPosterityIds(nodeId, bizId);
            userIds = this.scrmUserService.queryIdsByNodeIds((Collection)manageNodeIds);
        }
        if (!StringUtils.isEmpty((CharSequence)reqDto.getUserId())) {
            Long userId = this.scrmUserService.getIdByNum(reqDto.getUserId());
            Set manageUserIds = this.userRoleCommonService.getManageUserIds();
            if (!manageUserIds.contains(userId)) {
                return Collections.emptyList();
            }
            userIds.add(userId);
        }
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Collections.emptyList();
        }
        params.setUserIds((Collection)userIds);
        List smsTasks = this.smsTaskMapper.statistic(params);
        List days = DateUtil.betweenDays((Date)reqDto.getStartTime(), (Date)reqDto.getEndTime());
        ArrayList<SmsTaskRespDto> resultList = new ArrayList<SmsTaskRespDto>();
        days.forEach(day -> {
            SmsTask task = smsTasks.stream().filter(smsTask -> day.longValue() == smsTask.getDate().getTime()).findAny().orElse(null);
            boolean hasData = ObjectUtils.isEmpty((Object)task);
            resultList.add(SmsTaskRespDto.builder().time((Long)day).successCount(hasData ? 0 : task.getSuccessCount()).failCount(hasData ? 0 : task.getFailCount()).build());
        });
        return resultList;
    }

    @Override
    public List<String> option(Long bizId) {
        List resultList;
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        if (ObjectUtils.isEmpty((Object)bindings)) {
            return Collections.emptyList();
        }
        String key = "signature";
        Map map = JacksonUtil.toMap((String)bindings.getConfigJson());
        if (MapUtils.isEmpty((Map)map) || !map.containsKey(key)) {
            return Collections.emptyList();
        }
        String signature = String.valueOf(map.get(key));
        if (signature.contains("id")) {
            List strIdAndNames = (List)map.get(key);
            resultList = strIdAndNames.stream().map(StrIdAndNameDto::getName).collect(Collectors.toList());
        } else {
            resultList = (List)map.get(key);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportExcel(SmsTaskReqDto reqDto, HttpServletResponse response) {
        log.info("exportExcel reqDto:{}", (Object)reqDto);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u6570\u636e\u7edf\u8ba1");
        String fileName = "\u77ed\u4fe1\u6570\u636e\u7edf\u8ba1.xls";
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int i = 0; i < HEADERS.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(HEADERS[i]);
            cell.setCellValue((RichTextString)text);
        }
        List<SmsTaskRespDto> dtoList = this.statistic(reqDto);
        if (dtoList.size() > 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            int rowNum = 1;
            for (SmsTaskRespDto respDto : dtoList) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                ssRow.createCell(0).setCellValue(simpleDateFormat.format(respDto.getTime()));
                ssRow.createCell(1).setCellValue((double)respDto.getSuccessCount().intValue());
                ssRow.createCell(2).setCellValue((double)respDto.getFailCount().intValue());
                ++rowNum;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("workbook write error", (Throwable)e);
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException ex) {
                log.error("workbook close error", (Throwable)ex);
            }
        }
    }

    @Override
    public List<SmsTemplateOptionRespDto> optionTemplate(Long bizId) {
        SmsTemplateQueryParams params = new SmsTemplateQueryParams();
        params.setBizId(bizId);
        params.setAuditStatus(Integer.valueOf(AuditStatusEnum.PASS.getValue()));
        List smsTemplates = this.smsTemplateMapper.queryList(params);
        ArrayList<SmsTemplateOptionRespDto> resultList = new ArrayList<SmsTemplateOptionRespDto>();
        if (!CollectionUtils.isEmpty((Collection)smsTemplates)) {
            for (SmsTemplate smsTemplate : smsTemplates) {
                resultList.add(SmsTemplateOptionRespDto.to(smsTemplate));
            }
        }
        return resultList;
    }

    @Override
    public Long sendCustomSmsByTemplateId(ScrmSendSmsReqDto reqDto) {
        log.info("sendCustomSmsByTemplateId reqDto:{}", (Object)reqDto);
        Long templateId = reqDto.getTemplateId();
        Preconditions.checkArgument((boolean)Objects.nonNull(templateId), (Object)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        List<SmsTemplateOptionRespDto> smsTemplates = this.optionTemplate(reqDto.getBizId());
        log.info("sendCustomSmsByTemplateId templateIds:{}", smsTemplates.stream().map(SmsTemplateOptionRespDto::getId).collect(Collectors.toList()));
        SmsTemplateOptionRespDto respDto = smsTemplates.stream().filter(template -> template.getId().longValue() == templateId.longValue()).findFirst().orElse(null);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)respDto) ? 1 : 0) != 0, (Object)"\u6a21\u677fid\u9519\u8bef");
        reqDto.setContent(respDto.getContent());
        return this.sendCustomSms(reqDto);
    }

    @Override
    public Long sendCustomSms(ScrmSendSmsReqDto reqDto) {
        String bjyTaskId;
        log.info("sendCustomSms reqDto:{}", (Object)reqDto);
        String name = reqDto.getName();
        String mobile = reqDto.getMobile();
        String content = reqDto.getContent();
        content = this.replaceContent(content, mobile, name);
        String signature = reqDto.getSignature();
        this.checkSms(reqDto.getBizId(), NumberUtils.INTEGER_ONE, content, signature);
        if (StringUtils.isBlank((CharSequence)reqDto.getSignature())) {
            List<String> nameDtoList = this.option(reqDto.getBizId());
            Preconditions.checkArgument((!CollectionUtils.isEmpty(nameDtoList) ? 1 : 0) != 0, (Object)"\u7b7e\u540d\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u524d\u5f80\u9cb2\u9e4f\u914d\u7f6e");
            signature = nameDtoList.get(0);
        }
        SmsTask smsTask = new SmsTask();
        smsTask.setNum(this.idGen.getNum());
        smsTask.setBizId(reqDto.getBizId());
        smsTask.setCorpId(reqDto.getCorpId());
        smsTask.setReason("");
        smsTask.setSignatureId(signature);
        smsTask.setContentType(NumberUtils.INTEGER_ONE);
        smsTask.setContent(reqDto.getContent());
        smsTask.setTotalCount(NumberUtils.INTEGER_ONE);
        smsTask.setSuccessCount(NumberUtils.INTEGER_ZERO);
        smsTask.setFailCount(NumberUtils.INTEGER_ZERO);
        smsTask.setChannel(Integer.valueOf(SmsChannelEnum.MARKETING.getValue()));
        smsTask.setCreateBy(reqDto.getUserId());
        smsTask.setUpdateBy(reqDto.getUserId());
        Date curDate = new Date();
        smsTask.setCreateTime(curDate);
        smsTask.setUpdateTime(curDate);
        this.smsTaskMapper.insert((Object)smsTask);
        Map<String, String> params = this.getSendParams(Lists.newArrayList((Object[])new String[]{reqDto.getMobile()}), content, reqDto.getCorpId(), signature);
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.sendUrl, params, this.bjyPartnerService.getBjyHeader(reqDto.getBizId(), reqDto.getCorpId()));
            bjyTaskId = jsonObject.getJSONObject("data").getString(SEND_ID);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bjyTaskId), (Object)"\u8425\u9500\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("send marketing sms error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8425\u9500\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
        }
        curDate = new Date();
        SmsTaskDetail smsTaskDetail = SmsTaskDetail.builder().num(this.idGen.getNum()).bizId(reqDto.getBizId()).corpId(reqDto.getCorpId()).smsTaskId(smsTask.getId()).bjyTaskId(bjyTaskId).bjyResult("").status(NumberUtils.INTEGER_ZERO).phone(mobile).createBy(reqDto.getUserId()).updateBy(reqDto.getUserId()).createTime(curDate).updateTime(curDate).build();
        this.smsTaskDetailMapper.insert((Object)smsTaskDetail);
        if (smsTaskDetail != null) {
            this.followRecordMsgService.followRecordToKafka(FollowRecordMsg.fromSmsRecord((SmsTaskDetail)smsTaskDetail));
            return smsTaskDetail.getId();
        }
        return null;
    }

    @Override
    public Long sendNoticeSms(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSms reqDto:{}", (Object)reqDto);
        List<String> nameDtoList = this.option(reqDto.getBizId());
        Preconditions.checkArgument((!CollectionUtils.isEmpty(nameDtoList) ? 1 : 0) != 0, (Object)"\u7b7e\u540d\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u524d\u5f80\u9cb2\u9e4f\u914d\u7f6e");
        String signature = nameDtoList.get(0);
        this.checkSms(reqDto.getBizId(), NumberUtils.INTEGER_ONE, reqDto.getContent(), signature);
        SmsTask smsTask = new SmsTask();
        smsTask.setNum(this.idGen.getNum());
        smsTask.setBizId(reqDto.getBizId());
        smsTask.setCorpId(reqDto.getCorpId());
        smsTask.setReason("");
        smsTask.setSignatureId(signature);
        smsTask.setContentType(NumberUtils.INTEGER_ONE);
        smsTask.setContent(reqDto.getContent());
        smsTask.setTotalCount(NumberUtils.INTEGER_ONE);
        smsTask.setSuccessCount(NumberUtils.INTEGER_ZERO);
        smsTask.setFailCount(NumberUtils.INTEGER_ZERO);
        smsTask.setChannel(Integer.valueOf(SmsChannelEnum.NOTICE.getValue()));
        smsTask.setCreateBy(reqDto.getUserId());
        smsTask.setUpdateBy(reqDto.getUserId());
        Date curDate = new Date();
        smsTask.setCreateTime(curDate);
        smsTask.setUpdateTime(curDate);
        this.smsTaskMapper.insert((Object)smsTask);
        Map<String, String> params = this.getNoticeSendParams(Lists.newArrayList((Object[])new String[]{reqDto.getMobile()}), reqDto.getContent(), signature);
        String bjyTaskId = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(reqDto.getBizId(), this.noticeSendUrl, params);
            Map data = jsonObject.getJSONObject("data").getInnerMap();
            Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)data) ? 1 : 0) != 0, (Object)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            for (Map.Entry map : data.entrySet()) {
                bjyTaskId = (String)map.getKey();
                List phones = (List)map.getValue();
                Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)phones) && ((String)phones.get(0)).contains(reqDto.getMobile()) ? 1 : 0) != 0, (Object)"\u8fd4\u56de\u624b\u673a\u53f7\u6709\u8bef\uff0c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("send notice sms error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u901a\u77e5\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(bjyTaskId), (Object)"bjyTaskId\u4e3a\u7a7a\uff0c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        curDate = new Date();
        SmsTaskDetail smsTaskDetail = SmsTaskDetail.builder().num(this.idGen.getNum()).bizId(reqDto.getBizId()).corpId(reqDto.getCorpId()).smsTaskId(smsTask.getId()).bjyTaskId(bjyTaskId).bjyResult("").status(NumberUtils.INTEGER_ZERO).phone(reqDto.getMobile()).createBy(reqDto.getUserId()).updateBy(reqDto.getUserId()).createTime(curDate).updateTime(curDate).build();
        this.smsTaskDetailMapper.insert((Object)smsTaskDetail);
        return smsTaskDetail.getId();
    }

    @Override
    public Long sendNoticeSmsBatch(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSmsBatch reqDto:{}", (Object)reqDto);
        List mobiles = reqDto.getMobiles();
        List<String> nameDtoList = this.option(reqDto.getBizId());
        Preconditions.checkArgument((!CollectionUtils.isEmpty(nameDtoList) ? 1 : 0) != 0, (Object)"\u7b7e\u540d\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u524d\u5f80\u9cb2\u9e4f\u914d\u7f6e");
        String signature = nameDtoList.get(0);
        this.checkSms(reqDto.getBizId(), mobiles.size(), reqDto.getContent(), signature);
        ArrayList taskDetails = Lists.newArrayList();
        SmsTask smsTask = new SmsTask();
        smsTask.setNum(this.idGen.getNum());
        smsTask.setBizId(reqDto.getBizId());
        smsTask.setCorpId(reqDto.getCorpId());
        smsTask.setReason("");
        smsTask.setSignatureId(signature);
        smsTask.setContentType(NumberUtils.INTEGER_ONE);
        smsTask.setContent(reqDto.getContent());
        smsTask.setTotalCount(NumberUtils.INTEGER_ONE);
        smsTask.setSuccessCount(NumberUtils.INTEGER_ZERO);
        smsTask.setFailCount(NumberUtils.INTEGER_ZERO);
        smsTask.setChannel(Integer.valueOf(SmsChannelEnum.NOTICE.getValue()));
        smsTask.setCreateBy(reqDto.getUserId());
        smsTask.setUpdateBy(reqDto.getUserId());
        Date curDate = new Date();
        smsTask.setCreateTime(curDate);
        smsTask.setUpdateTime(curDate);
        this.smsTaskMapper.insert((Object)smsTask);
        Map<String, String> params = this.getNoticeSendParams(mobiles, reqDto.getContent(), signature);
        String bjyTaskId = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(reqDto.getBizId(), this.noticeSendUrl, params);
            Map data = jsonObject.getJSONObject("data").getInnerMap();
            Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)data) ? 1 : 0) != 0, (Object)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            curDate = new Date();
            for (Map.Entry map : data.entrySet()) {
                List phones;
                bjyTaskId = (String)map.getKey();
                if (StringUtils.isBlank((CharSequence)bjyTaskId) || CollectionUtils.isEmpty((Collection)(phones = (List)map.getValue()))) continue;
                String phone = (String)phones.get(0);
                SmsTaskDetail smsTaskDetail = SmsTaskDetail.builder().num(this.idGen.getNum()).bizId(reqDto.getBizId()).corpId(reqDto.getCorpId()).smsTaskId(smsTask.getId()).bjyTaskId(bjyTaskId).bjyResult("").status(NumberUtils.INTEGER_ZERO).phone(phone.contains("86") ? phone.substring(2) : phone).createBy(reqDto.getUserId()).updateBy(reqDto.getUserId()).createTime(curDate).updateTime(curDate).build();
                taskDetails.add(smsTaskDetail);
            }
            this.smsTaskDetailMapper.batchInsert((List)taskDetails);
        }
        catch (Exception e) {
            log.error("send notice sms batch error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u901a\u77e5\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
        }
        return null;
    }

    @Override
    public Map<Long, Integer> getSendStatusBySmsTaskDetailIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        return this.smsTaskDetailMapper.selectStatusByIds(ids);
    }

    @Override
    public boolean isOpen() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        return bindings != null && bindings.getIsOpen() == 1;
    }

    private void checkSms(Long bizId, int size, String content, String signature) {
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(bizId);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)partnerInfo) ? 1 : 0) != 0, (Object)"partner_id\u4e3a\u7a7a");
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u672a\u5f00\u901a");
        this.check(size, content, bizId, signature);
    }

    private String replaceContent(String content, String phone, String name) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        name = StringUtils.isBlank((CharSequence)name) ? "" : name;
        content = content.replace(CUSTOMER_NAME_STR, name);
        content = content.replace(CUSTOMER_PHONE_STR, phone);
        content = content.replace(TEMPLATE_NAME_STR, name);
        content = content.replace(TEMPLATE_PHONE_STR, phone);
        return content;
    }

    private List<CustomerDto> parseExcel(Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(0);
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        if (physicalNumberOfRows - 1 > 5000) {
            log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(physicalNumberOfRows - 1));
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
        }
        Row headerRow = sheet.getRow(0);
        Cell firstCell = headerRow.getCell(NumberUtils.INTEGER_ZERO.intValue());
        String firstCellStr = firstCell.getStringCellValue();
        if (!HEADER_FIRST_CELL_STR.equals(firstCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e00\u5217\u6807\u9898\u4e3a:{}", (Object)firstCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e00\u5217\u4e0d\u4e3a\u3010\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09\u3011");
        }
        Cell secondCell = headerRow.getCell(NumberUtils.INTEGER_ONE.intValue());
        String secondCellStr = secondCell.getStringCellValue();
        if (!HEADER_SECOND_CELL_STR.equals(secondCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e8c\u5217\u6807\u9898\u4e3a:{}", (Object)secondCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e8c\u5217\u4e0d\u4e3a\u3010\u5ba2\u6237\u540d\u79f0\u3011");
        }
        HashSet customers = Sets.newHashSet();
        int totalCount = physicalNumberOfRows - 1;
        int i = 0;
        int dataStartRow = 0;
        while (i < totalCount) {
            Row row;
            if (Objects.isNull(row = sheet.getRow(++dataStartRow))) continue;
            Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String mobile = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)mobile)) {
                ++i;
                continue;
            }
            String name = null;
            cell = row.getCell(NumberUtils.INTEGER_ONE.intValue());
            if (!Objects.isNull(cell)) {
                cell.setCellType(CellType.STRING);
                name = cell.getStringCellValue();
            }
            if (MobileUtils.isPhone((String)mobile)) {
                customers.add(new CustomerDto(mobile, name));
            }
            ++i;
        }
        return Lists.newArrayList((Iterable)customers);
    }

    private static Workbook create(InputStream inp) throws IOException, InvalidFormatException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    private void sendAndSave(List<SmsTaskDetail> smsTaskDetailList, SmsTask smsTask) {
        String content = smsTask.getContent();
        String signature = smsTask.getSignatureId();
        Long bizId = smsTask.getBizId();
        String corpId = smsTask.getCorpId();
        log.info("sendAndSave content:{}", (Object)content);
        if (content.contains(CUSTOMER_NAME_STR) || content.contains(CUSTOMER_PHONE_STR) || content.contains(TEMPLATE_NAME_STR) || content.contains(TEMPLATE_PHONE_STR)) {
            for (SmsTaskDetail smsTaskDetail2 : smsTaskDetailList) {
                String name = smsTaskDetail2.getName();
                String phone = smsTaskDetail2.getPhone();
                String sendContent = this.replaceContent(content, phone, name);
                Map<String, String> params = this.getSendOneParams(smsTaskDetail2.getPhone(), sendContent, corpId, signature);
                try {
                    JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.sendUrl, params);
                    String bjyTaskId = jsonObject.getJSONObject("data").getString(SEND_ID);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bjyTaskId), (Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                    smsTaskDetail2.setBjyTaskId(bjyTaskId);
                    smsTaskDetail2.setStatus(Integer.valueOf(StatusEnum.WAIT.getValue()));
                }
                catch (Exception e) {
                    log.error("send sms error", (Throwable)e);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
                }
            }
        } else {
            String bjyTaskId;
            List<String> phones = smsTaskDetailList.stream().map(SmsTaskDetail::getPhone).collect(Collectors.toList());
            Map<String, String> params = this.getSendParams(phones, content, corpId, signature);
            try {
                JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.sendUrl, params);
                bjyTaskId = jsonObject.getJSONObject("data").getString(SEND_ID);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bjyTaskId), (Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            }
            catch (Exception e) {
                log.error("send sms error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
            }
            smsTaskDetailList.stream().forEach(smsTaskDetail -> {
                smsTaskDetail.setBjyTaskId(bjyTaskId);
                smsTaskDetail.setStatus(Integer.valueOf(StatusEnum.WAIT.getValue()));
            });
        }
        if (smsTask.getSendType() == 1) {
            this.smsTaskDetailMapper.batchUpdate(smsTaskDetailList);
        } else {
            this.smsTaskDetailMapper.batchInsert(smsTaskDetailList);
        }
        if (!CollectionUtils.isEmpty(smsTaskDetailList)) {
            for (SmsTaskDetail detail : smsTaskDetailList) {
                this.followRecordMsgService.followRecordToKafka(FollowRecordMsg.fromSmsRecord((SmsTaskDetail)detail));
            }
        }
    }

    public List<SmsTaskDetail> buildSmsTaskDetailList(SmsTaskReqDto smsTaskReqDto, Long smsTaskId, String bjyTaskId, String bjyResult, List<CustomerDto> customers) {
        ArrayList<SmsTaskDetail> smsTaskDetailList = new ArrayList<SmsTaskDetail>();
        Long bizId = smsTaskReqDto.getBizId();
        String corpId = smsTaskReqDto.getCorpId();
        Integer status = smsTaskReqDto.getSendType() == 1 ? Integer.valueOf(StatusEnum.WAIT_SEND.getValue()) : Integer.valueOf(StatusEnum.WAIT.getValue());
        if (bizId == null) {
            CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
            customers.stream().forEach(customer -> smsTaskDetailList.add(SmsTaskDetail.builder().num(this.idGen.getNum()).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).smsTaskId(smsTaskId).bjyTaskId(bjyTaskId).status(status).bjyResult(bjyResult).phone(customer.getPhone()).name(customer.getName()).createBy(currentUser.getId()).createTime(new Date()).updateBy(currentUser.getId()).updateTime(new Date()).build()));
        } else {
            customers.stream().forEach(customer -> smsTaskDetailList.add(SmsTaskDetail.builder().num(this.idGen.getNum()).bizId(bizId).corpId(corpId).smsTaskId(smsTaskId).bjyTaskId(bjyTaskId).status(status).bjyResult(bjyResult).phone(customer.getPhone()).name(customer.getName()).createBy(bizId).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).build()));
        }
        return smsTaskDetailList;
    }

    private void check(int size, String content, Long bizId, String signature) {
        int total;
        String msg = "\u3010" + signature + "\u3011" + content;
        int number = this.getNumberByMsg(msg);
        Map<String, String> params = this.getCheckParams(msg);
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.checkUrl, params);
            total = jsonObject.getJSONObject("data").getIntValue("total");
        }
        catch (BusinessException e) {
            log.error("check sms error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("check sms error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6821\u9a8c\u4f59\u989d\u5f02\u5e38");
        }
        Preconditions.checkArgument((total > number * size ? 1 : 0) != 0, (Object)("\u672c\u6b21\u53d1\u9001\u4efb\u52a1\u6309" + number * size + "\u6761\u77ed\u4fe1\u8ba1\u8d39\uff08\u5f53\u524d\u53ef\u53d1\u9001" + total + "\u6761\uff09\uff0c\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u5145\u503c\uff01"));
    }

    private int getNumberByMsg(String msg) {
        if (msg.length() < 70) {
            return 1;
        }
        return msg.length() / 67 + 1;
    }

    private Map<String, String> getCheckParams(String content) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(CONTENT, content);
        return map;
    }

    private Map<String, String> getNoticeSendParams(List<String> phones, String content, String signature) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(SMS_SIGN, signature);
        map.put(CONTENT, content);
        map.put("to", String.join((CharSequence)",", phones));
        return map;
    }

    private Map<String, String> getSendParams(List<String> phones, String content, String corpId, String signature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CORP_ID, (Object)corpId);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(SMS_SIGN, signature);
        map.put(CONTENT, content);
        map.put("type", "100003");
        map.put("to", String.join((CharSequence)",", phones));
        map.put("custom_params", jsonObject.toJSONString());
        return map;
    }

    private Map<String, String> getSendOneParams(String phone, String content, String corpId, String signature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CORP_ID, (Object)corpId);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(SMS_SIGN, signature);
        map.put("type", "100003");
        map.put(CONTENT, content);
        map.put("to", phone);
        map.put("custom_params", jsonObject.toJSONString());
        return map;
    }

    private Map<String, String> getNoticeSendInfoParams(String bjyTaskId, String phone, String partnerId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("partner_id", partnerId);
        map.put("msg_id", bjyTaskId);
        map.put("mobile", phone);
        return map;
    }

    private Map<String, String> getSendDetailParams(String bjyTaskId, int page, String partnerId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("partner_id", partnerId);
        map.put(SEND_ID, bjyTaskId);
        map.put("page", String.valueOf(page));
        map.put("page_size", String.valueOf(100));
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return map;
    }
}

