/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.ScrmSmsService;
import com.kuaike.scrm.common.service.dto.AppSmsRespDto;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.service.dto.req.SmsSendReqDto;
import com.kuaike.scrm.common.service.dto.resp.SmsCountRespDto;
import com.kuaike.scrm.common.service.dto.resp.SmsRecordDto;
import com.kuaike.scrm.dal.sms.dto.SmsTaskQueryParams;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskDetailMapper;
import com.kuaike.scrm.sms.dto.SmsTaskDetailRespDto;
import com.kuaike.scrm.sms.dto.SmsTaskReqDto;
import com.kuaike.scrm.sms.service.SmsTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScrmSmsServiceImpl
implements ScrmSmsService {
    private static final Logger log = LoggerFactory.getLogger(ScrmSmsServiceImpl.class);
    @Autowired
    private SmsTaskService smsTaskService;
    @Autowired
    private SmsTaskDetailMapper smsTaskDetailMapper;

    public AppSmsRespDto recordList(List<String> phones, PageDto pageDto) {
        return this.resultList(phones, pageDto);
    }

    public AppSmsRespDto recordList(String phone, PageDto pageDto) {
        return this.resultList(Lists.newArrayList((Object[])new String[]{phone}), pageDto);
    }

    public Long sendCustomSms(ScrmSendSmsReqDto reqDto) {
        log.info("sendCustomSms, reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        return this.smsTaskService.sendCustomSms(reqDto);
    }

    public Long sendNoticeSms(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSms, reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        return this.smsTaskService.sendNoticeSms(reqDto);
    }

    public Long sendNoticeSmsBatch(ScrmSendSmsReqDto reqDto) {
        log.info("sendNoticeSmsBatch, reqDto:{}", (Object)reqDto);
        reqDto.validateBatchParams();
        return this.smsTaskService.sendNoticeSmsBatch(reqDto);
    }

    public Map<Long, Integer> getSendStatusBySmsTaskDetailIds(Collection<Long> ids) {
        return this.smsTaskService.getSendStatusBySmsTaskDetailIds(ids);
    }

    public List<SmsCountRespDto> smsCount(SmsSendReqDto reqDto) {
        log.info("smsCount: reqDto:{}", (Object)reqDto);
        reqDto.validate();
        if (CollectionUtils.isEmpty((Collection)reqDto.getPhones())) {
            return Lists.newArrayList();
        }
        SmsTaskQueryParams params = new SmsTaskQueryParams();
        params.setBizId(reqDto.getBizId());
        params.setPhones((Collection)reqDto.getPhones());
        List detailList = this.smsTaskDetailMapper.querySmsCountDetail(params);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return Lists.newArrayList();
        }
        List latestSmsRecords = this.smsTaskDetailMapper.queryLatestSmsRecord(params);
        Map latestRecordMap = latestSmsRecords.stream().collect(Collectors.toMap(SmsTaskDetail::getPhone, Function.identity()));
        ArrayList<SmsCountRespDto> resultList = new ArrayList<SmsCountRespDto>();
        for (SmsTaskDetail smsTaskDetail : detailList) {
            SmsCountRespDto respDto = new SmsCountRespDto();
            respDto.setPhone(smsTaskDetail.getPhone());
            respDto.setSmsCount(smsTaskDetail.getSmsCount());
            respDto.setSmsSuccessCount(smsTaskDetail.getSmsSuccessCount());
            respDto.setSmsFailCount(smsTaskDetail.getSmsFailCount());
            SmsTaskDetail latestRecord = (SmsTaskDetail)latestRecordMap.get(smsTaskDetail.getPhone());
            if (latestRecord != null) {
                respDto.setLatestSmsId(latestRecord.getNum());
                respDto.setLatestSmsTime(latestRecord.getUpdateTime());
            }
            resultList.add(respDto);
        }
        return resultList;
    }

    private AppSmsRespDto resultList(List<String> phones, PageDto pageDto) {
        SmsTaskReqDto reqDto = new SmsTaskReqDto();
        reqDto.setPageDto(pageDto);
        reqDto.setPhones(phones);
        List<SmsTaskDetailRespDto> list = this.smsTaskService.taskDetail(reqDto);
        ArrayList<SmsRecordDto> resultList = new ArrayList<SmsRecordDto>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SmsTaskDetailRespDto smsTaskDetailRespDto : list) {
                SmsRecordDto smsRecordDto = new SmsRecordDto();
                BeanUtils.copyProperties((Object)smsTaskDetailRespDto, (Object)smsRecordDto);
                resultList.add(smsRecordDto);
            }
        }
        return new AppSmsRespDto(resultList, reqDto.getPageDto());
    }
}

