/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.sms.dto.SmsTemplateQueryParams;
import com.kuaike.scrm.dal.sms.entity.SmsTemplate;
import com.kuaike.scrm.sms.service.impl.AuditStatusEnum;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SmsTemplateReqDto {
    private Long id;
    private String name;
    private String signatureId;
    private String content;
    private Integer auditStatus;
    private PageDto pageDto;
    private List<String> deptIds;
    private List<String> userIds;

    public SmsTemplate backward(String num, String bjyTemplateId) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        return SmsTemplate.builder().num(num).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).content(this.content).name(this.name).signatureId(this.signatureId).bjyTemplateId(bjyTemplateId).auditStatus(Integer.valueOf(AuditStatusEnum.WAIT.getValue())).createBy(currentUser.getId()).createTime(new Date()).updateBy(currentUser.getId()).updateTime(new Date()).isDeleted(Integer.valueOf(0)).build();
    }

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAddParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.signatureId), (Object)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public SmsTemplateQueryParams to(Long bizId) {
        SmsTemplateQueryParams params = new SmsTemplateQueryParams();
        params.setBizId(bizId);
        params.setName(StringUtils.isNotBlank((CharSequence)this.name) ? this.name.trim() : this.name);
        params.setPageDto(this.pageDto);
        params.setAuditStatus(this.auditStatus);
        return params;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public List<String> getDeptIds() {
        return this.deptIds;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setDeptIds(List<String> deptIds) {
        this.deptIds = deptIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsTemplateReqDto)) {
            return false;
        }
        SmsTemplateReqDto other = (SmsTemplateReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$auditStatus = this.getAuditStatus();
        Integer other$auditStatus = other.getAuditStatus();
        if (this$auditStatus == null ? other$auditStatus != null : !((Object)this$auditStatus).equals(other$auditStatus)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$signatureId = this.getSignatureId();
        String other$signatureId = other.getSignatureId();
        if (this$signatureId == null ? other$signatureId != null : !this$signatureId.equals(other$signatureId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        List<String> this$deptIds = this.getDeptIds();
        List<String> other$deptIds = other.getDeptIds();
        if (this$deptIds == null ? other$deptIds != null : !((Object)this$deptIds).equals(other$deptIds)) {
            return false;
        }
        List<String> this$userIds = this.getUserIds();
        List<String> other$userIds = other.getUserIds();
        return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsTemplateReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $auditStatus = this.getAuditStatus();
        result = result * 59 + ($auditStatus == null ? 43 : ((Object)$auditStatus).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $signatureId = this.getSignatureId();
        result = result * 59 + ($signatureId == null ? 43 : $signatureId.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        List<String> $deptIds = this.getDeptIds();
        result = result * 59 + ($deptIds == null ? 43 : ((Object)$deptIds).hashCode());
        List<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        return result;
    }

    public String toString() {
        return "SmsTemplateReqDto(id=" + this.getId() + ", name=" + this.getName() + ", signatureId=" + this.getSignatureId() + ", content=" + this.getContent() + ", auditStatus=" + this.getAuditStatus() + ", pageDto=" + this.getPageDto() + ", deptIds=" + this.getDeptIds() + ", userIds=" + this.getUserIds() + ")";
    }
}

