/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.dto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.sms.dto.SmsTaskQueryParams;
import com.kuaike.scrm.dal.sms.entity.SmsTask;
import com.kuaike.scrm.sms.service.impl.SmsChannelEnum;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class SmsTaskReqDto {
    private String num;
    private String reason;
    private String signatureId;
    private String signature;
    private Integer contentType;
    private String content;
    private Long createBy;
    private Date createTime;
    private Long updateBy;
    private Date updateTime;
    private IdGen idGen;
    private String userId;
    private String nodeId;
    private Long smsTaskId;
    private Date startTime;
    private Date endTime;
    private String operatorName;
    private PageDto pageDto;
    private List<String> phones;
    private List<CustomerDto> customers;
    private Integer status;
    private String phone;
    private String batchId;
    private Integer sendType;
    private Date sendTime;
    private Long bizId;
    private String corpId;

    public SmsTask backward() {
        SmsTask smsTask;
        if (this.bizId == null) {
            CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
            smsTask = SmsTask.builder().num(this.idGen.getNum()).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).content(this.content).contentType(this.contentType).reason(this.reason).signatureId(this.signatureId).totalCount(Integer.valueOf(this.customers.size())).failCount(Integer.valueOf(0)).successCount(Integer.valueOf(0)).createBy(currentUser.getId()).channel(Integer.valueOf(SmsChannelEnum.MARKETING.getValue())).sendType(this.sendType).sendTime(this.sendTime).createTime(new Date()).updateBy(currentUser.getId()).updateTime(new Date()).build();
        } else {
            smsTask = SmsTask.builder().num(this.idGen.getNum()).bizId(this.bizId).corpId(this.corpId).content(this.content).contentType(this.contentType).reason(this.reason).signatureId(this.signatureId).totalCount(Integer.valueOf(this.customers.size())).failCount(Integer.valueOf(0)).successCount(Integer.valueOf(0)).createBy(Long.valueOf(-1L)).channel(Integer.valueOf(SmsChannelEnum.MARKETING.getValue())).sendType(this.sendType).sendTime(this.sendTime).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).build();
        }
        if (smsTask.getSendType() == 1) {
            smsTask.setStatus(Integer.valueOf(0));
        }
        return smsTask;
    }

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        if (this.bizId != null && StringUtils.isNotBlank((CharSequence)this.corpId)) {
            return;
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAddParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.contentType) ? 1 : 0) != 0, (Object)"\u5185\u5bb9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.sendType == null) {
            this.sendType = 0;
        }
    }

    public SmsTaskQueryParams to(Long bizId) {
        SmsTaskQueryParams smsTaskQueryParams = new SmsTaskQueryParams();
        smsTaskQueryParams.setOperatorName(this.operatorName);
        smsTaskQueryParams.setBizId(bizId);
        smsTaskQueryParams.setStartDate(this.startTime);
        smsTaskQueryParams.setEndDate(this.endTime);
        smsTaskQueryParams.setStatus(this.status);
        smsTaskQueryParams.setPhones(StringUtils.isNotBlank((CharSequence)this.phone) ? Lists.newArrayList((Object[])new String[]{this.phone.trim()}) : null);
        smsTaskQueryParams.setPageDto(this.pageDto);
        smsTaskQueryParams.setSmsTaskId(this.smsTaskId);
        return smsTaskQueryParams;
    }

    public String getNum() {
        return this.num;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public String getSignature() {
        return this.signature;
    }

    public Integer getContentType() {
        return this.contentType;
    }

    public String getContent() {
        return this.content;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public IdGen getIdGen() {
        return this.idGen;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Long getSmsTaskId() {
        return this.smsTaskId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public List<String> getPhones() {
        return this.phones;
    }

    public List<CustomerDto> getCustomers() {
        return this.customers;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setIdGen(IdGen idGen) {
        this.idGen = idGen;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setSmsTaskId(Long smsTaskId) {
        this.smsTaskId = smsTaskId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setPhones(List<String> phones) {
        this.phones = phones;
    }

    public void setCustomers(List<CustomerDto> customers) {
        this.customers = customers;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsTaskReqDto)) {
            return false;
        }
        SmsTaskReqDto other = (SmsTaskReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$contentType = this.getContentType();
        Integer other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        Long this$createBy = this.getCreateBy();
        Long other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy)) {
            return false;
        }
        Long this$updateBy = this.getUpdateBy();
        Long other$updateBy = other.getUpdateBy();
        if (this$updateBy == null ? other$updateBy != null : !((Object)this$updateBy).equals(other$updateBy)) {
            return false;
        }
        Long this$smsTaskId = this.getSmsTaskId();
        Long other$smsTaskId = other.getSmsTaskId();
        if (this$smsTaskId == null ? other$smsTaskId != null : !((Object)this$smsTaskId).equals(other$smsTaskId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$signatureId = this.getSignatureId();
        String other$signatureId = other.getSignatureId();
        if (this$signatureId == null ? other$signatureId != null : !this$signatureId.equals(other$signatureId)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        IdGen this$idGen = this.getIdGen();
        IdGen other$idGen = other.getIdGen();
        if (this$idGen == null ? other$idGen != null : !this$idGen.equals(other$idGen)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$operatorName = this.getOperatorName();
        String other$operatorName = other.getOperatorName();
        if (this$operatorName == null ? other$operatorName != null : !this$operatorName.equals(other$operatorName)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        List<String> this$phones = this.getPhones();
        List<String> other$phones = other.getPhones();
        if (this$phones == null ? other$phones != null : !((Object)this$phones).equals(other$phones)) {
            return false;
        }
        List<CustomerDto> this$customers = this.getCustomers();
        List<CustomerDto> other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        return !(this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsTaskReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        Long $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        Long $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : ((Object)$updateBy).hashCode());
        Long $smsTaskId = this.getSmsTaskId();
        result = result * 59 + ($smsTaskId == null ? 43 : ((Object)$smsTaskId).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $signatureId = this.getSignatureId();
        result = result * 59 + ($signatureId == null ? 43 : $signatureId.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        IdGen $idGen = this.getIdGen();
        result = result * 59 + ($idGen == null ? 43 : $idGen.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $operatorName = this.getOperatorName();
        result = result * 59 + ($operatorName == null ? 43 : $operatorName.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        List<String> $phones = this.getPhones();
        result = result * 59 + ($phones == null ? 43 : ((Object)$phones).hashCode());
        List<CustomerDto> $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        return result;
    }

    public String toString() {
        return "SmsTaskReqDto(num=" + this.getNum() + ", reason=" + this.getReason() + ", signatureId=" + this.getSignatureId() + ", signature=" + this.getSignature() + ", contentType=" + this.getContentType() + ", content=" + this.getContent() + ", createBy=" + this.getCreateBy() + ", createTime=" + this.getCreateTime() + ", updateBy=" + this.getUpdateBy() + ", updateTime=" + this.getUpdateTime() + ", idGen=" + this.getIdGen() + ", userId=" + this.getUserId() + ", nodeId=" + this.getNodeId() + ", smsTaskId=" + this.getSmsTaskId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", operatorName=" + this.getOperatorName() + ", pageDto=" + this.getPageDto() + ", phones=" + this.getPhones() + ", customers=" + this.getCustomers() + ", status=" + this.getStatus() + ", phone=" + this.getPhone() + ", batchId=" + this.getBatchId() + ", sendType=" + this.getSendType() + ", sendTime=" + this.getSendTime() + ", bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ")";
    }
}

