/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSkuAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSpuAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CategoryLevelDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SkuItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpuItemDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuAddReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuBatchAddReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuIdReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdatePriceReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuUpdateStockReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuUpdateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuBatchAddResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuAddResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuUpdateResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.UploadImgResp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletCommonService;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.shop.dto.SkuStatisticResult;
import com.kuaike.scrm.dal.shop.dto.SpuProductIdReq;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.shop.dto.ProductEsModel;
import com.kuaike.scrm.shop.dto.SaleStatisticDto;
import com.kuaike.scrm.shop.dto.spu.dto.CacheCategoryItem;
import com.kuaike.scrm.shop.dto.spu.dto.DescInfoDto;
import com.kuaike.scrm.shop.dto.spu.dto.SkuItemDto;
import com.kuaike.scrm.shop.dto.spu.req.SpuAddReq;
import com.kuaike.scrm.shop.dto.spu.req.SpuListQueryParam;
import com.kuaike.scrm.shop.dto.spu.resp.SpuListItem;
import com.kuaike.scrm.shop.dto.spu.resp.SpuStatusStatisticResp;
import com.kuaike.scrm.shop.enums.WxShopSpuEditStatus;
import com.kuaike.scrm.shop.enums.WxShopSpuStatus;
import com.kuaike.scrm.shop.enums.WxShopValidType;
import com.kuaike.scrm.shop.service.OrderEsService;
import com.kuaike.scrm.shop.service.ProductEsService;
import com.kuaike.scrm.shop.service.ShopCommonService;
import com.kuaike.scrm.shop.service.ShopProductService;
import com.kuaike.scrm.shop.service.datasync.CategoryPullService;
import com.kuaike.scrm.utils.HttpHeadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopProductServiceImpl
implements ShopProductService {
    private static final Logger log = LoggerFactory.getLogger(ShopProductServiceImpl.class);
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private WxShopSpuAPI wxShopSpuAPI;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Autowired
    private AppletCommonService appletCommonService;
    @Autowired
    private ShopCommonService shopCommonService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ProductEsService productEsService;
    @Autowired
    private OrderEsService orderEsService;
    @Autowired
    private ShopSkuMapper skuMapper;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private WxShopSkuAPI shopSkuAPI;
    @Autowired
    private CategoryPullService categoryPullService;
    @Autowired
    private DistributedLock lock;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SpuItemDto add(SpuAddReq req) {
        log.info("add spu with req={}", (Object)req);
        StopWatchDto timer = new StopWatchDto("skuAdd", true, log);
        timer.start("checkAndSetOutProductIdSkuId");
        this.checkAndSetOutProductIdSkuId(req);
        timer.stop();
        timer.start("validate");
        req.validate();
        timer.stop();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        timer.start("getAccessToken");
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        timer.stop();
        timer.start("exchangeWxImg");
        this.exchangeWxImg(req, currentUserInfo, appId);
        timer.stop();
        cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuAddReq spuAddReq = (cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuAddReq)JSONObject.parseObject((String)JSON.toJSONString((Object)req), cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuAddReq.class);
        timer.start("add");
        SpuAddResp spuAddResp = this.wxShopSpuAPI.spuAdd(accessToken, spuAddReq);
        timer.stop();
        timer.start("spuGet");
        SpuGetReq spuGetReq = new SpuGetReq();
        spuGetReq.setProductId(spuAddResp.getData().getProductId());
        spuGetReq.setNeedEditSpu(1);
        SpuGetResp spuGetResp = this.wxShopSpuAPI.spuGet(accessToken, spuGetReq);
        timer.stop();
        timer.print();
        return spuGetResp.getData().getSpu();
    }

    private void checkAndSetOutProductIdSkuId(SpuAddReq req) {
        if (StringUtils.isBlank((CharSequence)req.getOutProductId())) {
            req.setOutProductId(this.idGen.getNum());
        }
        if (CollectionUtils.isNotEmpty(req.getSkus())) {
            for (SkuItemDto sku : req.getSkus()) {
                if (!StringUtils.isBlank((CharSequence)sku.getOutSkuId())) continue;
                sku.setOutSkuId(this.idGen.getNum());
                sku.setOutProductId(req.getOutProductId());
            }
        }
    }

    private void exchangeWxImg(SpuAddReq req, CurrentUserInfo currentUserInfo, String appId) {
        StopWatchDto timer = new StopWatchDto("exchangeWxImg", true, log);
        HashSet aliCloudImgUrls = Sets.newHashSet();
        timer.start("addImgs");
        this.addImgs(req, aliCloudImgUrls);
        timer.stop();
        if (CollectionUtils.isEmpty((Collection)aliCloudImgUrls)) {
            timer.print();
            return;
        }
        timer.start("asynch execute");
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)aliCloudImgUrls.size());
        HashMap url2TempUrl = Maps.newHashMap();
        for (String aliCloudImgUrl : aliCloudImgUrls) {
            futureList.add(CompletableFuture.supplyAsync(() -> {
                try {
                    UploadImgResp uploadImgResp = this.shopCommonService.saveUploadImg(appId, aliCloudImgUrl, currentUserInfo.getId(), false, true);
                    url2TempUrl.put(aliCloudImgUrl, uploadImgResp.getPicFile().getTempImgUrl());
                }
                catch (IOException e) {
                    log.error("saveUploadImg with error", (Throwable)e);
                }
                return null;
            }, ThreadTools.getIoTaskThreadPool()));
        }
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        CompletionStage resultList = allFuture.thenApplyAsync(value -> futureList.stream().map(CompletableFuture::join).collect(Collectors.toList()), (Executor)ThreadTools.getIoTaskThreadPool());
        ((CompletableFuture)resultList).join();
        timer.stop();
        timer.start("changeImgs");
        this.changeImgs(req, url2TempUrl);
        timer.stop();
        timer.print();
    }

    private void changeImgs(SpuAddReq req, Map<String, String> url2TempUrl) {
        ArrayList finalHeadImg;
        if (CollectionUtils.isNotEmpty(req.getHeadImg())) {
            finalHeadImg = Lists.newArrayList();
            for (String img : req.getHeadImg()) {
                if (HttpHeadUtils.isWxResource((String)img)) {
                    finalHeadImg.add(img);
                    continue;
                }
                if (!Objects.nonNull(url2TempUrl.get(img))) continue;
                finalHeadImg.add(url2TempUrl.get(img));
            }
            req.setHeadImg(finalHeadImg);
        }
        if (CollectionUtils.isNotEmpty(req.getDescInfo().getImgs())) {
            finalHeadImg = Lists.newArrayList();
            for (String img : req.getDescInfo().getImgs()) {
                if (HttpHeadUtils.isWxResource((String)img)) {
                    finalHeadImg.add(img);
                    continue;
                }
                if (!Objects.nonNull(url2TempUrl.get(img))) continue;
                finalHeadImg.add(url2TempUrl.get(img));
            }
            req.getDescInfo().setImgs(finalHeadImg);
        }
        if (CollectionUtils.isNotEmpty(req.getSkus())) {
            for (SkuItemDto dto : req.getSkus()) {
                if (!StringUtils.isNotBlank((CharSequence)dto.getThumbImg()) || HttpHeadUtils.isWxResource((String)dto.getThumbImg())) continue;
                dto.setThumbImg(url2TempUrl.get(dto.getThumbImg()));
            }
        }
    }

    private void findExchangeImgs(List<String> imgs, Collection<String> aliCloudImgUrls) {
        List needChangeImgs;
        if (CollectionUtils.isNotEmpty(imgs) && CollectionUtils.isNotEmpty(needChangeImgs = imgs.stream().filter(a -> !HttpHeadUtils.isWxResource((String)a)).collect(Collectors.toList()))) {
            aliCloudImgUrls.addAll(needChangeImgs);
        }
    }

    private void addImgs(SpuAddReq req, Collection<String> aliCloudImgUrls) {
        List<String> thumbImgs;
        if (CollectionUtils.isNotEmpty(req.getHeadImg())) {
            this.findExchangeImgs(req.getHeadImg(), aliCloudImgUrls);
        }
        if (CollectionUtils.isNotEmpty(req.getDescInfo().getImgs())) {
            this.findExchangeImgs(req.getDescInfo().getImgs(), aliCloudImgUrls);
        }
        if (CollectionUtils.isNotEmpty(req.getSkus()) && CollectionUtils.isNotEmpty(thumbImgs = req.getSkus().stream().map(SkuItemDto::getThumbImg).filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            this.findExchangeImgs(thumbImgs, aliCloudImgUrls);
        }
    }

    @Override
    public void update(com.kuaike.scrm.shop.dto.spu.req.SpuUpdateReq req) {
        log.info("update spu with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        SpuGetReq spuGetReq = new SpuGetReq();
        spuGetReq.setProductId(Long.valueOf(req.getProductId()));
        spuGetReq.setOutProductId(req.getOutProductId());
        spuGetReq.setNeedEditSpu(1);
        SpuGetResp spuGetResp = this.wxShopSpuAPI.spuGet(accessToken, spuGetReq);
        Preconditions.checkArgument((Objects.nonNull(spuGetResp) && Objects.nonNull(spuGetResp.getData()) && Objects.nonNull(spuGetResp.getData().getSpu()) ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        SpuItemDto spuItemDto = spuGetResp.getData().getSpu();
        Preconditions.checkArgument((!Objects.equals(spuItemDto.getEditStatus(), WxShopSpuEditStatus.AUDITING.getStatus()) ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6b63\u5728\u5ba1\u6838\u4e2d,\u4e0d\u80fd\u7ee7\u7eed\u4fee\u6539");
        this.exchangeWxImg(req, currentUserInfo, appId);
        String productId = req.getProductId();
        SpuUpdateReq spuUpdateReq = (SpuUpdateReq)JSON.parseObject((String)JSON.toJSONString((Object)req), SpuUpdateReq.class);
        List newSkuItem = spuUpdateReq.getSkus();
        this.readAndUpdateSku(req, accessToken, productId, newSkuItem);
        spuUpdateReq.setSkus(null);
        SpuUpdateResp spuUpdateResp = this.wxShopSpuAPI.spuUpdate(accessToken, spuUpdateReq);
        log.info("spu update resp:{}", (Object)spuUpdateResp);
    }

    private void readAndUpdateSku(com.kuaike.scrm.shop.dto.spu.req.SpuUpdateReq req, String accessToken, String productId, List<SkuItem> newSkuItem) {
        List addSkuItems;
        Integer editStatus = 1;
        Integer needRealStock = 0;
        List<SkuItem> oldSkuItem = this.getSkuItems(req.getProductId(), accessToken, editStatus, needRealStock);
        List nowSkuIds = oldSkuItem.stream().map(SkuItem::getSkuId).collect(Collectors.toList());
        List newSkuIds = newSkuItem.stream().map(SkuItem::getSkuId).filter(a -> Objects.nonNull(a) && a != 0L).collect(Collectors.toList());
        HashSet updateSkuIds = Sets.newHashSet((Iterable)CollectionUtils.intersection(newSkuIds, nowSkuIds));
        HashSet deleteSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(nowSkuIds, newSkuIds));
        HashSet addSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(newSkuIds, nowSkuIds));
        this.collectUpdateItems(accessToken, newSkuItem, oldSkuItem, updateSkuIds);
        if (CollectionUtils.isNotEmpty((Collection)deleteSkuIds)) {
            log.info("deleted sku = {}", (Object)deleteSkuIds);
            for (Long skuId : deleteSkuIds) {
                SkuIdReq skuIdReq = new SkuIdReq();
                skuIdReq.setSkuId(skuId);
                skuIdReq.setProductId(Long.valueOf(productId));
                this.shopSkuAPI.skuDel(accessToken, skuIdReq);
            }
        }
        if (CollectionUtils.isNotEmpty(addSkuItems = newSkuItem.stream().filter(a -> addSkuIds.contains(a.getSkuId()) || a.getSkuId() == null || a.getSkuId().equals(0L)).collect(Collectors.toList()))) {
            SkuBatchAddReq batchAddReq = new SkuBatchAddReq();
            ArrayList skuAddReqs = Lists.newArrayList();
            for (SkuItem addSkuItem : addSkuItems) {
                SkuAddReq skuAddReq = (SkuAddReq)JSON.parseObject((String)JSON.toJSONString((Object)addSkuItem), SkuAddReq.class);
                skuAddReqs.add(skuAddReq);
            }
            batchAddReq.setSkus((List)skuAddReqs);
            SkuBatchAddResp batchAddResp = this.shopSkuAPI.skuBatchAdd(accessToken, batchAddReq);
            log.info("sku batch add resp:{}", (Object)batchAddResp);
        }
    }

    public void syncSkus(String appId, String productId, String accessToken, Integer editStatus, Integer needRealStock) {
        log.info("syncSkus with appId={},productId={},editStatus={},needRealStock={}", new Object[]{appId, productId, editStatus, needRealStock});
        List shopSkus = this.skuMapper.queryByProductId(appId, productId);
        Set oldSkuIds = shopSkus.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
        List<SkuItem> newAllSkuItems = this.getSkuItems(productId, accessToken, editStatus, needRealStock);
        Set newSkuIds = newAllSkuItems.stream().map(a -> String.valueOf(a.getSkuId())).collect(Collectors.toSet());
        HashSet deletedSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(oldSkuIds, newSkuIds));
        HashSet addSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(newSkuIds, oldSkuIds));
        HashSet updateSkuIds = Sets.newHashSet((Iterable)CollectionUtils.intersection(newSkuIds, oldSkuIds));
        ArrayList updateSkus = Lists.newArrayList();
        ArrayList addSkus = Lists.newArrayList();
        for (SkuItem item : newAllSkuItems) {
            ShopSku shopSku = this.getShopSku(appId, item);
            if (updateSkuIds.contains(item.getSkuId())) {
                updateSkus.add(shopSku);
            }
            if (!addSkuIds.contains(item.getSkuId())) continue;
            addSkus.add(shopSku);
        }
        if (CollectionUtils.isNotEmpty((Collection)addSkus)) {
            this.skuMapper.batchInsert((Collection)addSkus);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateSkus)) {
            this.skuMapper.batchUpdate((Collection)updateSkus);
        }
        if (CollectionUtils.isNotEmpty((Collection)deletedSkuIds)) {
            this.skuMapper.deleteBySkuIds(String.valueOf(productId), (Collection)deletedSkuIds);
        }
    }

    private void collectUpdateItems(String accessToken, List<SkuItem> newSkuItem, List<SkuItem> oldSkuItem, Set<Long> updateSkuIds) {
        if (CollectionUtils.isNotEmpty(updateSkuIds)) {
            HashSet updateSkuItems = Sets.newHashSet();
            HashSet updateSkuPriceItems = Sets.newHashSet();
            HashSet updateSkuStockItems = Sets.newHashSet();
            Map<Long, SkuItem> oldSkuId2Item = oldSkuItem.stream().collect(Collectors.toMap(SkuItem::getSkuId, a -> a));
            Map<Long, SkuItem> newSkuId2Item = newSkuItem.stream().collect(Collectors.toMap(SkuItem::getSkuId, a -> a));
            updateSkuIds.forEach(skuId -> {
                SkuItem oldItem = oldSkuId2Item.getOrDefault(skuId, new SkuItem());
                SkuItem newItem = newSkuId2Item.getOrDefault(skuId, new SkuItem());
                if (!Objects.equals(newItem.getSalePrice(), oldItem.getSalePrice()) || !Objects.equals(newItem.getMarketPrice(), oldItem.getMarketPrice())) {
                    updateSkuItems.add(newItem);
                    updateSkuPriceItems.add(newItem);
                }
                if (!Objects.equals(newItem.getStockNum(), oldItem.getStockNum())) {
                    updateSkuItems.add(newItem);
                    updateSkuStockItems.add(newItem);
                }
                if (!(Objects.equals(newItem.getBarCode(), oldItem.getBarCode()) && Objects.equals(newItem.getSkuCode(), oldItem.getSkuCode()) && Objects.equals(newItem.getThumbImg(), oldItem.getThumbImg()) && CollectionUtils.isEqualCollection((Collection)newItem.getSkuAttrs(), (Collection)oldItem.getSkuAttrs()))) {
                    updateSkuItems.add(newItem);
                }
            });
            updateSkuPriceItems.removeAll(updateSkuItems);
            if (CollectionUtils.isNotEmpty((Collection)updateSkuPriceItems)) {
                log.info("only change price,skuItems={}", (Object)updateSkuPriceItems);
                for (SkuItem item : updateSkuPriceItems) {
                    this.updateSkuPrice(accessToken, item);
                }
            }
            updateSkuStockItems.removeAll(updateSkuItems);
            if (CollectionUtils.isNotEmpty((Collection)updateSkuStockItems)) {
                log.info("only change stock,skuItems={}", (Object)updateSkuStockItems);
                for (SkuItem item : updateSkuStockItems) {
                    this.updateSkuStockNum(accessToken, item);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateSkuItems)) {
                for (SkuItem item : updateSkuItems) {
                    this.updateSku(accessToken, item);
                }
            }
        }
    }

    private ShopSku getShopSku(String appId, SkuItem item) {
        ShopSku shopSku = new ShopSku();
        shopSku.setStatus(item.getStatus());
        shopSku.setProductId(String.valueOf(item.getProductId()));
        shopSku.setOutProductId(item.getOutProductId());
        shopSku.setSkuId(String.valueOf(item.getSkuId()));
        shopSku.setOutSkuId(item.getOutSkuId());
        shopSku.setSkuBody(JSON.toJSONString((Object)item));
        shopSku.setAppId(appId);
        shopSku.setCreateTime(new Date());
        shopSku.setCreateBy(Long.valueOf(-1L));
        shopSku.setMarketPrice(item.getMarketPrice());
        shopSku.setSalePrice(item.getSalePrice());
        shopSku.setStockNum(item.getStockNum());
        shopSku.setNum(this.idGen.getNum());
        shopSku.setBizId(Long.valueOf(-1L));
        shopSku.setSource(Integer.valueOf(1));
        return shopSku;
    }

    private List<SkuItem> getSkuItems(String productId, String accessToken, Integer editStatus, Integer needRealStock) {
        SkuGetListReq skuGetListReq = new SkuGetListReq();
        skuGetListReq.setProductId(Long.valueOf(productId));
        skuGetListReq.setNeedRealStock(needRealStock);
        skuGetListReq.setNeedEditSku(editStatus);
        SkuGetListResp skuGetListResp = this.shopSkuAPI.skuGetBatch(accessToken, skuGetListReq);
        return skuGetListResp.getSkus();
    }

    private void updateSku(String accessToken, SkuItem item) {
        SkuUpdateReq skuUpdateReq = new SkuUpdateReq();
        skuUpdateReq.setSkuId(item.getSkuId());
        skuUpdateReq.setProductId(item.getProductId());
        skuUpdateReq.setOutProductId(item.getOutProductId());
        skuUpdateReq.setStockNum(item.getStockNum());
        skuUpdateReq.setThumbImg(item.getThumbImg());
        skuUpdateReq.setBarCode(item.getBarCode());
        skuUpdateReq.setSkuCode(item.getSkuCode());
        skuUpdateReq.setMarketPrice(item.getMarketPrice());
        skuUpdateReq.setSalePrice(item.getSalePrice());
        skuUpdateReq.setSkuAttrs(item.getSkuAttrs());
        skuUpdateReq.setOutSkuId(item.getOutSkuId());
        this.shopSkuAPI.skuUpdate(accessToken, skuUpdateReq);
    }

    private void updateSkuStockNum(String accessToken, SkuItem item) {
        SkuUpdateStockReq updateStockReq = new SkuUpdateStockReq();
        updateStockReq.setSkuId(item.getSkuId());
        updateStockReq.setStockNum(item.getStockNum());
        updateStockReq.setProductId(item.getProductId());
        updateStockReq.setOutProductId(item.getOutProductId());
        updateStockReq.setOutSkuId(item.getOutSkuId());
        updateStockReq.setType(Integer.valueOf(1));
        this.shopSkuAPI.skuUpdateStock(accessToken, updateStockReq);
    }

    private void updateSkuPrice(String accessToken, SkuItem item) {
        SkuUpdatePriceReq updatePriceReq = new SkuUpdatePriceReq();
        updatePriceReq.setProductId(item.getProductId());
        updatePriceReq.setOutProductId(item.getOutProductId());
        updatePriceReq.setSkuId(item.getSkuId());
        updatePriceReq.setOutSkuId(item.getOutSkuId());
        updatePriceReq.setSalePrice(item.getSalePrice());
        updatePriceReq.setMarketPrice(item.getMarketPrice());
        this.shopSkuAPI.skuUpdatePrice(accessToken, updatePriceReq);
    }

    @Override
    public SpuGetResp queryAndUpdateSpu(Long updateBy, String appId, String accessToken, String productId, String outProductId) {
        log.info("queryAndUpdateSpu with appId={}, updateBy={}, productId={}, outProductId={}", new Object[]{appId, updateBy, productId, outProductId});
        SpuGetReq spuGetReq = new SpuGetReq();
        spuGetReq.setProductId(Long.valueOf(productId));
        spuGetReq.setOutProductId(outProductId);
        spuGetReq.setNeedEditSpu(1);
        return this.wxShopSpuAPI.spuGet(accessToken, spuGetReq);
    }

    @Override
    public void del(SpuProductIdReq req) {
        log.info("del spu with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq spuProductIdReq = new cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq();
        if (StringUtils.isNotBlank((CharSequence)req.getProductId())) {
            spuProductIdReq.setProductId(Long.valueOf(req.getProductId()));
        }
        spuProductIdReq.setOutProductId(req.getOutProductId());
        this.wxShopSpuAPI.spuDel(accessToken, spuProductIdReq);
        ShopSpu item = this.shopSpuMapper.queryByProductIdReq(req);
        req.setProductId(item.getProductId());
        req.setOutProductId(item.getOutProductId());
        this.deleteSpuDb(currentUserInfo, item);
        this.deleteSpuEs(req);
        this.skuMapper.deleteByProductId(req.getProductId());
    }

    private void deleteSpuDb(CurrentUserInfo currentUserInfo, ShopSpu item) {
        item.setUpdateBy(currentUserInfo.getId());
        item.setUpdateTime(new Date());
        item.setIsDeleted(Integer.valueOf(1));
        this.shopSpuMapper.updateByPrimaryKeySelective((Object)item);
    }

    private void deleteSpuEs(SpuProductIdReq req) {
        this.productEsService.deleteProduct(req.getProductId());
    }

    @Override
    public void listing(SpuProductIdReq req) {
        log.info("listing spu with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        SpuGetReq spuGetReq = new SpuGetReq();
        spuGetReq.setProductId(Long.valueOf(req.getProductId()));
        spuGetReq.setOutProductId(req.getOutProductId());
        spuGetReq.setNeedEditSpu(1);
        SpuGetResp spuGetResp = this.wxShopSpuAPI.spuGet(accessToken, spuGetReq);
        Preconditions.checkArgument((Objects.nonNull(spuGetResp) && Objects.nonNull(spuGetResp.getData()) && Objects.nonNull(spuGetResp.getData().getSpu()) ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        SpuItemDto spuItemDto = spuGetResp.getData().getSpu();
        Preconditions.checkArgument((!Objects.equals(spuItemDto.getEditStatus(), WxShopSpuEditStatus.AUDITING.getStatus()) ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6b63\u5728\u5ba1\u6838\u4e2d,\u4e0d\u80fd\u7ee7\u7eed\u4e0a\u67b6");
        Preconditions.checkArgument((!Objects.equals(spuItemDto.getStatus(), WxShopSpuStatus.LISTING.getStatus()) || !Objects.equals(spuItemDto.getEditStatus(), WxShopSpuEditStatus.AUDIT_SUCCESS.getStatus()) ? 1 : 0) != 0, (Object)"\u5546\u54c1\u5df2\u4e0a\u67b6,\u4e0d\u80fd\u7ee7\u7eed\u4e0a\u67b6");
        cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq spuProductIdReq = new cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq();
        if (StringUtils.isNotBlank((CharSequence)req.getProductId())) {
            spuProductIdReq.setProductId(Long.valueOf(req.getProductId()));
        }
        spuProductIdReq.setOutProductId(req.getOutProductId());
        this.wxShopSpuAPI.spuListing(accessToken, spuProductIdReq);
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductIdReq(req);
        if (Objects.nonNull(shopSpu)) {
            shopSpu.setEditStatus(WxShopSpuEditStatus.AUDITING.getStatus());
            shopSpu.setUpdateBy(currentUserInfo.getId());
            shopSpu.setUpdateTime(new Date());
            this.shopSpuMapper.updateByPrimaryKey((Object)shopSpu);
        }
    }

    @Override
    public void delisting(SpuProductIdReq req) {
        log.info("delisting spu with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductIdReq(req);
        cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq spuProductIdReq = new cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq();
        if (StringUtils.isNotBlank((CharSequence)req.getProductId())) {
            spuProductIdReq.setProductId(Long.valueOf(req.getProductId()));
        }
        spuProductIdReq.setOutProductId(req.getOutProductId());
        this.wxShopSpuAPI.spuDelisting(accessToken, spuProductIdReq);
        if (Objects.nonNull(shopSpu)) {
            shopSpu.setStatus(Integer.valueOf(WxShopSpuStatus.SELF_DELISTING.getStatus()));
            shopSpu.setUpdateBy(currentUserInfo.getId());
            shopSpu.setUpdateTime(new Date());
            this.shopSpuMapper.updateByPrimaryKey((Object)shopSpu);
        }
    }

    @Override
    public Map<String, Object> detail(SpuProductIdReq req) {
        log.info("detail with req={}", (Object)req);
        String appId = this.appletCommonService.getCurrentAppId();
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        SpuGetReq getReq = new SpuGetReq();
        getReq.setProductId(Long.valueOf(req.getProductId()));
        getReq.setOutProductId(req.getOutProductId());
        getReq.setNeedEditSpu(1);
        SpuGetResp getResp = this.wxShopSpuAPI.spuGet(accessToken, getReq);
        if (Objects.nonNull(getResp)) {
            SpuItemDto result = getResp.getData().getSpu();
            SkuGetListReq skuGetListReq = new SkuGetListReq();
            skuGetListReq.setProductId(getResp.getData().getSpu().getProductId());
            if (getResp.getData().getSpu().getEditStatus() >= 4) {
                skuGetListReq.setNeedEditSku(Integer.valueOf(0));
                skuGetListReq.setNeedRealStock(Integer.valueOf(1));
            } else {
                skuGetListReq.setNeedEditSku(Integer.valueOf(1));
                skuGetListReq.setNeedRealStock(Integer.valueOf(0));
            }
            SkuGetListResp skuGetListResp = this.shopSkuAPI.skuGetBatch(accessToken, skuGetListReq);
            List oldSkuItem = skuGetListResp.getSkus();
            result.setSkus(oldSkuItem);
            Iterator iterator = result.getCats().iterator();
            while (iterator.hasNext()) {
                CategoryLevelDto cat;
                CacheCategoryItem categoryItem = this.categoryPullService.getCategoryByCatId(appId, (cat = (CategoryLevelDto)iterator.next()).getCatId());
                cat.setName(Objects.nonNull(categoryItem) ? categoryItem.getName() : "");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)result));
            JSONObject couponcodeInfo = jsonObject.getJSONObject("couponcodeInfo");
            if (Objects.nonNull(couponcodeInfo)) {
                JSONObject validInfo = couponcodeInfo.getJSONObject("validInfo");
                String validTypeStr = validInfo.getString("validType");
                validInfo.remove((Object)"validType");
                validInfo.put("validType", (Object)WxShopValidType.getTypeByEnDesc(validTypeStr));
            }
            return jsonObject;
        }
        return null;
    }

    @Override
    public SpuStatusStatisticResp statusCount() {
        log.info("query statusCount");
        String appId = this.appletCommonService.getCurrentAppId();
        Map status2Count = this.shopSpuMapper.countByStatus(appId);
        SpuStatusStatisticResp resp = new SpuStatusStatisticResp();
        AtomicInteger totalCount = new AtomicInteger();
        status2Count.forEach((status, count) -> {
            switch (WxShopSpuStatus.getByStatus(status)) {
                case INIT: {
                    resp.setWaitListCount(resp.getWaitListCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case RECYCLE_BIN: {
                    resp.setDeleteCount(resp.getDeleteCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case LISTING: {
                    resp.setListingCount(resp.getListingCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case SELF_DELISTING: 
                case SOLD_OUT_DELISTING: 
                case VIOLATION_DELISTING: {
                    resp.setDelistCount(resp.getDelistCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
            }
        });
        resp.setTotalCount(totalCount.get());
        return resp;
    }

    @Override
    public List<SpuListItem> list(SpuListQueryParam param) {
        List productEsModels;
        List<String> productIds;
        log.info("list with req={}", (Object)param);
        param.validate();
        String appId = param.getAppId();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(appId);
            Preconditions.checkArgument((Objects.nonNull(appletInfo) && appletInfo.getAuthStatus().equals(1) ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\u6216\u672a\u6388\u6743");
        } else {
            appId = this.appletCommonService.getCurrentAppId();
            param.setAppId(appId);
        }
        Pair<List<ProductEsModel>, Long> pair = this.productEsService.queryProductList(param, false);
        if (Objects.nonNull(param.getPageDto())) {
            param.getPageDto().setCount(Integer.valueOf(((Long)pair.getRight()).intValue()));
            param.getPageDto().setCurPageCount(Integer.valueOf(((List)pair.getLeft()).size()));
        }
        if (CollectionUtils.isEmpty(productIds = (productEsModels = (List)pair.getLeft()).stream().map(ProductEsModel::getProductId).collect(Collectors.toList()))) {
            return Lists.newArrayList();
        }
        List shopSpus = this.shopSpuMapper.queryByProductIds(appId, productIds);
        Map<String, ShopSpu> spuId2Spu = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, a -> a));
        List leftProductIds = shopSpus.stream().map(a -> String.valueOf(a.getProductId())).collect(Collectors.toList());
        List resultList = this.skuMapper.statisticByProductIds(appId, leftProductIds);
        Map<String, Integer> productId2StockNum = resultList.stream().collect(Collectors.toMap(SkuStatisticResult::getProductId, a -> a.getStockNum().intValue()));
        Map<String, SaleStatisticDto> productId2SaleCount = this.orderEsService.countStockNumByProductIds(productIds);
        ArrayList result = Lists.newArrayList();
        for (ProductEsModel model : productEsModels) {
            ShopSpu spu = spuId2Spu.get(model.getProductId());
            if (Objects.isNull(spu)) continue;
            SpuListItem item = new SpuListItem();
            SpuItemDto dto = (SpuItemDto)JSON.parseObject((String)spu.getSpuBody(), SpuItemDto.class);
            DescInfoDto descInfoDto = new DescInfoDto();
            BeanUtils.copyProperties((Object)dto.getDescInfo(), (Object)descInfoDto);
            item.setDescInfo(descInfoDto);
            item.setProductId(spu.getProductId());
            item.setAuditStatus(spu.getEditStatus());
            item.setEditStatus(spu.getStatus());
            item.setOutProductId(spu.getOutProductId());
            item.setHeadImg(dto.getHeadImg());
            item.setTitle(dto.getTitle());
            item.setSubTitle(dto.getSubTitle());
            item.setPrice(dto.getMinPrice());
            SaleStatisticDto saleStatisticDto = productId2SaleCount.get(spu.getProductId());
            item.setSaleCount(Objects.nonNull(saleStatisticDto) ? saleStatisticDto.getTotalSaleCount() : 0L);
            item.setOpenIdCount(Objects.nonNull(saleStatisticDto) ? saleStatisticDto.getDistinctOpenIdCount() : 0L);
            item.setOrderCount(Objects.nonNull(saleStatisticDto) ? saleStatisticDto.getOrderCount() : 0L);
            item.setStockNum(productId2StockNum.getOrDefault(spu.getProductId(), 0));
            item.setUpdateTime(spu.getUpdateTime());
            result.add(item);
        }
        return result;
    }

    @Override
    public void checkExistInEsAndInsert(List<SpuItemDto> spuItemDtos, String appId) {
        Set<ProductEsModel> existsProducts = this.productEsService.existsProducts(spuItemDtos);
        ArrayList newSpuItemList = Lists.newArrayList();
        ArrayList updateSpuList = Lists.newArrayList();
        Set existsProductIds = existsProducts.stream().map(a -> Long.valueOf(a.getProductId())).collect(Collectors.toSet());
        for (SpuItemDto spuItemDto : spuItemDtos) {
            if (existsProductIds.contains(spuItemDto.getProductId())) {
                updateSpuList.add(spuItemDto);
                continue;
            }
            newSpuItemList.add(spuItemDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)newSpuItemList)) {
            this.productEsService.batchInsertProduct(newSpuItemList, appId);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateSpuList)) {
            this.productEsService.batchUpdateProduct(updateSpuList, appId);
        }
    }

    @Override
    public List<SpuItemDto> checkExistInDbAndInsert(String appId, List<String> productIds, List<SpuItemDto> spuItemDtos) {
        List<ShopSpu> list;
        log.info("checkExistInDbAndInsert with appId={}, productIds={}", (Object)appId, productIds);
        Set existsProductIds = this.shopSpuMapper.existsProductIds(appId, productIds);
        ArrayList newSpuItemList = Lists.newArrayList();
        ArrayList updateSpulist = Lists.newArrayList();
        for (SpuItemDto spuItemDto : spuItemDtos) {
            if (existsProductIds.contains(spuItemDto.getProductId())) {
                updateSpulist.add(spuItemDto);
                continue;
            }
            newSpuItemList.add(spuItemDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)newSpuItemList)) {
            list = this.convertToShopSpu(appId, newSpuItemList);
            this.shopSpuMapper.batchInsert(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateSpulist)) {
            list = this.convertToShopSpu(appId, updateSpulist);
            this.shopSpuMapper.batchUpdate(list);
        }
        return newSpuItemList;
    }

    private List<ShopSpu> convertToShopSpu(String appId, List<SpuItemDto> spuItemDtos) {
        ArrayList list = Lists.newArrayList();
        for (SpuItemDto spuItemDto : spuItemDtos) {
            ShopSpu shopSpu = new ShopSpu();
            shopSpu.setCreateBy(Long.valueOf(-1L));
            shopSpu.setCreateTime(new Date());
            shopSpu.setProductId(String.valueOf(spuItemDto.getProductId()));
            shopSpu.setAppId(appId);
            shopSpu.setOutProductId(spuItemDto.getOutProductId());
            shopSpu.setNum(this.idGen.getNum());
            shopSpu.setUpdateBy(Long.valueOf(-1L));
            shopSpu.setIsDeleted(Integer.valueOf(0));
            shopSpu.setStatus(spuItemDto.getStatus());
            shopSpu.setEditStatus(spuItemDto.getEditStatus());
            shopSpu.setSpuBody(JSON.toJSONString((Object)spuItemDto));
            shopSpu.setIsNetSchoolGoods(Integer.valueOf(0));
            shopSpu.setNetSchoolGoodsType(Integer.valueOf(0));
            list.add(shopSpu);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLocalSpuByProductId(String userName, String productId) {
        log.info("updateLocalSpuByProductId with userName={}, productId={}", (Object)userName, (Object)productId);
        String key = userName + "$$" + productId;
        try {
            this.lock.lock(key, 20L, 40L, TimeUnit.SECONDS);
            String appId = this.appletInfoMapper.queryAppIdByUserName(userName);
            if (StringUtils.isBlank((CharSequence)appId)) {
                log.warn("userName={} not found appId", (Object)userName);
                return;
            }
            String accessToken = this.appletAccessTokenService.getAccessToken(appId);
            SpuGetReq spuGetReq = new SpuGetReq();
            spuGetReq.setProductId(Long.valueOf(productId));
            spuGetReq.setNeedEditSpu(0);
            SpuGetResp spuGetResp = this.wxShopSpuAPI.spuGet(accessToken, spuGetReq);
            if (Objects.nonNull(spuGetResp) && Objects.nonNull(spuGetResp.getData()) && Objects.nonNull(spuGetResp.getData().getSpu())) {
                this.checkExistInDbAndInsert(appId, Lists.newArrayList((Object[])new String[]{productId}), Lists.newArrayList((Object[])new SpuItemDto[]{spuGetResp.getData().getSpu()}));
                this.checkExistInEsAndInsert(Lists.newArrayList((Object[])new SpuItemDto[]{spuGetResp.getData().getSpu()}), appId);
            }
            int editStatus = 0;
            int needRealStock = 1;
            if (spuGetResp != null && spuGetResp.getData().getSpu().getEditStatus() < WxShopSpuEditStatus.AUDIT_SUCCESS.getStatus()) {
                editStatus = 1;
                needRealStock = 0;
            }
            this.syncSkus(appId, productId, accessToken, editStatus, needRealStock);
        }
        catch (Exception e) {
            log.error("updateLocalSpuByProductId with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }
}

