/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizeMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.service.AppletAuthService;
import com.kuaike.scrm.shop.service.ShopAuthService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShopAuthServiceImpl
implements ShopAuthService {
    private static final Logger log = LoggerFactory.getLogger(ShopAuthServiceImpl.class);
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private AppletAuthService appletAuthService;

    @Override
    public void authorize(AuthorizeMsg msg) {
        String appId = msg.getAuthorizerAppid();
        String authCode = msg.getAuthorizationCode();
        Date expiredTime = new Date(msg.getAuthorizationCodeExpiredTime() * 1000L);
        String preAuthCode = msg.getPreAuthCode();
        log.info("authorize official account, appId={}, authCode={}, expiredTime={}, preAuthCode={}", new Object[]{appId, authCode, expiredTime, preAuthCode});
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        try {
            AuthInfoResp authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
            this.appletAuthService.fillShopInfo(null, appId, authInfo, appInfo);
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
    }
}

