/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSkuAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSpuAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SkuItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpuItemDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuGetResp;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.shop.enums.WxShopSpuStatus;
import com.kuaike.scrm.shop.service.ProductEsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpuUpdateService {
    private static final Logger log = LoggerFactory.getLogger(SpuUpdateService.class);
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private AppletAccessTokenService accessTokenService;
    @Autowired
    private WxShopSpuAPI shopSpuAPI;
    @Autowired
    private WxShopSkuAPI shopSkuAPI;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private ShopSkuMapper shopSkuMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ProductEsService productEsService;
    private Set<Integer> needUpdateStatusList = Sets.newHashSet((Object[])new Integer[]{WxShopSpuStatus.INIT.getStatus(), WxShopSpuStatus.LISTING.getStatus(), WxShopSpuStatus.RECYCLE_BIN.getStatus(), WxShopSpuStatus.SELF_DELISTING.getStatus(), WxShopSpuStatus.VIOLATION_DELISTING.getStatus(), WxShopSpuStatus.SOLD_OUT_DELISTING.getStatus()});

    public Set<Integer> getNeedUpdateStatus() {
        return this.needUpdateStatusList;
    }

    public void doRun() {
        List appIds = this.appletInfoMapper.queryAllAuthShopAppId();
        if (CollectionUtils.isNotEmpty((Collection)appIds)) {
            for (String appId : appIds) {
                ThreadTools.getMixTaskThreadPool().submit(() -> {
                    try {
                        this.run(appId);
                    }
                    catch (Exception e) {
                        log.info("run with error", (Throwable)e);
                    }
                });
            }
        }
    }

    public void run(String appId) {
        Date fromDate = DateUtils.addDays((Date)new Date(), (int)-90);
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        int start = 0;
        int pageSize = 40;
        boolean ifContinue = false;
        do {
            List shopSpus;
            if (CollectionUtils.isNotEmpty((Collection)(shopSpus = this.shopSpuMapper.queryNotFinishedWithStatus(appId, fromDate, this.getNeedUpdateStatus(), start, pageSize)))) {
                count.getAndAdd(shopSpus.size());
                String accessToken = this.accessTokenService.getAccessToken(appId);
                ArrayList needUpdateSpuList = Lists.newArrayList();
                ArrayList needUpdateSkuList = Lists.newArrayList();
                ArrayList needAddSkuList = Lists.newArrayList();
                ArrayList needDelSkuList = Lists.newArrayList();
                for (ShopSpu shopSpu : shopSpus) {
                    this.collectNeedUpdate(appId, accessToken, needUpdateSpuList, shopSpu, needUpdateSkuList, needAddSkuList, needDelSkuList);
                }
                if (CollectionUtils.isNotEmpty((Collection)needUpdateSpuList)) {
                    updateCount.getAndAdd(needUpdateSpuList.size());
                    this.shopSpuMapper.batchUpdate((List)needUpdateSpuList);
                    this.productEsService.batchUpdateProduct(needUpdateSpuList);
                }
                if (CollectionUtils.isNotEmpty((Collection)needUpdateSkuList)) {
                    this.shopSkuMapper.batchUpdate((Collection)needUpdateSkuList);
                }
                if (CollectionUtils.isNotEmpty((Collection)needAddSkuList)) {
                    this.shopSkuMapper.batchInsert((Collection)needAddSkuList);
                }
                if (CollectionUtils.isNotEmpty((Collection)needDelSkuList)) {
                    this.shopSkuMapper.deleteBySkuIds(null, (Collection)needDelSkuList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)shopSpus) && shopSpus.size() == pageSize) {
                ifContinue = true;
                start += pageSize;
                continue;
            }
            ifContinue = false;
        } while (ifContinue);
        log.info("finish spu update with appId={}, total check size={}, update size={}", new Object[]{appId, count.get(), updateCount.get()});
    }

    private void collectNeedUpdate(String appId, String accessToken, List<ShopSpu> needUpdateSpus, ShopSpu shopSpu, List<ShopSku> updateSkus, List<ShopSku> addSkus, List<String> deleteSkuIds) {
        ShopSpu newItem;
        SpuGetReq req = new SpuGetReq();
        req.setNeedEditSpu(0);
        req.setOutProductId(shopSpu.getOutProductId());
        req.setProductId(Long.valueOf(shopSpu.getProductId()));
        SpuItemDto dto = null;
        for (int i = 0; i < 3; ++i) {
            try {
                SpuGetResp spuGetResp = this.shopSpuAPI.spuGet(accessToken, req);
                dto = spuGetResp.getData().getSpu();
                break;
            }
            catch (Exception e) {
                log.error("getSpu error, req={}", (Object)e, (Object)req);
                continue;
            }
        }
        if (!this.isEquals(shopSpu, newItem = this.buildShopSpu(shopSpu, dto))) {
            needUpdateSpus.add(newItem);
        }
        this.collectSkuChange(appId, accessToken, shopSpu, updateSkus, addSkus, deleteSkuIds, dto);
    }

    private void collectSkuChange(String appId, String accessToken, ShopSpu shopSpu, List<ShopSku> updateSkus, List<ShopSku> addSkus, List<String> deleteSkuIds, SpuItemDto dto) {
        ShopSku shopSku;
        SkuItem skuItem;
        SkuGetListReq skuGetListReq = new SkuGetListReq();
        skuGetListReq.setProductId(dto != null ? dto.getProductId() : null);
        skuGetListReq.setNeedEditSku(Integer.valueOf(0));
        skuGetListReq.setNeedRealStock(Integer.valueOf(1));
        Collection newSkuItems = null;
        for (int i = 0; i < 3; ++i) {
            try {
                SkuGetListResp skuGetListResp = this.shopSkuAPI.skuGetBatch(accessToken, skuGetListReq);
                newSkuItems = skuGetListResp.getSkus();
                break;
            }
            catch (Exception e) {
                log.error("getSku error, req={}", (Object)e, (Object)skuGetListReq);
                continue;
            }
        }
        Map<Object, Object> skuId2Item = Maps.newHashMap();
        if (newSkuItems != null) {
            skuId2Item = newSkuItems.stream().collect(Collectors.toMap(a -> a.getSkuId(), a -> a));
        }
        List oldShopSkuList = this.shopSkuMapper.queryByProductId(appId, shopSpu.getProductId());
        List<Object> newSkuIds = Lists.newArrayList();
        if (newSkuItems != null) {
            newSkuIds = newSkuItems.stream().map(a -> String.valueOf(a.getSkuId())).collect(Collectors.toList());
        }
        List oldSkuIds = oldShopSkuList.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        HashSet updateSkuIds = Sets.newHashSet((Iterable)CollectionUtils.intersection((Iterable)newSkuIds, oldSkuIds));
        HashSet delSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(oldSkuIds, (Iterable)newSkuIds));
        HashSet addSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract((Iterable)newSkuIds, oldSkuIds));
        if (CollectionUtils.isNotEmpty((Collection)updateSkuIds)) {
            for (String updateSkuId : updateSkuIds) {
                skuItem = (SkuItem)skuId2Item.get(updateSkuId);
                shopSku = this.buildShopSku(skuItem, false, null);
                updateSkus.add(shopSku);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addSkuIds)) {
            for (String addSkuId : addSkuIds) {
                skuItem = (SkuItem)skuId2Item.get(addSkuId);
                shopSku = this.buildShopSku(skuItem, true, appId);
                addSkus.add(shopSku);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)delSkuIds)) {
            deleteSkuIds.addAll(delSkuIds);
        }
    }

    private ShopSpu buildShopSpu(ShopSpu shopSpu, SpuItemDto dto) {
        ShopSpu newItem = new ShopSpu();
        newItem.setId(shopSpu.getId());
        newItem.setAppId(shopSpu.getAppId());
        newItem.setProductId(shopSpu.getProductId());
        newItem.setOutProductId(shopSpu.getOutProductId());
        newItem.setStatus(dto != null ? dto.getStatus() : null);
        newItem.setEditStatus(dto != null ? dto.getEditStatus() : null);
        newItem.setSpuBody(JSON.toJSONString((Object)dto));
        return newItem;
    }

    private ShopSku buildShopSku(SkuItem skuItem, boolean isNew, String appId) {
        ShopSku shopSku = new ShopSku();
        if (isNew) {
            shopSku.setNum(this.idGen.getNum());
            shopSku.setUpdateBy(Long.valueOf(-1L));
            shopSku.setCreateBy(Long.valueOf(-1L));
            shopSku.setCreateTime(new Date());
            shopSku.setAppId(appId);
        }
        shopSku.setOutSkuId(skuItem.getOutSkuId());
        shopSku.setStockNum(skuItem.getStockNum());
        shopSku.setSkuId(String.valueOf(skuItem.getSkuId()));
        shopSku.setSalePrice(skuItem.getSalePrice());
        shopSku.setMarketPrice(skuItem.getMarketPrice());
        shopSku.setSkuBody(JSON.toJSONString((Object)skuItem));
        shopSku.setStatus(skuItem.getStatus());
        shopSku.setProductId(String.valueOf(skuItem.getProductId()));
        shopSku.setOutProductId(skuItem.getOutProductId());
        shopSku.setUpdateTime(new Date());
        shopSku.setBizId(Long.valueOf(-1L));
        shopSku.setSource(Integer.valueOf(1));
        return shopSku;
    }

    private boolean isEquals(ShopSpu oldItem, ShopSpu newItem) {
        if (!Objects.equals(oldItem.getEditStatus(), newItem.getEditStatus())) {
            return false;
        }
        if (!Objects.equals(oldItem.getSpuBody(), newItem.getSpuBody())) {
            return false;
        }
        return Objects.equals(oldItem.getStatus(), newItem.getStatus());
    }
}

