/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopCouponAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ValidInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.CouponDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.CouponInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountCondition;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.PromoteInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ReceiveInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.StockInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopCouponProduct;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponProductMapper;
import com.kuaike.scrm.shop.enums.WxShopCouponType;
import com.kuaike.scrm.shop.enums.WxShopPromoteType;
import com.kuaike.scrm.shop.enums.WxShopValidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CouponPullByCacheService {
    private static final Logger log = LoggerFactory.getLogger(CouponPullByCacheService.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopCouponAPI wxShopCouponAPI;
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private ShopCouponProductMapper shopCouponProductMapper;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private IdGen idGen;
    private static final String KEY = "shop:waitSyncCouponIds:";

    public void sync() {
        log.info("CouponPull start");
        List appIds = this.appletInfoMapper.queryAllAuthShopAppId();
        if (CollectionUtils.isNotEmpty((Collection)appIds)) {
            for (String appId : appIds) {
                this.doPull(appId);
            }
        }
        log.info("CouponPull end");
    }

    public void doPull(String appId) {
        Set couponIds = this.stringRedisTemplate.opsForHash().keys((Object)(KEY + appId));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponIds)) {
            return;
        }
        this.stringRedisTemplate.opsForHash().delete((Object)(KEY + appId), couponIds.toArray());
        ArrayList<ShopCoupon> updates = new ArrayList<ShopCoupon>();
        HashMap<String, List<String>> couponIdAndProductIdsMap = new HashMap<String, List<String>>();
        long bizId = 0L;
        String corpId = "";
        for (Object couponIdObj : couponIds) {
            CouponGetResp coupon;
            String couponId = String.valueOf(couponIdObj);
            log.info("\u540c\u6b65\u4f18\u60e0\u5238,appId:{},couponId:{}", (Object)appId, (Object)couponId);
            ShopCoupon exist = new ShopCoupon();
            exist.setAppId(appId);
            exist.setCouponId(couponId);
            ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)exist);
            if (shopCoupon == null) {
                log.info("\u540c\u6b65\u4f18\u60e0\u5238,\u901a\u8fc7couponId\u67e5\u8be2\u4e0d\u5230\u6570\u636e,{}", (Object)couponId);
                continue;
            }
            log.info("\u540c\u6b65\u4f18\u60e0\u5238\uff0cdb:{}", (Object)shopCoupon.toString());
            bizId = shopCoupon.getBizId();
            corpId = shopCoupon.getCorpId();
            CouponGetReq req = new CouponGetReq();
            req.setCouponId(Long.valueOf(couponId));
            try {
                coupon = this.wxShopCouponAPI.getCoupon(this.appletAccessTokenService.getAccessToken(appId), req);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4f18\u60e0\u5238\u8be6\u60c5\u5f02\u5e38,req:{}", (Object)req, (Object)e);
                continue;
            }
            log.info("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u4f18\u60e0\u5238\u8be6\u60c5,coupon:{}", (Object)coupon);
            CouponDto couponDto = coupon.getCoupon();
            if (couponDto == null) {
                log.info("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u4f18\u60e0\u5238\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                continue;
            }
            updates.add(this.buildUpdateShopCoupon(shopCoupon, couponDto));
            if (!WxShopCouponType.PRODUCT_CONDITION_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FULL_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FLAT_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_DIRECT_DISCOUNT.getType().equals(couponDto.getType())) continue;
            CouponInfo couponInfo = couponDto.getCouponInfo();
            DiscountInfo discountInfo = couponInfo.getDiscountInfo();
            DiscountCondition discountCondition = discountInfo.getDiscountCondition();
            couponIdAndProductIdsMap.put(String.valueOf(couponDto.getCouponId()), discountCondition.getProductIds().stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updates)) {
            this.shopCouponMapper.batchUpdateByCouponId(updates);
        }
        if (couponIdAndProductIdsMap.size() > 0) {
            this.handleCouponProducts(couponIdAndProductIdsMap, bizId, corpId, appId);
        }
    }

    private void handleCouponProducts(Map<String, List<String>> couponIdAndProductIdsMap, Long bizId, String corpId, String appId) {
        for (Map.Entry<String, List<String>> entry : couponIdAndProductIdsMap.entrySet()) {
            List<ShopCouponProduct> insertList;
            List<String> insertProductIds;
            String couponId = entry.getKey();
            List<String> productIds = entry.getValue();
            ShopCouponProduct select = new ShopCouponProduct();
            select.setBizId(bizId);
            select.setCouponId(couponId);
            List existsCouponProducts = this.shopCouponProductMapper.select((Object)select);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)existsCouponProducts)) {
                List<ShopCouponProduct> insertList2 = this.build(productIds, couponId, bizId, corpId, appId);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(insertList2)) continue;
                this.shopCouponProductMapper.batchInsert(insertList2);
                continue;
            }
            List existsProductIds = existsCouponProducts.stream().map(ShopCouponProduct::getProductId).collect(Collectors.toList());
            List delProductIds = existsProductIds.stream().filter(s -> !productIds.contains(s)).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(delProductIds)) {
                this.shopCouponProductMapper.deleteByProductIds(delProductIds, bizId);
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(insertProductIds = productIds.stream().filter(s -> !existsProductIds.contains(s)).collect(Collectors.toList())) || !org.apache.commons.collections.CollectionUtils.isNotEmpty(insertList = this.build(insertProductIds, couponId, bizId, corpId, appId))) continue;
            this.shopCouponProductMapper.batchInsert(insertList);
        }
    }

    private List<ShopCouponProduct> build(List<String> productIds, String couponId, Long bizId, String corpId, String appId) {
        ArrayList<ShopCouponProduct> list = new ArrayList<ShopCouponProduct>();
        Date now = new Date();
        for (String productId : productIds) {
            ShopCouponProduct shopCouponProduct = new ShopCouponProduct();
            shopCouponProduct.setAppId(appId);
            shopCouponProduct.setNum(this.idGen.getNum());
            shopCouponProduct.setBizId(bizId);
            shopCouponProduct.setCorpId(corpId);
            shopCouponProduct.setProductId(productId);
            shopCouponProduct.setCouponId(couponId);
            shopCouponProduct.setCreateBy(Long.valueOf(-1L));
            shopCouponProduct.setCreateTime(now);
            shopCouponProduct.setUpdateBy(Long.valueOf(-1L));
            shopCouponProduct.setUpdateTime(now);
            shopCouponProduct.setIsDeleted(Integer.valueOf(0));
            list.add(shopCouponProduct);
        }
        return list;
    }

    private ShopCoupon buildUpdateShopCoupon(ShopCoupon exist, CouponDto couponDto) {
        ShopCoupon update = new ShopCoupon();
        update.setId(exist.getId());
        update.setBizId(exist.getBizId());
        update.setType(couponDto.getType());
        update.setCouponId(exist.getCouponId());
        update.setStatus(couponDto.getStatus());
        update.setUpdateTime((Date)DateUtil.parse((CharSequence)couponDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        CouponInfo couponInfo = couponDto.getCouponInfo();
        update.setName(couponInfo.getName());
        PromoteInfo promoteInfo = couponInfo.getPromoteInfo();
        update.setPromoteType(WxShopPromoteType.getTypeByEnDesc(promoteInfo.getPromoteType()));
        update.setCustomizeChannel(promoteInfo.getCustomizeChannel());
        DiscountInfo discountInfo = couponInfo.getDiscountInfo();
        update.setDiscountNum(Integer.valueOf(discountInfo.getDiscountNum() != null ? discountInfo.getDiscountNum().intValue() : exist.getDiscountNum().intValue()));
        DiscountCondition discountCondition = discountInfo.getDiscountCondition();
        update.setProductCnt(Integer.valueOf(discountCondition.getProductCnt() != null ? discountCondition.getProductCnt().intValue() : exist.getProductCnt().intValue()));
        update.setProductPrice(discountCondition.getProductPrice());
        update.setDiscountFee(discountInfo.getDiscountFee());
        ReceiveInfo receiveInfo = couponInfo.getReceiveInfo();
        update.setReceiveStartTime((Date)DateUtil.parse((CharSequence)receiveInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        update.setReceiveEndTime((Date)DateUtil.parse((CharSequence)receiveInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        ValidInfo validInfo = couponInfo.getValidInfo();
        update.setValidType(WxShopValidType.getTypeByEnDesc(validInfo.getValidType()));
        update.setValidDayNum(validInfo.getValidDayNum());
        StockInfo stockInfo = couponDto.getStockInfo();
        update.setReceiveNum(stockInfo != null ? stockInfo.getReceiveNum() : exist.getReceiveNum());
        update.setUsedNum(stockInfo != null ? stockInfo.getUsedNum() : exist.getUsedNum());
        ExtInfo extInfo = couponInfo.getExtInfo();
        update.setTotalNum(receiveInfo.getTotalNum());
        update.setLimitNumOnePerson(receiveInfo.getLimitNumOnePerson());
        update.setJumpProductId(String.valueOf(extInfo.getJumpProductId()));
        update.setNotes(extInfo.getNotes());
        if (validInfo.getStartTime() != null) {
            update.setValidStartTime((Date)DateUtil.parse((CharSequence)validInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (validInfo.getEndTime() != null) {
            update.setValidEndTime((Date)DateUtil.parse((CharSequence)validInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return update;
    }
}

