/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopCouponAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ValidInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.CouponDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.CouponInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountCondition;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.PromoteInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ReceiveInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.StockInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetListResp;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopCouponProduct;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponProductMapper;
import com.kuaike.scrm.shop.enums.WxShopCouponType;
import com.kuaike.scrm.shop.enums.WxShopPromoteType;
import com.kuaike.scrm.shop.enums.WxShopValidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CouponCreatePullService
extends AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(CouponCreatePullService.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopCouponAPI wxShopCouponAPI;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private ShopCouponProductMapper shopCouponProductMapper;
    private static final String COUPON_CREATE_LAST_CREATE_TIME_KEY = "couponCreateLastCreateTime";

    public String getKey() {
        String key = "couponCreate";
        Integer status = (Integer)this.paramMap.get("status");
        if (Objects.nonNull(status)) {
            key = key + ":" + status;
        }
        return key;
    }

    public String getStartTime(String appId) {
        String value = (String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)this.getHashKey());
        return StringUtils.isNotBlank((CharSequence)value) ? value : "1970-01-02 00:00:00";
    }

    public int getTotalNum(String appId) {
        return 0;
    }

    private String getHashKey() {
        Integer status;
        String hashKey = COUPON_CREATE_LAST_CREATE_TIME_KEY;
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            hashKey = hashKey + ":" + status;
        }
        return hashKey;
    }

    public void saveTotalNum(String appId, int newTotalNum) {
    }

    public int getPageSize() {
        return 30;
    }

    public PullResult doPull(String appId, String startTime, String endTime, int page, int pageSize) {
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        CouponGetListReq req = this.buildReq(page, pageSize, startTime, endTime);
        CouponGetListResp couponList = this.getCouponList(accessToken, req);
        log.info("\u6839\u636ecreateTime\u540c\u6b65\u5c0f\u5546\u5e97\u4f18\u60e0\u5238\uff0cstartTime:{}\uff0cendTime:{}\uff0creq:{}\uff0cresp:{}", new Object[]{startTime, endTime, req, couponList.toString()});
        PullResult pullResult = new PullResult();
        pullResult.setResultList(couponList.getCoupons());
        pullResult.setTotalNum(couponList.getTotalNum());
        return pullResult;
    }

    private CouponGetListReq buildReq(int page, int pageSize, String startTime, String endTime) {
        Integer status;
        CouponGetListReq req = new CouponGetListReq();
        req.setStartCreateTime(startTime);
        req.setEndCreateTime(endTime);
        req.setPage(Integer.valueOf(page));
        req.setPageSize(Integer.valueOf(pageSize));
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            req.setStatus(status);
        }
        return req;
    }

    private CouponGetListResp getCouponList(String accessToken, CouponGetListReq req) {
        int retry = 3;
        while (retry != 0) {
            try {
                return this.wxShopCouponAPI.getCouponList(accessToken, req);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u4f18\u60e0\u5238\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)(--retry), (Object)e);
            }
        }
        log.error("\u540c\u6b65\u4f18\u60e0\u5238\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38");
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
    }

    protected void save(String appId, PullResult result) {
        super.save(appId, result);
        ArrayList<CouponDto> couponList = new ArrayList<CouponDto>();
        ArrayList<String> couponIds = new ArrayList<String>();
        DateTime lastCreateTime = null;
        HashMap<String, CouponDto> couponIdAndDtoMap = new HashMap<String, CouponDto>();
        for (Object item : result.getResultList()) {
            CouponDto couponDto = (CouponDto)item;
            couponList.add(couponDto);
            couponIds.add(String.valueOf(couponDto.getCouponId()));
            couponIdAndDtoMap.put(String.valueOf(couponDto.getCouponId()), couponDto);
            DateTime createTime = DateUtil.parse((CharSequence)couponDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (lastCreateTime != null && createTime.getTime() <= lastCreateTime.getTime()) continue;
            lastCreateTime = createTime;
        }
        if (CollectionUtils.isNotEmpty(couponList)) {
            this.handleCouponDtos(couponList, appId, couponIds, couponIdAndDtoMap);
            lastCreateTime = DateUtil.offsetSecond(lastCreateTime, (int)-1);
            this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)this.getHashKey(), (Object)DateUtil.format((Date)lastCreateTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void handleCouponDtos(List<CouponDto> couponList, String appId, List<String> couponIds, Map<String, CouponDto> couponIdAndDtoMap) {
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728");
        }
        List existCoupons = this.shopCouponMapper.selectByCouponIds(appletInfo.getBizId(), couponIds, Integer.valueOf(0));
        List existCouponIds = existCoupons.stream().map(ShopCoupon::getCouponId).collect(Collectors.toList());
        List<CouponDto> insertCouponList = couponList.stream().filter(c -> !existCouponIds.contains(c.getCouponId())).collect(Collectors.toList());
        HashMap<String, List<String>> couponIdAndProductIdsMap = new HashMap<String, List<String>>();
        if (CollectionUtils.isNotEmpty((Collection)existCoupons)) {
            Map<String, List<String>> couponIdAndProductIdsMapByUpdate = this.updateCoupons(existCoupons, couponIdAndDtoMap, appId);
            couponIdAndProductIdsMap.putAll(couponIdAndProductIdsMapByUpdate);
        }
        if (CollectionUtils.isNotEmpty(insertCouponList)) {
            Map<String, List<String>> couponIdAndProductIdsMapByInsert = this.insertCoupons(insertCouponList, appletInfo.getBizId(), appletInfo.getCorpId(), appId);
            couponIdAndProductIdsMap.putAll(couponIdAndProductIdsMapByInsert);
        }
        this.handleCouponProducts(couponIdAndProductIdsMap, appletInfo.getBizId(), appletInfo.getCorpId(), appId);
    }

    private void handleCouponProducts(Map<String, List<String>> couponIdAndProductIdsMap, Long bizId, String corpId, String appId) {
        for (Map.Entry<String, List<String>> entry : couponIdAndProductIdsMap.entrySet()) {
            List<ShopCouponProduct> insertList;
            List<String> insertProductIds;
            String couponId = entry.getKey();
            List<String> productIds = entry.getValue();
            ShopCouponProduct select = new ShopCouponProduct();
            select.setBizId(bizId);
            select.setCouponId(couponId);
            List existsCouponProducts = this.shopCouponProductMapper.select((Object)select);
            if (CollectionUtils.isEmpty((Collection)existsCouponProducts)) {
                List<ShopCouponProduct> insertList2 = this.build(productIds, couponId, bizId, corpId, appId);
                if (!CollectionUtils.isNotEmpty(insertList2)) continue;
                this.shopCouponProductMapper.batchInsert(insertList2);
                continue;
            }
            List existsProductIds = existsCouponProducts.stream().map(ShopCouponProduct::getProductId).collect(Collectors.toList());
            List delProductIds = existsProductIds.stream().filter(s -> !productIds.contains(s)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(delProductIds)) {
                this.shopCouponProductMapper.deleteByProductIds(delProductIds, bizId);
            }
            if (!CollectionUtils.isNotEmpty(insertProductIds = productIds.stream().filter(s -> !existsProductIds.contains(s)).collect(Collectors.toList())) || !CollectionUtils.isNotEmpty(insertList = this.build(insertProductIds, couponId, bizId, corpId, appId))) continue;
            this.shopCouponProductMapper.batchInsert(insertList);
        }
    }

    private List<ShopCouponProduct> build(List<String> productIds, String couponId, Long bizId, String corpId, String appId) {
        ArrayList<ShopCouponProduct> list = new ArrayList<ShopCouponProduct>();
        Date now = new Date();
        for (String productId : productIds) {
            ShopCouponProduct shopCouponProduct = new ShopCouponProduct();
            shopCouponProduct.setAppId(appId);
            shopCouponProduct.setNum(this.idGen.getNum());
            shopCouponProduct.setBizId(bizId);
            shopCouponProduct.setCorpId(corpId);
            shopCouponProduct.setProductId(productId);
            shopCouponProduct.setCouponId(couponId);
            shopCouponProduct.setCreateBy(Long.valueOf(-1L));
            shopCouponProduct.setCreateTime(now);
            shopCouponProduct.setUpdateBy(Long.valueOf(-1L));
            shopCouponProduct.setUpdateTime(now);
            shopCouponProduct.setIsDeleted(Integer.valueOf(0));
            list.add(shopCouponProduct);
        }
        return list;
    }

    private Map<String, List<String>> insertCoupons(List<CouponDto> insertCouponList, Long bizId, String corpId, String appId) {
        ArrayList<ShopCoupon> couponList = new ArrayList<ShopCoupon>();
        HashMap<String, List<String>> couponIdAndProductIdsMap = new HashMap<String, List<String>>();
        for (CouponDto couponDto : insertCouponList) {
            DateTime dtoUpdateTime = DateUtil.parse((CharSequence)couponDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            ShopCoupon shopCoupon = this.couponDtoToShopCoupon(couponDto, dtoUpdateTime, appId);
            shopCoupon.setBizId(bizId);
            shopCoupon.setCorpId(corpId);
            shopCoupon.setNum(this.idGen.getNum());
            shopCoupon.setCreateBy(Long.valueOf(-1L));
            shopCoupon.setUpdateBy(Long.valueOf(-1L));
            couponList.add(shopCoupon);
            if (!WxShopCouponType.PRODUCT_CONDITION_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FULL_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FLAT_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_DIRECT_DISCOUNT.getType().equals(couponDto.getType())) continue;
            CouponInfo couponInfo = couponDto.getCouponInfo();
            DiscountInfo discountInfo = couponInfo.getDiscountInfo();
            DiscountCondition discountCondition = discountInfo.getDiscountCondition();
            couponIdAndProductIdsMap.put(String.valueOf(couponDto.getCouponId()), discountCondition.getProductIds().stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
        }
        try {
            this.shopCouponMapper.batchInsert(couponList);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u4f18\u60e0\u5238\u6570\u636e\uff0c\u5904\u7406\u63d2\u5165\u903b\u8f91\u5f02\u5e38", (Throwable)e);
        }
        return couponIdAndProductIdsMap;
    }

    private Map<String, List<String>> updateCoupons(List<ShopCoupon> existCoupons, Map<String, CouponDto> couponIdAndDtoMap, String appId) {
        HashMap<String, List<String>> couponIdAndProductIdsMap = new HashMap<String, List<String>>();
        ArrayList<ShopCoupon> updateCoupons = new ArrayList<ShopCoupon>();
        for (ShopCoupon coupon : existCoupons) {
            CouponDto couponDto = couponIdAndDtoMap.get(coupon.getCouponId());
            if (couponDto == null) continue;
            DateTime dtoUpdateTime = DateUtil.parse((CharSequence)couponDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            Date updateTime = coupon.getUpdateTime();
            if (dtoUpdateTime.getTime() == updateTime.getTime()) continue;
            ShopCoupon shopCoupon = this.couponDtoToShopCoupon(couponDto, dtoUpdateTime, appId);
            shopCoupon.setBizId(coupon.getBizId());
            updateCoupons.add(shopCoupon);
            if (!WxShopCouponType.PRODUCT_CONDITION_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FULL_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_FLAT_DISCOUNT.getType().equals(couponDto.getType()) && !WxShopCouponType.PRODUCT_DIRECT_DISCOUNT.getType().equals(couponDto.getType())) continue;
            CouponInfo couponInfo = couponDto.getCouponInfo();
            DiscountInfo discountInfo = couponInfo.getDiscountInfo();
            DiscountCondition discountCondition = discountInfo.getDiscountCondition();
            couponIdAndProductIdsMap.put(String.valueOf(couponDto.getCouponId()), discountCondition.getProductIds().stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(updateCoupons)) {
            this.shopCouponMapper.batchUpdateByCouponId(updateCoupons);
        }
        return couponIdAndProductIdsMap;
    }

    private ShopCoupon couponDtoToShopCoupon(CouponDto couponDto, DateTime dtoUpdateTime, String appId) {
        log.info("couponDtoToShopCoupon dto:{}", (Object)couponDto);
        ShopCoupon shopCoupon = new ShopCoupon();
        shopCoupon.setAppId(appId);
        shopCoupon.setCouponId(String.valueOf(couponDto.getCouponId()));
        shopCoupon.setType(couponDto.getType());
        shopCoupon.setStatus(couponDto.getStatus());
        CouponInfo couponInfo = couponDto.getCouponInfo();
        PromoteInfo promoteInfo = couponInfo.getPromoteInfo();
        shopCoupon.setPromoteType(WxShopPromoteType.getTypeByEnDesc(promoteInfo.getPromoteType()));
        shopCoupon.setCustomizeChannel(promoteInfo.getCustomizeChannel());
        shopCoupon.setName(couponInfo.getName());
        DiscountInfo discountInfo = couponInfo.getDiscountInfo();
        shopCoupon.setDiscountNum(Integer.valueOf(discountInfo.getDiscountNum() != null ? discountInfo.getDiscountNum().intValue() : 0));
        DiscountCondition discountCondition = discountInfo.getDiscountCondition();
        shopCoupon.setProductCnt(Integer.valueOf(discountCondition.getProductCnt() != null ? discountCondition.getProductCnt().intValue() : 0));
        shopCoupon.setProductPrice(discountCondition.getProductPrice());
        shopCoupon.setDiscountFee(discountInfo.getDiscountFee());
        ReceiveInfo receiveInfo = couponInfo.getReceiveInfo();
        shopCoupon.setReceiveStartTime((Date)DateUtil.parse((CharSequence)receiveInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        shopCoupon.setReceiveEndTime((Date)DateUtil.parse((CharSequence)receiveInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        ValidInfo validInfo = couponInfo.getValidInfo();
        shopCoupon.setValidType(WxShopValidType.getTypeByEnDesc(validInfo.getValidType()));
        shopCoupon.setValidDayNum(validInfo.getValidDayNum());
        StockInfo stockInfo = couponDto.getStockInfo();
        shopCoupon.setReceiveNum(Integer.valueOf(stockInfo != null ? stockInfo.getReceiveNum() : 0));
        shopCoupon.setUsedNum(Integer.valueOf(stockInfo != null ? stockInfo.getUsedNum() : 0));
        ExtInfo extInfo = couponInfo.getExtInfo();
        shopCoupon.setTotalNum(receiveInfo.getTotalNum());
        shopCoupon.setLimitNumOnePerson(receiveInfo.getLimitNumOnePerson());
        shopCoupon.setJumpProductId(String.valueOf(extInfo.getJumpProductId()));
        shopCoupon.setNotes(extInfo.getNotes());
        shopCoupon.setIsDeleted(Integer.valueOf(0));
        shopCoupon.setCreateTime((Date)DateUtil.parse((CharSequence)couponDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        shopCoupon.setUpdateTime((Date)dtoUpdateTime);
        if (validInfo.getStartTime() != null) {
            shopCoupon.setValidStartTime((Date)DateUtil.parse((CharSequence)validInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (validInfo.getEndTime() != null) {
            shopCoupon.setValidEndTime((Date)DateUtil.parse((CharSequence)validInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return shopCoupon;
    }
}

