/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopUtilAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CategoryItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CategoryResp;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.shop.dto.spu.dto.CacheCategoryItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CategoryPullService {
    private static final Logger log = LoggerFactory.getLogger(CategoryPullService.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopUtilAPI wxShopUtilAPI;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    private static final String CATEGORY_CACHE_PREFIX = "shop:category:";

    public List<CategoryItem> category(String appId, Long catId) {
        Preconditions.checkArgument((Objects.nonNull(catId) && catId >= 0L ? 1 : 0) != 0, (Object)"catId \u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u53d6\u503c\u5927\u4e8e\u7b49\u4e8e0");
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        CategoryResp categoryResp = this.wxShopUtilAPI.getCategory(accessToken, catId);
        return categoryResp.getCatList();
    }

    public void cacheCategory(String appId) {
        log.info("\u5f00\u59cb\u62c9\u53d6\u7c7b\u76ee\u4fe1\u606f,appId:{}", (Object)appId);
        Preconditions.checkArgument((boolean)Objects.nonNull(appId), (Object)"appId \u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u83b7\u53d6\u7c7b\u76ee\u4fe1\u606f,appId:{},catId:{}", (Object)appId, (Object)0);
        List<CategoryItem> rootCategoryList = this.category(appId, 0L);
        this.recursiveGetCategory(rootCategoryList, appId, 1);
        log.info("\u7ed3\u675f\u62c9\u53d6\u7c7b\u76ee\u4fe1\u606f,appId:{}", (Object)appId);
    }

    public CacheCategoryItem getCategoryByCatId(String appId, Long catId) {
        Preconditions.checkArgument((boolean)Objects.nonNull(appId), (Object)"appId \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(catId), (Object)"catId \u4e0d\u80fd\u4e3a\u7a7a");
        String cat = (String)this.stringRedisTemplate.opsForHash().get((Object)(CATEGORY_CACHE_PREFIX + appId), (Object)String.valueOf(catId));
        if (StringUtils.isBlank((CharSequence)cat)) {
            return null;
        }
        return (CacheCategoryItem)JSON.parseObject((String)cat, CacheCategoryItem.class);
    }

    private void recursiveGetCategory(List<CategoryItem> categoryList, String appId, Integer level) {
        if (CollectionUtils.isEmpty(categoryList)) {
            return;
        }
        for (CategoryItem categoryItem : categoryList) {
            this.saveCache(appId, categoryItem, level);
            log.info("\u83b7\u53d6\u7c7b\u76ee\u4fe1\u606f,appId:{},catId:{}, level:{}", new Object[]{appId, categoryItem.getCatId(), level});
            List<CategoryItem> nextCategoryList = this.category(appId, categoryItem.getCatId());
            int nextLevel = level + 1;
            this.recursiveGetCategory(nextCategoryList, appId, nextLevel);
        }
    }

    private void saveCache(String appId, CategoryItem categoryItem, Integer level) {
        CacheCategoryItem cacheCategoryItem = new CacheCategoryItem();
        cacheCategoryItem.setCatId(categoryItem.getCatId());
        cacheCategoryItem.setFCatId(categoryItem.getFCatId());
        cacheCategoryItem.setName(categoryItem.getName());
        cacheCategoryItem.setLevel(level);
        this.stringRedisTemplate.opsForHash().put((Object)(CATEGORY_CACHE_PREFIX + appId), (Object)String.valueOf(categoryItem.getCatId()), (Object)JSON.toJSONString((Object)cacheCategoryItem));
    }

    public void sync() {
        log.info("shop category pull sync start");
        List appIds = this.appletInfoMapper.queryAllAuthShopAppId();
        if (CollectionUtils.isNotEmpty((Collection)appIds)) {
            for (String appId : appIds) {
                ThreadTools.getMixTaskThreadPool().submit(() -> this.cacheCategory(appId));
            }
        }
        log.info("shop category pull sync end");
    }
}

