/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WxShopValidType {
    COUPON_VALID_TYPE_TIME(1, "\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u751f\u6548", "COUPON_VALID_TYPE_TIME"),
    COUPON_VALID_TYPE_DAY(2, "\u751f\u6548\u5929\u6570", "COUPON_VALID_TYPE_DAY");

    private Integer type;
    private String desc;
    private String enDesc;
    private static Map<Integer, WxShopValidType> map;
    private static Map<String, WxShopValidType> enMap;

    private WxShopValidType(Integer type, String desc, String enDesc) {
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public static String getDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public static Integer getTypeByEnDesc(String enDesc) {
        return enMap.containsKey(enDesc) ? enMap.get(enDesc).getType() : -1;
    }

    public static String getEnDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getEnDesc() : null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    static {
        map = Maps.newHashMap();
        enMap = Maps.newHashMap();
        for (WxShopValidType type : WxShopValidType.values()) {
            map.put(type.type, type);
            enMap.put(type.enDesc, type);
        }
    }
}

