/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OrderFlowStatus {
    ORDER_FLOW_STATUS_TRANSACTION_FAIL(1, "\u4ea4\u6613\u5931\u8d25"),
    ORDER_FLOW_STATUS_TRANSACTION_SUC(2, "\u4ea4\u6613\u6210\u529f"),
    ORDER_FLOW_STATUS_TRANSACTION_ERR(3, "\u4ea4\u6613\u5f02\u5e38"),
    ORDER_FLOW_STATUS_TRANSACTION_PENDING_SETTLED(4, "\u5f85\u7ed3\u7b97");

    private int status;
    private String desc;
    private static final Map<Integer, OrderFlowStatus> int2StatusMap;
    private static final Map<String, OrderFlowStatus> str2StatusMap;

    private OrderFlowStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public static OrderFlowStatus getByStatus(Integer status) {
        return int2StatusMap.get(status);
    }

    public static OrderFlowStatus getByName(String name) {
        return str2StatusMap.get(name);
    }

    static {
        int2StatusMap = Arrays.stream(OrderFlowStatus.values()).collect(Collectors.toMap(OrderFlowStatus::getStatus, a -> a));
        str2StatusMap = Arrays.stream(OrderFlowStatus.values()).collect(Collectors.toMap(Enum::name, a -> a));
    }
}

