/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopRegisterAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopUtilAPI;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.BusiLicense;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CheckAuditStatusData;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.IdCardInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.NameInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PicFile;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ReturnInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpecialQualification;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SuperAdministratorInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.RegisterShopReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SubmitBasicInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SubmitMerchantInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CheckAuditStatusResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.resp.FastRegisterInfoResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletRegisterService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.applet.ShopAvailableStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopOpenDraft;
import com.kuaike.scrm.dal.shop.entity.ShopRegisterLog;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOpenDraftMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopRegisterLogMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.shop.dto.register.BusiLicenseDto;
import com.kuaike.scrm.shop.dto.register.IdCardInfoDto;
import com.kuaike.scrm.shop.dto.register.NameInfoDto;
import com.kuaike.scrm.shop.dto.register.ReturnInfoDto;
import com.kuaike.scrm.shop.dto.register.StepRespDto;
import com.kuaike.scrm.shop.dto.register.SubmitInfoDto;
import com.kuaike.scrm.shop.dto.register.SubmitTypeDto;
import com.kuaike.scrm.shop.dto.register.SuperAdministratorInfoDto;
import com.kuaike.scrm.shop.enums.RegisterStep;
import com.kuaike.scrm.shop.enums.RegisterStepStatus;
import com.kuaike.scrm.shop.enums.RegisterType;
import com.kuaike.scrm.shop.enums.SubmitInfoOptType;
import com.kuaike.scrm.shop.enums.WxCheckAuditStatus;
import com.kuaike.scrm.shop.enums.WxRegisterStatus;
import com.kuaike.scrm.shop.enums.WxRegisterType;
import com.kuaike.scrm.shop.enums.WxSuperAdminType;
import com.kuaike.scrm.shop.service.ShopRegisterService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopRegisterServiceImpl
implements ShopRegisterService {
    private static final Logger log = LoggerFactory.getLogger(ShopRegisterServiceImpl.class);
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private ShopOpenDraftMapper shopOpenDraftMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private WxShopRegisterAPI wxShopRegisterAPI;
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopUtilAPI wxShopUtilAPI;
    @Resource
    private ShopRegisterLogMapper shopRegisterLogMapper;
    @Resource
    private AppletRegisterService appletRegisterService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitInfo(SubmitInfoDto dto) {
        log.info("submitInfo,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        AppletInfo appletInfo = this.selectByBizId(currentUserInfo.getBizId());
        log.info("submitInfo \u5148\u67e5\u8be2appletInfo:{}", (Object)appletInfo);
        if (appletInfo != null && ShopAvailableStatus.AVAILABLE.getStatus().equals(appletInfo.getShopAvailable())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5b58\u5728\u5b8c\u6210\u5f00\u5e97\u7684\u5c0f\u5546\u5e97\uff0c\u8bf7\u5237\u65b0\uff0c\u91cd\u65b0\u8fdb\u5165\u5fae\u5c0f\u5e97");
        }
        Date now = new Date();
        ShopOpenDraft isExist = new ShopOpenDraft();
        isExist.setBizId(currentUserInfo.getBizId());
        ShopOpenDraft existShopOpenDraft = (ShopOpenDraft)this.shopOpenDraftMapper.selectOne((Object)isExist);
        ShopOpenDraft shopOpenDraft = new ShopOpenDraft();
        if (existShopOpenDraft != null) {
            shopOpenDraft = existShopOpenDraft;
            shopOpenDraft.setUpdateBy(currentUserInfo.getId());
            shopOpenDraft.setUpdateTime(now);
        } else {
            shopOpenDraft.setStep(RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType());
            shopOpenDraft.setCreateTime(now);
            shopOpenDraft.setCreateBy(currentUserInfo.getId());
            shopOpenDraft.setNum(this.idGen.getNum());
            shopOpenDraft.setUpdateBy(currentUserInfo.getId());
            shopOpenDraft.setUpdateTime(now);
        }
        Integer step = shopOpenDraft.getStep();
        if (RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType().equals(step)) {
            shopOpenDraft.setSuperAdministratorInfo(JSON.toJSONString((Object)dto.getSuperAdministratorInfo()));
        } else if (RegisterStep.TWO_SUBMIT_PAYMENT_QUALIFICATION_VERIFY_ACCOUNT.getType().equals(step)) {
            shopOpenDraft.setSubjectType(dto.getSubjectType());
            shopOpenDraft.setBusiLicense(JSON.toJSONString((Object)dto.getBusiLicense()));
            shopOpenDraft.setMerchantShortname(dto.getMerchantShortname());
            shopOpenDraft.setIdCardInfo(JSON.toJSONString((Object)dto.getIdCardInfo()));
            shopOpenDraft.setSpecialQualification(JSON.toJSONString(dto.getSpecialQualification()));
            shopOpenDraft.setSupplementaryMaterial(JSON.toJSONString(dto.getSupplementaryMaterial()));
            shopOpenDraft.setSupplementaryDesc(dto.getSupplementaryDesc());
            shopOpenDraft.setIdCardName(dto.getIdCardInfo().getIdCardName());
            shopOpenDraft.setIdCardNumber(dto.getIdCardInfo().getIdCardNumber());
        } else {
            shopOpenDraft.setNameInfo(JSON.toJSONString((Object)dto.getNameInfo()));
            shopOpenDraft.setReturnInfo(JSON.toJSONString((Object)dto.getReturnInfo()));
            shopOpenDraft.setCompanyAddress(JSON.toJSONString((Object)dto.getCompanyAddress()));
        }
        shopOpenDraft.setBizId(currentUserInfo.getBizId());
        shopOpenDraft.setCorpId(currentUserInfo.getCorpId());
        shopOpenDraft.setApiOpenstoreType(WxRegisterType.COMPLETE_STORE.getType());
        shopOpenDraft.setIsDeleted(Integer.valueOf(0));
        log.info("shopOpenDraft:{}", (Object)shopOpenDraft);
        if (existShopOpenDraft != null) {
            this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)shopOpenDraft);
        } else {
            this.shopOpenDraftMapper.insert((Object)shopOpenDraft);
        }
        if (SubmitInfoOptType.SUBMIT.getType().equals(dto.getType())) {
            this.openShop(shopOpenDraft);
        }
    }

    private void openShop(ShopOpenDraft shopOpenDraft) {
        log.info("openShop,shopOpenDraft:{}", (Object)shopOpenDraft);
        Integer step = shopOpenDraft.getStep();
        if ((step == null || RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType().equals(step)) && !WxRegisterStatus.SUCCESS.getStatus().equals(shopOpenDraft.getRegisterStatus())) {
            String reqRes = this.registerShop(shopOpenDraft);
            log.info("registerShop,reqRes:{}", (Object)reqRes);
            Preconditions.checkArgument((boolean)StringUtils.isBlank((CharSequence)reqRes), (Object)reqRes);
            ShopOpenDraft updateStatus = new ShopOpenDraft();
            updateStatus.setId(shopOpenDraft.getId());
            updateStatus.setStep(RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType());
            updateStatus.setRegisterStatus(WxRegisterStatus.SUBMITTED_REVIEW.getStatus());
            this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateStatus);
            return;
        }
        if (!(!RegisterStep.TWO_SUBMIT_PAYMENT_QUALIFICATION_VERIFY_ACCOUNT.getType().equals(step) || WxCheckAuditStatus.SUCCESS.getStatus().equals(shopOpenDraft.getMerchantInfoStatus()) && WxCheckAuditStatus.SUCCESS.getStatus().equals(shopOpenDraft.getAcctVerifyStatus()))) {
            this.submitMerchantInfo(shopOpenDraft);
            ShopOpenDraft updateStatus = new ShopOpenDraft();
            updateStatus.setId(shopOpenDraft.getId());
            updateStatus.setMerchantInfoStatus(WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus());
            updateStatus.setAcctVerifyStatus(WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus());
            this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateStatus);
            return;
        }
        if (!(!RegisterStep.THREE_SHOP_BASIC_INFO_PAYMENT_SIGNING.getType().equals(step) || WxCheckAuditStatus.SUCCESS.getStatus().equals(shopOpenDraft.getBasicInfoStatus()) && WxCheckAuditStatus.SUCCESS.getStatus().equals(shopOpenDraft.getPaySignStatus()))) {
            this.submitBasicInfo(shopOpenDraft);
            ShopOpenDraft updateStatus = new ShopOpenDraft();
            updateStatus.setId(shopOpenDraft.getId());
            updateStatus.setBasicInfoStatus(WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus());
            updateStatus.setPaySignStatus(WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus());
            this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateStatus);
        }
    }

    @Override
    public StepRespDto step() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        StepRespDto respDto = new StepRespDto();
        AppletInfo appletInfo = this.selectByBizId(currentUserInfo.getBizId());
        log.info("step appletInfo:{}", (Object)appletInfo);
        if (appletInfo != null && ShopAvailableStatus.AVAILABLE.getStatus().equals(appletInfo.getShopAvailable())) {
            respDto.setShopAvailable(ShopAvailableStatus.AVAILABLE.getStatus());
            return respDto;
        }
        ShopRegisterLog shopRegisterLog = this.shopRegisterLogMapper.selectLastLogByBizId(currentUserInfo.getBizId());
        if (shopRegisterLog == null) {
            respDto.setType(RegisterType.NEVER.getType());
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            respDto.setStatus(RegisterStepStatus.WAIT_START.getStatus());
            respDto.setStep(RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType());
            return respDto;
        }
        int registerType = shopRegisterLog.getRegisterType();
        log.info("step shopRegisterLog registerType:{}", (Object)registerType);
        RegisterType type = RegisterType.getByType(registerType);
        switch (type) {
            case CREATE_SHOP: {
                return this.stepByCreateShop(currentUserInfo);
            }
            case BIND_SHOP: 
            case AUTHORIZE_APPLET: {
                return this.stepByAuthorize(type.getType(), appletInfo);
            }
            case REGISTER_APPLET: {
                return this.stepByRegisterApplet(appletInfo);
            }
        }
        respDto.setType(RegisterType.NEVER.getType());
        respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
        respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
        return respDto;
    }

    private StepRespDto stepByRegisterApplet(AppletInfo appletInfo) {
        StepRespDto respDto = new StepRespDto();
        respDto.setType(RegisterType.REGISTER_APPLET.getType());
        if (appletInfo == null) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            return respDto;
        }
        FastRegisterInfoResp fastRegisterInfoResp = this.appletRegisterService.fastRegisterInfo();
        if (fastRegisterInfoResp == null) {
            respDto.setShopAvailable(appletInfo.getShopAvailable());
            respDto.setIsAuth(appletInfo.getAuthStatus());
            return respDto;
        }
        respDto.setRegisterStatus(fastRegisterInfoResp.getRegisterStatus());
        respDto.setNameStatus(fastRegisterInfoResp.getNameStatus());
        respDto.setHeadImgStatus(fastRegisterInfoResp.getHeadImgStatus());
        respDto.setDescStatus(fastRegisterInfoResp.getDescStatus());
        respDto.setCatStatus(fastRegisterInfoResp.getCatStatus());
        respDto.setDomainStatus(fastRegisterInfoResp.getDomainStatus());
        respDto.setSearchStatus(fastRegisterInfoResp.getSearchStatus());
        respDto.setCommitCodeStatus(fastRegisterInfoResp.getCommitCodeStatus());
        respDto.setShopAvailable(appletInfo.getShopAvailable());
        respDto.setIsAuth(appletInfo.getAuthStatus());
        return respDto;
    }

    private StepRespDto stepByAuthorize(Integer registerType, AppletInfo appletInfo) {
        StepRespDto respDto = new StepRespDto();
        respDto.setType(registerType);
        log.info("stepByAuthorize appletInfo:{}", (Object)appletInfo);
        if (appletInfo == null) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            return respDto;
        }
        if (AppletAuthStatus.UNAUTHORIZED.getStatus().equals(appletInfo.getAuthStatus())) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            return respDto;
        }
        if (ShopAvailableStatus.UNAVAILABLE.getStatus().equals(appletInfo.getShopAvailable())) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
        }
        respDto.setIsAuth(appletInfo.getAuthStatus());
        return respDto;
    }

    private AppletInfo selectByBizId(Long bizId) {
        AppletInfo isExist = new AppletInfo();
        isExist.setIsDeleted(Integer.valueOf(0));
        isExist.setBizId(bizId);
        isExist.setBusinessType(AppletUseBusinessType.WX_SHOP.getType());
        return (AppletInfo)this.appletInfoMapper.selectOne((Object)isExist);
    }

    private StepRespDto stepByCreateShop(CurrentUserInfo userInfo) {
        StepRespDto respDto = new StepRespDto();
        respDto.setType(RegisterType.CREATE_SHOP.getType());
        AppletInfo appletInfo = this.selectByBizId(userInfo.getBizId());
        log.info("stepByCreateShop appletInfo:{}", (Object)appletInfo);
        if (appletInfo != null && AppletAuthStatus.UNAUTHORIZED.getStatus().equals(appletInfo.getAuthStatus())) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            return respDto;
        }
        ShopOpenDraft shopOpenDraftIsExist = new ShopOpenDraft();
        shopOpenDraftIsExist.setBizId(userInfo.getBizId());
        shopOpenDraftIsExist.setIsDeleted(Integer.valueOf(0));
        ShopOpenDraft existShopOpenDraft = (ShopOpenDraft)this.shopOpenDraftMapper.selectOne((Object)shopOpenDraftIsExist);
        log.info("stepByCreateShop existShopOpenDraft:{}", (Object)existShopOpenDraft);
        if (existShopOpenDraft == null) {
            respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
            respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
            respDto.setStatus(RegisterStepStatus.WAIT_START.getStatus());
            respDto.setStep(RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType());
            return respDto;
        }
        return this.stepByCreateShopUnfinished(existShopOpenDraft);
    }

    private StepRespDto stepByCreateShopUnfinished(ShopOpenDraft shopOpenDraft) {
        StepRespDto respDto = new StepRespDto();
        respDto.setShopAvailable(ShopAvailableStatus.UNAVAILABLE.getStatus());
        respDto.setIsAuth(AppletAuthStatus.UNAUTHORIZED.getStatus());
        respDto.setStep(shopOpenDraft.getStep());
        if (RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType().equals(shopOpenDraft.getStep())) {
            if (shopOpenDraft.getRegisterStatus() == null) {
                respDto.setStatus(RegisterStepStatus.WAIT_START.getStatus());
            } else if (WxRegisterStatus.SUBMITTED_REVIEW.getStatus().equals(shopOpenDraft.getRegisterStatus())) {
                respDto.setStatus(RegisterStepStatus.PENDING.getStatus());
            } else if (WxRegisterStatus.SUCCESS.getStatus().equals(shopOpenDraft.getRegisterStatus())) {
                respDto.setStatus(RegisterStepStatus.SUCCESS.getStatus());
            } else if (WxRegisterStatus.WAIT_SIGN.getStatus().equals(shopOpenDraft.getRegisterStatus())) {
                respDto.setStatus(RegisterStepStatus.PENDING.getStatus());
            } else {
                respDto.setStatus(RegisterStepStatus.FAIL.getStatus());
                respDto.setFailMsg(StringUtils.isBlank((CharSequence)shopOpenDraft.getRejectReasons()) ? WxRegisterStatus.NO_SEND_OR_INVALID.getDesc() : shopOpenDraft.getRejectReasons());
            }
        } else if (RegisterStep.TWO_SUBMIT_PAYMENT_QUALIFICATION_VERIFY_ACCOUNT.getType().equals(shopOpenDraft.getStep())) {
            respDto.setIsAuth(AppletAuthStatus.AUTHORIZED.getStatus());
            if (shopOpenDraft.getMerchantInfoStatus() == null) {
                respDto.setStatus(RegisterStepStatus.WAIT_START.getStatus());
            } else if (WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(shopOpenDraft.getBasicInfoStatus())) {
                respDto.setStatus(RegisterStepStatus.SUCCESS.getStatus());
            } else if (WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus().equals(shopOpenDraft.getMerchantInfoStatus())) {
                respDto.setStatus(RegisterStepStatus.FAIL.getStatus());
                respDto.setFailMsg(shopOpenDraft.getRejectReasons());
            } else if (WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus().equals(shopOpenDraft.getMerchantInfoStatus())) {
                if (WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(shopOpenDraft.getAcctVerifyStatus())) {
                    respDto.setStatus(RegisterStepStatus.WAIT_SCAN.getStatus());
                    respDto.setVerifyUrl(shopOpenDraft.getLegalValidationUrl());
                } else {
                    respDto.setStatus(RegisterStepStatus.PENDING.getStatus());
                }
            }
        } else if (RegisterStep.THREE_SHOP_BASIC_INFO_PAYMENT_SIGNING.getType().equals(shopOpenDraft.getStep())) {
            if (WxCheckAuditStatus.NOT_OPERABLE.getStatus().equals(shopOpenDraft.getBasicInfoStatus())) {
                respDto.setStatus(RegisterStepStatus.WAIT_START.getStatus());
            } else if (WxCheckAuditStatus.SUBMITTED_REVIEW.getStatus().equals(shopOpenDraft.getBasicInfoStatus())) {
                if (WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(shopOpenDraft.getPaySignStatus())) {
                    respDto.setStatus(RegisterStepStatus.WAIT_SCAN.getStatus());
                    respDto.setVerifyUrl(shopOpenDraft.getSignUrl());
                } else {
                    respDto.setStatus(RegisterStepStatus.PENDING.getStatus());
                }
            } else if (WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus().equals(shopOpenDraft.getBasicInfoStatus())) {
                respDto.setStatus(RegisterStepStatus.FAIL.getStatus());
                respDto.setFailMsg(shopOpenDraft.getRejectReasons());
            } else if (WxCheckAuditStatus.SUCCESS.getStatus().equals(shopOpenDraft.getBasicInfoStatus())) {
                respDto.setShopAvailable(ShopAvailableStatus.AVAILABLE.getStatus());
                respDto.setStatus(RegisterStepStatus.SUCCESS.getStatus());
            }
        }
        return respDto;
    }

    private String registerShop(ShopOpenDraft shopOpenDraft) {
        SuperAdministratorInfoDto superAdministratorInfo;
        try {
            superAdministratorInfo = (SuperAdministratorInfoDto)JSON.parseObject((String)shopOpenDraft.getSuperAdministratorInfo(), SuperAdministratorInfoDto.class);
        }
        catch (Exception e) {
            log.error("registerShop,\u89e3\u6790superAdministratorInfo\u5f02\u5e38", (Throwable)e);
            this.updateShopOpenDraftWhenRegisterShopFail(shopOpenDraft.getId(), "\u8d85\u7ba1\u4fe1\u606f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            return "\u8d85\u7ba1\u4fe1\u606f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
        }
        RegisterShopReq registerShopReq = new RegisterShopReq();
        registerShopReq.setWxName(superAdministratorInfo.getWxName());
        registerShopReq.setIdCardName(superAdministratorInfo.getName());
        registerShopReq.setIdCardNumber(superAdministratorInfo.getIdCardNumber());
        registerShopReq.setApiOpenStoreType(WxRegisterType.COMPLETE_STORE.getType());
        registerShopReq.setAuthPageUrl(this.appletAccessTokenService.getShopAuthUrl());
        log.info("registerShop registerShopReq:{}", (Object)registerShopReq);
        ErrorCode errorCode = this.wxShopRegisterAPI.registerShop(this.componentTokenService.getComponentAccessToken(), registerShopReq);
        log.info("registerShop,errorCode:{}", (Object)errorCode);
        if (errorCode.getErrCode() != 0) {
            this.updateShopOpenDraftWhenRegisterShopFail(shopOpenDraft.getId(), errorCode.getErrMsg());
            return errorCode.getErrMsg();
        }
        return null;
    }

    private void updateShopOpenDraftWhenRegisterShopFail(Long shopOpenDraftId, String failMsg) {
        ShopOpenDraft update = new ShopOpenDraft();
        update.setRegisterStatus(WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus());
        update.setRejectReasons(failMsg);
        update.setId(shopOpenDraftId);
        this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)update);
    }

    private void submitMerchantInfo(ShopOpenDraft shopOpenDraft) {
        PicFile picFile;
        ArrayList<String> picFileList;
        SuperAdministratorInfoDto superAdministratorInfoDto;
        IdCardInfoDto idCardInfoDto;
        BusiLicenseDto busiLicenseDto;
        SubmitMerchantInfoReq req = new SubmitMerchantInfoReq();
        req.setAppId(null);
        req.setSubjectType(shopOpenDraft.getSubjectType().toString());
        try {
            busiLicenseDto = (BusiLicenseDto)JSON.parseObject((String)shopOpenDraft.getBusiLicense(), BusiLicenseDto.class);
        }
        catch (Exception e) {
            log.error("submitMerchantInfo,\u89e3\u6790busiLicenseDto\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        BusiLicense busiLicense = new BusiLicense();
        BeanUtils.copyProperties((Object)busiLicenseDto, (Object)busiLicense);
        if (StringUtils.isBlank((CharSequence)busiLicense.getEndDate())) {
            busiLicense.setEndDate("\u957f\u671f");
        }
        UploadImgResp uploadImgResp = this.imgUrlToMediaId(shopOpenDraft.getRegisteredAppid(), busiLicenseDto.getPicFile());
        busiLicense.setPicFile(uploadImgResp.getPicFile());
        req.setBusiLicense(busiLicense);
        try {
            idCardInfoDto = (IdCardInfoDto)JSON.parseObject((String)shopOpenDraft.getIdCardInfo(), IdCardInfoDto.class);
        }
        catch (Exception e) {
            log.error("submitMerchantInfo,\u89e3\u6790idCardInfoDto\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        IdCardInfo idCardInfo = new IdCardInfo();
        BeanUtils.copyProperties((Object)idCardInfoDto, (Object)idCardInfo);
        if (StringUtils.isBlank((CharSequence)idCardInfo.getEndDate())) {
            idCardInfo.setEndDate("\u957f\u671f");
        }
        UploadImgResp portraitUploadImgResp = this.imgUrlToMediaId(shopOpenDraft.getRegisteredAppid(), idCardInfoDto.getPortraitPicFile());
        idCardInfo.setPortraitPicFile(portraitUploadImgResp.getPicFile());
        UploadImgResp nationUploadImgResp = this.imgUrlToMediaId(shopOpenDraft.getRegisteredAppid(), idCardInfoDto.getNationPicFile());
        idCardInfo.setNationPicFile(nationUploadImgResp.getPicFile());
        req.setIdCardInfo(idCardInfo);
        try {
            superAdministratorInfoDto = (SuperAdministratorInfoDto)JSON.parseObject((String)shopOpenDraft.getSuperAdministratorInfo(), SuperAdministratorInfoDto.class);
        }
        catch (Exception e) {
            log.error("submitMerchantInfo,\u89e3\u6790superAdministratorInfoDto\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        SuperAdministratorInfo superAdministratorInfo = new SuperAdministratorInfo();
        BeanUtils.copyProperties((Object)superAdministratorInfoDto, (Object)superAdministratorInfo);
        if (idCardInfo.getIdCardNumber().equals(superAdministratorInfoDto.getIdCardNumber())) {
            superAdministratorInfo.setType(WxSuperAdminType.LEGAL_PERSON_OR_OPERATOR.getType().toString());
        } else {
            superAdministratorInfo.setType(WxSuperAdminType.CHARGE.getType().toString());
        }
        superAdministratorInfo.setPhone(Long.valueOf(superAdministratorInfoDto.getPhone()));
        superAdministratorInfo.setIdCardNumber(Long.valueOf(superAdministratorInfoDto.getIdCardNumber()));
        req.setSuperAdministratorInfo(superAdministratorInfo);
        req.setMerchantShortName(shopOpenDraft.getMerchantShortname());
        if (StringUtils.isNotBlank((CharSequence)shopOpenDraft.getSpecialQualification())) {
            List specialQualifications;
            try {
                specialQualifications = JSON.parseArray((String)shopOpenDraft.getSpecialQualification(), String.class);
            }
            catch (Exception e) {
                log.error("submitMerchantInfo,\u89e3\u6790specialQualifications\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            picFileList = new ArrayList<String>();
            for (String sq : specialQualifications) {
                UploadImgResp specialQualificationUploadImgResp = this.imgUrlToMediaId(shopOpenDraft.getRegisteredAppid(), sq);
                picFile = specialQualificationUploadImgResp.getPicFile();
                picFileList.add(picFile.getMediaId());
            }
            SpecialQualification specialQualification = new SpecialQualification();
            specialQualification.setPicFileList(picFileList);
            req.setSpecialQualification(specialQualification);
        }
        if (StringUtils.isNotBlank((CharSequence)shopOpenDraft.getSupplementaryMaterial())) {
            List supplementaryMaterials;
            try {
                supplementaryMaterials = JSON.parseArray((String)shopOpenDraft.getSupplementaryMaterial(), String.class);
            }
            catch (Exception e) {
                log.error("submitMerchantInfo,\u89e3\u6790supplementaryMaterial\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            picFileList = new ArrayList();
            for (String sq : supplementaryMaterials) {
                UploadImgResp supplementaryMaterialUploadImgResp = this.imgUrlToMediaId(shopOpenDraft.getRegisteredAppid(), sq);
                picFile = supplementaryMaterialUploadImgResp.getPicFile();
                picFileList.add(picFile.getMediaId());
            }
            SpecialQualification supplementaryMaterial = new SpecialQualification();
            supplementaryMaterial.setPicFileList(picFileList);
            req.setSupplementaryMaterial(supplementaryMaterial);
        }
        if (StringUtils.isNotBlank((CharSequence)shopOpenDraft.getSupplementaryDesc())) {
            req.setSupplementaryDesc(shopOpenDraft.getSupplementaryDesc());
        }
        log.info("submitMerchantInfo req:{}", (Object)req);
        ErrorCode errorCode = this.wxShopRegisterAPI.submitMerchantInfo(this.appletAccessTokenService.getAccessToken(shopOpenDraft.getRegisteredAppid()), req);
        log.info("submitMerchantInfo,errorCode:{}", (Object)errorCode);
        if (errorCode.getErrCode() != 0) {
            this.updateShopOpenDraftWhenMerchantInfoFail(shopOpenDraft.getId(), errorCode.getErrMsg());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
        }
    }

    private UploadImgResp imgUrlToMediaId(String appId, String url) {
        int retry = 3;
        while (retry != 0) {
            try {
                return this.wxShopUtilAPI.uploadImg(this.appletAccessTokenService.getAccessToken(appId), Integer.valueOf(1), Integer.valueOf(0), url, null);
            }
            catch (WeixinException e) {
                log.error("submitMerchantInfo,\u4e0a\u4f20\u7279\u6b8a\u8d44\u8d28\u5f02\u5e38,\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)(--retry), (Object)e);
            }
        }
        log.error("submitMerchantInfo,\u4e0a\u4f20\u7279\u6b8a\u8d44\u8d28\u5f02\u5e38");
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
    }

    private void updateShopOpenDraftWhenMerchantInfoFail(Long shopOpenDraftId, String failMsg) {
        ShopOpenDraft update = new ShopOpenDraft();
        update.setMerchantInfoStatus(WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus());
        update.setRejectReasons(failMsg);
        update.setId(shopOpenDraftId);
        this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)update);
    }

    private void updateShopOpenDraftWhenBasicInfoFail(Long shopOpenDraftId, String failMsg) {
        ShopOpenDraft update = new ShopOpenDraft();
        update.setBasicInfoStatus(WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus());
        update.setRejectReasons(failMsg);
        update.setId(shopOpenDraftId);
        this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)update);
    }

    private void submitBasicInfo(ShopOpenDraft shopOpenDraft) {
        ReturnInfoDto companyAddress;
        ReturnInfoDto returnInfo;
        NameInfoDto nameInfoDto;
        SubmitBasicInfoReq req = new SubmitBasicInfoReq();
        req.setAppId(shopOpenDraft.getRegisteredAppid());
        try {
            nameInfoDto = (NameInfoDto)JSON.parseObject((String)shopOpenDraft.getNameInfo(), NameInfoDto.class);
        }
        catch (Exception e) {
            log.error("submitBasicInfo,\u89e3\u6790nameInfo\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        NameInfo nameInfo = new NameInfo();
        BeanUtils.copyProperties((Object)nameInfoDto, (Object)nameInfo);
        req.setNameInfo(nameInfo);
        try {
            returnInfo = (ReturnInfoDto)JSON.parseObject((String)shopOpenDraft.getReturnInfo(), ReturnInfoDto.class);
        }
        catch (Exception e) {
            log.error("submitBasicInfo,\u89e3\u6790returnInfo\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        ReturnInfo wxReturnInfo = new ReturnInfo();
        AddressInfo addressInfo = new AddressInfo();
        BeanUtils.copyProperties((Object)returnInfo, (Object)addressInfo);
        wxReturnInfo.setAddressInfo(addressInfo);
        wxReturnInfo.setMail(returnInfo.getMail());
        try {
            companyAddress = (ReturnInfoDto)JSON.parseObject((String)shopOpenDraft.getCompanyAddress(), ReturnInfoDto.class);
        }
        catch (Exception e) {
            log.error("submitBasicInfo,\u89e3\u6790companyAddress\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        AddressInfo wxCompanyAddress = new AddressInfo();
        BeanUtils.copyProperties((Object)companyAddress, (Object)wxCompanyAddress);
        wxReturnInfo.setCompanyAddress(wxCompanyAddress);
        req.setReturnInfo(wxReturnInfo);
        log.info("submitBasicInfo,req:{}", (Object)req);
        ErrorCode errorCode = this.wxShopRegisterAPI.submitBasicinfo(this.appletAccessTokenService.getAccessToken(shopOpenDraft.getRegisteredAppid()), req);
        if (errorCode.getErrCode() != 0) {
            this.updateShopOpenDraftWhenBasicInfoFail(shopOpenDraft.getId(), errorCode.getErrMsg());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
        }
    }

    @Override
    public void checkAuditStatus() {
        List shopOpenDrafts = this.shopOpenDraftMapper.selectListByNotOpen(RegisterStep.THREE_SHOP_BASIC_INFO_PAYMENT_SIGNING.getType(), WxCheckAuditStatus.SUCCESS.getStatus());
        log.info("\u672c\u6b21\u67e5\u8be2\u5f00\u5e97\u72b6\u6001\u7684\u6570\u91cf:{}", (Object)shopOpenDrafts.size());
        if (CollectionUtils.isEmpty((Collection)shopOpenDrafts)) {
            return;
        }
        for (ShopOpenDraft draft : shopOpenDrafts) {
            CheckAuditStatusResp checkAuditStatusResp;
            SuperAdministratorInfoDto superAdministratorInfo;
            log.info("current draft:{}", (Object)draft.toString());
            try {
                superAdministratorInfo = (SuperAdministratorInfoDto)JSON.parseObject((String)draft.getSuperAdministratorInfo(), SuperAdministratorInfoDto.class);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790superAdministratorInfo\u5f02\u5e38", (Throwable)e);
                continue;
            }
            String wxName = superAdministratorInfo.getWxName();
            try {
                checkAuditStatusResp = this.wxShopRegisterAPI.checkAuditStatus(StringUtils.isBlank((CharSequence)draft.getRegisteredAppid()) ? this.componentTokenService.getComponentAccessToken() : this.appletAccessTokenService.getAccessToken(draft.getRegisteredAppid()), wxName);
            }
            catch (Exception e) {
                log.error("checkAuditStatus,error!", (Throwable)e);
                continue;
            }
            CheckAuditStatusData data = checkAuditStatusResp.getData();
            log.info("checkAuditStatus,result:{}", (Object)data);
            if (StringUtils.isBlank((CharSequence)draft.getRegisteredAppid()) && StringUtils.isNotBlank((CharSequence)data.getRegisterAppId())) {
                draft.setRegisteredAppid(data.getRegisterAppId());
                this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)draft);
            }
            String auditRejectReasons = data.getAuditRejectReasons();
            int registerStatus = data.getRegisterStatus();
            if (!WxRegisterStatus.SUCCESS.getStatus().equals(draft.getRegisterStatus())) {
                ShopOpenDraft updateRegisterStatus = new ShopOpenDraft();
                updateRegisterStatus.setId(draft.getId());
                if (WxRegisterStatus.SUCCESS.getStatus().equals(registerStatus)) {
                    updateRegisterStatus.setStep(RegisterStep.TWO_SUBMIT_PAYMENT_QUALIFICATION_VERIFY_ACCOUNT.getType());
                    updateRegisterStatus.setRegisterStatus(Integer.valueOf(registerStatus));
                    updateRegisterStatus.setRegisteredAppid(data.getRegisterAppId());
                } else {
                    updateRegisterStatus.setRegisterStatus(Integer.valueOf(registerStatus));
                    updateRegisterStatus.setRejectReasons(auditRejectReasons);
                }
                this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateRegisterStatus);
                continue;
            }
            int merchantInfoStatus = data.getMerchantInfoStatus();
            int acctVerifyStatus = data.getAcctVerifyStatus();
            int basicInfoStatus = data.getBasicInfoStatus();
            if (!WxCheckAuditStatus.SUCCESS.getStatus().equals(draft.getMerchantInfoStatus())) {
                ShopOpenDraft updateDraft = new ShopOpenDraft();
                updateDraft.setId(draft.getId());
                if (WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus().equals(merchantInfoStatus)) {
                    updateDraft.setMerchantInfoStatus(Integer.valueOf(merchantInfoStatus));
                    updateDraft.setId(draft.getId());
                    updateDraft.setRejectReasons(auditRejectReasons);
                    this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
                    continue;
                }
                if (WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(acctVerifyStatus)) {
                    updateDraft.setAcctVerifyStatus(Integer.valueOf(acctVerifyStatus));
                    updateDraft.setLegalValidationUrl(data.getLegalValidationUrl());
                    this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
                    continue;
                }
                if (!WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(basicInfoStatus)) continue;
                updateDraft.setStep(RegisterStep.THREE_SHOP_BASIC_INFO_PAYMENT_SIGNING.getType());
                updateDraft.setMerchantInfoStatus(WxCheckAuditStatus.SUCCESS.getStatus());
                updateDraft.setBasicInfoStatus(WxCheckAuditStatus.NOT_OPERABLE.getStatus());
                this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
                continue;
            }
            int paySignStatus = data.getPaySignStatus();
            if (WxCheckAuditStatus.SUCCESS.getStatus().equals(draft.getBasicInfoStatus())) continue;
            ShopOpenDraft updateDraft = new ShopOpenDraft();
            if (WxCheckAuditStatus.REVIEW_FAILED_REJECTED.getStatus().equals(basicInfoStatus)) {
                updateDraft.setBasicInfoStatus(Integer.valueOf(basicInfoStatus));
                updateDraft.setRejectReasons(auditRejectReasons);
                this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
                continue;
            }
            if (WxCheckAuditStatus.NORMAL_OPERABLE.getStatus().equals(paySignStatus)) {
                updateDraft.setPaySignStatus(Integer.valueOf(paySignStatus));
                updateDraft.setSignUrl(data.getSignUrl());
                this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
                continue;
            }
            if (!WxCheckAuditStatus.SUCCESS.getStatus().equals(paySignStatus)) continue;
            updateDraft.setPaySignStatus(Integer.valueOf(paySignStatus));
            updateDraft.setBasicInfoStatus(WxCheckAuditStatus.SUCCESS.getStatus());
            this.shopOpenDraftMapper.updateByPrimaryKeySelective((Object)updateDraft);
            this.updateAppletInfoAvailable(draft.getRegisteredAppid());
        }
    }

    private void updateAppletInfoAvailable(String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(appId);
        if (appletInfo != null) {
            appletInfo.setShopAvailable(ShopAvailableStatus.AVAILABLE.getStatus());
            this.appletInfoMapper.updateByPrimaryKeySelective((Object)appletInfo);
        }
    }

    @Override
    public SubmitInfoDto getSubmitInfo() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        SubmitInfoDto dto = new SubmitInfoDto();
        ShopOpenDraft isExistDraft = new ShopOpenDraft();
        isExistDraft.setBizId(currentUserInfo.getBizId());
        ShopOpenDraft shopOpenDraft = (ShopOpenDraft)this.shopOpenDraftMapper.selectOne((Object)isExistDraft);
        if (shopOpenDraft == null) {
            return dto;
        }
        dto.setStep(shopOpenDraft.getStep());
        dto.setNum(shopOpenDraft.getNum());
        dto.setSubjectType(shopOpenDraft.getSubjectType());
        BusiLicenseDto busiLicenseDto = (BusiLicenseDto)JSON.parseObject((String)shopOpenDraft.getBusiLicense(), BusiLicenseDto.class);
        dto.setBusiLicense(busiLicenseDto);
        dto.setMerchantShortname(shopOpenDraft.getMerchantShortname());
        IdCardInfoDto idCardInfoDto = (IdCardInfoDto)JSON.parseObject((String)shopOpenDraft.getIdCardInfo(), IdCardInfoDto.class);
        dto.setIdCardInfo(idCardInfoDto);
        SuperAdministratorInfoDto superAdministratorInfoDto = (SuperAdministratorInfoDto)JSON.parseObject((String)shopOpenDraft.getSuperAdministratorInfo(), SuperAdministratorInfoDto.class);
        dto.setSuperAdministratorInfo(superAdministratorInfoDto);
        NameInfoDto nameInfoDto = (NameInfoDto)JSON.parseObject((String)shopOpenDraft.getNameInfo(), NameInfoDto.class);
        dto.setNameInfo(nameInfoDto);
        ReturnInfoDto returnInfoDto = (ReturnInfoDto)JSON.parseObject((String)shopOpenDraft.getReturnInfo(), ReturnInfoDto.class);
        dto.setReturnInfo(returnInfoDto);
        ReturnInfoDto companyAddress = (ReturnInfoDto)JSON.parseObject((String)shopOpenDraft.getCompanyAddress(), ReturnInfoDto.class);
        dto.setCompanyAddress(companyAddress);
        dto.setSpecialQualification(JSON.parseArray((String)shopOpenDraft.getSpecialQualification(), String.class));
        dto.setSupplementaryMaterial(JSON.parseArray((String)shopOpenDraft.getSupplementaryMaterial(), String.class));
        dto.setSupplementaryDesc(shopOpenDraft.getSupplementaryDesc());
        return dto;
    }

    @Override
    public void submitType(SubmitTypeDto dto) {
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopRegisterLog registerLog = new ShopRegisterLog();
        registerLog.setBizId(userInfo.getBizId());
        registerLog.setCorpId(userInfo.getCorpId());
        registerLog.setRegisterType(dto.getType());
        registerLog.setCreateBy(userInfo.getId());
        registerLog.setUpdateBy(userInfo.getId());
        Date now = new Date();
        registerLog.setCreateTime(now);
        registerLog.setUpdateTime(now);
        registerLog.setIsDeleted(Integer.valueOf(0));
        this.shopRegisterLogMapper.insert((Object)registerLog);
    }

    @Override
    public void clearLastSubmitType() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopRegisterLog registerLog = this.shopRegisterLogMapper.selectLastLogByBizId(currentUserInfo.getBizId());
        log.info("clearLastSubmitType registerLog:{}", (Object)registerLog);
        this.shopRegisterLogMapper.deleteByPrimaryKey((Object)registerLog.getId());
    }
}

