/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopCouponAPI;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ValidInfoByCreate;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.CouponDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountCondition;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.DiscountInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ExtInfoByCreate;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.PromoteInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.ReceiveInfoByCreate;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.UserCouponItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponCreateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponGetUserListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.CouponUpdateStatusReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponCreateResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CouponGetUserListResp;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.dto.coupon.CouponListQueryParams;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopCouponProduct;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponProductMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.shop.dto.coupon.CouponCreateOrUpdateDto;
import com.kuaike.scrm.shop.dto.coupon.CouponDiscountInfoDto;
import com.kuaike.scrm.shop.dto.coupon.CouponExtInfoDto;
import com.kuaike.scrm.shop.dto.coupon.CouponListReqDto;
import com.kuaike.scrm.shop.dto.coupon.CouponListRespDto;
import com.kuaike.scrm.shop.dto.coupon.CouponPromoteInfoDto;
import com.kuaike.scrm.shop.dto.coupon.CouponReceiveInfoDto;
import com.kuaike.scrm.shop.dto.coupon.CouponStockInfoDto;
import com.kuaike.scrm.shop.dto.coupon.CouponUpdateStatusReqDto;
import com.kuaike.scrm.shop.dto.coupon.CouponValidInfoDto;
import com.kuaike.scrm.shop.dto.coupon.GetUserCouponListReqDto;
import com.kuaike.scrm.shop.dto.coupon.UserCouponListResp;
import com.kuaike.scrm.shop.enums.WxShopCouponStatus;
import com.kuaike.scrm.shop.enums.WxShopPromoteType;
import com.kuaike.scrm.shop.enums.WxShopValidType;
import com.kuaike.scrm.shop.service.ShopCouponService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopCouponServiceImpl
implements ShopCouponService {
    private static final Logger log = LoggerFactory.getLogger(ShopCouponServiceImpl.class);
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private WxShopCouponAPI wxShopCouponAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private ShopCouponProductMapper shopCouponProductMapper;

    @Override
    public List<CouponListRespDto> list(CouponListReqDto dto) {
        log.info("list,dto:{}", (Object)dto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        CouponListQueryParams params = new CouponListQueryParams();
        params.setBizId(userInfo.getBizId());
        params.setIsDeleted(Integer.valueOf(0));
        if (dto.getPageDto() != null) {
            ShopCoupon selectCount = new ShopCoupon();
            selectCount.setBizId(params.getBizId());
            selectCount.setIsDeleted(params.getIsDeleted());
            int total = this.shopCouponMapper.selectCount((Object)selectCount);
            dto.getPageDto().setCount(Integer.valueOf(total));
        }
        params.setPageDto(dto.getPageDto());
        params.setSource(Integer.valueOf(GoodsOrderSource.WX_SHOP.getSource()));
        List shopCoupons = this.shopCouponMapper.selectListByParams(params);
        if (CollectionUtils.isEmpty((Collection)shopCoupons)) {
            return Lists.newArrayList();
        }
        ArrayList<CouponListRespDto> respDtoList = new ArrayList<CouponListRespDto>(shopCoupons.size());
        for (ShopCoupon shopCoupon : shopCoupons) {
            respDtoList.add(this.buildRespDto(shopCoupon));
        }
        return respDtoList;
    }

    public CouponListRespDto buildRespDto(ShopCoupon shopCoupon) {
        CouponListRespDto respDto = new CouponListRespDto();
        respDto.setName(shopCoupon.getName());
        respDto.setCouponId(shopCoupon.getCouponId());
        respDto.setType(shopCoupon.getType());
        respDto.setStatus(shopCoupon.getStatus());
        CouponValidInfoDto validInfoDto = new CouponValidInfoDto();
        validInfoDto.setValidType(shopCoupon.getValidType());
        validInfoDto.setValidDayNum(shopCoupon.getValidDayNum());
        validInfoDto.setValidStartTime(shopCoupon.getValidStartTime() != null ? DateUtil.format((Date)shopCoupon.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        validInfoDto.setValidEndTime(shopCoupon.getValidEndTime() != null ? DateUtil.format((Date)shopCoupon.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        respDto.setValidInfo(validInfoDto);
        CouponPromoteInfoDto promoteInfoDto = new CouponPromoteInfoDto();
        promoteInfoDto.setPromoteType(shopCoupon.getPromoteType());
        promoteInfoDto.setCustomizeChannel(shopCoupon.getCustomizeChannel());
        respDto.setPromoteInfo(promoteInfoDto);
        CouponDiscountInfoDto discountInfoDto = new CouponDiscountInfoDto();
        discountInfoDto.setDiscountNum(shopCoupon.getDiscountNum());
        discountInfoDto.setDiscountFee(shopCoupon.getDiscountFee());
        discountInfoDto.setProductCnt(shopCoupon.getProductCnt());
        discountInfoDto.setProductPrice(shopCoupon.getProductPrice());
        List productIds = this.shopCouponProductMapper.selectProductIdsByCouponId(shopCoupon.getBizId(), shopCoupon.getCouponId());
        discountInfoDto.setProductIds(productIds);
        respDto.setDiscountInfo(discountInfoDto);
        CouponReceiveInfoDto receiveInfoDto = new CouponReceiveInfoDto();
        receiveInfoDto.setStartTime(DateUtil.format((Date)shopCoupon.getReceiveStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        receiveInfoDto.setEndTime(DateUtil.format((Date)shopCoupon.getReceiveEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        receiveInfoDto.setTotalNum(shopCoupon.getTotalNum());
        receiveInfoDto.setLimitNumOnePerson(shopCoupon.getLimitNumOnePerson());
        respDto.setReceiveInfo(receiveInfoDto);
        CouponStockInfoDto stockInfoDto = new CouponStockInfoDto();
        stockInfoDto.setReceiveNum(shopCoupon.getReceiveNum());
        stockInfoDto.setTotalNum(shopCoupon.getTotalNum());
        stockInfoDto.setUsedNum(shopCoupon.getUsedNum());
        respDto.setStockInfo(stockInfoDto);
        CouponExtInfoDto extInfoDto = new CouponExtInfoDto();
        extInfoDto.setNotes(shopCoupon.getNotes());
        extInfoDto.setJumpProductId(shopCoupon.getJumpProductId());
        respDto.setExtInfo(extInfoDto);
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdate(CouponCreateOrUpdateDto dto) {
        log.info("createOrUpdate,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        AppletInfo shopExist = new AppletInfo();
        shopExist.setBizId(userInfo.getBizId());
        shopExist.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
        shopExist.setBusinessType(AppletUseBusinessType.WX_SHOP.getType());
        AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)shopExist);
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        if (StringUtils.isNotBlank((CharSequence)dto.getCouponId())) {
            CouponCreateResp createCouponResp;
            ShopCoupon exist = new ShopCoupon();
            exist.setCouponId(dto.getCouponId());
            exist.setBizId(userInfo.getBizId());
            ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)exist);
            Preconditions.checkArgument((shopCoupon != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
            Preconditions.checkArgument((boolean)WxShopCouponStatus.NOT_EFFECT_EDITING.getStatus().equals(shopCoupon.getStatus()), (Object)"\u975e\u672a\u751f\u6548\u7684\u4f18\u60e0\u5238\u4e0d\u53ef\u7f16\u8f91");
            CouponCreateReq couponCreateReq = this.dtoToCouponCreateReq(dto);
            couponCreateReq.setCouponId(Long.valueOf(shopCoupon.getCouponId()));
            log.info("edit coupon req:{}", (Object)couponCreateReq);
            try {
                createCouponResp = this.wxShopCouponAPI.updateCoupon(this.appletAccessTokenService.getAccessToken(appletInfo.getAppId()), couponCreateReq);
            }
            catch (Exception e) {
                log.error("createOrUpdate,\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u7f16\u8f91\u4f18\u60e0\u5238\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            log.info("edit coupon resp:{}", (Object)createCouponResp);
            if (createCouponResp.getErrCode() != 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, createCouponResp.getErrMsg());
            }
            ShopCoupon updateShopCoupon = this.couponCreateReqToShopCoupon(couponCreateReq, userInfo, null, null, false);
            updateShopCoupon.setUpdateBy(userInfo.getId());
            updateShopCoupon.setUpdateTime(new Date());
            updateShopCoupon.setId(shopCoupon.getId());
            this.shopCouponMapper.updateByPrimaryKeySelective((Object)updateShopCoupon);
            this.updateCouponProduct(shopCoupon.getCouponId(), userInfo, shopCoupon.getAppId(), dto.getDiscountInfo().getProductIds());
        } else {
            CouponCreateResp createCouponResp;
            CouponCreateReq couponCreateReq = this.dtoToCouponCreateReq(dto);
            log.info("add coupon req:{}", (Object)couponCreateReq);
            try {
                createCouponResp = this.wxShopCouponAPI.createCoupon(this.appletAccessTokenService.getAccessToken(appletInfo.getAppId()), couponCreateReq);
            }
            catch (Exception e) {
                log.error("createOrUpdate,\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u521b\u5efa\u4f18\u60e0\u5238\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            log.info("add coupon resp:{}", (Object)createCouponResp);
            if (createCouponResp.getErrCode() != 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, createCouponResp.getErrMsg());
            }
            String couponId = String.valueOf(createCouponResp.getData().getCouponId());
            ShopCoupon shopCoupon = this.couponCreateReqToShopCoupon(couponCreateReq, userInfo, couponId, appletInfo.getAppId(), true);
            this.shopCouponMapper.insert((Object)shopCoupon);
            this.handleBatchInsertCouponProduct(dto.getDiscountInfo().getProductIds(), shopCoupon.getCouponId(), userInfo, shopCoupon.getAppId());
        }
    }

    private void updateCouponProduct(String couponId, CurrentUserInfo userInfo, String appId, List<String> productIds) {
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        ShopCouponProduct exist = new ShopCouponProduct();
        exist.setBizId(userInfo.getBizId());
        exist.setCouponId(couponId);
        List existsRelation = this.shopCouponProductMapper.select((Object)exist);
        if (CollectionUtils.isEmpty((Collection)existsRelation)) {
            this.handleBatchInsertCouponProduct(productIds, couponId, userInfo, appId);
        } else {
            List<String> insertProducts;
            List existProductIds = existsRelation.stream().map(ShopCouponProduct::getProductId).collect(Collectors.toList());
            List delProducts = existProductIds.stream().filter(p -> !productIds.contains(p)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(delProducts)) {
                log.info("updateCouponProduct delProducts:{}", delProducts);
                this.shopCouponProductMapper.deleteByProductIds(delProducts, userInfo.getBizId());
            }
            if (CollectionUtils.isNotEmpty(insertProducts = productIds.stream().filter(p -> !existProductIds.contains(p)).collect(Collectors.toList()))) {
                this.handleBatchInsertCouponProduct(insertProducts, couponId, userInfo, appId);
            }
        }
    }

    private void handleBatchInsertCouponProduct(List<String> productIds, String couponId, CurrentUserInfo userInfo, String appId) {
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        Date now = new Date();
        ArrayList<ShopCouponProduct> list = new ArrayList<ShopCouponProduct>();
        for (String productId : productIds) {
            ShopCouponProduct product = new ShopCouponProduct();
            product.setNum(this.idGen.getNum());
            product.setBizId(userInfo.getBizId());
            product.setCorpId(userInfo.getCorpId());
            product.setProductId(productId);
            product.setCouponId(couponId);
            product.setAppId(appId);
            product.setCreateBy(userInfo.getId());
            product.setCreateTime(now);
            product.setUpdateBy(userInfo.getId());
            product.setUpdateTime(now);
            product.setIsDeleted(Integer.valueOf(0));
            list.add(product);
        }
        this.shopCouponProductMapper.batchInsert(list);
    }

    private ShopCoupon couponCreateReqToShopCoupon(CouponCreateReq couponCreateReq, CurrentUserInfo userInfo, String couponId, String appId, boolean isInsert) {
        Date now = new Date();
        ShopCoupon shopCoupon = new ShopCoupon();
        shopCoupon.setBizId(userInfo.getBizId());
        shopCoupon.setCorpId(userInfo.getCorpId());
        PromoteInfo promoteInfo = couponCreateReq.getPromoteInfo();
        shopCoupon.setPromoteType(WxShopPromoteType.getTypeByEnDesc(promoteInfo.getPromoteType()));
        shopCoupon.setCustomizeChannel(promoteInfo.getCustomizeChannel());
        shopCoupon.setName(couponCreateReq.getName());
        shopCoupon.setType(couponCreateReq.getType());
        DiscountInfo discountInfo = couponCreateReq.getDiscountInfo();
        shopCoupon.setDiscountNum(Integer.valueOf(discountInfo.getDiscountNum() != null ? discountInfo.getDiscountNum().intValue() : 0));
        shopCoupon.setDiscountFee(Long.valueOf(discountInfo.getDiscountFee() != null ? discountInfo.getDiscountFee() : 0L));
        DiscountCondition discountCondition = discountInfo.getDiscountCondition();
        shopCoupon.setProductCnt(Integer.valueOf(discountCondition.getProductCnt() != null ? discountCondition.getProductCnt().intValue() : 0));
        shopCoupon.setProductPrice(Long.valueOf(discountCondition.getProductPrice() != null ? discountCondition.getProductPrice() : 0L));
        ReceiveInfoByCreate receiveInfo = couponCreateReq.getReceiveInfo();
        shopCoupon.setReceiveStartTime(new Date(receiveInfo.getStartTime() * 1000L));
        shopCoupon.setReceiveEndTime(new Date(receiveInfo.getEndTime() * 1000L));
        ValidInfoByCreate validInfo = couponCreateReq.getValidInfo();
        shopCoupon.setValidType(validInfo.getValidType());
        shopCoupon.setValidDayNum(Integer.valueOf(validInfo.getValidDayNum() != null ? validInfo.getValidDayNum() : 0));
        shopCoupon.setTotalNum(receiveInfo.getTotalNum());
        shopCoupon.setLimitNumOnePerson(receiveInfo.getLimitNumOnePerson());
        ExtInfoByCreate extInfo = couponCreateReq.getExtInfo();
        shopCoupon.setValidStartTime(validInfo.getStartTime() != null ? new Date(validInfo.getStartTime() * 1000L) : new Date(extInfo.getValidTime()));
        shopCoupon.setValidEndTime(validInfo.getStartTime() != null ? new Date(validInfo.getEndTime() * 1000L) : new Date(extInfo.getInvalidTime()));
        shopCoupon.setNotes(extInfo.getNotes());
        shopCoupon.setJumpProductId(String.valueOf(extInfo.getJumpProductId()));
        shopCoupon.setStatus(WxShopCouponStatus.NOT_EFFECT_EDITING.getStatus());
        shopCoupon.setUpdateBy(userInfo.getId());
        shopCoupon.setUpdateTime(now);
        if (isInsert) {
            shopCoupon.setNum(this.idGen.getNum());
            shopCoupon.setReceiveNum(Integer.valueOf(0));
            shopCoupon.setUsedNum(Integer.valueOf(0));
            shopCoupon.setCouponId(couponId);
            shopCoupon.setAppId(appId);
            shopCoupon.setCreateBy(userInfo.getId());
            shopCoupon.setCreateTime(now);
            shopCoupon.setIsDeleted(Integer.valueOf(0));
        }
        return shopCoupon;
    }

    private CouponCreateReq dtoToCouponCreateReq(CouponCreateOrUpdateDto dto) {
        CouponCreateReq couponCreateReq = new CouponCreateReq();
        couponCreateReq.setType(dto.getType());
        couponCreateReq.setName(dto.getName());
        DiscountInfo discountInfo = new DiscountInfo();
        CouponDiscountInfoDto discountInfoDto = dto.getDiscountInfo();
        discountInfo.setDiscountFee(discountInfoDto.getDiscountFee());
        discountInfo.setDiscountNum(Long.valueOf(discountInfoDto.getDiscountNum() != null ? (long)discountInfoDto.getDiscountNum().intValue() : 0L));
        DiscountCondition discountCondition = new DiscountCondition();
        discountCondition.setProductCnt(Long.valueOf(discountInfoDto.getProductCnt() != null ? (long)discountInfoDto.getProductCnt().intValue() : 0L));
        discountCondition.setProductPrice(Long.valueOf(discountInfoDto.getProductPrice() != null ? discountInfoDto.getProductPrice() : 0L));
        discountCondition.setProductIds(discountInfoDto.getProductIds().stream().map(Long::parseLong).collect(Collectors.toList()));
        discountInfo.setDiscountCondition(discountCondition);
        couponCreateReq.setDiscountInfo(discountInfo);
        ExtInfoByCreate extInfo = new ExtInfoByCreate();
        CouponExtInfoDto couponExtInfoDto = dto.getExtInfo();
        extInfo.setJumpProductId(Long.valueOf(couponExtInfoDto.getJumpProductId()));
        extInfo.setNotes(couponExtInfoDto.getNotes());
        CouponReceiveInfoDto receiveInfoDto = dto.getReceiveInfo();
        DateTime receiveStartTime = DateUtil.parse((CharSequence)receiveInfoDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
        DateTime receiveEndTime = DateUtil.parse((CharSequence)receiveInfoDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        CouponValidInfoDto validInfoDto = dto.getValidInfo();
        DateTime validStartTime = DateUtil.parse((CharSequence)validInfoDto.getValidStartTime());
        DateTime validEndTime = DateUtil.parse((CharSequence)validInfoDto.getValidEndTime());
        if (WxShopValidType.COUPON_VALID_TYPE_TIME.getType().equals(validInfoDto.getValidType())) {
            extInfo.setValidTime(Long.valueOf(validStartTime.getTime()));
            extInfo.setInvalidTime(Long.valueOf(validEndTime.getTime()));
        } else {
            extInfo.setValidTime(Long.valueOf(receiveStartTime.getTime()));
            DateTime endTime = DateUtil.offsetDay((Date)receiveEndTime, (int)validInfoDto.getValidDayNum());
            extInfo.setInvalidTime(Long.valueOf(endTime.getTime()));
        }
        couponCreateReq.setExtInfo(extInfo);
        PromoteInfo promoteInfo = new PromoteInfo();
        CouponPromoteInfoDto promoteInfoDto = dto.getPromoteInfo();
        promoteInfo.setPromoteType(WxShopPromoteType.getEnDescByType(promoteInfoDto.getPromoteType()));
        promoteInfo.setCustomizeChannel(promoteInfoDto.getCustomizeChannel());
        couponCreateReq.setPromoteInfo(promoteInfo);
        ReceiveInfoByCreate receiveInfo = new ReceiveInfoByCreate();
        receiveInfo.setStartTime(Long.valueOf(DateUtil.parse((CharSequence)receiveInfoDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss").getTime() / 1000L));
        receiveInfo.setEndTime(Long.valueOf(DateUtil.parse((CharSequence)receiveInfoDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss").getTime() / 1000L));
        receiveInfo.setLimitNumOnePerson(receiveInfoDto.getLimitNumOnePerson());
        receiveInfo.setTotalNum(receiveInfoDto.getTotalNum());
        couponCreateReq.setReceiveInfo(receiveInfo);
        ValidInfoByCreate validInfo = new ValidInfoByCreate();
        validInfo.setValidType(validInfoDto.getValidType());
        validInfo.setValidDayNum(validInfoDto.getValidDayNum());
        if (validInfoDto.getValidStartTime() != null) {
            validInfo.setStartTime(Long.valueOf(DateUtil.parse((CharSequence)validInfoDto.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss").getTime() / 1000L));
        }
        if (validInfoDto.getValidEndTime() != null) {
            validInfo.setEndTime(Long.valueOf(DateUtil.parse((CharSequence)validInfoDto.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss").getTime() / 1000L));
        }
        couponCreateReq.setValidInfo(validInfo);
        return couponCreateReq;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(CouponUpdateStatusReqDto dto) {
        ErrorCode errorCode;
        CouponGetResp coupon;
        log.info("updateStatus,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopCoupon exist = new ShopCoupon();
        exist.setCouponId(dto.getCouponId());
        exist.setBizId(userInfo.getBizId());
        exist.setIsDeleted(Integer.valueOf(0));
        ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)exist);
        Preconditions.checkArgument((shopCoupon != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        Integer newStatus = dto.getStatus();
        CouponGetReq couponGetReq = new CouponGetReq();
        couponGetReq.setCouponId(Long.valueOf(shopCoupon.getCouponId()));
        try {
            coupon = this.wxShopCouponAPI.getCoupon(this.appletAccessTokenService.getAccessToken(shopCoupon.getAppId()), couponGetReq);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u4f18\u60e0\u5238\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u4f18\u60e0\u5238\u72b6\u6001\u5931\u8d25");
        }
        log.info("updateStatus \u4ece\u5fae\u4fe1\u67e5\u8be2\u4f18\u60e0\u5238\u6700\u65b0\u8be6\u60c5:{}", (Object)coupon);
        CouponDto couponDto = coupon.getCoupon();
        Integer status = couponDto.getStatus();
        if (!status.equals(shopCoupon.getStatus())) {
            this.updateCouponStatus(shopCoupon.getId(), status, userInfo.getId());
            return;
        }
        CouponUpdateStatusReq req = new CouponUpdateStatusReq();
        req.setCouponId(Long.valueOf(shopCoupon.getCouponId()));
        if (shopCoupon.getStatus().equals(WxShopCouponStatus.NOT_EFFECT_EDITING.getStatus())) {
            Preconditions.checkArgument((newStatus.equals(WxShopCouponStatus.EFFECTIVE.getStatus()) || newStatus.equals(WxShopCouponStatus.DELETED.getStatus()) ? 1 : 0) != 0, (Object)"\u672a\u751f\u6548\u7684\u4f18\u60e0\u5238\u53ea\u80fd\u751f\u6548\u6216\u5220\u9664");
        }
        if (shopCoupon.getStatus().equals(WxShopCouponStatus.EFFECTIVE.getStatus())) {
            Preconditions.checkArgument((boolean)newStatus.equals(WxShopCouponStatus.INVALIDATED.getStatus()), (Object)"\u751f\u6548\u7684\u4f18\u60e0\u5238\u53ea\u80fd\u4f5c\u5e9f");
        }
        if (shopCoupon.getStatus().equals(WxShopCouponStatus.EXPIRED.getStatus()) || shopCoupon.getStatus().equals(WxShopCouponStatus.INVALIDATED.getStatus())) {
            Preconditions.checkArgument((boolean)newStatus.equals(WxShopCouponStatus.DELETED.getStatus()), (Object)"\u5f53\u524d\u72b6\u6001\u7684\u4f18\u60e0\u5238\u53ea\u80fd\u5220\u9664");
        }
        req.setStatus(newStatus);
        log.info("updateStatus,req:{}", (Object)req);
        try {
            errorCode = this.wxShopCouponAPI.updateCouponStatus(this.appletAccessTokenService.getAccessToken(shopCoupon.getAppId()), req);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u66f4\u65b0\u4f18\u60e0\u5238\u72b6\u6001\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        log.info("updateStatus,resp:{}", (Object)errorCode);
        if (errorCode.getErrCode() != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
        }
        this.updateCouponStatus(shopCoupon.getId(), newStatus, userInfo.getId());
    }

    private void updateCouponStatus(Long id, Integer status, Long userId) {
        ShopCoupon update = new ShopCoupon();
        update.setId(id);
        if (WxShopCouponStatus.DELETED.getStatus().equals(status)) {
            this.shopCouponMapper.delete((Object)update);
            return;
        }
        update.setStatus(status);
        update.setUpdateBy(userId);
        update.setUpdateTime(new Date());
        this.shopCouponMapper.updateByPrimaryKeySelective((Object)update);
    }

    @Override
    public List<UserCouponListResp> getUserCouponList(GetUserCouponListReqDto dto) {
        List shopCoupons;
        log.info("getUserCouponList req:{}", (Object)dto);
        dto.validate();
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(dto.getAppId());
        Preconditions.checkArgument((appletInfo != null && appletInfo.getAuthStatus() == 1 ? 1 : 0) != 0, (Object)"\u5c0f\u5546\u5e97\u672a\u6388\u6743");
        CouponGetUserListReq req = new CouponGetUserListReq();
        req.setOpenId(dto.getOpenId());
        req.setStatus(Integer.valueOf(100));
        CouponGetUserListResp couponUserList = this.wxShopCouponAPI.getCouponUserList(this.appletAccessTokenService.getAccessToken(dto.getAppId()), req);
        List userCouponList = couponUserList.getUserCouponList();
        List couponIds = userCouponList.stream().map(UserCouponItem::getCouponId).map(a -> String.valueOf(a)).collect(Collectors.toList());
        ArrayList<UserCouponListResp> respList = new ArrayList<UserCouponListResp>();
        try {
            shopCoupons = this.shopCouponMapper.selectByCouponIds(appletInfo.getBizId(), couponIds, Integer.valueOf(0));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u7528\u6237\u4f18\u60e0\u5238\u5f02\u5e38,req:{}", (Object)req, (Object)e);
            return respList;
        }
        Map couponIdMap = shopCoupons.stream().collect(Collectors.toMap(ShopCoupon::getCouponId, Function.identity()));
        for (UserCouponItem item : userCouponList) {
            ShopCoupon shopCoupon = (ShopCoupon)couponIdMap.get(item.getCouponId());
            if (shopCoupon == null) continue;
            UserCouponListResp resp = new UserCouponListResp();
            resp.setCouponId(item.getCouponId());
            resp.setCouponName(shopCoupon.getName());
            resp.setValidEndTime(item.getEndTime());
            respList.add(resp);
        }
        return respList;
    }
}

