/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.roc.service.impl;

import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ErrorCodeUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.roc.dto.Staff;
import com.kuaike.scrm.roc.dto.response.LoginRespDto;
import com.kuaike.scrm.roc.service.StaffService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
public class StaffServiceImpl
implements StaffService {
    private static final Logger log = LoggerFactory.getLogger(StaffServiceImpl.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private LdapTemplate ldapTemplate;
    @Value(value="${spring.ldap.domainName}")
    private String ldapDomainName;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginRespDto authenticate(String username, String password, HttpSession httpSession) {
        LoginRespDto loginRespDto = new LoginRespDto();
        if (StringUtils.isBlank((CharSequence)username)) {
            loginRespDto.setMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            loginRespDto.setResult(false);
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            loginRespDto.setMsg("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            loginRespDto.setResult(false);
        }
        String userDn = username + this.ldapDomainName;
        DirContext ctx = null;
        List list = null;
        try {
            ctx = this.ldapTemplate.getContextSource().getContext(userDn, password);
            loginRespDto.setResult(true);
            list = this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person").and("sAMAccountName").is(username), (AttributesMapper)new StaffAttributesMapper());
        }
        catch (Exception ex) {
            log.error("login error", (Throwable)ex);
            log.info("login failed username={}, password={}", (Object)username, (Object)password);
            loginRespDto.setMsg("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            loginRespDto.setResult(false);
        }
        finally {
            LdapUtils.closeContext((LdapContext)((LdapContext)ctx));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            Staff staff = (Staff)list.get(0);
            httpSession.setAttribute("ROC_LOING_USER_NAME", (Object)staff.getSAMAccountName());
        }
        return loginRespDto;
    }

    @Override
    public void logout(HttpServletRequest req, HttpSession httpSession) {
        String sAMAccountName = this.getLoginSAMAccountName();
        this.deleteCurrentUser(sAMAccountName);
        httpSession.removeAttribute("ROC_LOING_USER_NAME");
    }

    @Override
    public List<Staff> getAllStaff() {
        return this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person"), (AttributesMapper)new StaffAttributesMapper());
    }

    @Override
    public Staff getStaffBySAMAccountName(String sAMAccountName) {
        List list = this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person").and("sAMAccountName").is(sAMAccountName), (AttributesMapper)new StaffAttributesMapper());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (Staff)list.get(0);
        }
        return null;
    }

    @Override
    public Staff getRocLoginUserInfo() {
        String sAMAccountName = this.getLoginSAMAccountName();
        Staff staff = (Staff)this.getRedisValue(sAMAccountName);
        return staff;
    }

    @Override
    public Staff getUserInfo(HttpServletRequest request, HttpServletResponse response) {
        String sAMAccountName = this.getLoginSAMAccountName();
        Staff staff = null;
        if (StringUtils.isBlank((CharSequence)sAMAccountName) || Objects.isNull(sAMAccountName)) {
            this.returnAjaxNologinResponse(request, response);
            return null;
        }
        Object currentUserInfoInRedis = this.getRedisValue(sAMAccountName);
        if (currentUserInfoInRedis instanceof Staff) {
            staff = (Staff)currentUserInfoInRedis;
        } else {
            staff = new Staff();
            staff.setSAMAccountName(sAMAccountName);
        }
        if (Objects.nonNull(staff)) {
            this.setRedisValue(sAMAccountName, staff);
        }
        return staff;
    }

    public void deleteCurrentUser(String sAMAccountName) {
        String key = this.getUserInfoKey(sAMAccountName);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.deleteRedisValue(this.redisTemplate, key);
        }
    }

    private Object deleteRedisValue(RedisTemplate<String, Object> redisTemplate, String key) {
        return redisTemplate.delete((Object)key);
    }

    public Object getRedisValue(String key) {
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        return valueOperations.get((Object)this.getUserInfoKey(key));
    }

    private void setRedisValue(String sAMAccountName, Object value) {
        if (Objects.isNull(sAMAccountName)) {
            return;
        }
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        valueOperations.set((Object)this.getUserInfoKey(sAMAccountName), value, 2592000L, TimeUnit.SECONDS);
    }

    private String getUserInfoKey(String sAMAccountName) {
        String key = String.format("ROC_LOGIN_KEY_%s", sAMAccountName);
        return this.redisKeyPrefix + LoginUtils.getSessionId() + key;
    }

    private void returnAjaxNologinResponse(HttpServletRequest request, HttpServletResponse response) {
        long code = ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)CommonErrorCode.NO_LOGIN);
        HashMap map = Maps.newHashMap();
        response.setStatus(401);
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)new ApiResult(code, "\u7528\u6237\u672a\u767b\u5f55", (Object)map)));
    }

    public String getLoginSAMAccountName() {
        String sAMAccountName = "";
        HttpSession httpSession = LoginUtils.getSession();
        if (Objects.nonNull(httpSession)) {
            sAMAccountName = (String)httpSession.getAttribute("ROC_LOING_USER_NAME");
        }
        return sAMAccountName;
    }

    private class StaffAttributesMapper
    implements AttributesMapper<Staff> {
        private StaffAttributesMapper() {
        }

        public Staff mapFromAttributes(Attributes attrs) throws NamingException {
            Staff staff = new Staff();
            log.info("attrs:{}", (Object)attrs);
            staff.setName((String)attrs.get("cn").get());
            staff.setSAMAccountName((String)attrs.get("samaccountname").get());
            return staff;
        }
    }
}

