/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PersonModReqDto {
    private String num;
    private Long groupId;
    private List<String> keywords;
    private List<UniformMsgDto> contentList;
    private String title;
    private Integer isTop;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.num), (Object)"\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.groupId), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u8bdd\u672f\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.title.length() <= 50 ? 1 : 0) != 0, (Object)"\u8bdd\u672f\u6807\u9898\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"\u8bdd\u672f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        for (UniformMsgDto msgDto : this.contentList) {
            msgDto.validate();
        }
        if (CollectionUtils.isNotEmpty(this.keywords)) {
            Preconditions.checkArgument((this.keywords.size() <= 10 ? 1 : 0) != 0, (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
            for (String keyword : this.keywords) {
                Preconditions.checkArgument((boolean)Objects.nonNull(keyword), (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u4e3anull");
                Preconditions.checkArgument((keyword.length() <= 50 ? 1 : 0) != 0, (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
            }
            HashSet<String> keySet = new HashSet<String>(this.keywords);
            Preconditions.checkArgument((keySet.size() == this.keywords.size() ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u91cd\u590d");
        }
    }

    public String getNum() {
        return this.num;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getIsTop() {
        return this.isTop;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonModReqDto)) {
            return false;
        }
        PersonModReqDto other = (PersonModReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Integer this$isTop = this.getIsTop();
        Integer other$isTop = other.getIsTop();
        if (this$isTop == null ? other$isTop != null : !((Object)this$isTop).equals(other$isTop)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonModReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Integer $isTop = this.getIsTop();
        result = result * 59 + ($isTop == null ? 43 : ((Object)$isTop).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "PersonModReqDto(num=" + this.getNum() + ", groupId=" + this.getGroupId() + ", keywords=" + this.getKeywords() + ", contentList=" + this.getContentList() + ", title=" + this.getTitle() + ", isTop=" + this.getIsTop() + ")";
    }
}

