/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.service;

import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.jsmsg.MiniProgramDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.material.service.MaterialManagerService;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReplyContentHandleService {
    private static final Logger log = LoggerFactory.getLogger(ReplyContentHandleService.class);
    @Autowired
    private MaterialManagerService materialManagerService;

    public void handleMsgMediaId(Long bizId, String corpId, List<UniformMsgDto> msgList) {
        for (UniformMsgDto msgDto : msgList) {
            String mediaId = null;
            switch (JsMsgType.get((String)msgDto.getMsgType())) {
                case FILE: 
                case VIDEO: 
                case IMAGE: {
                    mediaId = this.materialManagerService.getMediaId(bizId, corpId, msgDto.getFile().getFileUrl(), msgDto.getFile().getFileName(), msgDto.getMsgType());
                    msgDto.setMediaId(mediaId);
                    break;
                }
                case MINI_PROGRAM: {
                    MiniProgramDto miniprogram = msgDto.getMiniprogram();
                    if (!StringUtils.isNotEmpty((CharSequence)miniprogram.getImgUrl())) break;
                    mediaId = this.materialManagerService.getMediaId(bizId, corpId, miniprogram.getImgUrl(), JsMsgType.IMAGE.getValue());
                    msgDto.setMediaId(mediaId);
                    break;
                }
            }
        }
    }

    public List<UniformMsgDto> getMsgList(String params) {
        List<UniformMsgDto> result = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)params)) {
            return result;
        }
        try {
            result = JacksonUtil.str2List((String)params, UniformMsgDto.class);
        }
        catch (IOException e) {
            UniformMsgDto text = new UniformMsgDto();
            text.setMsgType(JsMsgType.TEXT.getValue());
            text.setContent(params);
            result.add(text);
            log.error("old quick reply content parse json error: ", (Throwable)e);
        }
        return result;
    }
}

