/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.service.impl;

import cn.kinyun.wework.sdk.entity.msg.Article;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmRemindService;
import com.kuaike.scrm.common.service.dto.RemindMsgDto;
import com.kuaike.scrm.common.service.dto.req.ScrmAddRemindReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmModRemindReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmRemindDetailReqDto;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.ModRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrmRemindServiceImpl
implements ScrmRemindService {
    private static final Logger log = LoggerFactory.getLogger(ScrmRemindServiceImpl.class);
    @Autowired
    private RemindService remindService;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    public void sendMsg(String corpId, List<String> weworkUserNums, String sendContent) {
        log.info("send remind msg corpId: {}, weworkUserNums: {}, sendContent: {}", new Object[]{corpId, weworkUserNums, sendContent});
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserNums) || StringUtils.isEmpty((CharSequence)sendContent)) {
            return;
        }
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        String target = Joiner.on((String)"|").join((Iterable)weworkUserIds);
        try {
            this.remindService.sendMsg(corpId, target, sendContent);
        }
        catch (Exception e) {
            log.error("send remind msg error: ", (Throwable)e);
        }
    }

    public void sendNewMsg(String corpId, List<String> weworkUserNums, List<RemindMsgDto> msgDtos) {
        log.info("send remind new msg corpId: {}, weworkUserNums: {}, sendContent: {}", new Object[]{corpId, weworkUserNums, msgDtos});
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserNums) || CollectionUtils.isEmpty(msgDtos)) {
            return;
        }
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        String target = Joiner.on((String)"|").join((Iterable)weworkUserIds);
        ArrayList articles = Lists.newArrayListWithCapacity((int)msgDtos.size());
        for (RemindMsgDto msgDto : msgDtos) {
            Article article = new Article();
            article.setUrl(msgDto.getUrl());
            article.setDescription(msgDto.getDescription());
            article.setPicUrl(msgDto.getPicUrl());
            article.setTitle(msgDto.getTitle());
            articles.add(article);
        }
        try {
            this.remindService.sendNewMsg(corpId, target, articles);
        }
        catch (Exception e) {
            log.error("send remind new msg error: ", (Throwable)e);
        }
    }

    public void sendMsg(String corpId, String target, String sendContent) {
        try {
            this.remindService.sendMsg(corpId, target, sendContent);
        }
        catch (Exception e) {
            log.error("sendMsg: corpId:{}, target:{}, error:{} ", new Object[]{corpId, target, e});
        }
    }

    public void addRemind(ScrmAddRemindReqDto reqDto) {
        try {
            AddRemindReqDto addRemindReqDto = new AddRemindReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)addRemindReqDto);
            ArrayList targetList = Lists.newArrayList();
            for (ScrmRemindDetailReqDto dto : reqDto.getRemindDetailReqDtos()) {
                RemindDetailReqDto targetDto = new RemindDetailReqDto();
                BeanUtils.copyProperties((Object)dto, (Object)targetDto);
                targetList.add(targetDto);
            }
            addRemindReqDto.setRemindDetailReqDtos(targetList);
            this.remindService.addRemind(addRemindReqDto);
        }
        catch (Exception e) {
            log.error("addRemind: reqDto:{}, error:{} ", (Object)reqDto, (Object)e);
        }
    }

    public void modRemind(ScrmModRemindReqDto reqDto) {
        try {
            ModRemindReqDto modRemindReqDto = new ModRemindReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)modRemindReqDto);
            ArrayList targetList = Lists.newArrayList();
            for (ScrmRemindDetailReqDto dto : reqDto.getRemindDetailReqDtos()) {
                RemindDetailReqDto targetDto = new RemindDetailReqDto();
                BeanUtils.copyProperties((Object)dto, (Object)targetDto);
                targetList.add(targetDto);
            }
            modRemindReqDto.setRemindDetailReqDtos(targetList);
            this.remindService.modRemind(modRemindReqDto);
        }
        catch (Exception e) {
            log.error("modRemind: reqDto:{}, error:{} ", (Object)reqDto, (Object)e);
        }
    }
}

