/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.service.impl;

import cn.kinyun.wework.sdk.api.AgentApi;
import cn.kinyun.wework.sdk.entity.agent.AgentMsgBase;
import cn.kinyun.wework.sdk.entity.agent.SendMsgResult;
import cn.kinyun.wework.sdk.entity.agent.msg.NewsMsg;
import cn.kinyun.wework.sdk.entity.agent.msg.TextMsg;
import cn.kinyun.wework.sdk.entity.msg.Article;
import cn.kinyun.wework.sdk.entity.msg.News;
import cn.kinyun.wework.sdk.entity.msg.Text;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.remind.entity.QyRemind;
import com.kuaike.scrm.dal.remind.entity.QyRemindDetail;
import com.kuaike.scrm.dal.remind.mapper.QyRemindDetailMapper;
import com.kuaike.scrm.dal.remind.mapper.QyRemindMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.DisableRemindReqDto;
import com.kuaike.scrm.remind.dto.req.ModRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.dto.req.RemindUserListReqDto;
import com.kuaike.scrm.remind.dto.resp.RemindUserRespDto;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RemindServiceImpl
implements RemindService {
    private static final Logger log = LoggerFactory.getLogger(RemindServiceImpl.class);
    @Autowired
    private QyRemindMapper remindMapper;
    @Autowired
    private QyRemindDetailMapper remindDetailMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private CustomizedTokenService tokenService;
    @Autowired
    private ParamEncryService paramEncryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRemind(AddRemindReqDto reqDto) {
        log.info("qyRemind addRemind get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{reqDto.getOperatorId(), reqDto.getBizId(), reqDto.getCorpId()});
        log.info("reqDto : {}", (Object)reqDto.toString());
        reqDto.validate();
        if (CollectionUtils.isEmpty(reqDto.getRemindDetailReqDtos())) {
            return;
        }
        QyRemind remind = new QyRemind();
        remind.setContent(reqDto.getContent());
        remind.setBizType(reqDto.getBizType());
        remind.setRemindType(reqDto.getRemindType());
        remind.setStatus(Integer.valueOf(1));
        remind.setFkId(reqDto.getFkId());
        remind.setFkCreateBy(reqDto.getFkCreateBy());
        remind.setBizId(reqDto.getBizId());
        remind.setCorpId(reqDto.getCorpId());
        remind.setCreateTime(new Date());
        remind.setCreateBy(reqDto.getOperatorId());
        remind.setMeetingType(reqDto.getMeetingType());
        this.remindMapper.insertSelective((Object)remind);
        if (reqDto.getRemindDetailReqDtos().size() > 0) {
            ArrayList details = Lists.newArrayList();
            for (RemindDetailReqDto detailReqDto : reqDto.getRemindDetailReqDtos()) {
                QyRemindDetail detail = new QyRemindDetail();
                detail.setRemindId(remind.getId());
                detail.setWeworkUserNum(detailReqDto.getWeworkUserNum());
                detail.setSendtime(detailReqDto.getSendTime());
                detail.setIsSend(Boolean.valueOf(false));
                detail.setBizId(reqDto.getBizId());
                detail.setCorpId(reqDto.getCorpId());
                detail.setCreateBy(reqDto.getOperatorId());
                detail.setCreateTime(new Date());
                detail.setExtraParam(detailReqDto.getExtraParam());
                detail.setExtraType(detailReqDto.getExtraType());
                detail.setBizType(reqDto.getBizType());
                detail.setFkId(reqDto.getFkId());
                detail.setMeetingType(reqDto.getMeetingType());
                details.add(detail);
            }
            this.remindDetailMapper.insertRemindDetails((List)details);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modRemind(ModRemindReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qyRemind modRemind get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        QyRemind remind = this.remindMapper.queryRemindByFKid(reqDto.getFkId(), reqDto.getBizType());
        if (Objects.nonNull(remind)) {
            this.remindMapper.delRemind(reqDto.getFkId(), reqDto.getBizType());
            this.remindDetailMapper.delRemindDetail(remind.getId(), userInfo.getBizId());
        }
        if (CollectionUtils.isEmpty(reqDto.getRemindDetailReqDtos())) {
            return;
        }
        AddRemindReqDto addRemindReqDto = new AddRemindReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)addRemindReqDto);
        addRemindReqDto.setOperatorId(userInfo.getId());
        addRemindReqDto.setBizId(userInfo.getBizId());
        addRemindReqDto.setCorpId(userInfo.getCorpId());
        this.addRemind(addRemindReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableRemind(DisableRemindReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qyRemind disableRemind get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        QyRemind remind = this.remindMapper.queryRemindByFKid(reqDto.getFkId(), reqDto.getBizType());
        if (Objects.nonNull(remind)) {
            this.remindMapper.disableRemind(reqDto.getFkId(), reqDto.getBizType());
            this.remindDetailMapper.delRemindDetail(remind.getId(), userInfo.getBizId());
        }
    }

    @Override
    public List<RemindUserRespDto> getRemindWeworkUserList(RemindUserListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qyRemind disableRemind get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validateParam();
        QyRemind remind = this.remindMapper.getRemind(reqDto.getMeetingId());
        if (Objects.isNull(remind)) {
            log.info("getRemindWeworkUserList remind is null");
            return null;
        }
        ArrayList respDtos = Lists.newArrayList();
        List details = this.remindDetailMapper.getRemindDetail(remind.getId(), userInfo.getBizId());
        if (remind.getRemindType() == 2) {
            Set<String> allWeworkusers = details.stream().map(QyRemindDetail::getWeworkUserNum).collect(Collectors.toSet());
            List hasSendWeworkUserDetails = details.stream().filter(QyRemindDetail::getIsSend).collect(Collectors.toList());
            Set hasSendWeworkUsers = hasSendWeworkUserDetails.stream().map(QyRemindDetail::getWeworkUserNum).collect(Collectors.toSet());
            allWeworkusers.forEach(weworkUserNum -> {
                RemindUserRespDto respDto = new RemindUserRespDto(reqDto.getMeetingId(), (String)weworkUserNum, hasSendWeworkUsers.contains(weworkUserNum) ? 1 : 0);
                respDtos.add(respDto);
            });
        } else {
            details.forEach(detail -> {
                RemindUserRespDto respDto = new RemindUserRespDto(reqDto.getMeetingId(), detail.getWeworkUserNum(), detail.getIsSend() != false ? 0 : 1);
                respDtos.add(respDto);
            });
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void qyRemind(String corpId) {
        log.info("qyRemind get corpId = #{}", (Object)corpId);
        List remindDetails = this.remindDetailMapper.getRemindListBySendTime(corpId);
        if (CollectionUtils.isEmpty((Collection)remindDetails)) {
            log.info("qyRemind remindDetails is null, not need send remind");
            return;
        }
        Set weworkUserNums = remindDetails.stream().map(QyRemindDetail::getWeworkUserNum).collect(Collectors.toSet());
        log.info("qyRemindDetail get detail weworkUserNums: {}", (Object)weworkUserNums.size());
        List weworkUsers = this.weworkUserMapper.getWeworkUserIdsByNum(corpId, weworkUserNums);
        Map<String, WeworkUser> weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, a -> a));
        Map<String, Long> weworkUserIdMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getId));
        log.info("qyRemindDetail weworkUserIdMap: {}", weworkUserIdMap);
        Set<String> extraParams = remindDetails.stream().map(QyRemindDetail::getExtraParam).collect(Collectors.toSet());
        Map<String, String> contactMap = null;
        Map<String, String> chatroomMap = null;
        if (extraParams.size() > 0) {
            ArrayList extraParamList = Lists.newArrayList();
            extraParams.forEach(a -> {
                if (StringUtils.isNotBlank((CharSequence)a)) {
                    if (a.contains(",")) {
                        String[] extras = a.split(",");
                        extraParamList.addAll(Arrays.asList(extras));
                    } else {
                        extraParamList.add(a);
                    }
                }
            });
            List contactList = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, (Collection)extraParamList);
            contactMap = contactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, WeworkContact::getName));
            log.info("qyRemindDetail contactMap: {}", contactMap);
            List chatRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, (Collection)extraParamList);
            chatroomMap = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, WeworkChatRoom::getName));
            log.info("qyRemindDetail chatroomMap: {}", chatroomMap);
        }
        Set remindIds = remindDetails.stream().map(QyRemindDetail::getRemindId).collect(Collectors.toSet());
        List reminds = this.remindMapper.getRemindByIds(remindIds, corpId);
        Map<Long, QyRemind> remindMap = reminds.stream().collect(Collectors.toMap(QyRemind::getId, a -> a));
        log.info("qyRemindDetail remindMap: {}", remindMap);
        Set createBys = reminds.stream().map(QyRemind::getFkCreateBy).collect(Collectors.toSet());
        Map<Long, Long> fk_createByMap = reminds.stream().collect(Collectors.toMap(QyRemind::getId, QyRemind::getFkCreateBy));
        QyRemindDetail qyDetail = (QyRemindDetail)remindDetails.get(0);
        Map userInfoMap = this.userMapper.selectUserIdAndNameByIds(qyDetail.getBizId(), corpId, createBys);
        log.info("qyRemindDetail userInfoMap: {}", (Object)userInfoMap);
        Set fkIds = reminds.stream().map(QyRemind::getFkId).collect(Collectors.toSet());
        List meetings = this.meetingMapper.getNumsByMeetingIds(fkIds, corpId);
        Map<Long, String> meetingNumMap = meetings.stream().collect(Collectors.toMap(Meeting::getId, Meeting::getNum));
        log.info("qyRemindDetail meetingNumMap: {}", meetingNumMap);
        ArrayList sendSuccessQyReminds = Lists.newArrayList();
        for (QyRemindDetail detail : remindDetails) {
            String contactName;
            String extraParam;
            log.info("qyRemindDetail id: {}", (Object)detail.getRemindId());
            QyRemind remind = remindMap.get(detail.getRemindId());
            if (Objects.isNull(remind)) {
                log.info("qyRemind remind is null");
                continue;
            }
            log.info("qyRemind id: {}, bizType: {}, status: {}", new Object[]{remind.getId(), remind.getBizType(), remind.getStatus()});
            if (remind.getStatus() > 1) continue;
            String sendContent = remind.getContent();
            if (weworkUserMap.size() == 0) {
                log.info("qyRemind weworkUserMap is null");
                continue;
            }
            WeworkUser weworkUser = weworkUserMap.get(detail.getWeworkUserNum());
            if (Objects.isNull(weworkUser)) {
                log.info("qyRemind get weworkUser is null ,check weworkUserNum : {}", (Object)detail.getWeworkUserNum());
                continue;
            }
            String memberNickName = weworkUser.getName();
            if (userInfoMap.size() > 0) {
                Long fk_createBy = fk_createByMap.get(remind.getId());
                String createName = (String)userInfoMap.get(fk_createBy);
                if (sendContent.contains("${creator}")) {
                    sendContent = sendContent.replace("${creator}", "[" + createName + "]");
                }
            } else {
                log.info("qyRemind userInfoMap is null");
            }
            if (sendContent.contains("${nickname}")) {
                sendContent = sendContent.replace("${nickname}", memberNickName);
            }
            if (remind.getBizType() == 1) {
                log.info("qyRemind MeetingType: {}, sendContent: {}", (Object)remind.getMeetingType(), (Object)sendContent);
                if (remind.getMeetingType() == 2 && sendContent.contains("##")) {
                    Long weworkUserId = weworkUserIdMap.get(detail.getWeworkUserNum());
                    String meetingNum = meetingNumMap.get(remind.getFkId());
                    log.info("qyRemind meetingNum: {}", (Object)meetingNum);
                    String[] spiltUrl = sendContent.split("##");
                    log.info("spiltUrl: {}", (Object)spiltUrl[1]);
                    MeetingParams meetingParams = new MeetingParams();
                    meetingParams.setMeetingId(remind.getFkId());
                    meetingParams.setWeworkUserNum(detail.getWeworkUserNum());
                    meetingParams.setMeetingType(MeetingType.INTERNAL_MEETING.getValue());
                    String encryNum = this.paramEncryService.encryMeetingParam(meetingParams);
                    String meetingUrl = spiltUrl[1].replace("${customstr}", encryNum);
                    log.info("qyRemind meetingUrl: {}", (Object)meetingUrl);
                    String url = "<a href=\"" + meetingUrl + "\">\u53c2\u52a0\u76f4\u64ad</a>";
                    log.info("qyRemind url: {}", (Object)url);
                    if (spiltUrl[0].contains("${meetingUrl}")) {
                        sendContent = spiltUrl[0].replace("${meetingUrl}", url);
                    }
                }
                if (remind.getMeetingType() == 1 && sendContent.contains("${remark}")) {
                    extraParam = detail.getExtraParam();
                    log.info("qyRemind extraParam: {}", (Object)extraParam);
                    if (StringUtils.isNotBlank((CharSequence)extraParam)) {
                        contactName = this.getContactName(contactMap, chatroomMap, extraParam, detail.getExtraType());
                        sendContent = sendContent.replace("${remark}", "[" + contactName + "]");
                    } else {
                        sendContent = sendContent.replace("${remark}", "[]");
                    }
                }
            }
            log.info("qyRemind sendContent: {}", (Object)sendContent);
            if (remind.getBizType() == 2 && sendContent.contains("${remark}")) {
                extraParam = detail.getExtraParam();
                log.info("qyRemind extraParam: {}", (Object)extraParam);
                if (StringUtils.isNotBlank((CharSequence)extraParam)) {
                    contactName = this.getContactName(contactMap, chatroomMap, extraParam, detail.getExtraType());
                    sendContent = sendContent.replace("${remark}", "[" + contactName + "]");
                } else {
                    sendContent = sendContent.replace("${remark}", "[]");
                }
            }
            log.info("qyRemind SendMsgContent: {}", (Object)sendContent);
            SendMsgResult result = this.sendMsg(corpId, weworkUser.getWeworkUserId(), sendContent);
            log.info("qyRemind SendMsgResult remindDetailId: {} errCode: {}, errMsg: {}", new Object[]{detail.getId(), result.getErrCode(), result.getErrMsg()});
            if (result.getErrCode() != 0 || !result.getErrMsg().equals("ok")) continue;
            sendSuccessQyReminds.add(detail);
        }
        if (sendSuccessQyReminds.size() > 0) {
            List sendRemindDetailIds = sendSuccessQyReminds.stream().map(QyRemindDetail::getId).collect(Collectors.toList());
            this.remindDetailMapper.updateIsSendById(sendRemindDetailIds, corpId);
            log.info("qyRemind sendSuccessQyRemindDetailIds : {}", sendRemindDetailIds);
        }
    }

    private String getContactName(Map<String, String> contactMap, Map<String, String> chatroomMap, String extraParam, int extraType) {
        log.info("qyRemind contactMap: {},  chatroomMap: {}, extraParam: {}", new Object[]{contactMap, chatroomMap, extraParam});
        ArrayList extraParamList = Lists.newArrayList();
        if (extraParam.contains(",")) {
            String[] extras = extraParam.split(",");
            extraParamList.addAll(Arrays.asList(extras));
        } else {
            extraParamList.add(extraParam);
        }
        ArrayList contactNames = Lists.newArrayList();
        if (extraType == 1 && Objects.nonNull(contactMap)) {
            for (String singalExtraParam : extraParamList) {
                contactNames.add(contactMap.get(singalExtraParam));
            }
        }
        if (extraType == 2 && Objects.nonNull(chatroomMap)) {
            for (String singalExtraParam : extraParamList) {
                contactNames.add(chatroomMap.get(singalExtraParam));
            }
        }
        String contactName = "";
        if (contactNames.size() > 0) {
            contactName = Joiner.on((String)",").join((Iterable)contactNames);
        }
        log.info("qyRemind contactName: {}", (Object)contactName);
        return contactName;
    }

    @Override
    public SendMsgResult sendMsg(String corpId, String target, String sendContent) {
        Integer agentID = this.tokenService.getAgentId(corpId);
        String accessToken = this.tokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new NullPointerException("accessToken is marked @NonNull but is null");
        }
        TextMsg textMsg = new TextMsg();
        textMsg.setMsgType("text");
        textMsg.setAgentId(agentID);
        textMsg.setToUser(target);
        Text text = new Text();
        text.setContent(sendContent);
        textMsg.setText(text);
        log.info("qyRemind sendText: {}", (Object)textMsg);
        SendMsgResult result = this.agentApi.sendMsg(accessToken, (AgentMsgBase)textMsg);
        return result;
    }

    @Override
    public SendMsgResult sendNewMsg(String corpId, String target, List<Article> articles) {
        Integer agentID = this.tokenService.getAgentId(corpId);
        String accessToken = this.tokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new NullPointerException("accessToken is marked @NonNull but is null");
        }
        NewsMsg newsMsg = new NewsMsg();
        newsMsg.setMsgType("news");
        newsMsg.setAgentId(agentID);
        newsMsg.setToUser(target);
        News news = new News();
        news.setArticles(articles);
        newsMsg.setNews(news);
        log.info("qyRemind sendNewMsg: {}", (Object)newsMsg.toString());
        SendMsgResult result = this.agentApi.sendMsg(accessToken, (AgentMsgBase)newsMsg);
        return result;
    }

    @Override
    public Article setArticleNews(String title, String description, String url, String picurl) {
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        article.setUrl(url);
        article.setPicUrl(picurl);
        return article;
    }
}

