/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.service.impl;

import com.github.pagehelper.Page;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.chat.check.dto.req.QualityCheckEsDto;
import com.kuaike.scrm.chat.check.service.QualityLogQueryEsService;
import com.kuaike.scrm.common.enums.QualitySenderType;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLogEs;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QualityLogQueryEsServiceImpl
implements QualityLogQueryEsService {
    private static final Logger log = LoggerFactory.getLogger(QualityLogQueryEsServiceImpl.class);
    @Value(value="${scrm.elasticsearch.qualityCheckLogIndex}")
    private String index;
    @Value(value="${scrm.elasticsearch.qualityCheckTriggerLogIndex}")
    private String triggerIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    private static final DateTimeZone TIME_ZONE = DateTimeZone.getDefault();

    private BoolQueryBuilder convertSourceBuilder(QualityCheckEsDto dto) {
        if (dto == null) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u4e0d\u5339\u914d\uff1adto is null");
            return null;
        }
        log.info("Query queryCheckLogList: dto:{}", (Object)dto);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((CharSequence)dto.getCorpId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"corpId.keyword", (String[])new String[]{dto.getCorpId()}));
        }
        if (Objects.nonNull(dto.getBizId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)dto.getSendStatus()));
        }
        RangeQueryBuilder createTime = QueryBuilders.rangeQuery((String)"createTime");
        if (Objects.nonNull(dto.getStartTime()) && Objects.isNull(createTime.from())) {
            createTime.gte((Object)dto.getStartTime().getTime());
        }
        if (Objects.nonNull(dto.getEndTime()) && Objects.isNull(createTime.to())) {
            createTime.lte((Object)dto.getEndTime().getTime());
        }
        if (Objects.nonNull(createTime.from()) || Objects.nonNull(createTime.to())) {
            queryBuilder.must((QueryBuilder)createTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getSendWeworkUserNum())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sendWeworkUserNum.keyword", (String[])new String[]{dto.getSendWeworkUserNum()}));
        }
        if (dto.getSenderType() != null) {
            QualitySenderType senderType = QualitySenderType.getByType((Integer)dto.getSenderType());
            if (senderType == QualitySenderType.WEWORK_CONTACT) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"senderType", (Object)QualitySenderType.WEWORK_CONTACT.getType()));
            } else {
                queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"senderType", (Object)QualitySenderType.WEWORK_CONTACT.getType()));
            }
        }
        if (Objects.nonNull(dto.getSendStatus())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isRevoke", (Object)dto.getSendStatus()));
        }
        if (Objects.nonNull(dto.getType())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)dto.getType()));
        }
        if (CollectionUtils.isNotEmpty(dto.getSendWeworkUserIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sendWeworkUserId.keyword", dto.getSendWeworkUserIds()));
        }
        if (CollectionUtils.isNotEmpty(dto.getReceiveTargetIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"receiveTargetId.keyword", dto.getReceiveTargetIds()));
        }
        if (CollectionUtils.isNotEmpty(dto.getTriggerBehaviors())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"triggerBehavior", dto.getTriggerBehaviors()));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getBatchNotifyNo())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"batchNotifyNo.keyword", (String[])new String[]{dto.getBatchNotifyNo()}));
        }
        if (CollectionUtils.isNotEmpty(dto.getMsgIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"msgId.keyword", dto.getMsgIds()));
        }
        return queryBuilder;
    }

    @Override
    public Page<QualityCheckLogEs> queryCheckLogList(QualityCheckEsDto dto) {
        SearchResponse search;
        if (dto == null) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u4e0d\u5339\u914d\uff1adto is null");
            return null;
        }
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        if (queryBuilder == null) {
            queryBuilder = QueryBuilders.boolQuery();
        }
        if (CollectionUtils.isNotEmpty(dto.getTriggerGroupIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"words.triggerGroupId", dto.getTriggerGroupIds()));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(10000);
        if (dto.getPageDto() != null) {
            searchSourceBuilder.size(dto.getPageDto().getPageSize().intValue());
            Integer originPageNum = dto.getPageDto().getPageNum();
            searchSourceBuilder.from((originPageNum - 1) * dto.getPageDto().getPageSize());
        }
        searchSourceBuilder.sort("createTime", SortOrder.DESC);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        log.info("Query queryCheckLogList search param :{}", (Object)searchRequest.source().toString());
        Page pageResult = new Page(searchSourceBuilder.from(), searchSourceBuilder.size());
        try {
            search = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("query result error:", (Throwable)e);
            return pageResult;
        }
        if (search == null) {
            log.info("query result search is null");
            return pageResult;
        }
        SearchHits hits = search.getHits();
        long totalHits = hits.getTotalHits();
        SearchHit[] hitsHits = hits.getHits();
        List checkLogEs = Stream.of(hitsHits).map(item -> {
            String sourceAsString = item.getSourceAsString();
            try {
                return (QualityCheckLogEs)JacksonUtil.str2Obj((String)sourceAsString, QualityCheckLogEs.class);
            }
            catch (IOException e) {
                log.error("query result error:", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
        pageResult.setTotal(totalHits);
        pageResult.addAll(checkLogEs);
        return pageResult;
    }

    @Override
    public Map<Integer, Integer> queryBehaviorCount(QualityCheckEsDto dto) {
        SearchResponse searchResponse;
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_behavior").field("triggerBehavior")).size(10000));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        log.info("Query queryBehaviorCount search param :{}", (Object)searchRequest.source().toString());
        HashMap behaviorMap = Maps.newHashMap();
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("queryBehaviorCount: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
            return behaviorMap;
        }
        try {
            Terms nameAgg = (Terms)searchResponse.getAggregations().get("group_by_behavior");
            for (Terms.Bucket bucket : nameAgg.getBuckets()) {
                int triggerBehavior = bucket.getKeyAsNumber().intValue();
                int countValue = (int)bucket.getDocCount();
                log.info("queryBehaviorCount get triggerBehavior: {}, countValue: {}", (Object)triggerBehavior, (Object)countValue);
                behaviorMap.put(triggerBehavior, countValue);
            }
        }
        catch (Exception e) {
            log.error("queryBehaviorCount: \u89e3\u6790\u5f02\u5e38, e = ", (Throwable)e);
        }
        return behaviorMap;
    }

    @Override
    public Map<Long, Integer> queryBehaviorWordCount(QualityCheckEsDto dto) {
        SearchResponse searchResponse;
        if (dto == null) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u4e0d\u5339\u914d\uff1adto is null");
            return null;
        }
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        if (queryBuilder == null) {
            queryBuilder = QueryBuilders.boolQuery();
        }
        if (CollectionUtils.isNotEmpty(dto.getTriggerGroupIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"triggerGroupId", dto.getTriggerGroupIds()));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_triggerGroupId").field("triggerGroupId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"distinct_msg_id").field("msgId.keyword")));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.triggerIndex});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        log.info("Query queryBehaviorWordCount search param :{}", (Object)searchRequest.source().toString());
        HashMap behaviorGroupMap = Maps.newHashMap();
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("queryBehaviorWordCount: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
            return behaviorGroupMap;
        }
        try {
            Terms nameAgg = (Terms)searchResponse.getAggregations().get("group_by_triggerGroupId");
            for (Terms.Bucket bucket : nameAgg.getBuckets()) {
                long triggerBehavior = bucket.getKeyAsNumber().longValue();
                Cardinality distinctMsgIdCardinality = (Cardinality)bucket.getAggregations().get("distinct_msg_id");
                int distinctValue = (int)distinctMsgIdCardinality.getValue();
                log.info("queryBehaviorWordCount get triggerBehavior: {}, distinctValue: {}", (Object)triggerBehavior, (Object)distinctValue);
                behaviorGroupMap.put(triggerBehavior, distinctValue);
            }
        }
        catch (Exception e) {
            log.error("queryBehaviorCount: \u89e3\u6790\u5f02\u5e38, e = ", (Throwable)e);
        }
        return behaviorGroupMap;
    }

    @Override
    public Map<Date, Map<Long, Integer>> queryBehaviorWordCountByDate(QualityCheckEsDto dto) {
        SearchResponse searchResponse;
        if (dto == null) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u4e0d\u5339\u914d\uff1adto is null");
            return null;
        }
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        if (queryBuilder == null) {
            queryBuilder = QueryBuilders.boolQuery();
        }
        if (CollectionUtils.isNotEmpty(dto.getTriggerGroupIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"triggerGroupId", dto.getTriggerGroupIds()));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"group_by_create_time").field("createTime")).dateHistogramInterval(DateHistogramInterval.DAY).timeZone(TIME_ZONE)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_triggerGroupId").field("triggerGroupId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"distinct_msg_id").field("msgId.keyword"))));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.triggerIndex});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.scroll(TimeValue.timeValueMinutes((long)1L));
        log.info("Query queryBehaviorWordCountByDate search param :{}", (Object)searchRequest.source().toString());
        HashMap behaviorDateGroupMap = Maps.newHashMap();
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("queryBehaviorWordCountByDate: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
            return behaviorDateGroupMap;
        }
        try {
            ParsedDateHistogram dateHistogram = (ParsedDateHistogram)searchResponse.getAggregations().get("group_by_create_time");
            for (Histogram.Bucket bucket : dateHistogram.getBuckets()) {
                DateTime date = (DateTime)bucket.getKey();
                Date createTime = date.toDate();
                HashMap groupIdMap = Maps.newHashMap();
                Terms behaviorAgg = (Terms)bucket.getAggregations().get("group_by_triggerGroupId");
                for (Terms.Bucket innerBucket : behaviorAgg.getBuckets()) {
                    long triggerBehaviorGroupId = innerBucket.getKeyAsNumber().longValue();
                    Cardinality distinctMsgIdCardinality = (Cardinality)innerBucket.getAggregations().get("distinct_msg_id");
                    int distinctValue = (int)distinctMsgIdCardinality.getValue();
                    log.info("queryBehaviorWordCountByDate get triggerBehaviorGroupId: {}, distinctValue: {}", (Object)triggerBehaviorGroupId, (Object)distinctValue);
                    groupIdMap.put(triggerBehaviorGroupId, distinctValue);
                }
                behaviorDateGroupMap.put(createTime, groupIdMap);
            }
        }
        catch (Exception e) {
            log.error("queryBehaviorWordCountByDate: \u89e3\u6790\u5f02\u5e38, e = ", (Throwable)e);
        }
        return behaviorDateGroupMap;
    }

    @Override
    public Map<Date, Map<Integer, Integer>> queryBehaviorCountByDate(QualityCheckEsDto dto) {
        SearchResponse searchResponse;
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"group_by_create_time").field("createTime")).dateHistogramInterval(DateHistogramInterval.DAY).timeZone(TIME_ZONE)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_behavior").field("triggerBehavior")).size(10000)));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.scroll(TimeValue.timeValueMinutes((long)1L));
        log.info("Query queryBehaviorCountByDate search param :{}", (Object)searchRequest.source().toString());
        HashMap behaviorDateGroupMap = Maps.newHashMap();
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("queryBehaviorCountByDate: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
            return behaviorDateGroupMap;
        }
        try {
            ParsedDateHistogram dateHistogram = (ParsedDateHistogram)searchResponse.getAggregations().get("group_by_create_time");
            for (Histogram.Bucket bucket : dateHistogram.getBuckets()) {
                DateTime date = (DateTime)bucket.getKey();
                Date createTime = date.toDate();
                HashMap groupIdMap = Maps.newHashMap();
                Terms behaviorAgg = (Terms)bucket.getAggregations().get("group_by_behavior");
                for (Terms.Bucket innerBucket : behaviorAgg.getBuckets()) {
                    int triggerBehavior = innerBucket.getKeyAsNumber().intValue();
                    int countValue = (int)innerBucket.getDocCount();
                    groupIdMap.put(triggerBehavior, countValue);
                }
                behaviorDateGroupMap.put(createTime, groupIdMap);
            }
        }
        catch (Exception e) {
            log.error("queryBehaviorCountByDate: \u89e3\u6790\u5f02\u5e38, e = ", (Throwable)e);
        }
        return behaviorDateGroupMap;
    }

    @Override
    public List<QualityCheckLogEs> queryQualityCheckLogEsList(QualityCheckEsDto dto) {
        BoolQueryBuilder queryBuilder = this.convertSourceBuilder(dto);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        log.info("Query queryQualityCheckLogEsList search param :{}", (Object)searchRequest.source().toString());
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("countLogTimeoutUnReplyMap: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
        }
        if (searchResponse == null) {
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] hitsHits = hits.getHits();
        List<QualityCheckLogEs> checkLogEs = Stream.of(hitsHits).map(item -> {
            String sourceAsString = item.getSourceAsString();
            try {
                return (QualityCheckLogEs)JacksonUtil.str2Obj((String)sourceAsString, QualityCheckLogEs.class);
            }
            catch (IOException e) {
                log.error("queryQualityCheckLogEsList error", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
        return checkLogEs;
    }
}

