/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.dto.req;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.dto.req.MonitorCycle;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class QualityUnreplyBaseDto {
    private Integer senderType;
    private Integer timeout;
    private List<MonitorCycle> cycles;

    public void validate() {
        if (this.timeout == null) {
            this.timeout = 30;
        }
        if (CollectionUtils.isNotEmpty(this.cycles)) {
            HashSet weekdays = Sets.newHashSet();
            int weekCount = 0;
            for (MonitorCycle monitorCycle : this.cycles) {
                monitorCycle.validate();
                weekdays.addAll(monitorCycle.getWeekday());
                weekCount += monitorCycle.getWeekday().size();
            }
            if (weekCount > weekdays.size()) {
                Preconditions.checkArgument((boolean)false, (Object)"\u5de5\u4f5c\u5468\u671f\u4e0d\u80fd\u91cd\u590d");
            }
        }
    }

    public Integer getSenderType() {
        return this.senderType;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public List<MonitorCycle> getCycles() {
        return this.cycles;
    }

    public void setSenderType(Integer senderType) {
        this.senderType = senderType;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setCycles(List<MonitorCycle> cycles) {
        this.cycles = cycles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualityUnreplyBaseDto)) {
            return false;
        }
        QualityUnreplyBaseDto other = (QualityUnreplyBaseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$senderType = this.getSenderType();
        Integer other$senderType = other.getSenderType();
        if (this$senderType == null ? other$senderType != null : !((Object)this$senderType).equals(other$senderType)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        List<MonitorCycle> this$cycles = this.getCycles();
        List<MonitorCycle> other$cycles = other.getCycles();
        return !(this$cycles == null ? other$cycles != null : !((Object)this$cycles).equals(other$cycles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QualityUnreplyBaseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $senderType = this.getSenderType();
        result = result * 59 + ($senderType == null ? 43 : ((Object)$senderType).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        List<MonitorCycle> $cycles = this.getCycles();
        result = result * 59 + ($cycles == null ? 43 : ((Object)$cycles).hashCode());
        return result;
    }

    public String toString() {
        return "QualityUnreplyBaseDto(senderType=" + this.getSenderType() + ", timeout=" + this.getTimeout() + ", cycles=" + this.getCycles() + ")";
    }
}

