/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.chat.check.dto.req.GetUnreplyConfReqDto;
import com.kuaike.scrm.chat.check.dto.req.MonitorCycle;
import com.kuaike.scrm.chat.check.dto.req.QualityBehaviorListReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityBehaviorSettingReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityUnreplyBaseDto;
import com.kuaike.scrm.chat.check.dto.resp.QualityBehaviorRespDto;
import com.kuaike.scrm.chat.check.service.QualityBehaviorService;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.PublishPayloadDto;
import com.kuaike.scrm.common.enums.PublishPayloadType;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualitySenderType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorUnreplyCycle;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorUnreplySetting;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorUnreplyCycleMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorUnreplySettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QualityBehaviorServiceImpl
implements QualityBehaviorService {
    private static final Logger log = LoggerFactory.getLogger(QualityBehaviorServiceImpl.class);
    @Resource
    private QualityCheckBehaviorSettingMapper qualityCheckBehaviorSettingMapper;
    @Resource
    private QualityCheckBehaviorUnreplyCycleMapper qualityCheckBehaviorUnreplyCycleMapper;
    @Resource
    private QualityCheckBehaviorUnreplySettingMapper qualityCheckBehaviorUnreplySettingMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ApplicationContext context;

    @Override
    public void modBehaviorSetting(QualityBehaviorSettingReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("modBehaviorSetting get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        this.qualityCheckBehaviorSettingMapper.updateBehaviorSetting(reqDto.getId(), reqDto.getCheckStatus(), userInfo.getCorpId(), userInfo.getId());
        this.readNewBehavior(userInfo.getBizId(), userInfo.getCorpId());
    }

    @Override
    public List<QualityBehaviorRespDto> qualityBehaviorList(QualityBehaviorListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qualityBehaviorList get userID = #{}, and bizId = #{}, and corpId = #{}, reqDto = {}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId(), reqDto});
        Preconditions.checkArgument((reqDto.getSenderType() != null ? 1 : 0) != 0, (Object)"senderType is null");
        List settingList = this.qualityCheckBehaviorSettingMapper.queryBehaviorListBySenderType(userInfo.getBizId(), reqDto.getSenderType());
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            log.info("qualityBehaviorList get setting is null");
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (QualityCheckBehaviorSetting setting : settingList) {
            QualityBehaviorRespDto respDto = new QualityBehaviorRespDto();
            respDto.setId(setting.getNum());
            respDto.setCheckDesc(setting.getCheckDesc());
            respDto.setCheckStatus(setting.getCheckStatus());
            respDto.setCheckValue(setting.getCheckValue());
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public void addBehaviorSetting(Long bizId, String corpId) {
        List settings = this.qualityCheckBehaviorSettingMapper.queryBehaviorlist(corpId);
        if (CollectionUtils.isEmpty((Collection)settings)) {
            Integer[] behaviorSettings;
            for (Integer setting : behaviorSettings = new Integer[]{1, 2, 3, 4}) {
                QualityCheckBehaviorSetting behaviorSetting = new QualityCheckBehaviorSetting();
                behaviorSetting.setBizId(bizId);
                behaviorSetting.setCorpId(corpId);
                behaviorSetting.setCheckDesc(QualityBehaviorType.getByType((int)setting).getDesc());
                behaviorSetting.setCheckValue(setting);
                behaviorSetting.setCheckStatus(Integer.valueOf(0));
                behaviorSetting.setSenderType(QualitySenderType.WEWORK_USER.getType());
                behaviorSetting.setCreateTime(new Date());
                behaviorSetting.setCreateBy(bizId);
                behaviorSetting.setNum(this.idGen.getNum());
                this.qualityCheckBehaviorSettingMapper.insertSelective((Object)behaviorSetting);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTimeOutUnreplySetting(QualityUnreplyBaseDto reqDto) {
        log.info("addTimeOutUnreplySetting: {}", (Object)reqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((reqDto.getSenderType() != null ? 1 : 0) != 0, (Object)"senderType is null");
        reqDto.validate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Integer senderType = reqDto.getSenderType();
        QualityCheckBehaviorUnreplySetting unreplySetting = this.qualityCheckBehaviorUnreplySettingMapper.queryUnreplySetting(corpId, bizId, senderType);
        if (unreplySetting == null) {
            unreplySetting = this.insertUnreplySetting(reqDto.getTimeout(), senderType);
            if (CollectionUtils.isNotEmpty(reqDto.getCycles())) {
                this.saveUnreplyCycleSetting(unreplySetting.getNum(), reqDto.getCycles());
            }
        } else {
            String unreplyNum = unreplySetting.getNum();
            this.qualityCheckBehaviorUnreplyCycleMapper.delUnreplyCycle(unreplyNum, userInfo.getCorpId());
            this.qualityCheckBehaviorUnreplySettingMapper.updateUnreplySetting(corpId, unreplySetting.getNum(), reqDto.getTimeout(), userInfo.getId());
            this.saveUnreplyCycleSetting(unreplyNum, reqDto.getCycles());
        }
    }

    @Override
    @Transactional
    public QualityUnreplyBaseDto getTimeoutUnreplySetting(GetUnreplyConfReqDto params) {
        Preconditions.checkArgument((params.getSenderType() != null ? 1 : 0) != 0, (Object)"senderType is null");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Integer senderType = params.getSenderType();
        QualityCheckBehaviorUnreplySetting unreplySetting = this.qualityCheckBehaviorUnreplySettingMapper.queryUnreplySetting(corpId, bizId, senderType);
        if (unreplySetting == null) {
            unreplySetting = this.insertUnreplySetting(30, senderType);
        }
        List exists = this.qualityCheckBehaviorUnreplyCycleMapper.queryUnreplyCycle(unreplySetting.getNum(), userInfo.getCorpId());
        HashMap mapCycle = Maps.newHashMap();
        for (QualityCheckBehaviorUnreplyCycle cycle : exists) {
            String key = DateUtil.dateToDateString((Date)cycle.getStartTime(), (String)"HH:mm") + "-" + DateUtil.dateToDateString((Date)cycle.getEndTime(), (String)"HH:mm");
            if (mapCycle.containsKey(key)) {
                ((List)mapCycle.get(key)).add(cycle.getWeekday());
                continue;
            }
            ArrayList list = Lists.newArrayList((Object[])new Integer[]{cycle.getWeekday()});
            mapCycle.put(key, list);
        }
        QualityUnreplyBaseDto result = new QualityUnreplyBaseDto();
        result.setTimeout(unreplySetting.getTimeout());
        result.setCycles(Lists.newArrayList());
        for (Map.Entry entry : mapCycle.entrySet()) {
            String key = (String)entry.getKey();
            String startTime = key.split("-")[0];
            String endTime = key.split("-")[1];
            MonitorCycle monitorCycle = new MonitorCycle();
            monitorCycle.setEndTime(endTime);
            monitorCycle.setStartTime(startTime);
            monitorCycle.setWeekday((List)entry.getValue());
            result.getCycles().add(monitorCycle);
        }
        return result;
    }

    private QualityCheckBehaviorUnreplySetting insertUnreplySetting(Integer timeout, Integer senderType) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        QualityCheckBehaviorUnreplySetting unreplySetting = new QualityCheckBehaviorUnreplySetting();
        unreplySetting.setNum(this.idGen.getNum());
        unreplySetting.setBizId(userInfo.getBizId());
        unreplySetting.setCorpId(userInfo.getCorpId());
        unreplySetting.setCreateTime(new Date());
        unreplySetting.setCreateBy(userInfo.getId());
        unreplySetting.setUpdateTime(new Date());
        unreplySetting.setTimeout(timeout);
        unreplySetting.setSenderType(senderType);
        this.qualityCheckBehaviorUnreplySettingMapper.insert((Object)unreplySetting);
        return unreplySetting;
    }

    private void saveUnreplyCycleSetting(String unreplyNum, List<MonitorCycle> cycles) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        for (MonitorCycle monitorCycle : cycles) {
            List<Integer> weekdays = monitorCycle.getWeekday();
            for (Integer weekday : weekdays) {
                QualityCheckBehaviorUnreplyCycle cycle = new QualityCheckBehaviorUnreplyCycle();
                cycle.setBizId(userInfo.getBizId());
                cycle.setCorpId(userInfo.getCorpId());
                cycle.setCreateBy(userInfo.getId());
                cycle.setCreateTime(new Date());
                cycle.setUpdateTime(new Date());
                cycle.setIsDeleted(Integer.valueOf(0));
                cycle.setUnreplyNum(unreplyNum);
                cycle.setWeekday(weekday);
                cycle.setStartTime(DateUtil.getDate((String)monitorCycle.getStartTime(), (String)"HH:mm"));
                cycle.setEndTime(DateUtil.getDate((String)monitorCycle.getEndTime(), (String)"HH:mm"));
                this.qualityCheckBehaviorUnreplyCycleMapper.insert((Object)cycle);
            }
        }
    }

    private void readNewBehavior(Long bizId, String corpId) {
        CorpSensitiveWordBehaviorDto dto = new CorpSensitiveWordBehaviorDto();
        dto.setBizId(bizId);
        dto.setCorpId(corpId);
        this.publishReloadQualityBehaviorEvent(dto);
    }

    private void publishReloadQualityBehaviorEvent(CorpSensitiveWordBehaviorDto dto) {
        PublishPayloadDto publishPayloadDto = new PublishPayloadDto();
        publishPayloadDto.setType(PublishPayloadType.QUALITY_CHECK_BEHAVIOR_CHANGE);
        publishPayloadDto.setContent(JSON.toJSONString((Object)dto));
        this.context.publishEvent((Object)publishPayloadDto);
    }
}

