/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.dto.req.QualityAddAndModReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityCheckListReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityCheckReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityDelReqDto;
import com.kuaike.scrm.chat.check.dto.resp.QuaityCheckDateRespDto;
import com.kuaike.scrm.chat.check.dto.resp.QualityCheckNodeDetail;
import com.kuaike.scrm.chat.check.dto.resp.QualityCheckRespDto;
import com.kuaike.scrm.chat.check.dto.resp.QualityCheckWordDetail;
import com.kuaike.scrm.chat.check.dto.resp.QualityCheckWordRespDto;
import com.kuaike.scrm.chat.check.service.QualityWordCheckService;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.PublishPayloadDto;
import com.kuaike.scrm.common.enums.ConversationTypeEnum;
import com.kuaike.scrm.common.enums.PublishPayloadType;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckLog;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckWordGroup;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckWordGroupNode;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckWords;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckLogMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckWordGroupNodeMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckWordsMapper;
import com.kuaike.scrm.dal.system.dto.OrgQueryParams;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QualityWordCheckServiceImpl
implements QualityWordCheckService {
    private static final Logger log = LoggerFactory.getLogger(QualityWordCheckServiceImpl.class);
    @Autowired
    private QualityCheckWordGroupMapper wordGroupMapper;
    @Autowired
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;
    @Autowired
    private QualityCheckWordGroupNodeMapper groupNodeMapper;
    @Autowired
    private QualityCheckWordsMapper wordsMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private QualityCheckLogMapper logMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private OrgService orgService;
    private static final String QUALITY_HEADER_TITLE = "\u654f\u611f\u8bcd\u5206\u6790\u8868";
    private static final String[] QUALITY_HEADERS = new String[]{"\u53d1\u9001\u6210\u5458", "\u53d1\u9001\u5bf9\u8c61", "\u5bf9\u8c61\u7c7b\u578b", "\u654f\u611f\u8bcd", "\u53d1\u9001\u5185\u5bb9", "\u53d1\u9001\u72b6\u6001", "\u53d1\u9001\u65f6\u95f4"};
    private static final String QUALITY_BEHAVIOR_HEADER_TITLE = "\u654f\u611f\u884c\u4e3a\u5206\u6790\u8868";
    private static final String[] QUALITY_BEHAVIOR_HEADERS = new String[]{"\u64cd\u4f5c\u6210\u5458", "\u53d1\u64cd\u4f5c\u5bf9\u8c61", "\u5bf9\u8c61\u7c7b\u578b", "\u654f\u611f\u884c\u4e3a", "\u53d1\u9001\u65f6\u95f4"};

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void qualityAddAndMod(QualityAddAndModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qualityAddAndMod get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getId())) {
            this.qualityMod(reqDto, userInfo);
        } else {
            this.qualityAdd(reqDto, userInfo);
        }
        this.readNewWordAndNode(userInfo.getCorpId());
    }

    private void readNewWordAndNode(String corpId) {
        List groups = this.wordGroupMapper.queryByCorpId(corpId);
        List nodes = this.groupNodeMapper.queryByCorpId(corpId);
        List words = this.wordsMapper.queryByCorpId(corpId);
        CorpSensitiveWordBehaviorDto dto = new CorpSensitiveWordBehaviorDto();
        Map<Long, String> groupId2Name = groups.stream().collect(Collectors.toMap(a -> a.getId(), a -> a.getGroupName()));
        Map groupId2NodeIds = nodes.stream().collect(Collectors.groupingBy(QualityCheckWordGroupNode::getGroupId, Collectors.mapping(a -> a.getNodeId().intValue(), Collectors.toSet())));
        Map groupId2Words = words.stream().collect(Collectors.groupingBy(QualityCheckWords::getGroupId, Collectors.mapping(QualityCheckWords::getWord, Collectors.toSet())));
        groupId2Name.forEach((groupId, groupName) -> {
            Set groupWords = groupId2Words.getOrDefault(groupId, Sets.newHashSet());
            groupWords.add(groupName);
            groupId2Words.put((Long)groupId, groupWords);
        });
        dto.setCorpId(corpId);
        dto.setGroupId2Words(groupId2Words);
        dto.setGroupId2NodeIds(groupId2NodeIds);
        this.publishReloadQualityWordEvent(dto);
    }

    private void publishReloadQualityWordEvent(CorpSensitiveWordBehaviorDto dto) {
        PublishPayloadDto publishPayloadDto = new PublishPayloadDto();
        publishPayloadDto.setType(PublishPayloadType.QUALITY_CHECK_WORD_CHANGE);
        publishPayloadDto.setContent(JSON.toJSONString((Object)dto));
        this.context.publishEvent((Object)publishPayloadDto);
    }

    private void qualityMod(QualityAddAndModReqDto reqDto, CurrentUserInfo userInfo) {
        List newGroupNodes;
        log.info("qualityMod reqDto: {}", (Object)reqDto);
        QualityCheckWordGroup wordGroup = this.wordGroupMapper.getWordGroup(reqDto.getId(), userInfo.getCorpId());
        if (Objects.isNull(wordGroup)) {
            log.info("qualityMod get wordGroup is null");
            return;
        }
        if (!wordGroup.getGroupName().equals(reqDto.getSensitiveWord().trim())) {
            Set userIds = this.userRoleCommonService.getManageUserIds();
            log.info("qualityMod userIds: {}", (Object)userIds);
            List groupNames = this.wordGroupMapper.queryAllGroupNames((Collection)userIds, userInfo.getCorpId());
            if (CollectionUtils.isNotEmpty((Collection)groupNames)) {
                Preconditions.checkArgument((!groupNames.contains(reqDto.getSensitiveWord()) ? 1 : 0) != 0, (Object)"\u654f\u611f\u8bcd\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
            }
        }
        List groupNodes = this.groupNodeMapper.getGroupNodeList(wordGroup.getId(), userInfo.getCorpId());
        List groupNodeIds = groupNodes.stream().map(QualityCheckWordGroupNode::getNodeId).collect(Collectors.toList());
        log.info("qualityMod getNodeIds : {}", groupNodeIds);
        Collection<Object> delNodeIds = Collections.emptyList();
        Collection<Object> addNodeIds = Collections.emptyList();
        if (reqDto.getVisibleType() == 1) {
            delNodeIds = groupNodeIds;
        } else if (CollectionUtils.isNotEmpty(reqDto.getNodeIds())) {
            delNodeIds = CollectionUtils.removeAll(groupNodeIds, reqDto.getNodeIds());
        }
        log.info("qualityMod delNodeIds : {}", delNodeIds);
        if (CollectionUtils.isNotEmpty(reqDto.getNodeIds())) {
            addNodeIds = CollectionUtils.removeAll(reqDto.getNodeIds(), groupNodeIds);
            log.info("qualityMod addNodeIds : {}", addNodeIds);
        }
        if (CollectionUtils.isNotEmpty(delNodeIds)) {
            ArrayList delIds = Lists.newArrayList();
            for (QualityCheckWordGroupNode qualityCheckWordGroupNode : groupNodes) {
                if (!delNodeIds.contains(qualityCheckWordGroupNode.getNodeId())) continue;
                delIds.add(qualityCheckWordGroupNode.getId());
            }
            log.info("qualityMod del groupNode Ids : {}", (Object)delIds);
            this.groupNodeMapper.delGroupNode((Collection)delIds, userInfo.getCorpId(), userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty(addNodeIds)) {
            ArrayList addGroupNodes = Lists.newArrayList();
            for (Long l : addNodeIds) {
                QualityCheckWordGroupNode groupNode = this.setWordGroupNode(wordGroup.getId(), l, userInfo);
                addGroupNodes.add(groupNode);
            }
            log.info("qualityMod addGroupNodes : {}", (Object)addGroupNodes);
            this.groupNodeMapper.addGroupNodeList((List)addGroupNodes);
        }
        if (CollectionUtils.isEmpty((Collection)(newGroupNodes = this.groupNodeMapper.getGroupNodeList(wordGroup.getId(), userInfo.getCorpId())))) {
            Integer rootDepartment = this.organizationMapper.queryRootDepartment(userInfo.getCorpId());
            log.info("qualityMod get root department: {}", (Object)rootDepartment);
            QualityCheckWordGroupNode qualityCheckWordGroupNode = this.setWordGroupNode(wordGroup.getId(), rootDepartment.longValue(), userInfo);
            this.groupNodeMapper.insertSelective((Object)qualityCheckWordGroupNode);
        }
        List checkWords = this.wordsMapper.getCheckWordList(wordGroup.getId(), userInfo.getCorpId());
        List list = checkWords.stream().map(QualityCheckWords::getWord).collect(Collectors.toList());
        log.info("qualityMod getWordDescs : {}", list);
        Collection<Object> delWordStrs = Collections.emptyList();
        Collection<Object> addWordStrs = Collections.emptyList();
        if (CollectionUtils.isEmpty(reqDto.getKeyWords())) {
            delWordStrs = list;
        } else {
            delWordStrs = CollectionUtils.removeAll(list, reqDto.getKeyWords());
            addWordStrs = CollectionUtils.removeAll(reqDto.getKeyWords(), list);
        }
        log.info("qualityMod delWordStrs : {}", delWordStrs);
        log.info("qualityMod addWordStrs : {}", addWordStrs);
        if (CollectionUtils.isNotEmpty(delWordStrs)) {
            ArrayList delIds = Lists.newArrayList();
            for (QualityCheckWords qualityCheckWords : checkWords) {
                if (!delWordStrs.contains(qualityCheckWords.getWord())) continue;
                delIds.add(qualityCheckWords.getId());
            }
            log.info("qualityMod del checkWords Ids : {}", (Object)delIds);
            this.wordsMapper.delCheckWordList((List)delIds, userInfo.getCorpId(), userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty(addWordStrs)) {
            ArrayList addCheckWords = Lists.newArrayList();
            for (String string : addWordStrs) {
                QualityCheckWords words = this.setCheckWords(wordGroup.getId(), string.trim(), userInfo);
                addCheckWords.add(words);
            }
            log.info("qualityMod addCheckWords : {}", (Object)addCheckWords);
            this.wordsMapper.addCheckWordsList((List)addCheckWords);
        }
        log.info("qualityMod update wordGroupName : {}", (Object)reqDto.getSensitiveWord());
        this.wordGroupMapper.updateWordGroup(reqDto.getId(), reqDto.getSensitiveWord().trim(), userInfo.getCorpId(), userInfo.getId(), reqDto.getVisibleType());
    }

    private void qualityAdd(QualityAddAndModReqDto reqDto, CurrentUserInfo userInfo) {
        log.info("qualityAdd reqDto: {}", (Object)reqDto);
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("qualityAdd userIds: {}", (Object)userIds);
        List groupNames = this.wordGroupMapper.queryAllGroupNames((Collection)userIds, userInfo.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)groupNames)) {
            Preconditions.checkArgument((!groupNames.contains(reqDto.getSensitiveWord()) ? 1 : 0) != 0, (Object)"\u654f\u611f\u8bcd\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        QualityCheckWordGroup wordGroup = this.setCheckWordGroup(reqDto.getSensitiveWord().trim(), userInfo, reqDto.getVisibleType());
        this.wordGroupMapper.insertSelective((Object)wordGroup);
        ArrayList checkWords = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(reqDto.getKeyWords())) {
            for (String key : reqDto.getKeyWords()) {
                QualityCheckWords words = this.setCheckWords(wordGroup.getId(), key.trim(), userInfo);
                checkWords.add(words);
            }
            this.wordsMapper.addCheckWordsList((List)checkWords);
        }
        if (reqDto.getVisibleType() == 1) {
            Integer rootDepartment = this.organizationMapper.queryRootDepartment(userInfo.getCorpId());
            log.info("qualityAdd get root department: {}", (Object)rootDepartment);
            QualityCheckWordGroupNode groupNode = this.setWordGroupNode(wordGroup.getId(), rootDepartment.longValue(), userInfo);
            this.groupNodeMapper.insertSelective((Object)groupNode);
        } else {
            ArrayList groupNodes = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(reqDto.getNodeIds())) {
                for (Long nodeId : reqDto.getNodeIds()) {
                    QualityCheckWordGroupNode groupNode = this.setWordGroupNode(wordGroup.getId(), nodeId, userInfo);
                    groupNodes.add(groupNode);
                }
                this.groupNodeMapper.addGroupNodeList((List)groupNodes);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void qualityDel(QualityDelReqDto reqDto) {
        List checkWords;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qualityDel get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getId()), (Object)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        QualityCheckWordGroup wordGroup = this.wordGroupMapper.getWordGroup(reqDto.getId(), userInfo.getCorpId());
        if (Objects.isNull(wordGroup)) {
            log.info("qualityDel get wordGroup is null");
            return;
        }
        List groupNodes = this.groupNodeMapper.getGroupNodeList(wordGroup.getId(), userInfo.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)groupNodes)) {
            List ids = groupNodes.stream().map(QualityCheckWordGroupNode::getId).collect(Collectors.toList());
            log.info("qualityDel get groupNodes ids : {}", ids);
            this.groupNodeMapper.delGroupNode(ids, userInfo.getCorpId(), userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkWords = this.wordsMapper.getCheckWordList(wordGroup.getId(), userInfo.getCorpId())))) {
            List ids = checkWords.stream().map(QualityCheckWords::getId).collect(Collectors.toList());
            log.info("qualityDel get checkWords ids : {}", ids);
            this.wordsMapper.delCheckWordList(ids, userInfo.getCorpId(), userInfo.getId());
        }
        this.wordGroupMapper.delWordGroup(reqDto.getId(), userInfo.getCorpId(), userInfo.getId());
        this.readNewWordAndNode(userInfo.getCorpId());
    }

    @Override
    public List<QualityCheckWordRespDto> qualityList(QualityCheckListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qualityList qualityList get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("qualityList qualityList userIds: {}", (Object)userIds);
        List wordGroupList = this.wordGroupMapper.getWordGroupList(reqDto.getQueryName(), (Collection)userIds, userInfo.getCorpId(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)wordGroupList)) {
            log.info("qualityList qualityList wordGroupList is empty");
            return Collections.emptyList();
        }
        Integer count = this.wordGroupMapper.getWordGroupCount(reqDto.getQueryName(), (Collection)userIds, userInfo.getCorpId());
        reqDto.getPageDto().setCount(count);
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(wordGroupList.size()));
        List wordGroupIds = wordGroupList.stream().map(QualityCheckWordGroup::getId).collect(Collectors.toList());
        Map groupNodeIds = this.groupNodeMapper.queryNodeIds(wordGroupIds, userInfo.getCorpId());
        log.info("qualityList qualityList get groupNodeIds: {}", (Object)groupNodeIds);
        Collection allNodes = groupNodeIds.values();
        HashSet nIdS = new HashSet();
        if (CollectionUtils.isNotEmpty(allNodes)) {
            for (List nodeIds : allNodes) {
                if (!CollectionUtils.isNotEmpty((Collection)nodeIds)) continue;
                nIdS.addAll(nodeIds);
            }
        }
        log.info("qualityList qualityList get nIdS: {}", nIdS);
        OrgQueryParams queryParams = new OrgQueryParams();
        queryParams.setBizId(userInfo.getBizId());
        queryParams.setCorpId(userInfo.getCorpId());
        queryParams.setIds(nIdS);
        List organizations = this.organizationMapper.selectOrgsByParamDepartIds(queryParams);
        Map<Integer, Organization> nodeMap = null;
        if (CollectionUtils.isNotEmpty((Collection)organizations)) {
            nodeMap = organizations.stream().collect(Collectors.toMap(Organization::getWeworkDepartmentId, a -> a));
            log.info("qualityList qualityList get nodeMap: {}", nodeMap);
        }
        Map groupWords = this.wordsMapper.queryWordList(wordGroupIds, userInfo.getCorpId());
        log.info("qualityList qualityList get groupWords: {}", (Object)groupWords);
        Integer rootDepartment = this.organizationMapper.queryRootDepartment(userInfo.getCorpId());
        log.info("qualityAdd get root department: {}", (Object)rootDepartment);
        ArrayList respDtos = Lists.newArrayList();
        for (QualityCheckWordGroup wordGroup : wordGroupList) {
            QualityCheckWordRespDto respDto = new QualityCheckWordRespDto();
            respDto.setId(wordGroup.getNum());
            respDto.setSensitiveWord(wordGroup.getGroupName());
            List keyWords = (List)groupWords.get(wordGroup.getId());
            respDto.setKeyWords(keyWords);
            respDto.setVisibleType(wordGroup.getVisibleType());
            List nodeIds = (List)groupNodeIds.get(wordGroup.getId());
            respDto.setNodeIds(nodeIds);
            ArrayList nodeDetails = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)nodeIds)) {
                for (Long id : nodeIds) {
                    if (!Objects.nonNull(nodeMap)) continue;
                    Organization org = nodeMap.get(id.intValue());
                    if (Objects.nonNull(org)) {
                        QualityCheckNodeDetail nodeDesc = new QualityCheckNodeDetail();
                        nodeDesc.setId(id);
                        nodeDesc.setName(org.getName());
                        nodeDetails.add(nodeDesc);
                        continue;
                    }
                    log.info("qualityList query org is null, nodeId: {}", (Object)id);
                }
            }
            respDto.setNodes(nodeDetails);
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public List<QualityCheckRespDto> qualityCheckList(QualityCheckReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("qualityCheckList, params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        List groupIds = this.wordGroupMapper.queryGroupIdsByNums(reqDto.getQualityGroupIds(), currentUser.getCorpId());
        log.info("qualityCheckList getGroupIdNums: {}, groupIds: {}", reqDto.getQualityGroupIds(), (Object)groupIds);
        List<String> weworkUserIds = this.getManagerWeworkUserId(currentUser.getCorpId());
        log.info("qualityCheckList manager weworkUserIds: {}", weworkUserIds);
        List checkLogs = this.logMapper.queryCheckLogs(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), reqDto.getSendStatus(), reqDto.getQualityType(), weworkUserIds, (Collection)groupIds, reqDto.getBehaviors(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize(), currentUser.getCorpId());
        if (CollectionUtils.isEmpty((Collection)checkLogs)) {
            log.info("qualityCheckList, checkLogs is null");
            return Collections.emptyList();
        }
        Integer count = this.logMapper.queryCheckLogCount(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), reqDto.getSendStatus(), reqDto.getQualityType(), weworkUserIds, (Collection)groupIds, reqDto.getBehaviors(), currentUser.getCorpId());
        reqDto.getPageDto().setCount(count);
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(checkLogs.size()));
        List<QualityCheckRespDto> respDtos = this.qualityCheckListResp(checkLogs, reqDto.getQualityType(), currentUser.getCorpId());
        return respDtos;
    }

    private List<QualityCheckRespDto> qualityCheckListResp(List<QualityCheckLog> checkLogs, Integer qualityType, String corpId) {
        List sendWeworkUserIds = checkLogs.stream().map(QualityCheckLog::getSendWeworkUserId).collect(Collectors.toList());
        log.info("qualityCheckListResp get sendWeworkUserIds : {}", sendWeworkUserIds);
        List weworkUserList = this.weworkUserMapper.queryWeworkUserInfoList(corpId, sendWeworkUserIds);
        Map<String, WeworkUser> weworkUserMap = weworkUserList.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, a -> a));
        log.info("qualityCheckListResp get weworkUserMap : {}", weworkUserMap);
        Map checkWordMap = this.wordGroupMapper.queryGroupNames(null, corpId);
        log.info("qualityCheckListResp get checkWordMap : {}", (Object)checkWordMap);
        Map behaviorMap = this.behaviorSettingMapper.queryAllBehaviorList(corpId);
        behaviorMap.put(QualityBehaviorType.TIMEOUT_UNREPLY.getType(), QualityBehaviorType.TIMEOUT_UNREPLY.getDesc());
        log.info("qualityCheckListResp get behaviorMap : {}", (Object)behaviorMap);
        List targetIds = checkLogs.stream().map(QualityCheckLog::getReceiveTargetId).collect(Collectors.toList());
        log.info("qualityCheckListResp get targetIds : {}", targetIds);
        Map<String, WeworkUser> innerUserChatMap = this.handleInnerSingalChat(checkLogs, corpId);
        Map<String, UserContactInfo> externalContactChatMap = this.handleExternalSingalChat(checkLogs, corpId);
        Map<String, WeworkChatRoom> innerRoomChatMap = this.handleInnerRoomChat(checkLogs, corpId);
        Map<String, WeworkChatRoom> externalRoomChatMap = this.hanleExternalRoomChat(checkLogs, corpId);
        ArrayList respDtos = Lists.newArrayList();
        for (QualityCheckLog checkLog : checkLogs) {
            Collection<String> conversationTypeStr;
            QualityCheckRespDto respDto = new QualityCheckRespDto();
            respDtos.add(respDto);
            respDto.setId(checkLog.getNum());
            WeworkUser weworkUser = weworkUserMap.get(checkLog.getSendWeworkUserId());
            if (Objects.nonNull(weworkUser)) {
                respDto.setWeworkUserId(weworkUser.getWeworkUserId());
                respDto.setWeworkUserName(weworkUser.getName());
                respDto.setWeworkUserAvatar(weworkUser.getAvatar());
            } else {
                log.info("qualityCheckListResp get weworkUser is null,  getSendWeworkUserId : {}", (Object)checkLog.getSendWeworkUserId());
            }
            respDto.setTargetId(checkLog.getReceiveTargetId());
            respDto.setTargetType(checkLog.getTargetType());
            respDto.setTargetExternalType(checkLog.getExternalType());
            Map<String, String> targetMap = this.getSendTargetName(checkLog, innerUserChatMap, externalContactChatMap, innerRoomChatMap, externalRoomChatMap);
            Set<String> targetNames = targetMap.keySet();
            if (CollectionUtils.isNotEmpty(targetNames)) {
                for (String string : targetNames) {
                    respDto.setTargetName(string);
                }
            }
            if (CollectionUtils.isNotEmpty(conversationTypeStr = targetMap.values())) {
                for (String conversationTypeDesc : conversationTypeStr) {
                    respDto.setConversationType(conversationTypeDesc);
                }
            }
            String string = this.getCorpName(checkLog, externalContactChatMap);
            respDto.setCorpName(string);
            respDto.setSendTime(checkLog.getMsgTime());
            ArrayList quarityList = Lists.newArrayList();
            if (qualityType == 0) {
                List tGroupIds = this.logMapper.queryQualityGroupIds(checkLog.getMsgId(), corpId);
                log.info("qualityCheckListResp tGroupIds: {}", (Object)tGroupIds);
                if (CollectionUtils.isNotEmpty((Collection)tGroupIds)) {
                    for (Long groupId : tGroupIds) {
                        quarityList.add(checkWordMap.get(groupId));
                    }
                }
                respDto.setQualityWord(quarityList);
                respDto.setSendMsgType(checkLog.getMsgType());
                respDto.setSendContent(checkLog.getContent());
                respDto.setSendStatus(checkLog.getIsRevoke());
                continue;
            }
            List tBehaviorIdS = this.logMapper.queryBehaviorIds(checkLog.getMsgId(), corpId);
            log.info("qualityCheckListResp tBehaviorIdS: {}", (Object)tBehaviorIdS);
            if (CollectionUtils.isNotEmpty((Collection)tBehaviorIdS)) {
                for (Integer tValue : tBehaviorIdS) {
                    quarityList.add(behaviorMap.get(tValue));
                }
            }
            respDto.setQualityWord(quarityList);
        }
        return respDtos;
    }

    @Override
    public List<QuaityCheckDateRespDto> qualityCheckDateCountDetail(QualityCheckReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("qualityCheckDateCountDetail, params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        ArrayList respDtos = Lists.newArrayList();
        Long gap = 86400000L;
        Long i = reqDto.getStartTime().getTime();
        while (i < reqDto.getEndTime().getTime()) {
            Date currDate = new Date(i);
            QuaityCheckDateRespDto respDto = new QuaityCheckDateRespDto();
            respDto.setDate(currDate);
            respDto.setTotalCount(0);
            respDto.setCheckDetals(Collections.emptyList());
            respDtos.add(respDto);
            i = i + gap;
        }
        List<String> weworkUserIds = this.getManagerWeworkUserId(currentUser.getCorpId());
        log.info("qualityCheckDateCountDetail manager weworkUserIds: {}", weworkUserIds);
        if (reqDto.getQualityType() == 0) {
            List groupIds = this.wordGroupMapper.queryGroupIdsByNums(reqDto.getQualityGroupIds(), currentUser.getCorpId());
            log.info("qualityCheckDateCountDetail getGroupIdNums: {}, groupIds: {}", reqDto.getQualityGroupIds(), (Object)groupIds);
            Map groupCountMap = this.logMapper.queryCheckLogsGroupDateDetail(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), weworkUserIds, reqDto.getSendStatus(), (Collection)groupIds, currentUser.getCorpId());
            log.info("qualityCheckDateCountDetail, get groupCountMap:{}", (Object)groupCountMap);
            Map groupIdNameMap = this.wordGroupMapper.queryGroupNames((Collection)groupIds, currentUser.getCorpId());
            log.info("qualityCheckDateCountDetail, get groupIdNameMap:{}", (Object)groupIdNameMap);
            if (Objects.nonNull(groupCountMap)) {
                for (QuaityCheckDateRespDto respDto : respDtos) {
                    for (Map.Entry entry : groupCountMap.entrySet()) {
                        if (!respDto.getDate().equals(entry.getKey())) continue;
                        log.info("qualityCheckDateCountDetail, get groupCountMap Key = {}, Value = {}", entry.getKey(), entry.getValue());
                        int totalCount = 0;
                        ArrayList checkDetals = Lists.newArrayList();
                        for (Map.Entry sEntry : ((Map)entry.getValue()).entrySet()) {
                            log.info("qualityCheckDateCountDetail, get sEntry Key = {}, Value = {}", sEntry.getKey(), sEntry.getValue());
                            String groupName = (String)groupIdNameMap.get(sEntry.getKey());
                            if (!StringUtils.isNotBlank((CharSequence)groupName)) continue;
                            Integer groupCount = (Integer)sEntry.getValue();
                            totalCount += groupCount.intValue();
                            QualityCheckWordDetail detail = new QualityCheckWordDetail();
                            detail.setQualityWord(groupName);
                            detail.setCount(groupCount);
                            checkDetals.add(detail);
                        }
                        respDto.setTotalCount(totalCount);
                        respDto.setCheckDetals(checkDetals);
                    }
                }
            }
        } else {
            Map behaviorCountMap = this.logMapper.queryCheckLogsBehaviorDateDetail(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), weworkUserIds, reqDto.getBehaviors(), currentUser.getCorpId());
            log.info("qualityCheckDateCountDetail, get behaviorCountMap:{}", (Object)behaviorCountMap);
            if (Objects.nonNull(behaviorCountMap)) {
                for (QuaityCheckDateRespDto respDto : respDtos) {
                    for (Map.Entry entry : behaviorCountMap.entrySet()) {
                        if (!respDto.getDate().equals(entry.getKey())) continue;
                        log.info("qualityCheckDateCountDetail, get behaviorCountMap Key = {}, Value = {}", entry.getKey(), entry.getValue());
                        int totalCount = 0;
                        ArrayList checkDetals = Lists.newArrayList();
                        for (Map.Entry sEntry : ((Map)entry.getValue()).entrySet()) {
                            log.info("qualityCheckDateCountDetail, get sEntry Key = {}, Value = {}", sEntry.getKey(), sEntry.getValue());
                            String behaviorName = QualityBehaviorType.getByType((int)((Integer)sEntry.getKey())).getDesc();
                            if (!StringUtils.isNotBlank((CharSequence)behaviorName)) continue;
                            Integer groupCount = (Integer)sEntry.getValue();
                            totalCount += groupCount.intValue();
                            QualityCheckWordDetail detail = new QualityCheckWordDetail();
                            detail.setQualityWord(behaviorName);
                            detail.setCount(groupCount);
                            checkDetals.add(detail);
                        }
                        respDto.setTotalCount(totalCount);
                        respDto.setCheckDetals(checkDetals);
                    }
                }
            }
        }
        log.info("qualityCheckDateCountDetail respDto: {}", (Object)respDtos);
        return respDtos;
    }

    @Override
    public List<QualityCheckWordDetail> qualityCheckWordCountDetail(QualityCheckReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("qualityCheckWordCountDetail, params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        List<String> weworkUserIds = this.getManagerWeworkUserId(currentUser.getCorpId());
        log.info("qualityCheckWordCountDetail manager weworkUserIds: {}", weworkUserIds);
        ArrayList wordDetails = Lists.newArrayList();
        if (reqDto.getQualityType() == 0) {
            List groupIds = this.wordGroupMapper.queryGroupIdsByNums(reqDto.getQualityGroupIds(), currentUser.getCorpId());
            log.info("qualityCheckWordCountDetail getGroupIdNums: {}, groupIds: {}", reqDto.getQualityGroupIds(), (Object)groupIds);
            Map groupIdCountMap = this.logMapper.queryCheckLogsQualityGroupIdCount(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), weworkUserIds, reqDto.getSendStatus(), (Collection)groupIds, currentUser.getCorpId());
            log.info("qualityCheckWordCountDetail, get groupIdCountMap:{}", (Object)groupIdCountMap);
            Map groupIdNameMap = this.wordGroupMapper.queryGroupNames((Collection)groupIds, currentUser.getCorpId());
            log.info("qualityCheckWordCountDetail, get groupIdNameMap:{}", (Object)groupIdNameMap);
            if (Objects.nonNull(groupIdCountMap)) {
                for (Map.Entry entry : groupIdCountMap.entrySet()) {
                    log.info("qualityCheckWordCountDetail, get groupIdCountMap Key = {}, Value = {}", entry.getKey(), entry.getValue());
                    QualityCheckWordDetail detail = new QualityCheckWordDetail();
                    String groupName = (String)groupIdNameMap.get(entry.getKey());
                    if (!StringUtils.isNotBlank((CharSequence)groupName)) continue;
                    detail.setQualityWord(groupName);
                    detail.setCount((Integer)entry.getValue());
                    wordDetails.add(detail);
                }
            }
        } else {
            Map behaviorCountMap = this.logMapper.queryCheckLogsQualityBehaviorCount(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), weworkUserIds, reqDto.getBehaviors(), currentUser.getCorpId());
            log.info("qualityCheckWordCountDetail, get behaviorCountMap:{}", (Object)behaviorCountMap);
            if (Objects.nonNull(behaviorCountMap)) {
                for (Map.Entry entry : behaviorCountMap.entrySet()) {
                    log.info("qualityCheckWordCountDetail, get behaviorCountMap Key = {}, Value = {}", entry.getKey(), entry.getValue());
                    QualityCheckWordDetail detail = new QualityCheckWordDetail();
                    String behaviorName = QualityBehaviorType.getByType((int)((Integer)entry.getKey())).getDesc();
                    if (!StringUtils.isNotBlank((CharSequence)behaviorName)) continue;
                    detail.setQualityWord(behaviorName);
                    detail.setCount((Integer)entry.getValue());
                    wordDetails.add(detail);
                }
            }
        }
        log.info("qualityCheckWordCountDetail wordDetails: {}", (Object)wordDetails);
        return wordDetails;
    }

    @Override
    public void export(QualityCheckReqDto reqDto, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("export QualityCheck,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        String HEADER_TITLE = reqDto.getQualityType() == 0 ? QUALITY_HEADER_TITLE : QUALITY_BEHAVIOR_HEADER_TITLE;
        String[] HEADERS = reqDto.getQualityType() == 0 ? QUALITY_HEADERS : QUALITY_BEHAVIOR_HEADERS;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(HEADER_TITLE);
        String fileName = HEADER_TITLE + ".xls";
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int i = 0; i < HEADERS.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(HEADERS[i]);
            cell.setCellValue((RichTextString)text);
        }
        List groupIds = this.wordGroupMapper.queryGroupIdsByNums(reqDto.getQualityGroupIds(), currentUser.getCorpId());
        log.info("export getGroupIdNums: {}, groupIds: {}", reqDto.getQualityGroupIds(), (Object)groupIds);
        List<String> weworkUserIds = this.getManagerWeworkUserId(currentUser.getCorpId());
        log.info("export manager weworkUserIds: {}", weworkUserIds);
        List checkLogs = this.logMapper.queryCheckLogs(reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getWeworkUserId(), reqDto.getSendStatus(), reqDto.getQualityType(), weworkUserIds, (Collection)groupIds, reqDto.getBehaviors(), null, null, currentUser.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)checkLogs)) {
            List<QualityCheckRespDto> checkRespDtos = this.qualityCheckListResp(checkLogs, reqDto.getQualityType(), currentUser.getCorpId());
            int rowNum = 1;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            for (QualityCheckRespDto respDto : checkRespDtos) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                ssRow.createCell(0).setCellValue(respDto.getWeworkUserName());
                ssRow.createCell(1).setCellValue(respDto.getTargetName());
                ssRow.createCell(2).setCellValue(respDto.getConversationType());
                String qualityStr = StringUtils.join(respDto.getQualityWord(), (String)",");
                ssRow.createCell(3).setCellValue(qualityStr);
                if (reqDto.getQualityType() == 0) {
                    ssRow.createCell(4).setCellValue(respDto.getSendContent());
                    ssRow.createCell(5).setCellValue(respDto.getSendStatus() == 0 ? "\u5df2\u53d1\u9001" : "\u5df2\u64a4\u56de");
                    ssRow.createCell(6).setCellValue(simpleDateFormat.format(respDto.getSendTime()));
                } else {
                    ssRow.createCell(4).setCellValue(simpleDateFormat.format(respDto.getSendTime()));
                }
                ++rowNum;
            }
        } else {
            log.info("export QualityCheck get checkLogs is null");
        }
        log.info("export QualityCheck excel");
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getCorpName(QualityCheckLog checkLog, Map<String, UserContactInfo> externalContactChat) {
        String corpName = "";
        if (checkLog.getExternalType() == 1 && checkLog.getTargetType() == 1) {
            if (Objects.nonNull(externalContactChat)) {
                String key = StringUtils.join((Object[])new Object[]{checkLog.getSendWeworkUserId(), checkLog.getReceiveTargetId()}, (String)"$$");
                log.info("getCorpName externalContactChat key: {}", (Object)key);
                UserContactInfo contact = externalContactChat.get(key);
                if (Objects.nonNull(contact) && StringUtils.isNotBlank((CharSequence)contact.getCorpName())) {
                    corpName = contact.getCorpName();
                }
                log.info("getCorpName externalContactChat corpName: {}", (Object)corpName);
            } else {
                log.info("getCorpName externalContactChat is null");
            }
        }
        return corpName;
    }

    private Map<String, String> getSendTargetName(QualityCheckLog checkLog, Map<String, WeworkUser> innerUserChat, Map<String, UserContactInfo> externalContactChat, Map<String, WeworkChatRoom> innerRoomChat, Map<String, WeworkChatRoom> externalRoomChat) {
        WeworkChatRoom chatRoom;
        String sendTargetName = "";
        String targetTypeDesc = "";
        if (checkLog.getExternalType() == 0) {
            if (checkLog.getTargetType() == 1) {
                if (Objects.nonNull(innerUserChat)) {
                    WeworkUser user = innerUserChat.get(checkLog.getReceiveTargetId());
                    if (Objects.nonNull(user)) {
                        sendTargetName = user.getName();
                    }
                    targetTypeDesc = ConversationTypeEnum.INNER_CONTACT.getDesc();
                    log.info("getSendTargetName innerUserChat name: {}", (Object)sendTargetName);
                } else {
                    log.info("getSendTargetName innerUserChat is null");
                }
            } else if (Objects.nonNull(innerRoomChat)) {
                chatRoom = innerRoomChat.get(checkLog.getReceiveTargetId());
                if (Objects.nonNull(chatRoom)) {
                    sendTargetName = chatRoom.getName();
                }
                targetTypeDesc = ConversationTypeEnum.INNER_ROOM.getDesc();
                log.info("getSendTargetName innerRoomChat name: {}", (Object)sendTargetName);
            } else {
                log.info("getSendTargetName innerRoomChat is null");
            }
        } else if (checkLog.getTargetType() == 1) {
            if (Objects.nonNull(externalContactChat)) {
                String key = StringUtils.join((Object[])new Object[]{checkLog.getSendWeworkUserId(), checkLog.getReceiveTargetId()}, (String)"$$");
                log.info("getSendTargetName externalContactChat key: {}", (Object)key);
                UserContactInfo contact = externalContactChat.get(key);
                targetTypeDesc = ConversationTypeEnum.WECHAT_CONTACT.getDesc();
                if (Objects.nonNull(contact)) {
                    sendTargetName = contact.getRemark();
                    if (StringUtils.isNotBlank((CharSequence)contact.getCorpName())) {
                        targetTypeDesc = ConversationTypeEnum.WEWORK_CONTACT.getDesc();
                    }
                }
                log.info("getSendTargetName externalContactChat name: {}", (Object)sendTargetName);
            } else {
                log.info("getSendTargetName externalContactChat is null");
            }
        } else if (Objects.nonNull(externalRoomChat)) {
            chatRoom = externalRoomChat.get(checkLog.getReceiveTargetId());
            if (Objects.nonNull(chatRoom)) {
                sendTargetName = chatRoom.getName();
            }
            targetTypeDesc = ConversationTypeEnum.EXTERNAL_ROOM.getDesc();
            log.info("getSendTargetName externalRoomChat name: {}", (Object)sendTargetName);
        } else {
            log.info("getSendTargetName externalRoomChat is null");
        }
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put(sendTargetName, targetTypeDesc);
        return stringMap;
    }

    private Map<String, WeworkUser> handleInnerSingalChat(List<QualityCheckLog> checkLogs, String corpId) {
        List innerSingalChat = checkLogs.stream().filter(a -> a.getExternalType() == 0 && a.getTargetType() == 1).map(QualityCheckLog::getReceiveTargetId).collect(Collectors.toList());
        log.info("handleTarget  innerSingalChat: {}", innerSingalChat);
        if (CollectionUtils.isNotEmpty(innerSingalChat)) {
            List weworkUserList = this.weworkUserMapper.queryWeworkUserInfoList(corpId, innerSingalChat);
            Map<String, WeworkUser> weworkUserMap = weworkUserList.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, a -> a));
            log.info("handleTarget get weworkUserMap: {}", weworkUserMap);
            return weworkUserMap;
        }
        return null;
    }

    private Map<String, UserContactInfo> handleExternalSingalChat(List<QualityCheckLog> checkLogs, String corpId) {
        Map externalSignalMap = checkLogs.stream().filter(a -> a.getExternalType() == 1 && a.getTargetType() == 1).collect(Collectors.groupingBy(QualityCheckLog::getSendWeworkUserId, Collectors.mapping(QualityCheckLog::getReceiveTargetId, Collectors.toList())));
        log.info("handleTarget externalSignalMap: {}", externalSignalMap);
        ArrayList contactInfos = Lists.newArrayList();
        if (Objects.nonNull(externalSignalMap)) {
            for (Map.Entry entry : externalSignalMap.entrySet()) {
                List contactList = this.weworkContactRelationMapper.queryByWeworkUserIdAndQuery(corpId, null, entry.getKey(), null, (Collection)entry.getValue());
                contactInfos.addAll(contactList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)contactInfos)) {
            Map<String, UserContactInfo> contactInfoMap = contactInfos.stream().collect(Collectors.toMap(a -> StringUtils.join((Object[])new Object[]{a.getWeworkUserId(), a.getContactId()}, (String)"$$"), a -> a));
            log.info("handleTarget get contactInfoMap: {}", contactInfoMap);
            return contactInfoMap;
        }
        return null;
    }

    private Map<String, WeworkChatRoom> handleInnerRoomChat(List<QualityCheckLog> checkLogs, String corpId) {
        List innerRoomChat = checkLogs.stream().filter(a -> a.getExternalType() == 0 && a.getTargetType() == 2).map(QualityCheckLog::getReceiveTargetId).collect(Collectors.toList());
        log.info("handleTarget  innerRoomChat: {}", innerRoomChat);
        if (CollectionUtils.isNotEmpty(innerRoomChat)) {
            List innerChatRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, innerRoomChat);
            Map<String, WeworkChatRoom> innerRoomMap = innerChatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, a -> a));
            log.info("handleTarget get innerRoomMap: {}", innerRoomMap);
            return innerRoomMap;
        }
        return null;
    }

    private Map<String, WeworkChatRoom> hanleExternalRoomChat(List<QualityCheckLog> checkLogs, String corpId) {
        List externalRoomChat = checkLogs.stream().filter(a -> a.getExternalType() == 1 && a.getTargetType() == 2).map(QualityCheckLog::getReceiveTargetId).collect(Collectors.toList());
        log.info("handleTarget externalRoomChat: {}", externalRoomChat);
        if (CollectionUtils.isNotEmpty(externalRoomChat)) {
            List externalChatRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, externalRoomChat);
            Map<String, WeworkChatRoom> externalRoomMap = externalChatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, a -> a));
            log.info("handleTarget get externalRoomMap: {}", externalRoomMap);
            return externalRoomMap;
        }
        return null;
    }

    private QualityCheckWordGroup setCheckWordGroup(String groupName, CurrentUserInfo userInfo, Integer visiableType) {
        QualityCheckWordGroup wordGroup = new QualityCheckWordGroup();
        wordGroup.setNum(this.idGen.getNum());
        wordGroup.setBizId(userInfo.getBizId());
        wordGroup.setCorpId(userInfo.getCorpId());
        wordGroup.setGroupName(groupName);
        wordGroup.setCreateTime(new Date());
        wordGroup.setCreateBy(userInfo.getId());
        wordGroup.setIsDeleted(Integer.valueOf(0));
        wordGroup.setVisibleType(visiableType);
        return wordGroup;
    }

    private QualityCheckWords setCheckWords(Long groupId, String key, CurrentUserInfo userInfo) {
        QualityCheckWords words = new QualityCheckWords();
        words.setBizId(userInfo.getBizId());
        words.setCorpId(userInfo.getCorpId());
        words.setGroupId(groupId);
        words.setWord(key);
        words.setCreateBy(userInfo.getId());
        words.setCreateTime(new Date());
        words.setIsDeleted(Long.valueOf(0L));
        return words;
    }

    private QualityCheckWordGroupNode setWordGroupNode(Long groupId, Long nodeId, CurrentUserInfo userInfo) {
        QualityCheckWordGroupNode groupNode = new QualityCheckWordGroupNode();
        groupNode.setBizId(userInfo.getBizId());
        groupNode.setCorpId(userInfo.getCorpId());
        groupNode.setGroupId(groupId);
        groupNode.setNodeId(nodeId);
        groupNode.setCreateTime(new Date());
        groupNode.setCreateBy(userInfo.getId());
        groupNode.setIsDeleted(Long.valueOf(0L));
        return groupNode;
    }

    private List<String> getManagerWeworkUserId(String corpId) {
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("qualityList qualityList userIds: {}", (Object)userIds);
        List userInfoList = this.weworkUserMapper.queryWeworkUserByUserIds(corpId, (Collection)userIds);
        if (CollectionUtils.isNotEmpty((Collection)userInfoList)) {
            return userInfoList.stream().map(WeworkUser::getWeworkUserId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

