/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.chat.check.dto.req.MonitorCycle;
import com.kuaike.scrm.chat.check.dto.req.QualityBehaviorSettingReqDto;
import com.kuaike.scrm.chat.check.dto.req.QualityUnreplyBaseDto;
import com.kuaike.scrm.chat.check.dto.resp.QualityBehaviorRespDto;
import com.kuaike.scrm.chat.check.service.QualityBehaviorService;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.PublishPayloadDto;
import com.kuaike.scrm.common.enums.PublishPayloadType;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckBehaviorUnreplyCycle;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckBehaviorUnreplySetting;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckBehaviorUnreplyCycleMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckBehaviorUnreplySettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QualityBehaviorServiceImpl
implements QualityBehaviorService {
    private static final Logger log = LoggerFactory.getLogger(QualityBehaviorServiceImpl.class);
    @Resource
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;
    @Resource
    private QualityCheckBehaviorUnreplyCycleMapper behaviorUnreplyCycleMapper;
    @Resource
    private QualityCheckBehaviorUnreplySettingMapper behaviorUnreplySettingMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ApplicationContext context;

    @Override
    public void modBehaviorSetting(QualityBehaviorSettingReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("modBehaviorSetting get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        this.behaviorSettingMapper.updateBehaviorSetting(reqDto.getId(), reqDto.getCheckStatus(), userInfo.getCorpId(), userInfo.getId());
        this.readNewBehavior(userInfo.getCorpId());
    }

    @Override
    public List<QualityBehaviorRespDto> qualityBehaviorList() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("qualityBehaviorList get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        List settingList = this.behaviorSettingMapper.queryBehaviorlist(userInfo.getCorpId());
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            log.info("qualityBehaviorList get setting is null");
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (QualityCheckBehaviorSetting setting : settingList) {
            QualityBehaviorRespDto respDto = new QualityBehaviorRespDto();
            respDto.setId(setting.getNum());
            respDto.setCheckDesc(setting.getCheckDesc());
            respDto.setCheckStatus(setting.getCheckStatus());
            respDto.setCheckValue(setting.getCheckValue());
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public void addBehaviorSetting(Long bizId, String corpId) {
        List settings = this.behaviorSettingMapper.queryBehaviorlist(corpId);
        if (CollectionUtils.isEmpty((Collection)settings)) {
            Integer[] behaviorSettings;
            for (Integer setting : behaviorSettings = new Integer[]{1, 2, 3, 4}) {
                QualityCheckBehaviorSetting behaviorSetting = new QualityCheckBehaviorSetting();
                behaviorSetting.setBizId(bizId);
                behaviorSetting.setCorpId(corpId);
                behaviorSetting.setCheckDesc(QualityBehaviorType.getByType((int)setting).getDesc());
                behaviorSetting.setCheckValue(setting);
                behaviorSetting.setCheckStatus(Integer.valueOf(0));
                behaviorSetting.setCreateTime(new Date());
                behaviorSetting.setCreateBy(bizId);
                behaviorSetting.setNum(this.idGen.getNum());
                this.behaviorSettingMapper.insertSelective((Object)behaviorSetting);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTimeOutUnreplySetting(QualityUnreplyBaseDto reqDto) {
        log.info("addTimeOutUnreplySetting: {}", (Object)reqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        reqDto.validate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        QualityCheckBehaviorUnreplySetting unreplySetting = this.behaviorUnreplySettingMapper.queryUnreplySetting(corpId, bizId);
        if (unreplySetting == null) {
            unreplySetting = this.insertUnreplySetting(reqDto.getTimeout());
            if (CollectionUtils.isNotEmpty(reqDto.getCycles())) {
                this.saveUnreplyCycleSetting(unreplySetting.getNum(), reqDto.getCycles());
            }
        } else {
            String unreplyNum = unreplySetting.getNum();
            this.behaviorUnreplyCycleMapper.delUnreplyCycle(unreplyNum, userInfo.getCorpId());
            this.behaviorUnreplySettingMapper.updateUnreplySetting(corpId, unreplySetting.getNum(), reqDto.getTimeout(), userInfo.getId());
            this.saveUnreplyCycleSetting(unreplyNum, reqDto.getCycles());
        }
    }

    @Override
    @Transactional
    public QualityUnreplyBaseDto getTimeoutUnreplySetting() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        QualityCheckBehaviorUnreplySetting unreplySetting = this.behaviorUnreplySettingMapper.queryUnreplySetting(corpId, bizId);
        if (unreplySetting == null) {
            unreplySetting = this.insertUnreplySetting(30);
        }
        List exists = this.behaviorUnreplyCycleMapper.queryUnreplyCycle(unreplySetting.getNum(), userInfo.getCorpId());
        HashMap mapCycle = Maps.newHashMap();
        for (QualityCheckBehaviorUnreplyCycle cycle : exists) {
            String key = DateUtil.dateToDateString((Date)cycle.getStartTime(), (String)"HH:mm") + "-" + DateUtil.dateToDateString((Date)cycle.getEndTime(), (String)"HH:mm");
            if (mapCycle.containsKey(key)) {
                ((List)mapCycle.get(key)).add(cycle.getWeekday());
                continue;
            }
            ArrayList list = Lists.newArrayList((Object[])new Integer[]{cycle.getWeekday()});
            mapCycle.put(key, list);
        }
        QualityUnreplyBaseDto result = new QualityUnreplyBaseDto();
        result.setTimeout(unreplySetting.getTimeout());
        result.setCycles(Lists.newArrayList());
        for (String key : mapCycle.keySet()) {
            String startTime = key.split("-")[0];
            String endTime = key.split("-")[1];
            MonitorCycle monitorCycle = new MonitorCycle();
            monitorCycle.setEndTime(endTime);
            monitorCycle.setStartTime(startTime);
            monitorCycle.setWeekday((List)mapCycle.get(key));
            result.getCycles().add(monitorCycle);
        }
        return result;
    }

    private QualityCheckBehaviorUnreplySetting insertUnreplySetting(Integer timeout) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        QualityCheckBehaviorUnreplySetting unreplySetting = new QualityCheckBehaviorUnreplySetting();
        unreplySetting.setNum(this.idGen.getNum());
        unreplySetting.setBizId(userInfo.getBizId());
        unreplySetting.setCorpId(userInfo.getCorpId());
        unreplySetting.setCreateTime(new Date());
        unreplySetting.setCreateBy(userInfo.getId());
        unreplySetting.setUpdateTime(new Date());
        unreplySetting.setTimeout(timeout);
        this.behaviorUnreplySettingMapper.insert((Object)unreplySetting);
        return unreplySetting;
    }

    private void saveUnreplyCycleSetting(String unreplyNum, List<MonitorCycle> cycles) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        for (MonitorCycle monitorCycle : cycles) {
            List<Integer> weekdays = monitorCycle.getWeekday();
            for (Integer weekday : weekdays) {
                QualityCheckBehaviorUnreplyCycle cycle = new QualityCheckBehaviorUnreplyCycle();
                cycle.setBizId(userInfo.getBizId());
                cycle.setCorpId(userInfo.getCorpId());
                cycle.setCreateBy(userInfo.getId());
                cycle.setCreateTime(new Date());
                cycle.setUpdateTime(new Date());
                cycle.setIsDeleted(Integer.valueOf(0));
                cycle.setUnreplyNum(unreplyNum);
                cycle.setWeekday(weekday);
                cycle.setStartTime(DateUtil.getDate((String)monitorCycle.getStartTime(), (String)"HH:mm"));
                cycle.setEndTime(DateUtil.getDate((String)monitorCycle.getEndTime(), (String)"HH:mm"));
                this.behaviorUnreplyCycleMapper.insert((Object)cycle);
            }
        }
    }

    private void readNewBehavior(String corpId) {
        List behaviorSettings = this.behaviorSettingMapper.queryBehaviorlist(corpId);
        CorpSensitiveWordBehaviorDto dto = new CorpSensitiveWordBehaviorDto();
        Map<Integer, Integer> behaviorMap = behaviorSettings.stream().collect(Collectors.toMap(QualityCheckBehaviorSetting::getCheckValue, QualityCheckBehaviorSetting::getCheckStatus));
        dto.setCorpId(corpId);
        dto.setDelByContactCheck(behaviorMap.getOrDefault(QualityBehaviorType.DEL_BY_CONTACT.getType(), 0).equals(1));
        dto.setSendCardCheck(behaviorMap.getOrDefault(QualityBehaviorType.CARD.getType(), 0).equals(1));
        dto.setDelContactCheck(behaviorMap.getOrDefault(QualityBehaviorType.DEL_CONTACT.getType(), 0).equals(1));
        dto.setSendHongbaoCheck(behaviorMap.getOrDefault(QualityBehaviorType.RED_PACKAGE.getType(), 0).equals(1));
        this.publishReloadQualityBehaviorEvent(dto);
    }

    private void publishReloadQualityBehaviorEvent(CorpSensitiveWordBehaviorDto dto) {
        PublishPayloadDto publishPayloadDto = new PublishPayloadDto();
        publishPayloadDto.setType(PublishPayloadType.QUALITY_CHECK_BEHAVIOR_CHANGE);
        publishPayloadDto.setContent(JSON.toJSONString((Object)dto));
        this.context.publishEvent((Object)publishPayloadDto);
    }
}

