/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.dto.req.NotificationDto;
import com.kuaike.scrm.chat.check.dto.req.NotificationEnableDto;
import com.kuaike.scrm.chat.check.dto.resp.NotificationItemResp;
import com.kuaike.scrm.chat.check.dto.resp.QualityCheckWordRespDto;
import com.kuaike.scrm.chat.check.service.NotificationService;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckNotification;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckNotificationBehavior;
import com.kuaike.scrm.dal.qualityCheck.entity.QualityCheckNotificationScope;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckNotificationBehaviorMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckNotificationMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckNotificationScopeMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.qualityCheck.mapper.QualityCheckWordsMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationServiceImpl
implements NotificationService {
    private static final Logger log = LoggerFactory.getLogger(NotificationServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private QualityCheckNotificationMapper notificationMapper;
    @Resource
    private QualityCheckNotificationScopeMapper notificationScopeMapper;
    @Resource
    private QualityCheckNotificationBehaviorMapper notificationBehaviorMapper;
    @Resource
    private QualityCheckWordGroupMapper qualityCheckWordGroupMapper;
    @Resource
    private QualityCheckWordsMapper qualityCheckWordsMapper;
    @Resource
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;

    @Override
    @Transactional
    public String add(NotificationDto params) {
        log.info("notification service add: {}", (Object)params);
        params.validate();
        QualityCheckNotification notification = this.insertNotification(params);
        params.setId(notification.getNum());
        if (params.getScope() == 1) {
            this.saveNotificationScope(params);
        }
        this.saveNotificationActivity(params);
        return notification.getNum();
    }

    private QualityCheckNotification insertNotification(NotificationDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curDate = new Date();
        QualityCheckNotification notification = new QualityCheckNotification();
        notification.setNum(this.idGen.getNum());
        notification.setBizId(userInfo.getBizId());
        notification.setCorpId(userInfo.getCorpId());
        notification.setScope(params.getScope());
        notification.setChargeNum(params.getChargeNum());
        notification.setDepartMasterNum(params.getDepartMasterNum());
        notification.setIsNotify(params.getNotifyWeworkUser());
        notification.setIsNotifyTimeout(params.getUnreplyNotify());
        notification.setCreateTime(curDate);
        notification.setCreateBy(userInfo.getId());
        notification.setUpdateTime(curDate);
        notification.setUpdateBy(userInfo.getId());
        notification.setIsDeleted(Integer.valueOf(0));
        notification.setIsEnabled(Integer.valueOf(1));
        this.notificationMapper.insertSelective((Object)notification);
        return notification;
    }

    private void saveNotificationScope(NotificationDto params) {
        Set delList;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List exists = this.notificationScopeMapper.queryNotificationScope(userInfo.getCorpId(), params.getId());
        HashMap existOrg = Maps.newHashMap();
        HashMap existWeworkUser = Maps.newHashMap();
        for (Object notificationScope : exists) {
            if (notificationScope.getOrgNum() != null) {
                existOrg.put(notificationScope.getOrgNum(), notificationScope);
            }
            if (notificationScope.getWeworkUserNum() == null) continue;
            existWeworkUser.put(notificationScope.getWeworkUserNum(), notificationScope);
        }
        ArrayList addList = Lists.newArrayList();
        for (String orgId : params.getOrgIds()) {
            if (StringUtils.isBlank((CharSequence)orgId)) continue;
            if (!existOrg.keySet().contains(orgId)) {
                addList.add(this.buildScope(params.getId(), orgId, null));
                continue;
            }
            existOrg.keySet().remove(orgId);
        }
        for (String weworkUserNum : params.getWeworkUserIds()) {
            if (StringUtils.isBlank((CharSequence)weworkUserNum)) continue;
            if (!existWeworkUser.keySet().contains(weworkUserNum)) {
                addList.add(this.buildScope(params.getId(), null, weworkUserNum));
                continue;
            }
            existWeworkUser.keySet().remove(weworkUserNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.notificationScopeMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty(existOrg.keySet())) {
            delList = existOrg.values().stream().map(it -> it.getId()).collect(Collectors.toSet());
            this.notificationScopeMapper.batchDel(delList, userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty(existWeworkUser.keySet())) {
            delList = existWeworkUser.values().stream().map(it -> it.getId()).collect(Collectors.toSet());
            this.notificationScopeMapper.batchDel(delList, userInfo.getId());
        }
    }

    private QualityCheckNotificationScope buildScope(String notificationNum, String orgNum, String weworkUserNum) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curTime = new Date();
        QualityCheckNotificationScope notificationScope = new QualityCheckNotificationScope();
        notificationScope.setBizId(userInfo.getBizId());
        notificationScope.setCorpId(userInfo.getCorpId());
        notificationScope.setNotificationNum(notificationNum);
        notificationScope.setOrgNum(orgNum);
        notificationScope.setWeworkUserNum(weworkUserNum);
        notificationScope.setCreateBy(userInfo.getId());
        notificationScope.setUpdateBy(userInfo.getId());
        notificationScope.setCreateTime(curTime);
        notificationScope.setUpdateTime(curTime);
        notificationScope.setIsDeleted(Integer.valueOf(0));
        return notificationScope;
    }

    private void saveNotificationActivity(NotificationDto params) {
        Set delList;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List exists = this.notificationBehaviorMapper.queryNotificationBehavior(userInfo.getCorpId(), params.getId());
        HashMap existWord = Maps.newHashMap();
        HashMap existBehavior = Maps.newHashMap();
        for (Object notificationBehavior : exists) {
            if (notificationBehavior.getWordNum() != null) {
                existWord.put(notificationBehavior.getWordNum(), notificationBehavior);
            }
            if (notificationBehavior.getBehaviorNum() == null) continue;
            existBehavior.put(notificationBehavior.getBehaviorNum(), notificationBehavior);
        }
        ArrayList addList = Lists.newArrayList();
        for (String wordNum : params.getCheckWords()) {
            if (StringUtils.isBlank((CharSequence)wordNum)) continue;
            if (!existWord.keySet().contains(wordNum)) {
                addList.add(this.buildBehavior(params.getId(), wordNum, null));
                continue;
            }
            existWord.keySet().remove(wordNum);
        }
        for (String behaviorNum : params.getCheckBehaviors()) {
            if (StringUtils.isBlank((CharSequence)behaviorNum)) continue;
            if (!existBehavior.keySet().contains(behaviorNum)) {
                addList.add(this.buildBehavior(params.getId(), null, behaviorNum));
                continue;
            }
            existBehavior.keySet().remove(behaviorNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.notificationBehaviorMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty(existWord.keySet())) {
            delList = existWord.values().stream().map(it -> it.getId()).collect(Collectors.toSet());
            this.notificationBehaviorMapper.batchDel(delList, userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty(existBehavior.keySet())) {
            delList = existBehavior.values().stream().map(it -> it.getId()).collect(Collectors.toSet());
            this.notificationBehaviorMapper.batchDel(delList, userInfo.getId());
        }
    }

    private QualityCheckNotificationBehavior buildBehavior(String notificationNum, String wordNum, String behaviorNum) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curTime = new Date();
        QualityCheckNotificationBehavior notificationBehavior = new QualityCheckNotificationBehavior();
        notificationBehavior.setBizId(userInfo.getBizId());
        notificationBehavior.setCorpId(userInfo.getCorpId());
        notificationBehavior.setNotificationNum(notificationNum);
        notificationBehavior.setWordNum(wordNum);
        notificationBehavior.setBehaviorNum(behaviorNum);
        notificationBehavior.setCreateBy(userInfo.getId());
        notificationBehavior.setUpdateBy(userInfo.getId());
        notificationBehavior.setCreateTime(curTime);
        notificationBehavior.setUpdateTime(curTime);
        notificationBehavior.setIsDeleted(Integer.valueOf(0));
        return notificationBehavior;
    }

    @Override
    public void mod(NotificationDto params) {
        log.info("notification service mod: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getId()), (Object)"\u901a\u77e5id\u4e3a\u7a7a");
        String corpId = LoginUtils.getCurrentUserCorpId();
        QualityCheckNotification notification = new QualityCheckNotification();
        notification.setCorpId(corpId);
        notification.setNum(params.getId());
        notification = (QualityCheckNotification)this.notificationMapper.selectOne((Object)notification);
        Preconditions.checkArgument((notification != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u901a\u77e5\u8bbe\u7f6e");
        notification.setScope(params.getScope());
        notification.setChargeNum(params.getChargeNum());
        notification.setDepartMasterNum(params.getDepartMasterNum());
        notification.setIsNotify(params.getNotifyWeworkUser());
        notification.setIsNotifyTimeout(params.getUnreplyNotify());
        notification.setUpdateBy(userInfo.getId());
        notification.setUpdateTime(new Date());
        this.notificationMapper.updateByPrimaryKey((Object)notification);
        if (params.getScope() == 1) {
            this.saveNotificationScope(params);
        }
        this.saveNotificationActivity(params);
    }

    @Override
    @Transactional
    public void del(BaseDto params) {
        log.info("notification del params: {}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        this.notificationMapper.delNotification(userInfo.getCorpId(), params.getId(), userInfo.getId());
    }

    @Override
    @Transactional
    public void enabled(NotificationEnableDto params) {
        log.info("notification enabled params: {}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        this.notificationMapper.openOrCloseNotification(userInfo.getCorpId(), params.getId(), params.getIsEnabled(), userInfo.getId());
    }

    @Override
    public List<NotificationItemResp> list(BaseDto params) {
        List notifications;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("qualityList qualityList userIds: {}", (Object)userIds);
        if (params.getPageDto() != null) {
            int total = this.notificationMapper.queryNotificationCount(userInfo.getBizId(), userInfo.getCorpId(), (Collection)userIds);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(notifications = this.notificationMapper.queryNotificationList(userInfo.getBizId(), userInfo.getCorpId(), (Collection)userIds, params.getPageDto())))) {
            return Lists.newArrayList();
        }
        List notificationNums = notifications.stream().map(it -> it.getNum()).collect(Collectors.toList());
        Map orgMap = this.notificationScopeMapper.queryNotificationOrgMap(userInfo.getCorpId(), notificationNums);
        Map weworkUserMap = this.notificationScopeMapper.queryNotificationWeworkUserMap(userInfo.getCorpId(), notificationNums);
        Map wordMap = this.notificationBehaviorMapper.queryNotificationWordMap(userInfo.getCorpId(), notificationNums);
        Map behaviorMap = this.notificationBehaviorMapper.queryNotificationBehaviorMap(userInfo.getCorpId(), notificationNums);
        HashMap queryWeworkUserMap = Maps.newHashMap();
        for (QualityCheckNotification notification : notifications) {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)queryWeworkUserMap.get(notification.getNum())))) {
                ((List)queryWeworkUserMap.get(notification.getNum())).add(notification.getChargeNum());
            } else {
                queryWeworkUserMap.put(notification.getNum(), Lists.newArrayList((Object[])new String[]{notification.getChargeNum()}));
            }
            if (!StringUtils.isNotEmpty((CharSequence)notification.getDepartMasterNum())) continue;
            ((List)queryWeworkUserMap.get(notification.getNum())).add(notification.getDepartMasterNum());
        }
        Map<String, StrIdAndNameDto> orgDtoMap = this.getOrgDtoMap(orgMap);
        Map<String, WeworkUserDto> weworkUserDtoMap = this.getWeworkUserDtoMap(weworkUserMap, userInfo.getCorpId());
        weworkUserDtoMap.putAll(this.getWeworkUserDtoMap(queryWeworkUserMap, userInfo.getCorpId()));
        Map<String, QualityCheckWordRespDto> wordDtoMap = this.getWordDtoMap(wordMap, userInfo.getCorpId());
        Map<String, StrIdAndNameDto> behaviorDtoMap = this.getBehaviorDtoMap(behaviorMap, userInfo.getCorpId());
        ArrayList result = Lists.newArrayList();
        for (QualityCheckNotification notification : notifications) {
            NotificationItemResp resp = new NotificationItemResp();
            resp.setId(notification.getNum());
            resp.setIsEnabled(notification.getIsEnabled());
            resp.setScope(notification.getScope());
            if (resp.getScope() == 1) {
                List orgNums = (List)orgMap.get(notification.getNum());
                ArrayList orgDtoList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)orgNums)) {
                    for (String orgNum : orgNums) {
                        if (orgDtoMap.get(orgNum) == null) continue;
                        orgDtoList.add(orgDtoMap.get(orgNum));
                    }
                }
                resp.setOrgs(orgDtoList);
                List weworkUserNums = (List)weworkUserMap.get(notification.getNum());
                ArrayList weworkUserDtos = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)weworkUserNums)) {
                    Iterator iterator = weworkUserNums.iterator();
                    while (iterator.hasNext()) {
                        String weworkUserNum = (String)iterator.next();
                        if (weworkUserDtoMap.get(weworkUserNum) == null) continue;
                        weworkUserDtos.add(weworkUserDtoMap.get(weworkUserNum));
                    }
                }
                resp.setWeworkUsers(weworkUserDtos);
            }
            List wordNums = (List)wordMap.get(notification.getNum());
            ArrayList wordRespDtos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)wordNums)) {
                for (String wordNum : wordNums) {
                    if (wordDtoMap.get(wordNum) == null) continue;
                    wordRespDtos.add(wordDtoMap.get(wordNum));
                }
            }
            resp.setCheckWords(wordRespDtos);
            List behaviorNums = (List)behaviorMap.get(notification.getNum());
            ArrayList behaviorDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)behaviorNums)) {
                for (String behaviorNum : behaviorNums) {
                    if (behaviorDtoMap.get(behaviorNum) == null) continue;
                    behaviorDtoList.add(behaviorDtoMap.get(behaviorNum));
                }
            }
            resp.setCheckBehaviors(behaviorDtoList);
            resp.setUnreplyNotify(notification.getIsNotifyTimeout());
            resp.setCharge(weworkUserDtoMap.get(notification.getChargeNum()));
            resp.setDepartMaster(weworkUserDtoMap.get(notification.getDepartMasterNum()));
            resp.setNotifyWeworkUser(notification.getIsNotify());
            result.add(resp);
        }
        return result;
    }

    private Map<String, StrIdAndNameDto> getOrgDtoMap(Map<String, List<String>> orgMap) {
        HashSet orgSet = Sets.newHashSet();
        if (orgMap.isEmpty()) {
            return Maps.newHashMap();
        }
        for (List<String> list : orgMap.values()) {
            orgSet.addAll(list);
        }
        if (CollectionUtils.isEmpty((Collection)orgSet)) {
            return Maps.newHashMap();
        }
        List orgList = this.organizationMapper.selectOrgByNums((Collection)orgSet);
        HashMap orgNameMap = Maps.newHashMap();
        for (Organization org : orgList) {
            if (orgNameMap.containsKey(org.getNum())) continue;
            StrIdAndNameDto dto = new StrIdAndNameDto();
            dto.setId(org.getNum());
            dto.setName(org.getName());
            orgNameMap.put(org.getNum(), dto);
        }
        return orgNameMap;
    }

    private Map<String, WeworkUserDto> getWeworkUserDtoMap(Map<String, List<String>> weworkUserMap, String corpId) {
        HashSet weworkUserSet = Sets.newHashSet();
        if (weworkUserMap.isEmpty()) {
            return Maps.newHashMap();
        }
        for (List<String> list : weworkUserMap.values()) {
            weworkUserSet.addAll(list);
        }
        if (CollectionUtils.isEmpty((Collection)weworkUserSet)) {
            return Maps.newHashMap();
        }
        List weworkUsers = this.weworkUserMapper.getWeworkUserByNums(corpId, (Collection)weworkUserSet);
        Map<String, WeworkUserDto> weworkUserDtoMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUserDto::getId, Function.identity()));
        return weworkUserDtoMap;
    }

    private Map<String, QualityCheckWordRespDto> getWordDtoMap(Map<String, List<String>> wordMap, String corpId) {
        Set<Object> wordSet = Sets.newHashSet();
        if (wordMap.isEmpty()) {
            return Maps.newHashMap();
        }
        for (List<String> list : wordMap.values()) {
            wordSet.addAll(list);
        }
        if (CollectionUtils.isEmpty((Collection)wordSet)) {
            return Maps.newHashMap();
        }
        Set userIds = this.userRoleCommonService.getManageUserIds();
        Map wordNumIdMap = this.qualityCheckWordGroupMapper.queryGroupIdByNums(corpId, (Collection)wordSet, (Collection)userIds);
        if (wordNumIdMap.isEmpty()) {
            return Maps.newHashMap();
        }
        wordSet = wordNumIdMap.keySet();
        Map wordNameMap = this.qualityCheckWordGroupMapper.queryGroupMapByNums(corpId, (Collection)wordSet);
        Map wordListMap = this.qualityCheckWordsMapper.queryWordList(wordNumIdMap.values(), corpId);
        HashMap result = Maps.newHashMap();
        for (String string : wordSet) {
            QualityCheckWordRespDto dto = new QualityCheckWordRespDto();
            result.put(string, dto);
            dto.setId(string);
            dto.setSensitiveWord((String)wordNameMap.get(string));
            dto.setKeyWords((List)wordListMap.get(wordNumIdMap.get(string)));
        }
        return result;
    }

    private Map<String, StrIdAndNameDto> getBehaviorDtoMap(Map<String, List<String>> behaviorMap, String corpId) {
        HashSet behaviorSet = Sets.newHashSet();
        if (behaviorMap.isEmpty()) {
            return Maps.newHashMap();
        }
        for (List<String> list : behaviorMap.values()) {
            behaviorSet.addAll(list);
        }
        if (CollectionUtils.isEmpty((Collection)behaviorSet)) {
            return Maps.newHashMap();
        }
        List behaviors = this.behaviorSettingMapper.queryBehaviorlist(corpId);
        Map<String, String> behavoirNameMap = behaviors.stream().collect(Collectors.toMap(QualityCheckBehaviorSetting::getNum, QualityCheckBehaviorSetting::getCheckDesc));
        HashMap result = Maps.newHashMap();
        for (String behaviorNum : behaviorSet) {
            StrIdAndNameDto dto = new StrIdAndNameDto();
            dto.setId(behaviorNum);
            dto.setName(behavoirNameMap.get(behaviorNum));
            result.put(behaviorNum, dto);
        }
        return result;
    }
}

