/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.ProviderApi;
import cn.kinyun.wework.sdk.entity.provider.CorpInfo;
import cn.kinyun.wework.sdk.entity.provider.LoginInfo;
import cn.kinyun.wework.sdk.entity.provider.UserInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.LoginErrorType;
import com.kuaike.scrm.common.enums.SystemRoleType;
import com.kuaike.scrm.common.enums.WeworkRoleTypeEnum;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.service.PersonQuickReplyCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserRole;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserRoleMapper;
import com.kuaike.scrm.permission.dto.LoginCallbackDto;
import com.kuaike.scrm.permission.service.LoginCommonService;
import com.kuaike.scrm.permission.service.LoginService;
import com.kuaike.scrm.permission.service.QyapiLoginService;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.ProviderTokenService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QyapiLoginServiceImpl
implements QyapiLoginService {
    private static final Logger log = LoggerFactory.getLogger(QyapiLoginServiceImpl.class);
    @Value(value="${qyapi.corp.id}")
    private String corpId;
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Value(value="${scrm.biz.numCount}")
    private Integer numCount;
    @Autowired
    private ProviderApi providerApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private ProviderTokenService providerTokenService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private PersonQuickReplyCommonService personQuickReplyCommonService;
    @Autowired
    private WeworkUserRoleMapper weworkUserRoleMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private LoginCommonService loginCommonService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LoginCallbackDto suiteLoginCallback(String authCode, String state) {
        log.info("login callback, auth_code={}, state={}", (Object)authCode, (Object)state);
        LoginCallbackDto dto = new LoginCallbackDto();
        String accessToken = this.providerTokenService.getProviderToken();
        if (accessToken == null) {
            dto.setCode(-1);
            return dto;
        }
        LoginInfo loginInfo = null;
        try {
            loginInfo = this.providerApi.getLoginInfo(accessToken, authCode);
        }
        catch (WeworkException e) {
            log.error("failed, authCode:{}, state:{}", new Object[]{authCode, state, e});
            dto.setCode(-1);
            return dto;
        }
        catch (Exception e) {
            log.error("failed, authCode:{}, state:{}", new Object[]{authCode, state, e});
            dto.setCode(-1);
            return dto;
        }
        log.info("loginInfo:{}", (Object)loginInfo);
        CorpInfo corpInfo = loginInfo.getCorpInfo();
        UserInfo userInfo = loginInfo.getUserInfo();
        String authCorpId = corpInfo.getCorpId();
        String authUserId = userInfo.getUserId();
        if (!authCorpId.startsWith("wp")) {
            try {
                String openCorpId = this.customizedApi.getOpenCorpId(accessToken, authCorpId);
                log.info("\u7b2c\u4e09\u65b9\u626b\u7801\u767b\u5f55, ({},{}) -> ({},{})", new Object[]{authCorpId, authUserId, openCorpId, userInfo.getOpenUserId()});
                authCorpId = openCorpId;
                authUserId = userInfo.getOpenUserId();
            }
            catch (WeworkException e) {
                log.error("\u83b7\u53d6open corpId \u5931\u8d25", (Throwable)e);
            }
        }
        int code = this.suiteLogin(authCorpId, authUserId);
        dto.setCode(code);
        dto.setCorpId(authCorpId);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LoginCallbackDto agentLoginCallback(String authCode, String state) {
        log.info("login callback, auth_code={}, state={}", (Object)authCode, (Object)state);
        LoginCallbackDto dto = new LoginCallbackDto();
        String accessToken = this.providerTokenService.getProviderToken();
        if (accessToken == null) {
            dto.setCode(-1);
            return dto;
        }
        LoginInfo loginInfo = null;
        try {
            loginInfo = this.providerApi.getLoginInfo(accessToken, authCode);
        }
        catch (WeworkException e) {
            log.error("failed, authCode:{}, state:{}", new Object[]{authCode, state, e});
            dto.setCode(-1);
            return dto;
        }
        catch (Exception e) {
            log.error("failed, authCode:{}, state:{}", new Object[]{authCode, state, e});
            dto.setCode(-1);
            return dto;
        }
        log.info("loginInfo:{}", (Object)loginInfo);
        CorpInfo corpInfo = loginInfo.getCorpInfo();
        UserInfo userInfo = loginInfo.getUserInfo();
        String corpId = corpInfo.getCorpId();
        String weworkUserId = userInfo.getUserId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (weworkUser != null) {
            this.updateWeworkUser(userInfo, weworkUser);
        }
        int code = this.login(corpId, weworkUserId);
        dto.setCode(code);
        dto.setCorpId(corpId);
        return dto;
    }

    @Override
    public int installCallback(String authCorpId) {
        BusinessCustomer biz = this.businessCustomerMapper.getByAuthCorpId(authCorpId);
        return this.suiteLogin(biz.getAuthCorpId(), biz.getApplyWeworkUserId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int suiteLogin(String authCorpId, String authUserId) {
        log.info("suite login, authCorpId={}, authUserId={}", (Object)authCorpId, (Object)authUserId);
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByAuthCorpId(authCorpId);
        if (weworkCorp == null) {
            log.warn("wework_corp is null, authCorpId={}", (Object)authCorpId);
            return LoginErrorType.CORP_UN_AUTH.getValue();
        }
        if (weworkCorp.getIsAuth() == null || weworkCorp.getIsAuth() == 0) {
            if (weworkCorp.getDeauthTime() == null) {
                log.warn("wework_corp is not auth, authCorpId={}", (Object)authCorpId);
                return LoginErrorType.CORP_UN_AUTH.getValue();
            }
            log.warn("wework_corp canceled auth, authCorpId={}", (Object)authCorpId);
            return LoginErrorType.CANCEL_AUTH.getValue();
        }
        Long bizId = weworkCorp.getBizId();
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndAuthUserId(bizId, authUserId);
        if (weworkUser == null) {
            log.warn("wework_user is null, bizId={}, authCorpId={}, authUserId={}", new Object[]{bizId, authCorpId, authUserId});
            return LoginErrorType.USER_UN_AUTH.getValue();
        }
        if (authUserId.equals(biz.getApplyWeworkUserId())) {
            log.info("corp admin login, weworkUserId:{}", (Object)authUserId);
        } else {
            if (weworkUser.getIsAgentAuth() == null || weworkUser.getIsAgentAuth() == 0) {
                log.warn("wework_user suite is not auth, bizId={}, authCorpId={}, authUserId={}", new Object[]{bizId, authCorpId, authUserId});
                return LoginErrorType.USER_UN_AUTH.getValue();
            }
            if (weworkUser.getSyncStatus().intValue() != WeworkUserSyncStatus.SYNCHRONIZED.getValue()) {
                log.warn("wework_user is not synchronized, bizId={}, authCorpId={}, authUserId={}", new Object[]{bizId, authCorpId, authUserId});
                return LoginErrorType.USER_UN_SYNC.getValue();
            }
        }
        String weworkUserId = weworkUser.getWeworkUserId();
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUserId, corpId);
        boolean isFitAccountLimit = this.loginCommonService.isFitAccountLimit(biz, user);
        if (!isFitAccountLimit) {
            log.info("login: \u8d85\u51fa\u8d26\u53f7\u9650\u5236 biz:{},user:{}", (Object)authUserId, (Object)user);
            return LoginErrorType.OVER_LIMIT.getValue();
        }
        if (user == null) {
            log.info("login: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUserId:{}, weworkUser:{}", new Object[]{bizId, authUserId, weworkUser});
            user = this.userService.insertUser(weworkUser, true);
        } else {
            if (NumberUtils.INTEGER_ONE.equals(user.getIsDeleted())) {
                user.setIsDeleted(NumberUtils.INTEGER_ZERO);
                this.userMapper.updateByPrimaryKey((Object)user);
            }
            if (NumberUtils.INTEGER_ZERO.equals(user.getIsOpen())) {
                user.setIsOpen(NumberUtils.INTEGER_ONE);
                user.setUpdateTime(new Date());
                this.userMapper.updateByPrimaryKey((Object)user);
            }
        }
        Integer bizCount = biz.getNumCount();
        if (Objects.isNull(bizCount) || bizCount < 0) {
            biz.setNumCount(this.numCount);
            biz.setUpdateTime(new Date());
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
        }
        Boolean isAdmin = authUserId.equals(biz.getApplyWeworkUserId());
        this.initDefaultUserRole(biz, user, isAdmin);
        if (Objects.nonNull(biz) && Objects.nonNull(user)) {
            this.personQuickReplyCommonService.initDefaultPersonQuickReply(biz.getId(), biz.getCorpId(), user.getId());
        }
        if (!(authUserId.equals(biz.getApplyWeworkUserId()) || user.getEnabled() != null && user.getEnabled() != 0)) {
            log.warn("user is disabled, userId={}", (Object)user.getId());
            return LoginErrorType.UN_ENABLE_ACCOUNT.getValue();
        }
        LoginUtils.setLoginAccountId((Long)user.getId());
        CurrentUserInfo info = this.loginService.getCurrentUserInfo();
        LoginUtils.setCurrentUser((CurrentUserInfo)info);
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237:{}", (Object)info);
        return LoginErrorType.LOGIN_SUCCESS.getValue();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int login(String corpId, String weworkUserId) {
        boolean isFitAccountLimit;
        log.info("agent login, corpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUserId);
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp == null) {
            log.warn("wework_corp is null, corpId={}", (Object)corpId);
            return LoginErrorType.CORP_UN_AUTH.getValue();
        }
        if (weworkCorp.getIsAuth() == null || weworkCorp.getIsAuth() == 0) {
            if (weworkCorp.getDeauthTime() == null) {
                log.warn("wework_corp is not auth, corpId={}", (Object)corpId);
                return LoginErrorType.CORP_UN_AUTH.getValue();
            }
            log.warn("wework_corp has canceled auth, corpId={}", (Object)corpId);
            return LoginErrorType.CANCEL_AUTH.getValue();
        }
        Long bizId = weworkCorp.getBizId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUserId, corpId);
        if (weworkUser == null) {
            log.warn("wework_user is null, corpId={}", (Object)corpId);
            return LoginErrorType.USER_UN_AUTH.getValue();
        }
        String authUserId = weworkUser.getAuthUserId();
        if (weworkUser.getIsAgentAuth() == null || weworkUser.getIsAgentAuth() == 0) {
            if (authUserId.equals(biz.getApplyWeworkUserId())) {
                log.info("corp admin login, weworkUserId:{}", (Object)weworkUserId);
            } else {
                log.warn("wework_user is not authed, corpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUserId);
                return LoginErrorType.USER_UN_AUTH.getValue();
            }
        }
        if (!(isFitAccountLimit = this.loginCommonService.isFitAccountLimit(biz, user))) {
            log.info("login: \u8d85\u51fa\u8d26\u53f7\u9650\u5236 biz:{},user:{}", (Object)weworkUserId, (Object)user);
            return LoginErrorType.OVER_LIMIT.getValue();
        }
        if (user == null) {
            log.info("login: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUserId:{}, weworkUser:{}", new Object[]{bizId, weworkUserId, weworkUser});
            user = this.userService.insertUser(weworkUser, true);
        } else {
            if (NumberUtils.INTEGER_ONE.equals(user.getIsDeleted())) {
                user.setIsDeleted(NumberUtils.INTEGER_ZERO);
                this.userMapper.updateByPrimaryKey((Object)user);
            }
            if (NumberUtils.INTEGER_ZERO.equals(user.getIsOpen())) {
                user.setIsOpen(NumberUtils.INTEGER_ONE);
                user.setUpdateTime(new Date());
                this.userMapper.updateByPrimaryKey((Object)user);
            }
        }
        Integer bizCount = biz.getNumCount();
        if (Objects.isNull(bizCount) || bizCount < 0) {
            biz.setNumCount(this.numCount);
            biz.setUpdateTime(new Date());
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
        }
        Boolean isAdmin = weworkUser.getAuthUserId().equals(biz.getApplyWeworkUserId());
        this.initDefaultUserRole(biz, user, isAdmin);
        if (Objects.nonNull(user)) {
            this.personQuickReplyCommonService.initDefaultPersonQuickReply(biz.getId(), biz.getCorpId(), user.getId());
        }
        if (!(authUserId.equals(biz.getApplyWeworkUserId()) || user.getEnabled() != null && user.getEnabled() != 0)) {
            log.warn("user is disabled, userId={}", (Object)user.getId());
            return LoginErrorType.UN_ENABLE_ACCOUNT.getValue();
        }
        LoginUtils.setLoginAccountId((Long)user.getId());
        CurrentUserInfo info = this.loginService.getCurrentUserInfo();
        LoginUtils.setCurrentUser((CurrentUserInfo)info);
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237:{}", (Object)info);
        return LoginErrorType.LOGIN_SUCCESS.getValue();
    }

    private void updateWeworkUser(UserInfo userInfo, WeworkUser weworkUser) {
        WeworkUser weworkUser1 = new WeworkUser();
        weworkUser1.setId(weworkUser.getId());
        boolean flag = false;
        if (StringUtils.isBlank((CharSequence)weworkUser.getOpenUserId())) {
            weworkUser1.setOpenUserId(userInfo.getOpenUserId());
            weworkUser.setOpenUserId(userInfo.getOpenUserId());
            flag = true;
        }
        if (StringUtils.isBlank((CharSequence)weworkUser.getAvatar())) {
            weworkUser1.setAvatar(userInfo.getAvatar());
            weworkUser.setAvatar(userInfo.getAvatar());
            flag = true;
        }
        if (flag) {
            weworkUser1.setUpdateTime(new Date());
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser1);
            log.info("update wework_user, userInfo={}", (Object)userInfo);
        }
    }

    private void initDefaultUserRole(BusinessCustomer biz, User user, Boolean isAdmin) {
        Long roleId;
        if (biz.getSyncStatus() == 0) {
            log.info("biz is not synchronized. Skip init user role.");
            return;
        }
        log.info("initDefaultUserRole,userId:{}", (Object)user.getId());
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        Long userId = user.getId();
        Integer roleType = SystemRoleType.NORMAL.getValue();
        Long manageNodeId = null;
        if (isAdmin.booleanValue()) {
            roleType = SystemRoleType.ADMIN.getValue();
            manageNodeId = this.organizationMapper.selectRootNodeIdByBizIdAndCorpId(bizId, corpId);
        }
        if (Objects.isNull(roleId = this.roleMapper.selectSystemRoleIdByCorpIdAndType(corpId, roleType))) {
            log.warn("\u5546\u6237bizId:{}\u8fd8\u672a\u521d\u59cb\u5316\u9ed8\u8ba4\u89d2\u8272:{}", (Object)bizId, (Object)roleType);
            return;
        }
        UserRole record = new UserRole();
        record.setUserId(userId);
        List hasRoles = this.userRoleMapper.select((Object)record);
        if (CollectionUtils.isNotEmpty((Collection)hasRoles)) {
            return;
        }
        List userRoles = this.userRoleMapper.queryUserRoles(bizId, roleId, userId);
        if (CollectionUtils.isNotEmpty((Collection)userRoles)) {
            if (roleType.intValue() == SystemRoleType.NORMAL.getValue()) {
                return;
            }
            Set manageNodeIds = userRoles.stream().map(it -> it.getManageNodeId()).collect(Collectors.toSet());
            if (manageNodeIds.contains(manageNodeId)) {
                return;
            }
        }
        UserRole userRole = new UserRole();
        userRole.setUserId(userId);
        userRole.setRoleId(roleId);
        userRole.setBizId(bizId);
        userRole.setCorpId(corpId);
        if (Objects.nonNull(manageNodeId)) {
            userRole.setManageNodeId(manageNodeId);
        }
        userRole.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        userRole.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        userRole.setCreateTime(new Date());
        userRole.setUpdateTime(new Date());
        userRole.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.userRoleMapper.insertSelective((Object)userRole);
    }

    @Deprecated
    private void initWeworkUserRole(BusinessCustomer biz, WeworkUser weworkUser) {
        if (biz.getSyncStatus() == 0) {
            log.info("biz is not synchronized. Skip init wework user role.");
            return;
        }
        WeworkUserRole weworkUserRole = this.weworkUserRoleMapper.selectByCorpIdAndWeworkUserNum(biz.getCorpId(), weworkUser.getNum());
        if (Objects.nonNull(weworkUserRole)) {
            log.info("corpId:{},weworkUserNum:{}\u5df2\u7ecf\u914d\u7f6e\u4e86\u4f01\u5fae\u89d2\u8272:{}", new Object[]{biz.getCorpId(), weworkUser.getNum(), weworkUserRole.getWeworkRoleType()});
            return;
        }
        weworkUserRole = new WeworkUserRole();
        weworkUserRole.setBizId(biz.getId());
        weworkUserRole.setCorpId(biz.getCorpId());
        weworkUserRole.setWeworkUserNum(weworkUser.getNum());
        weworkUserRole.setCreateTime(new Date());
        weworkUserRole.setUpdateTime(new Date());
        weworkUserRole.setWeworkRoleType(Integer.valueOf(WeworkRoleTypeEnum.NORMAL.getValue()));
        if (biz.getApplyWeworkUserId().equals(weworkUser.getAuthUserId())) {
            weworkUserRole.setWeworkRoleType(Integer.valueOf(WeworkRoleTypeEnum.ADMIN.getValue()));
        }
        this.weworkUserRoleMapper.saveWeworkUserRole(weworkUserRole);
    }
}

