/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.perm.dto.PermissionDto;
import com.kuaike.scrm.common.perm.service.PermScanner;
import com.kuaike.scrm.dal.permission.entity.Permission;
import com.kuaike.scrm.dal.permission.mapper.PermissionMapper;
import com.kuaike.scrm.permission.dto.response.PermissionGroupRespDto;
import com.kuaike.scrm.permission.dto.response.PermissionRespDto;
import com.kuaike.scrm.permission.feign.AdPermScanner;
import com.kuaike.scrm.permission.feign.CrmPermScanner;
import com.kuaike.scrm.permission.feign.IPermScanner;
import com.kuaike.scrm.permission.feign.PayPermScanner;
import com.kuaike.scrm.permission.feign.RestResult;
import com.kuaike.scrm.permission.feign.TradePermScanner;
import com.kuaike.scrm.permission.service.PermissionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private PermScanner permScanner;
    @Autowired
    private CrmPermScanner crmPermScanner;
    @Autowired
    private TradePermScanner tradePermScanner;
    @Autowired
    private AdPermScanner adPermScanner;
    @Autowired
    private PayPermScanner payPermScanner;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(String token, SystemTypeEnum systemTypeEnum) {
        Long userId = -1L;
        log.info("update permission table...");
        if (!Objects.equals(this.permScanner.getToken(), token)) {
            log.warn("invalid token:{}", (Object)token);
            throw new IllegalArgumentException("Invalid token");
        }
        List<PermissionDto> perms = this.scan(token, systemTypeEnum);
        if (CollectionUtils.isEmpty(perms)) {
            log.warn("no permission found.");
            return;
        }
        ArrayList permissions = Lists.newArrayList();
        for (PermissionDto perm : perms) {
            Permission permission = new Permission();
            permission.setCode(perm.getCode());
            permission.setName(perm.getName());
            permission.setModuleName(perm.getModuleName());
            permission.setPath(perm.getPath());
            if (StringUtils.isBlank((CharSequence)perm.getRequestMethod())) {
                permission.setRequestMethod("POST");
            } else {
                permission.setRequestMethod(perm.getRequestMethod());
            }
            Long systemId = (long)this.getSystemType(perm.getCode());
            permission.setSystemId(systemId);
            permissions.add(permission);
        }
        if (CollectionUtils.isEmpty((Collection)permissions)) {
            log.warn("No permission found");
            return;
        }
        HashSet codes = Sets.newHashSet();
        HashSet duplicated = Sets.newHashSet();
        for (Permission permission : permissions) {
            String code = permission.getCode();
            if (codes.contains(code)) {
                duplicated.add(code);
                continue;
            }
            codes.add(permission.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)duplicated)) {
            log.warn("\u6743\u9650\u7f16\u7801\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002codes={}", (Object)duplicated);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6743\u9650\u7f16\u7801\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002codes=" + duplicated);
        }
        List exists = this.permissionMapper.selectByCodes((Collection)codes);
        Map<String, Long> map = exists.stream().collect(Collectors.toMap(Permission::getCode, Permission::getId));
        ArrayList add = Lists.newArrayList();
        ArrayList update = Lists.newArrayList();
        permissions.forEach(p -> {
            Long id = (Long)map.get(p.getCode());
            if (Objects.isNull(id)) {
                p.setCreateBy(userId);
                p.setUpdateBy(userId);
                add.add(p);
            } else {
                p.setId(id);
                p.setUpdateBy(userId);
                update.add(p);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)update)) {
            this.permissionMapper.batchUpdate((List)update);
        }
        if (CollectionUtils.isNotEmpty((Collection)add)) {
            this.permissionMapper.batchInsert((List)add);
        }
    }

    private Integer getSystemType(String code) {
        if (code.startsWith(SystemTypeEnum.CRM.getName())) {
            return SystemTypeEnum.CRM.getValue();
        }
        if (code.startsWith(SystemTypeEnum.TRADE.getName())) {
            return SystemTypeEnum.TRADE.getValue();
        }
        if (code.startsWith(SystemTypeEnum.PAY.getName())) {
            return SystemTypeEnum.PAY.getValue();
        }
        if (code.startsWith(SystemTypeEnum.AD.getName())) {
            return SystemTypeEnum.AD.getValue();
        }
        return SystemTypeEnum.SCRM.getValue();
    }

    @Override
    public List<PermissionGroupRespDto> getAllPermissions() {
        log.info("get all permissions");
        List allPermission = this.permissionMapper.getAllPermissions();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)allPermission), (Object)"\u7cfb\u7edf\u6743\u9650\u8fd8\u672a\u521d\u59cb\u5316");
        Map<String, List<Permission>> moduleName2PermissionsMap = allPermission.stream().collect(Collectors.groupingBy(Permission::getModuleName));
        ArrayList groupRespDtos = Lists.newArrayListWithExpectedSize((int)moduleName2PermissionsMap.size());
        for (Map.Entry<String, List<Permission>> entry : moduleName2PermissionsMap.entrySet()) {
            PermissionGroupRespDto permissionGroupRespDto = new PermissionGroupRespDto();
            groupRespDtos.add(permissionGroupRespDto);
            permissionGroupRespDto.setModuleName(entry.getKey());
            List<Permission> modulePermission = entry.getValue();
            ArrayList permissionRespDtos = Lists.newArrayListWithExpectedSize((int)modulePermission.size());
            permissionGroupRespDto.setPermissions(permissionRespDtos);
            for (Permission permission : modulePermission) {
                PermissionRespDto permissionRespDto = new PermissionRespDto();
                permissionRespDtos.add(permissionRespDto);
                permissionRespDto.setId(permission.getId());
                permissionRespDto.setCode(permission.getCode());
                permissionRespDto.setName(permission.getName());
                permissionRespDto.setPath(permission.getPath());
                permissionRespDto.setSystemId(permission.getSystemId());
                Integer sid = permission.getSystemId().intValue();
                permissionRespDto.setSystemName(SystemTypeEnum.get((int)sid).getDesc());
            }
        }
        return groupRespDtos;
    }

    @Override
    public List<PermissionDto> scan(String token, SystemTypeEnum systemTypeEnum) {
        if (Objects.nonNull(systemTypeEnum)) {
            if (systemTypeEnum.getValue() == SystemTypeEnum.PAY.getValue()) {
                return this.scanPermission(systemTypeEnum.getName(), this.payPermScanner, token);
            }
            if (systemTypeEnum.getValue() == SystemTypeEnum.CRM.getValue()) {
                return this.scanPermission(systemTypeEnum.getName(), this.crmPermScanner, token);
            }
            if (systemTypeEnum.getValue() == SystemTypeEnum.SCRM.getValue()) {
                return this.permScanner.scanAllPerms(token);
            }
            if (systemTypeEnum.getValue() == SystemTypeEnum.AD.getValue()) {
                return this.scanPermission(systemTypeEnum.getName(), this.adPermScanner, token);
            }
            if (systemTypeEnum.getValue() == SystemTypeEnum.TRADE.getValue()) {
                return this.scanPermission(systemTypeEnum.getName(), this.tradePermScanner, token);
            }
        }
        List result = this.permScanner.scanAllPerms(token);
        List<PermissionDto> list = this.scanPermission(SystemTypeEnum.CRM.getName(), this.crmPermScanner, token);
        if (CollectionUtils.isNotEmpty(list)) {
            result.addAll(list);
        }
        if (CollectionUtils.isNotEmpty(list = this.scanPermission(SystemTypeEnum.TRADE.getName(), this.tradePermScanner, token))) {
            result.addAll(list);
        }
        if (CollectionUtils.isNotEmpty(list = this.scanPermission(SystemTypeEnum.AD.getName(), this.adPermScanner, token))) {
            result.addAll(list);
        }
        if (CollectionUtils.isNotEmpty(list = this.scanPermission(SystemTypeEnum.PAY.getName(), this.payPermScanner, token))) {
            result.addAll(list);
        }
        return result;
    }

    private List<PermissionDto> scanPermission(String name, IPermScanner scanner, String token) {
        try {
            RestResult<List<PermissionDto>> result = scanner.scan(token);
            if (result == null) {
                log.error("\u626b\u63cf{}\u63a5\u53e3\u6743\u9650\u5931\u8d25\uff0c\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c\u3002", (Object)name);
                return Collections.emptyList();
            }
            if (result.getCode() == 0L) {
                return result.getData();
            }
            log.error("\u626b\u63cf{}\u6743\u9650\u5931\u8d25, code={}, msg={}", new Object[]{name, result.getCode(), result.getMsg()});
        }
        catch (Exception e) {
            log.error("\u626b\u63cf{}\u63a5\u53e3\u5931\u8d25", (Object)name, (Object)e);
        }
        return Collections.emptyList();
    }
}

