/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ErrorCodeUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.enums.BizType;
import com.kuaike.scrm.common.enums.LoginErrorType;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.dto.RoleQueryParams;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.system.mapper.VersionMenuMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.permission.dto.SidebarUserInfoDto;
import com.kuaike.scrm.permission.dto.request.DlReqDto;
import com.kuaike.scrm.permission.dto.request.MobileReq;
import com.kuaike.scrm.permission.dto.request.SmsReqDto;
import com.kuaike.scrm.permission.dto.response.CoordinateRespDto;
import com.kuaike.scrm.permission.dto.response.LoginRespDto;
import com.kuaike.scrm.permission.dto.response.UserBizInfo;
import com.kuaike.scrm.permission.dto.response.VerifyCodeRespDto;
import com.kuaike.scrm.permission.service.LoginCommonService;
import com.kuaike.scrm.permission.service.LoginService;
import com.kuaike.scrm.permission.service.QyapiLoginService;
import com.kuaike.scrm.permission.utils.SmsUtil;
import com.kuaike.scrm.system.dto.response.PackageMenuRespDto;
import com.kuaike.scrm.system.service.PackageService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private OrgService orgService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private VersionMenuMapper versionMenuMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private LoginCommonService loginCommonService;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${aliyun.sms.scrm.signName}")
    private String signName;
    @Value(value="${aliyun.sms.verificationCode.templateCode}")
    private String templateCode;
    private static final int[] digit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    @Value(value="${sms.verifyCodeErrorTimes}")
    private int verifyCodeErrorTimes;
    @Value(value="${mobileLogin.lockTime}")
    private int mobileAccountLockTime;
    @Value(value="${scrm.biz.numCount}")
    private Integer numCount;
    @Value(value="${aliyun.sms.verificationCode.templateCode.ad}")
    private String adTemplateCode;
    @Autowired
    private PackageService packageService;
    @Autowired
    private QyapiLoginService qyapiLoginService;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String root;
    @Value(value="${suite.login.failed}")
    private String failedPage;
    private Random random = new Random();

    @Override
    public CurrentUserInfo getCurrentUserInfo() {
        WeworkUser weworkUser;
        Long userId = LoginUtils.getLoginAccountId();
        if (Objects.isNull(userId)) {
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (Objects.isNull(user)) {
            log.info("\u6839\u636e\u7528\u6237id\uff1a{}\u672a\u83b7\u53d6\u5230\u7528\u6237", (Object)userId);
            return null;
        }
        CurrentUserInfo currentUserInfo = new CurrentUserInfo();
        currentUserInfo.setName(user.getName());
        currentUserInfo.setMobile(user.getMobile());
        currentUserInfo.setAvatar(user.getAvatar());
        if (StringUtils.isNotBlank((CharSequence)user.getWeworkUserId()) && Objects.nonNull(weworkUser = this.weworkUserMapper.queryWeworkUserInfo(user.getCorpId(), user.getWeworkUserId()))) {
            currentUserInfo.setWeworkUserNum(weworkUser.getNum());
            if (StringUtils.isNotBlank((CharSequence)weworkUser.getName())) {
                currentUserInfo.setName(weworkUser.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)weworkUser.getAvatar())) {
                currentUserInfo.setAvatar(weworkUser.getAvatar());
            }
        }
        currentUserInfo.setWeworkUserId(user.getWeworkUserId());
        currentUserInfo.setId(user.getId());
        currentUserInfo.setNum(user.getNum());
        currentUserInfo.setIdentifier(user.getIdentifier());
        currentUserInfo.setUserNodeId(user.getNodeId());
        currentUserInfo.setCorpId(user.getCorpId());
        currentUserInfo.setBizId(user.getBizId());
        currentUserInfo.setEnabled(user.getEnabled());
        List<UserRoleRespDto> userRoles = this.getUserRoles(user.getId(), user.getBizId());
        if (CollectionUtils.isNotEmpty(userRoles)) {
            userRoles.sort((o1, o2) -> {
                if (Objects.nonNull(o1.getLatestUseTime()) && Objects.nonNull(o2.getLatestUseTime())) {
                    return o1.getLatestUseTime().equals(o2.getLatestUseTime()) ? 0 : (o1.getLatestUseTime().after(o2.getLatestUseTime()) ? -1 : 1);
                }
                return Objects.isNull(o1.getLatestUseTime()) ? 1 : -1;
            });
            UserRoleRespDto userRole = userRoles.get(0);
            currentUserInfo.setCurRole(userRole);
            currentUserInfo.setRoles(userRoles);
            Set menuCodes = this.roleMenuMapper.queryMenuCodesByRoleIdAndBizId(userRole.getRoleId(), user.getBizId());
            Set<String> bizMenuCodes = this.getBizMenuCode(user.getBizId());
            if (CollectionUtils.isNotEmpty((Collection)menuCodes)) {
                menuCodes.retainAll(bizMenuCodes);
                currentUserInfo.setMenuCodes(menuCodes);
            }
            Set manageNodeIds = currentUserInfo.getCurRole().getManageNodeIds();
            HashSet nodeIds = Sets.newHashSet();
            HashSet nodes = Sets.newHashSet();
            if (manageNodeIds != null && manageNodeIds.size() > 0) {
                for (Long nodeId : manageNodeIds) {
                    if (nodeId == null) continue;
                    nodeIds.add(nodeId);
                    nodeIds.addAll(this.nodeService.getPosterityIds((Collection)Sets.newHashSet((Object[])new Long[]{nodeId}), user.getBizId()));
                    Node node = this.nodeService.getNode(nodeId, user.getBizId());
                    if (!Objects.nonNull(node)) continue;
                    nodes.add(node);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)nodeIds)) {
                currentUserInfo.setNodeIds((List)Lists.newArrayList((Iterable)nodeIds));
            } else {
                currentUserInfo.setNodeIds(new ArrayList());
            }
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                currentUserInfo.setNodes((List)Lists.newArrayList((Iterable)nodes));
            } else {
                currentUserInfo.setNodes(new ArrayList());
            }
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)currentUserInfo.getBizId());
        Date date = businessCustomer.getExpireDate();
        currentUserInfo.setExpireDate(DateUtil.getTheDateBegin((Date)date));
        currentUserInfo.setBizStatus(businessCustomer.getStatus());
        currentUserInfo.setBizName(businessCustomer.getName());
        currentUserInfo.setOpenNetSchool(businessCustomer.getOpenNetSchool());
        this.setRedisValue(userId, currentUserInfo);
        return currentUserInfo;
    }

    private Set<String> getBizMenuCode(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String pkgIds = businessCustomer.getPkgIds();
        log.info("getBizMenuCode pkgIds: {}", (Object)pkgIds);
        Set<String> menuCodes = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)pkgIds)) {
            ArrayList<Long> pkgIdList = new ArrayList<Long>();
            if (pkgIds.contains(",")) {
                for (String s : pkgIds.split(",")) {
                    Long parseLong = Long.parseLong(s);
                    pkgIdList.add(parseLong);
                }
            } else {
                pkgIdList.add(Long.parseLong(pkgIds));
            }
            log.info("treeList pkgIdList: {}", pkgIdList);
            PackageMenuRespDto respDto = this.packageService.packageMenuInfo(pkgIdList);
            if (respDto != null) {
                menuCodes = respDto.getMenuCodes();
            }
        }
        return menuCodes;
    }

    private Object getRedisValue(Long userId) {
        String key = LoginUtils.getUserInfoKey((String)this.redisKeyPrefix, (Long)userId);
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        return valueOperations.get((Object)key);
    }

    private String getExternalTokenKey(String externalToken) {
        return String.format("%s:external:token:%s", this.redisKeyPrefix, externalToken);
    }

    @Override
    public void clearVerifyCodeErrorTimes(MobileReq mobileReq) {
        log.info("clearVerifyCodeErrorTimes,mobileReq:{}", (Object)mobileReq);
        mobileReq.validateParams();
        String verifyCodeErrorTimesKey = this.redisKeyPrefix + "verifyCodeErrorTimes:" + mobileReq.getMobile();
        this.redisTemplate.delete((Object)verifyCodeErrorTimesKey);
    }

    @Override
    public void dl(DlReqDto dlReqDto, HttpSession httpSession) {
        log.info("dl,dlReqDto:{}", (Object)dlReqDto);
        dlReqDto.validateParams();
        Long userId = this.userMapper.getSystemUserIdByCorpId(dlReqDto.getCorpId());
        if (Objects.isNull(userId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u67e5\u8be2\u5230\u7528\u6237");
        }
        httpSession.removeAttribute("EXTERNAL_TOKEN");
        LoginUtils.setLoginAccountId((Long)userId);
    }

    private void setRedisValue(Long userId, Object value) {
        if (Objects.isNull(userId)) {
            return;
        }
        String key = LoginUtils.getUserInfoKey((String)this.redisKeyPrefix, (Long)userId);
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        valueOperations.set((Object)key, value, 2592000L, TimeUnit.SECONDS);
        HttpSession session = LoginUtils.getSession();
        String token = (String)session.getAttribute("EXTERNAL_TOKEN");
        if (token == null) {
            String uuid = UUID.randomUUID().toString();
            token = Base64.getEncoder().encodeToString(uuid.getBytes(StandardCharsets.UTF_8));
            session.setAttribute("EXTERNAL_TOKEN", (Object)token);
            String redisKey = this.getExternalTokenKey(token);
            HashOperations hash = this.redisTemplate.opsForHash();
            hash.put((Object)redisKey, (Object)"sessionId", (Object)session.getId());
            hash.put((Object)redisKey, (Object)"userId", (Object)userId);
            this.redisTemplate.expire((Object)redisKey, 2592000L, TimeUnit.SECONDS);
        }
    }

    @Override
    public CurrentUserInfo changeRole(Long roleId, HttpServletRequest request) {
        log.info("changeRole,roleId:{}", (Object)roleId);
        Preconditions.checkArgument((boolean)Objects.nonNull(roleId), (Object)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Map roleMap = currentUserInfo.getRoles().stream().collect(Collectors.toMap(UserRoleRespDto::getRoleId, Function.identity()));
        if (!roleMap.containsKey(roleId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5458\u5de5\u6ca1\u6709\u8be5\u89d2\u8272");
        }
        UserRoleRespDto currentRole = (UserRoleRespDto)roleMap.get(roleId);
        currentUserInfo.setCurRole(currentRole);
        currentUserInfo.setMenuCodes(this.roleMenuMapper.getMenuCodesByRoleId(roleId, currentUserInfo.getBizId()));
        Set manageNodeIds = currentRole.getManageNodeIds();
        HashSet manageNodeIdsIncludeChildren = new HashSet();
        HashSet nodes = Sets.newHashSet();
        if (manageNodeIds != null && manageNodeIds.size() > 0) {
            for (Long nodeId : manageNodeIds) {
                if (nodeId == null) continue;
                manageNodeIdsIncludeChildren.addAll(this.nodeService.getPosterityIds((Collection)Sets.newHashSet((Object[])new Long[]{nodeId}), currentUserInfo.getBizId()));
                nodes.add(this.nodeService.getNode(nodeId, currentUserInfo.getBizId()));
            }
        }
        if (CollectionUtils.isNotEmpty(manageNodeIdsIncludeChildren)) {
            currentUserInfo.setNodeIds(new ArrayList(manageNodeIdsIncludeChildren));
        } else {
            currentUserInfo.setNodeIds(new ArrayList());
        }
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            currentUserInfo.setNodes((List)Lists.newArrayList((Iterable)nodes));
        } else {
            currentUserInfo.setNodes(new ArrayList());
        }
        Long userId = LoginUtils.getLoginAccountId();
        this.setRedisValue(userId, currentUserInfo);
        this.userRoleMapper.updateLatestUseTime(userId, roleId, currentUserInfo.getBizId());
        return currentUserInfo;
    }

    @Override
    public void logout(HttpServletRequest req, HttpSession httpSession) {
        String token = (String)httpSession.getAttribute("EXTERNAL_TOKEN");
        if (token != null) {
            String externalTokenKey = this.getExternalTokenKey(token);
            this.redisTemplate.delete((Object)externalTokenKey);
            httpSession.removeAttribute("EXTERNAL_TOKEN");
        }
        LoginUtils.deleteCurrentUser(this.redisTemplate, (String)this.redisKeyPrefix);
        LoginUtils.removeLoginAccountId();
    }

    @Override
    public CurrentUserInfo getUserCombinationInfo(HttpServletRequest request, HttpServletResponse response) {
        Long userId = LoginUtils.getLoginAccountId();
        log.info("getUserCombinationInfo,userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return null;
        }
        Object currentUserInfoInRedis = this.getRedisValue(userId);
        CurrentUserInfo currentUserInfo = currentUserInfoInRedis instanceof CurrentUserInfo ? (CurrentUserInfo)currentUserInfoInRedis : this.getCurrentUserInfo();
        if (Objects.isNull(currentUserInfo)) {
            return null;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)currentUserInfo.getBizId());
        if (businessCustomer == null) {
            log.warn("business customer is not found, bizId={}", (Object)currentUserInfo.getBizId());
            return null;
        }
        currentUserInfo.setBizStatus(businessCustomer.getStatus());
        currentUserInfo.setOpenNetSchool(businessCustomer.getOpenNetSchool());
        this.userMapper.updateLastLoginDateById(userId);
        log.info("\u66f4\u65b0\u7528\u6237userId:{}\u6700\u8fd1\u7684\u767b\u5f55\u65f6\u95f4", (Object)userId);
        this.appendMenuCodes(currentUserInfo);
        currentUserInfo.setMobile(MobileUtils.encryptMobile((String)currentUserInfo.getMobile()));
        return currentUserInfo;
    }

    @Override
    public SidebarUserInfoDto sidebarGetUserInfo(HttpServletRequest request, HttpServletResponse response) {
        CurrentUserInfo userInfo = this.getUserCombinationInfo(request, response);
        if (userInfo == null) {
            return null;
        }
        SidebarUserInfoDto userInfoDto = new SidebarUserInfoDto();
        userInfoDto.setCorpId(userInfo.getCorpId());
        userInfoDto.setWeworkUserId(userInfo.getWeworkUserId());
        userInfoDto.setWeworkUserNum(userInfo.getWeworkUserNum());
        return userInfoDto;
    }

    @Override
    public CoordinateRespDto getCoordinates(SmsReqDto reqDto) {
        log.info("getCoordinates,reqDto:{}", (Object)reqDto);
        reqDto.validateCoordinateParams();
        String redisKey = this.redisKeyPrefix + "coordinate:" + reqDto.getMobile();
        int width = this.random.nextInt(reqDto.getW() - 10);
        int height = this.random.nextInt(reqDto.getH() - 10);
        log.info("getCoordinates,width:{},height:{}", (Object)width, (Object)height);
        String w = this.getBase64EncodeCoordinate(width);
        String h = this.getBase64EncodeCoordinate(height);
        log.info("getCoordinates,w:{},h:{}", (Object)w, (Object)h);
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)(width + "," + height), 10L, TimeUnit.MINUTES);
        CoordinateRespDto coordinateRespDto = new CoordinateRespDto();
        coordinateRespDto.setW(w);
        coordinateRespDto.setH(h);
        return coordinateRespDto;
    }

    @Override
    public VerifyCodeRespDto sendSmsVerifyCode(SmsReqDto reqDto) {
        List users;
        log.info("sendSmsVerifyCode,reqDto:{}", (Object)reqDto);
        reqDto.validateSendVerifyCodeParams();
        VerifyCodeRespDto verifyCodeRespDto = new VerifyCodeRespDto();
        String verifyCodeErrorTimesKey = this.redisKeyPrefix + "verifyCodeErrorTimes:" + reqDto.getMobile();
        Object redisVal = this.redisTemplate.opsForValue().get((Object)verifyCodeErrorTimesKey);
        if (Objects.nonNull(redisVal)) {
            int errorTimes = (Integer)redisVal;
            log.info("\u624b\u673a\u53f7:{}\u5bf9\u5e94\u7684\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u4e3a:{}", (Object)reqDto.getMobile(), (Object)this.verifyCodeErrorTimes);
            if (errorTimes >= this.verifyCodeErrorTimes) {
                verifyCodeRespDto.setResult(false);
                verifyCodeRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef\u6b21\u6570\u5df2\u8fbe" + this.verifyCodeErrorTimes + "\u6b21,\u8bf7" + this.mobileAccountLockTime + "\u5c0f\u65f6\u540e\u91cd\u8bd5");
                return verifyCodeRespDto;
            }
        }
        if (CollectionUtils.isEmpty((Collection)(users = this.userMapper.selectUserByMobile(reqDto.getMobile())))) {
            log.info("\u6839\u636e\u624b\u673a\u53f7:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)reqDto.getMobile());
            verifyCodeRespDto.setResult(false);
            verifyCodeRespDto.setMsg("\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return verifyCodeRespDto;
        }
        String coordinateRedisKey = this.redisKeyPrefix + "coordinate:" + reqDto.getMobile();
        String coordinate = (String)this.redisTemplate.opsForValue().get((Object)coordinateRedisKey);
        if (StringUtils.isBlank((CharSequence)coordinate)) {
            log.info("\u6839\u636eredisKey:{}\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u7684\u503c", (Object)coordinateRedisKey);
            verifyCodeRespDto.setResult(false);
            verifyCodeRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return verifyCodeRespDto;
        }
        String x = new String(Base64.getDecoder().decode(Base64.getDecoder().decode(reqDto.getX())));
        String y = new String(Base64.getDecoder().decode(Base64.getDecoder().decode(reqDto.getY())));
        String decodeCoordinate = x + "," + y;
        if (!coordinate.equals(decodeCoordinate)) {
            log.info("\u524d\u7aef\u4f20\u5165\u7684\u5750\u6807:{}, \u540e\u7aef\u5b58\u7684\u5750\u6807:{}\u4e0d\u4e00\u81f4", (Object)decodeCoordinate, (Object)coordinate);
            verifyCodeRespDto.setResult(false);
            verifyCodeRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return verifyCodeRespDto;
        }
        String verifyCode = this.getVerifyCode();
        String verifyCodeRedisKey = this.redisKeyPrefix + "verifyCode:" + reqDto.getMobile();
        this.redisTemplate.opsForValue().set((Object)verifyCodeRedisKey, (Object)verifyCode, 10L, TimeUnit.MINUTES);
        String params = "{\"code\":" + verifyCode + "}";
        boolean result = SmsUtil.sendSms(reqDto.getMobile(), this.signName, this.templateCode, params);
        log.info("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801,mobile:{},verifyCode:{}, result:{}", new Object[]{reqDto.getMobile(), verifyCode, result});
        verifyCodeRespDto.setResult(true);
        return verifyCodeRespDto;
    }

    @Override
    public void getSmsVerifyCode(SmsReqDto reqDto) {
        log.info("getSmsVerifyCode,reqDto:{}", (Object)reqDto);
        if (reqDto == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getMobile())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String verifyCodeRedisKey = this.redisKeyPrefix + "smsVerifyCode:" + reqDto.getMobile();
        Object existsVerifyCode = this.redisTemplate.opsForValue().get((Object)verifyCodeRedisKey);
        if (existsVerifyCode != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        String verifyCode = this.getVerifyCode();
        String params = "{\"code\":" + verifyCode + "}";
        boolean result = SmsUtil.sendSms(reqDto.getMobile(), this.signName, this.adTemplateCode, params);
        if (result) {
            this.redisTemplate.opsForValue().set((Object)verifyCodeRedisKey, (Object)verifyCode, 10L, TimeUnit.MINUTES);
        }
        log.info("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801,mobile:{},verifyCode:{}, result:{}", new Object[]{reqDto.getMobile(), verifyCode, result});
    }

    @Override
    public LoginRespDto login(SmsReqDto reqDto, HttpSession httpSession) {
        log.info("login,reqDto:{}", (Object)reqDto);
        reqDto.validateLoginParams();
        LoginRespDto loginRespDto = new LoginRespDto();
        List users = this.userMapper.selectUserByMobile(reqDto.getMobile());
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.info("\u6839\u636e\u624b\u673a\u53f7:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)reqDto.getMobile());
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return loginRespDto;
        }
        String coordinateRedisKey = this.redisKeyPrefix + "coordinate:" + reqDto.getMobile();
        String coordinate = (String)this.redisTemplate.opsForValue().get((Object)coordinateRedisKey);
        if (StringUtils.isBlank((CharSequence)coordinate)) {
            log.info("\u6839\u636eredisKey:{}\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u7684\u503c", (Object)coordinateRedisKey);
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginRespDto;
        }
        String x = new String(Base64.getDecoder().decode(Base64.getDecoder().decode(reqDto.getX())));
        String y = new String(Base64.getDecoder().decode(Base64.getDecoder().decode(reqDto.getY())));
        String decodeCoordinate = x + "," + y;
        if (!coordinate.equals(decodeCoordinate)) {
            log.info("\u524d\u7aef\u4f20\u5165\u7684\u5750\u6807:{}, \u540e\u7aef\u5b58\u7684\u5750\u6807:{}\u4e0d\u4e00\u81f4", (Object)decodeCoordinate, (Object)coordinate);
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginRespDto;
        }
        String verifyCodeRedisKey = this.redisKeyPrefix + "verifyCode:" + reqDto.getMobile();
        String verifyCode = (String)this.redisTemplate.opsForValue().get((Object)verifyCodeRedisKey);
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            log.info("\u6839\u636everifyCodeRedisKey:{}\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u7684\u503c", (Object)verifyCodeRedisKey);
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginRespDto;
        }
        String verifyCodeErrorTimesKey = this.redisKeyPrefix + "verifyCodeErrorTimes:" + reqDto.getMobile();
        if (!verifyCode.equals(reqDto.getCode())) {
            Object redisVal = this.redisTemplate.opsForValue().get((Object)verifyCodeErrorTimesKey);
            if (Objects.isNull(redisVal)) {
                this.redisTemplate.opsForValue().set((Object)verifyCodeErrorTimesKey, (Object)NumberUtils.INTEGER_ONE, (long)this.mobileAccountLockTime, TimeUnit.HOURS);
            } else {
                int verifyCodeErrorTimes = (Integer)redisVal;
                this.redisTemplate.opsForValue().set((Object)verifyCodeErrorTimesKey, (Object)(verifyCodeErrorTimes + 1), this.redisTemplate.getExpire((Object)verifyCodeErrorTimesKey).longValue(), TimeUnit.SECONDS);
            }
            log.info("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u524d\u7aef\u4f20\u5165\u7684:{},\u540e\u7aef\u7f13\u5b58\u7684:{}", (Object)reqDto.getCode(), (Object)verifyCode);
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginRespDto;
        }
        this.redisTemplate.delete((Object)verifyCodeErrorTimesKey);
        LoginUtils.setLoginMobile((String)reqDto.getMobile());
        loginRespDto.setResult(true);
        ArrayList bizInfos = Lists.newArrayList();
        loginRespDto.setBizInfos(bizInfos);
        for (User user : users) {
            UserBizInfo userBizInfo = new UserBizInfo();
            bizInfos.add(userBizInfo);
            userBizInfo.setBizId(user.getBizId());
            userBizInfo.setCorpId(user.getCorpId());
            userBizInfo.setName(user.getBizName());
            userBizInfo.setUserId(user.getNum());
        }
        return loginRespDto;
    }

    @Override
    public LoginRespDto selectBiz(UserBizInfo userBizInfo, HttpSession httpSession) {
        Integer bizCount;
        boolean isFitAccountLimit;
        log.info("selectBiz,userBizInfo:{}", (Object)userBizInfo);
        userBizInfo.validateParams();
        LoginRespDto loginRespDto = new LoginRespDto();
        String mobile = LoginUtils.getLoginMobile();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.error("httpSession\u4e2d\u672a\u83b7\u53d6\u5230\u624b\u673a\u53f7");
            loginRespDto.setResult(false);
            return loginRespDto;
        }
        User user = this.userMapper.selectUserByMobileAndCorpId(mobile, userBizInfo.getCorpId());
        if (Objects.isNull(user)) {
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return loginRespDto;
        }
        if (NumberUtils.INTEGER_ZERO.equals(user.getEnabled())) {
            loginRespDto.setResult(false);
            loginRespDto.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u7981\u7528");
            return loginRespDto;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)userBizInfo.getBizId());
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByAuthCorpId(biz.getAuthCorpId());
        if (weworkCorp == null) {
            log.warn("wework_corp is null, authCorpId={}", (Object)biz.getAuthCorpId());
            return this.setFailLoginRespDtoByLoginErrorType(LoginErrorType.CORP_UN_AUTH, userBizInfo.getBizId());
        }
        if (weworkCorp.getIsAuth() == null || weworkCorp.getIsAuth() == 0) {
            if (weworkCorp.getDeauthTime() == null) {
                log.warn("wework_corp is not auth, authCorpId={}", (Object)biz.getAuthCorpId());
                return this.setFailLoginRespDtoByLoginErrorType(LoginErrorType.CORP_UN_AUTH, userBizInfo.getBizId());
            }
            log.warn("wework_corp canceled auth, authCorpId={}", (Object)biz.getAuthCorpId());
            return this.setFailLoginRespDtoByLoginErrorType(LoginErrorType.CANCEL_AUTH, userBizInfo.getBizId());
        }
        Long bizId = weworkCorp.getBizId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndMobile(bizId, mobile);
        if (weworkUser != null && !biz.getApplyWeworkUserId().equals(weworkUser.getOpenUserId())) {
            if (weworkUser.getIsAgentAuth() == null || weworkUser.getIsAgentAuth() == 0) {
                log.warn("wework_user suite is not auth, bizId={}, authCorpId={}, authUserId={}", new Object[]{bizId, biz.getAuthCorpId(), userBizInfo.getUserId()});
                return this.setFailLoginRespDtoByLoginErrorType(LoginErrorType.USER_UN_AUTH, userBizInfo.getBizId());
            }
            if (weworkUser.getSyncStatus().intValue() != WeworkUserSyncStatus.SYNCHRONIZED.getValue()) {
                log.warn("wework_user is not synchronized, bizId={}, authCorpId={}, authUserId={}", new Object[]{bizId, biz.getAuthCorpId(), userBizInfo.getUserId()});
                return this.setFailLoginRespDtoByLoginErrorType(LoginErrorType.USER_UN_SYNC, userBizInfo.getBizId());
            }
        }
        if (!(isFitAccountLimit = this.loginCommonService.isFitAccountLimit(biz, user))) {
            log.info("selectBiz: \u8d85\u8fc7\u8d26\u53f7\u9650\u5236\uff0cbiz:{}, user:{}", (Object)biz, (Object)user);
            int bizType = this.loginCommonService.getBizType(userBizInfo.getBizId());
            switch (BizType.get((int)bizType)) {
                case TRIAL: {
                    loginRespDto.setResult(false);
                    loginRespDto.setMsg("\u8d26\u53f7\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u7ba1\u7406\u5458");
                    break;
                }
                case NORMAL: {
                    loginRespDto.setResult(false);
                    loginRespDto.setMsg("\u8d26\u53f7\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u7ba1\u7406\u5458");
                    break;
                }
            }
            return loginRespDto;
        }
        if (NumberUtils.INTEGER_ZERO.equals(user.getIsOpen())) {
            user.setIsOpen(NumberUtils.INTEGER_ONE);
            user.setUpdateTime(new Date());
            this.userMapper.updateByPrimaryKey((Object)user);
        }
        if (Objects.isNull(bizCount = biz.getNumCount()) || bizCount < 0) {
            biz.setNumCount(this.numCount);
            biz.setUpdateTime(new Date());
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
        }
        LoginUtils.setLoginAccountId((Long)user.getId());
        loginRespDto.setResult(true);
        return loginRespDto;
    }

    @Override
    public String getToken() {
        HttpSession session = LoginUtils.getSession();
        return (String)session.getAttribute("EXTERNAL_TOKEN");
    }

    private LoginRespDto setFailLoginRespDtoByLoginErrorType(LoginErrorType loginErrorType, Long bizId) {
        LoginRespDto loginRespDto = new LoginRespDto();
        int bizType = this.loginCommonService.getBizType(bizId);
        String redirectUrl = this.root + this.failedPage + "?code=" + loginErrorType.getValue() + "&businessCustomerType=" + bizType;
        loginRespDto.setResult(false);
        loginRespDto.setMsg(loginErrorType.getDesc());
        loginRespDto.setRedirectUrl(redirectUrl);
        return loginRespDto;
    }

    private void returnAjaxNologinResponse(HttpServletResponse response) {
        long code = ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)CommonErrorCode.NO_LOGIN);
        HashMap map = Maps.newHashMap();
        response.setStatus(401);
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)new ApiResult(code, "\u7528\u6237\u672a\u767b\u5f55", (Object)map)));
    }

    private List<UserRoleRespDto> getUserRoles(Long userId, Long bizId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null!");
        UserRole userRole = new UserRole();
        userRole.setUserId(userId);
        List userRoles = this.userRoleMapper.select((Object)userRole);
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            return Lists.newArrayList();
        }
        Map<Long, List<UserRole>> roleId2UserRolesMap = userRoles.stream().collect(Collectors.groupingBy(UserRole::getRoleId));
        Map roleNodeMap = userRoles.stream().filter(a -> a.getManageNodeId() != null).collect(Collectors.groupingBy(UserRole::getRoleId, Collectors.mapping(UserRole::getManageNodeId, Collectors.toSet())));
        List roleIds = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        RoleQueryParams queryParam = new RoleQueryParams();
        queryParam.setIds(roleIds);
        queryParam.setBizId(bizId);
        queryParam.setCorpId(((UserRole)userRoles.get(0)).getCorpId());
        Map roleMap = this.roleMapper.queryList(queryParam).stream().collect(Collectors.toMap(Role::getId, Function.identity()));
        ArrayList result = Lists.newArrayList();
        if (!roleMap.isEmpty()) {
            for (Map.Entry entry : roleMap.entrySet()) {
                Role role = (Role)entry.getValue();
                if (role == null) continue;
                UserRoleRespDto dto = new UserRoleRespDto();
                dto.setRoleId(role.getId());
                dto.setRoleName(role.getName());
                Set manageNodeIds = (Set)MapUtils.getObject(roleNodeMap, (Object)role.getId());
                ArrayList manageNodes = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
                    manageNodes.addAll(this.orgService.getNodeWithoutChildren(bizId, (Collection)manageNodeIds));
                }
                dto.setManageNodes(manageNodes);
                dto.setManageNodeIds(manageNodeIds);
                if (MapUtils.isNotEmpty(roleId2UserRolesMap) && roleId2UserRolesMap.containsKey(role.getId())) {
                    dto.setLatestUseTime(roleId2UserRolesMap.get(role.getId()).get(0).getLatestUseTime());
                }
                result.add(dto);
            }
        }
        return result;
    }

    private String getBase64EncodeCoordinate(int coordinate) {
        StringBuilder stringBuilder = new StringBuilder();
        String str = Base64.getEncoder().encodeToString(String.valueOf(coordinate).getBytes(StandardCharsets.UTF_8));
        char[] chars = str.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            stringBuilder.append(chars[i]);
        }
        str = Base64.getUrlEncoder().encodeToString(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        return str;
    }

    private String getVerifyCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int j = this.random.nextInt(10);
            if (i == 0 && j == 0) {
                j = 1;
            }
            stringBuilder.append(digit[j]);
        }
        return stringBuilder.toString();
    }

    private void appendMenuCodes(CurrentUserInfo currentUserInfo) {
        if (Objects.isNull(currentUserInfo)) {
            return;
        }
        UserRoleRespDto userRoleRespDto = currentUserInfo.getCurRole();
        if (Objects.isNull(userRoleRespDto)) {
            return;
        }
        Set currentMenuCodes = currentUserInfo.getMenuCodes();
        Long roleId = userRoleRespDto.getRoleId();
        Long bizId = currentUserInfo.getBizId();
        Set menuCodes = this.roleMenuMapper.getMenuCodesByRoleId(roleId, bizId);
        Set<String> bizMenuCodes = this.getBizMenuCode(bizId);
        if (CollectionUtils.isNotEmpty((Collection)menuCodes)) {
            menuCodes.retainAll(bizMenuCodes);
        }
        currentUserInfo.setMenuCodes(menuCodes);
        if (!Objects.equals(currentMenuCodes, menuCodes)) {
            this.setRedisValue(currentUserInfo.getId(), currentUserInfo);
        }
    }
}

