/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.service.impl;

import com.kuaike.scrm.common.enums.BizType;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.permission.service.LoginCommonService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginCommonServiceImpl
implements LoginCommonService {
    private static final Logger log = LoggerFactory.getLogger(LoginCommonServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public int getBizType(String corpId) {
        Long bizId;
        BusinessCustomer biz;
        WeworkCorp weworkCorp;
        log.info("getBizType: corpId:{}", (Object)corpId);
        if (StringUtils.isNotBlank((CharSequence)corpId) && Objects.nonNull(weworkCorp = this.weworkCorpMapper.getByCorpId(corpId)) && Objects.nonNull(biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)(bizId = weworkCorp.getBizId())))) {
            return biz.getType();
        }
        return BizType.TRIAL.getValue();
    }

    @Override
    public int getAuthBizType(String authCorpId) {
        BusinessCustomer biz;
        log.info("getBizType: authCorpId:{}", (Object)authCorpId);
        if (StringUtils.isNotBlank((CharSequence)authCorpId) && Objects.nonNull(biz = this.businessCustomerMapper.getByAuthCorpId(authCorpId))) {
            return biz.getType();
        }
        return BizType.TRIAL.getValue();
    }

    @Override
    public int getBizType(Long bizId) {
        BusinessCustomer biz;
        log.info("getBizType: bizId={}", (Object)bizId);
        if (bizId != null && Objects.nonNull(biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId))) {
            return biz.getType();
        }
        return BizType.TRIAL.getValue();
    }

    @Override
    public boolean isFitAccountLimit(BusinessCustomer biz, User user) {
        log.info("isFitAccountLimit: bizId:{},user:{}", (Object)biz, (Object)user);
        Integer bizCount = biz.getNumCount();
        if (Objects.isNull(bizCount) || bizCount <= 0) {
            log.info("isFitAccountLimit: \u672a\u8bbe\u7f6e\u8d26\u53f7\u6570\u91cf\u9650\u5236\uff0c\u53ef\u4ee5\u767b\u5f55, bizId:{},user:{}", (Object)biz, (Object)user);
            return true;
        }
        Long bizId = biz.getId();
        int openCount = this.userMapper.queryOpenCount(bizId);
        log.info("isFitAccountLimit: bizId:{}, openCount:{}, bizCount:{}", new Object[]{bizId, openCount, bizCount});
        if (openCount < bizCount) {
            log.info("isFitAccountLimit: \u5f00\u901a\u6570\u91cf\u5c0f\u4e8e\u8bbe\u7f6e\u7684\u8d26\u6237\u6570\uff0c\u53ef\u4ee5\u767b\u5f55,bizId:{},user:{}", (Object)biz, (Object)user);
            return true;
        }
        if (Objects.nonNull(user) && NumberUtils.INTEGER_ONE.equals(user.getIsOpen())) {
            log.info("isFitAccountLimit: \u5f00\u901a\u4e86\u767e\u5bb6\u4e91SCRM\uff0c\u53ef\u4ee5\u767b\u5f55, bizId:{}, user:{}", (Object)biz, (Object)user);
            return true;
        }
        return false;
    }
}

