/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.utils;

import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.enums.VisitorType;
import cn.kinyun.scrm.page.auth.dto.SnsUserDto;
import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.PageAuthRedisUtil;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.IpUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WoauthParseUtil {
    private static final Logger log = LoggerFactory.getLogger(WoauthParseUtil.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private PageAuthRedisUtil pageAuthRedisUtil;

    public WoauthUserDto getWoauthInfo(HttpServletRequest request) {
        SnsUserDto snsUserDto;
        Cookie[] cookies = request.getCookies();
        Map<String, String> cookieValues = this.handleCookies(cookies);
        String snsUserToken = cookieValues.get("SNS_USERINFO_TOKEN");
        WoauthUserDto user = new WoauthUserDto();
        user.setSnsUserInfoToken(snsUserToken);
        String ip = IpUtils.getIp((HttpServletRequest)request);
        user.setIp(ip);
        user.setUniqId(cookieValues.get("SNS_UNIQ_ID"));
        user.setCookie(cookieValues.get("SNS_UNIQ_ID"));
        if (StringUtils.isBlank((CharSequence)user.getUniqId())) {
            user.setUniqId(this.idGen.getNum());
        }
        if (snsUserToken == null) {
            return user;
        }
        String data = this.pageAuthRedisUtil.getSnsUser(snsUserToken);
        if (StringUtils.isBlank((CharSequence)data)) {
            return user;
        }
        log.info("snsUserStr: {}", (Object)data);
        try {
            snsUserDto = (SnsUserDto)JacksonUtil.str2Obj((String)data, SnsUserDto.class);
        }
        catch (IOException e) {
            log.error("deser json error: {}", (Object)data, (Object)e);
            return user;
        }
        user.setType(snsUserDto.getType());
        user.setBizId(snsUserDto.getBusinessCustomerId());
        user.setSex(snsUserDto.getSex());
        user.setAppId(snsUserDto.getAppId());
        user.setUniqueId(snsUserDto.getUniqueId());
        user.setCountry(snsUserDto.getCountry());
        user.setProvince(snsUserDto.getProvince());
        user.setCity(snsUserDto.getCity());
        user.setCorpId(snsUserDto.getAppId());
        user.setDeviceId(snsUserDto.getDeviceId());
        user.setUserId(snsUserDto.getUserId());
        user.setOpenId(snsUserDto.getOpenId());
        user.setExternalUserId(snsUserDto.getExternalUserId());
        user.setName(snsUserDto.getNickname());
        user.setAvatar(snsUserDto.getHeadImgUrl());
        if (user.getType() != null && user.getType() == 1) {
            if (StringUtils.isNotBlank((CharSequence)user.getOpenId())) {
                user.setUniqId(user.getOpenId());
            } else if (StringUtils.isNotBlank((CharSequence)user.getUserId())) {
                user.setUniqId(user.getUserId());
            } else if (StringUtils.isNotBlank((CharSequence)user.getDeviceId())) {
                user.setUniqId(user.getDeviceId());
            }
        } else {
            String openId;
            String uniqueId = snsUserDto.getUniqueId();
            if (uniqueId == null) {
                uniqueId = "";
            }
            if ((openId = snsUserDto.getOpenId()) == null) {
                openId = "";
            }
            user.setUniqId(openId + uniqueId);
        }
        return user;
    }

    public EventVisitor buildVisitor(WoauthUserDto woauthInfo, String referer) {
        EventVisitor visitor = new EventVisitor();
        visitor.setName(woauthInfo.getName());
        visitor.setAvatar(woauthInfo.getAvatar());
        visitor.setAppId(woauthInfo.getAppId());
        visitor.setContactId(woauthInfo.getExternalUserId());
        visitor.setCity(woauthInfo.getCity());
        visitor.setCountry(woauthInfo.getCountry());
        visitor.setProvince(woauthInfo.getProvince());
        visitor.setOpenId(woauthInfo.getOpenId());
        visitor.setUnionId(woauthInfo.getUniqueId());
        visitor.setCookie(woauthInfo.getCookie());
        visitor.setIp(woauthInfo.getIp());
        visitor.setUniqId(woauthInfo.getUniqId());
        visitor.setUserId(woauthInfo.getUserId());
        visitor.setRefer(referer);
        if (woauthInfo.getType() == null) {
            visitor.setType(Integer.valueOf(VisitorType.UNKNOWN.getValue()));
        } else if (woauthInfo.getType() == 0) {
            visitor.setType(Integer.valueOf(VisitorType.OFFICIAL.getValue()));
        } else if (woauthInfo.getType() == 1) {
            visitor.setType(Integer.valueOf(VisitorType.WEWORK.getValue()));
        }
        return visitor;
    }

    private Map<String, String> handleCookies(Cookie ... cookies) {
        HashMap result = Maps.newHashMap();
        if (cookies == null) {
            return result;
        }
        for (Cookie cookie : cookies) {
            String value;
            if (cookie.getName().equals("SNS_UNIQ_ID")) {
                result.put("SNS_UNIQ_ID", cookie.getValue());
                continue;
            }
            if (!cookie.getName().equals("SNS_USERINFO_TOKEN") || (value = cookie.getValue()) == null) continue;
            result.put("SNS_USERINFO_TOKEN", new String(Base64.getDecoder().decode(cookie.getValue()), StandardCharsets.UTF_8));
        }
        return result;
    }
}

