/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.service.impl;

import cn.kinyun.scrm.page.auth.dto.OAuthPageDto;
import cn.kinyun.scrm.page.auth.dto.SnsUserDto;
import cn.kinyun.scrm.page.auth.service.OauthService;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.scrm.page.auth.utils.PageAuthRedisUtil;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsUserinfo;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.WxOAuthScope;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.marketing.mapper.OauthShortUrlMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.time.Duration;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Service;

@Service
public class OauthServiceImpl
implements OauthService {
    private static final Logger log = LoggerFactory.getLogger(OauthServiceImpl.class);
    @Value(value="${oauth.appId}")
    private String appId;
    @Value(value="${oauth.appSecret}")
    private String appSecret;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.callbackUrl}")
    private String callbackUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.shortUrl}")
    private String oauthShortUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.defaultUrl}")
    private String defaultUrl;
    @Value(value="${scrm.domain.root}")
    private String domain;
    @Resource
    private OauthShortUrlMapper oauthShortUrlMapper;
    @Autowired
    private WxOAuth2API wxOAuth2API;
    @Autowired
    private PageAuthRedisUtil pageAuthRedisUtil;
    @Autowired
    private ShortUrlService shortUrlService;
    @Autowired
    private IdGen idGen;

    @Override
    public String wrapUrl(Long bizId, String url) {
        log.info("wrap url with params={}", (Object)url);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)"\u8df3\u8f6curl\u4e3a\u7a7a");
        OauthShortUrl oauthShort = this.oauthShortUrlMapper.queryShortUrlByOriginUrl(url);
        if (oauthShort != null && StringUtils.isNotBlank((CharSequence)oauthShort.getShortUrl())) {
            return MessageFormat.format(this.oauthShortUrl, oauthShort.getShortUrl());
        }
        OAuthPageDto data = new OAuthPageDto();
        data.setUrl(url);
        data.setType(OauthShortUrlTypeEnum.MERCHANT_WRAP_URL.getValue());
        data.setBizId(bizId);
        data.setFrom(String.valueOf(bizId));
        data.setTo("");
        return this.getShortUrl(data);
    }

    @Override
    public String handleCallback(String value, String code, String state, HttpServletRequest request, HttpServletResponse response) {
        String openId;
        log.info("callback with code={}, state={}, param={}", new Object[]{code, state, value});
        OAuthPageDto dto = OAuthPageDto.decrypt(value);
        if (dto == null) {
            log.warn("Invalid param. value={}", (Object)value);
            return this.defaultUrl;
        }
        String url = dto.getUrl();
        if (StringUtils.isBlank((CharSequence)code)) {
            log.warn("Matching failed: code is empty. params={}", (Object)dto);
            return url;
        }
        SnsAccessToken accessTokenDto = this.getAccessToken(code);
        if (accessTokenDto == null) {
            return url;
        }
        String accessToken = accessTokenDto.getAccessToken();
        SnsUserinfo oauthUserInfo = this.getOauthUserInfo(accessToken, openId = accessTokenDto.getOpenId());
        if (oauthUserInfo == null) {
            return url;
        }
        this.cacheUser(request, response, dto.getBizId(), oauthUserInfo);
        return url;
    }

    private String getShortUrl(OAuthPageDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"type is null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getUrl()}), (Object)"url is empty");
        String oauthUrl = this.buildOAuthUrl(params);
        log.info("build oauth url, originUrl: {}, oauthUrl: {}", (Object)params.getUrl(), (Object)oauthUrl);
        String shortUrl = this.idGen.getNum();
        this.shortUrlService.recordShortUrl(this.appId, params.getType(), params.getUrl(), oauthUrl, shortUrl);
        String url = MessageFormat.format(this.oauthShortUrl, shortUrl);
        log.info("generate shortUrl: {}", (Object)url);
        return url;
    }

    private String buildOAuthUrl(OAuthPageDto params) {
        String redirectUrl = this.callbackUrl + "?v=" + params.encrypt();
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            log.error("unsupported encoding", (Throwable)ignored);
        }
        return "https://open.weixin.qq.com/connect/oauth2/authorize?response_type=code&appid=" + this.appId + "&redirect_uri=" + redirectUrl + "&scope=" + WxOAuthScope.SNSAPI_USERINFO.getValue() + "&state=" + System.currentTimeMillis() + "#wechat_redirect";
    }

    private SnsAccessToken getAccessToken(String code) {
        return this.wxOAuth2API.accessToken(this.appId, this.appSecret, code);
    }

    private SnsUserinfo getOauthUserInfo(String accessToken, String openId) {
        return this.wxOAuth2API.getUserinfo(accessToken, openId, "zh_CN");
    }

    private void cacheUser(HttpServletRequest request, HttpServletResponse response, Long bizId, SnsUserinfo snsUserinfo) {
        log.info("cache snsUserinfo:{}", (Object)snsUserinfo);
        String openId = snsUserinfo.getOpenId();
        String token = MD5Utils.MD5((String)(this.appId + "," + openId));
        SnsUserDto dto = new SnsUserDto();
        dto.setType(0);
        dto.setBusinessCustomerId(bizId);
        dto.setAppId(this.appId);
        dto.setOpenId(openId);
        dto.setUniqueId(snsUserinfo.getUnionId());
        dto.setNickname(snsUserinfo.getNickname());
        dto.setSex(snsUserinfo.getSex());
        dto.setProvince(snsUserinfo.getProvince());
        dto.setCity(snsUserinfo.getCity());
        dto.setCountry(snsUserinfo.getCountry());
        dto.setHeadImgUrl(snsUserinfo.getHeadImgUrl());
        String data = JacksonUtil.obj2Str((Object)dto);
        this.pageAuthRedisUtil.setSnsUser(token, data, Duration.ofSeconds(3600L));
        log.info("domain:{}, token:{}", (Object)this.domain, (Object)token);
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        cookieSerializer.setCookieName("SNS_USERINFO_TOKEN");
        cookieSerializer.setCookieMaxAge(3600);
        cookieSerializer.setCookiePath("/");
        cookieSerializer.setDomainName(this.domain);
        cookieSerializer.setUseHttpOnlyCookie(true);
        cookieSerializer.setUseBase64Encoding(true);
        CookieSerializer.CookieValue cookieValue = new CookieSerializer.CookieValue(request, response, token);
        cookieSerializer.writeCookieValue(cookieValue);
    }
}

