/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.token.impl;

import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerToken;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountOperatorMapper;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialTokenServiceImpl
implements OfficialTokenService {
    private static final Logger log = LoggerFactory.getLogger(OfficialTokenServiceImpl.class);
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialAccountOperatorMapper officialAccountOperatorMapper;
    @Value(value="${wx.component.appid}")
    private String componentAppId;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getOfficialAccessToken(String appId) {
        log.info("get official access token, appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
        if (officialAccount == null) {
            log.error("\u516c\u4f17\u53f7\u672a\u6388\u6743\uff0cappId={}", (Object)appId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u672a\u6388\u6743");
        }
        if (officialAccount.getAuthStatus() == 0) {
            log.error("\u516c\u4f17\u53f7\u5df2\u7ecf\u53d6\u6d88\u6388\u6743\uff0cappId={}", (Object)appId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u5df2\u7ecf\u53d6\u6d88\u6388\u6743");
        }
        Date expireTime = DateUtils.addMinutes((Date)new Date(), (int)15);
        if (StringUtils.isNotBlank((CharSequence)officialAccount.getAccessToken()) && expireTime.before(officialAccount.getTokenExpireTime())) {
            return officialAccount.getAccessToken();
        }
        return this.refreshAccessToken(officialAccount);
    }

    @Override
    public String refreshAccessToken(OfficialAccount account) {
        log.info("refresh official access_token with params={}", (Object)account);
        String appId = account.getAppId();
        String refreshToken = account.getRefreshToken();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        AuthorizerToken authInfo = this.componentAuthAPI.refreshAuthorizerToken(componentAccessToken, this.componentAppId, appId, refreshToken);
        Date now = new Date();
        account.setAccessToken(authInfo.getAuthorizerAccessToken());
        account.setRefreshToken(authInfo.getAuthorizerRefreshToken());
        account.setTokenExpireTime(DateUtils.addSeconds((Date)now, (int)authInfo.getExpires()));
        account.setUpdateTime(now);
        this.officialAccountMapper.updateByPrimaryKeySelective((Object)account);
        return account.getAccessToken();
    }
}

