/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.token.impl;

import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsUserinfo;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.scrm.weixin.token.FansTokenService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFansToken;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansTokenMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FansTokenServiceImpl
implements FansTokenService {
    private static final Logger log = LoggerFactory.getLogger(FansTokenServiceImpl.class);
    public static final String OFFICIAL_FANS_TOKEN_CACHE = "fans_token";
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private WxOAuth2API wxOAuth2API;
    @Autowired
    private ComponentTokenService platformInfoService;
    @Autowired
    private OfficialAccountFansTokenMapper fansTokenMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    private static final List<String> SCOPES = Lists.newArrayList((Object[])new String[]{"snsapi_base", "snsapi_userinfo"});
    private static final String DEFAULT_SCOPE = "snsapi_base";
    private ExecutorService pool = Executors.newFixedThreadPool(8);
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SECONDS = 300;

    @Override
    public String getComponentOAuthPageUrl(String appId, String redirectUri, String scope, String state) {
        log.info("get OAuth page url with appId={}, redirectUri={}, scope={}, state={}", new Object[]{appId, redirectUri, scope, state});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)redirectUri), (Object)"redirect uri must not be null");
        if (StringUtils.isBlank((CharSequence)state)) {
            state = "";
        }
        if (!SCOPES.contains(scope)) {
            scope = DEFAULT_SCOPE;
        }
        try {
            redirectUri = URLEncoder.encode(redirectUri, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            log.error("url encode error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
        }
        return this.wxOAuth2API.getComponentOauthPageUrl(appId, redirectUri, scope, state, this.componentAppId);
    }

    @Override
    public String getOAuthPageUrl(String appId, String redirectUri, String scope, String state) {
        log.info("get OAuth page url with appId={}, redirectUri={}, scope={}, state={}", new Object[]{appId, redirectUri, scope, state});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)redirectUri), (Object)"redirect uri must not be null");
        if (StringUtils.isBlank((CharSequence)state)) {
            state = "";
        }
        if (!SCOPES.contains(scope)) {
            scope = DEFAULT_SCOPE;
        }
        try {
            redirectUri = URLEncoder.encode(redirectUri, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            log.error("url encode error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
        }
        return this.wxOAuth2API.getOauthPageUrl(appId, redirectUri, scope, state);
    }

    @Override
    public String getCacheAccessToken(String appId, String openId) {
        log.info("get cached accessToken with appId={}, openId={}", (Object)appId, (Object)openId);
        String accessToken = this.getCacheToken(appId, openId);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return accessToken;
        }
        OfficialAccountFansToken fansToken = this.fansTokenMapper.selectByAppIdAndOpenId(appId, openId);
        if (fansToken != null) {
            SnsAccessToken snsAccessToken = this.refreshAccessToken(appId, openId, fansToken.getRefreshToken());
            if (snsAccessToken == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5237\u65b0token\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            this.cacheToken(appId, snsAccessToken);
            return snsAccessToken.getAccessToken();
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6388\u6743\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u7528\u6237\u6388\u6743");
    }

    private String getCacheToken(String appId, String openId) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        String redisKey = this.redisPrefix + Joiner.on((String)"_").join((Object)OFFICIAL_FANS_TOKEN_CACHE, (Object)appId, new Object[]{openId});
        return (String)operations.get((Object)redisKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SnsAccessToken getAccessToken(String appId, String appSecret, String code) {
        log.info("get fans access token with appId={}, code={}", (Object)appId, (Object)code);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)code), (Object)"code must not be null");
        try {
            SnsAccessToken snsAccessToken = this.wxOAuth2API.accessToken(appId, appSecret, code);
            if (snsAccessToken != null) {
                OfficialAccountFansToken fansToken = this.constructFansToken(snsAccessToken, appId);
                OfficialAccountFansToken existFansToken = this.fansTokenMapper.selectByAppIdAndOpenId(appId, snsAccessToken.getOpenId());
                if (existFansToken != null) {
                    fansToken.setId(existFansToken.getId());
                    fansToken.setUpdateTime(new Date());
                    this.fansTokenMapper.updateByPrimaryKeySelective((Object)fansToken);
                } else {
                    this.fansTokenMapper.insertSelective((Object)fansToken);
                }
                this.cacheToken(appId, snsAccessToken);
            }
            return snsAccessToken;
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SnsAccessToken getComponentAccessToken(String appId, String code) {
        log.info("get fans access token with appId={}, code={}", (Object)appId, (Object)code);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)code), (Object)"code must not be null");
        try {
            String componentToken = this.platformInfoService.getComponentAccessToken();
            SnsAccessToken snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, this.componentAppId, componentToken);
            if (snsAccessToken != null) {
                OfficialAccountFansToken fansToken = this.constructFansToken(snsAccessToken, appId);
                OfficialAccountFansToken existFansToken = this.fansTokenMapper.selectByAppIdAndOpenId(appId, snsAccessToken.getOpenId());
                if (existFansToken != null) {
                    fansToken.setId(existFansToken.getId());
                    fansToken.setUpdateTime(new Date());
                    this.fansTokenMapper.updateByPrimaryKeySelective((Object)fansToken);
                } else {
                    this.fansTokenMapper.insertSelective((Object)fansToken);
                }
                this.cacheToken(appId, snsAccessToken);
            }
            return snsAccessToken;
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    private void cacheToken(String appId, SnsAccessToken snsAccessToken) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        String redisKey = this.redisPrefix + Joiner.on((String)"_").join((Object)OFFICIAL_FANS_TOKEN_CACHE, (Object)appId, new Object[]{snsAccessToken.getOpenId()});
        operations.set((Object)redisKey, (Object)snsAccessToken.getAccessToken(), Duration.of(snsAccessToken.getExpires() - 300, ChronoUnit.SECONDS));
    }

    private OfficialAccountFansToken constructFansToken(SnsAccessToken snsAccessToken, String appId) {
        OfficialAccountFansToken fansToken = new OfficialAccountFansToken();
        fansToken.setAppId(appId);
        fansToken.setOpenId(snsAccessToken.getOpenId());
        fansToken.setAccessToken(snsAccessToken.getAccessToken());
        fansToken.setRefreshToken(snsAccessToken.getRefreshToken());
        fansToken.setTokenExpireTime(DateUtils.addSeconds((Date)new Date(), (int)snsAccessToken.getExpires()));
        return fansToken;
    }

    @Override
    public void refreshAccessToken() {
        log.info("refresh token which expires in 30 minutes");
        Date fromTime = new Date();
        Date toTime = DateUtils.addMinutes((Date)fromTime, (int)30);
        List fansTokens = this.fansTokenMapper.selectByTokenExipireTimeRange(fromTime, toTime);
        if (CollectionUtils.isNotEmpty((Collection)fansTokens)) {
            int total = fansTokens.size();
            int pageSize = 100;
            int page = total / pageSize;
            if (total % pageSize > 0) {
                ++page;
            }
            for (int i = 0; i < page; ++i) {
                int fromIndex = i * pageSize;
                int toIndex = (i + 1) * pageSize > total ? total : (i + 1) * pageSize;
                List subList = fansTokens.subList(fromIndex, toIndex);
                this.pool.submit(() -> {
                    for (OfficialAccountFansToken fansToken : subList) {
                        this.refreshAccessToken(fansToken.getAppId(), fansToken.getOpenId(), fansToken.getRefreshToken());
                    }
                });
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SnsAccessToken refreshAccessToken(String appId, String openId, String refreshToken) {
        log.info("refresh web authorization token with appId={},refreshToken={}", (Object)appId, (Object)refreshToken);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)refreshToken), (Object)"refreshToken must not be null");
        try {
            SnsAccessToken snsAccessToken = this.wxOAuth2API.refressToken(appId, refreshToken);
            if (snsAccessToken != null) {
                OfficialAccountFansToken existFansToken = this.fansTokenMapper.selectByAppIdAndOpenId(appId, openId);
                if (existFansToken != null) {
                    OfficialAccountFansToken fansToken = this.constructFansToken(snsAccessToken, appId);
                    fansToken.setId(existFansToken.getId());
                    fansToken.setUpdateTime(new Date());
                    this.fansTokenMapper.updateByPrimaryKeySelective((Object)fansToken);
                }
                this.cacheToken(appId, snsAccessToken);
            }
            return snsAccessToken;
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    @Override
    public SnsUserinfo getUserInfo(String accessToken, String openId) {
        log.info("get user info with accessToken={}, openId={}", (Object)accessToken, (Object)openId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessToken), (Object)"accessToken must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId must not be null");
        try {
            if (this.wxOAuth2API.auth(accessToken, openId)) {
                return this.wxOAuth2API.getUserinfo(accessToken, openId, "zh_CN");
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u5408\u6cd5\u7684\u63a5\u53e3\u8c03\u7528\u51ed\u8bc1");
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }
}

