/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.token.impl;

import cn.kinyun.scrm.weixin.sdk.api.WxJsSdkAPI;
import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.basic.Ticket;
import cn.kinyun.scrm.weixin.sdk.entity.component.AccessToken;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.official.base.entity.PlatformInfo;
import com.kuaike.scrm.dal.official.base.mapper.PlatformInfoMapper;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComponentTokenServiceImpl
implements ComponentTokenService {
    private static final Logger log = LoggerFactory.getLogger(ComponentTokenServiceImpl.class);
    @Autowired
    private PlatformInfoMapper platformInfoMapper;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Resource
    private WxJsSdkAPI wxJsSdkAPI;
    @Value(value="${wx.component.appid}")
    private String appId;
    @Value(value="${wx.component.appSecret}")
    private String appSecret;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getComponentAccessToken() {
        AccessToken token;
        PlatformInfo platformInfo = this.platformInfoMapper.getByAppId(this.appId);
        if (platformInfo == null || StringUtils.isBlank((CharSequence)platformInfo.getVerifyTicket())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f00\u653e\u5e73\u53f0\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        Date now = new Date();
        if (StringUtils.isNotBlank((CharSequence)platformInfo.getAccessToken()) && now.before(platformInfo.getTokenExpireTime())) {
            return platformInfo.getAccessToken();
        }
        try {
            token = this.componentAuthAPI.componentAccessToken(this.appId, this.appSecret, platformInfo.getVerifyTicket());
        }
        catch (WeixinException e) {
            log.error("\u8bf7\u6c42 component_access_token \u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        log.info("refresh component_access_token");
        platformInfo.setAccessToken(token.getComponentAccessToken());
        platformInfo.setTokenExpireTime(DateUtils.addSeconds((Date)now, (int)((int)token.getExpires())));
        platformInfo.setUpdateTime(now);
        this.platformInfoMapper.updateByPrimaryKeySelective((Object)platformInfo);
        return token.getComponentAccessToken();
    }

    @Override
    public String getComponentJsapiTicket() {
        Ticket ticket;
        PlatformInfo platformInfo = this.platformInfoMapper.getByAppId(this.appId);
        if (platformInfo == null || StringUtils.isBlank((CharSequence)platformInfo.getVerifyTicket())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f00\u653e\u5e73\u53f0\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        Date now = new Date();
        if (StringUtils.isNotBlank((CharSequence)platformInfo.getJsapiTicket()) && now.before(platformInfo.getJsapiTicketExpireTime())) {
            return platformInfo.getJsapiTicket();
        }
        String accessToken = this.getComponentAccessToken();
        try {
            ticket = this.wxJsSdkAPI.getJsApiTicket(accessToken);
        }
        catch (WeworkException e) {
            log.error("\u8bf7\u6c42\u83b7\u53d6Ticket\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        platformInfo.setJsapiTicket(ticket.getTicket());
        platformInfo.setJsapiTicketExpireTime(DateUtils.addSeconds((Date)now, (int)ticket.getExpires()));
        platformInfo.setUpdateTime(now);
        this.platformInfoMapper.updateByPrimaryKeySelective((Object)platformInfo);
        return ticket.getTicket();
    }

    @Override
    public String getWechatAppId() {
        return this.appId;
    }
}

