/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.syncdata.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.scrm.weixin.enums.SubscribeEventType;
import cn.kinyun.scrm.weixin.sdk.api.WxUserAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.UnsubscribeEvent;
import cn.kinyun.scrm.weixin.sdk.entity.user.req.BatchUserInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserInfo;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserInfoListResp;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFansSubscribeLog;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansSubscribeLogMapper;
import com.kuaike.scrm.syncdata.service.OfficialFansSyncService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialFansSyncServiceImpl
implements OfficialFansSyncService {
    private static final Logger log = LoggerFactory.getLogger(OfficialFansSyncServiceImpl.class);
    @Autowired
    private WxUserAPI wxUserAPI;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialAccountFansMapper fansMapper;
    @Autowired
    private OfficialAccountFansSubscribeLogMapper subscribeLogMapper;
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    private ThreadPoolExecutor getUserListPool = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("get-user-list-pool-%d").build());
    private ThreadPoolExecutor batchGetInfoPool = new ThreadPoolExecutor(5, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("batch-get-info-pool-%d").build());
    private ThreadPoolExecutor compareFansPool = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("compare-fans-pool-%d").build());
    private static final int PAGE_SIZE = 200;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            log.info("sync official account fans, appId:{}", (Object)appId);
            OfficialAccount account = this.officialAccountMapper.queryServiceAccountByAppId(appId);
            if (null == account) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "appId:" + appId + "\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u4e0d\u5b58\u5728");
            }
            this.getUserListPool.submit(() -> this.doPullAndCompare(account));
        }
    }

    @Override
    public void syncAll() {
        List list = this.officialAccountMapper.queryServiceAccount();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        log.info("sync all official account fans, appIds={}", list.stream().map(OfficialAccount::getAppId).collect(Collectors.toList()));
        for (OfficialAccount account : list) {
            this.getUserListPool.submit(() -> this.doPullAndCompare(account));
        }
    }

    private void doPullAndCompare(OfficialAccount account) {
        Long bizId = account.getBizId();
        String corpId = account.getCorpId();
        String appId = account.getAppId();
        Long timestamp = new Date().getTime();
        boolean[] flag = new boolean[]{false, false, false};
        ArrayBlockingQueue<List<OfficialAccountFans>> openIdsQueue = new ArrayBlockingQueue<List<OfficialAccountFans>>(8);
        this.compareFansPool.submit(() -> this.compareFans(timestamp, flag, openIdsQueue));
        boolean pushDataError = this.pushDataToQueue(bizId, corpId, appId, timestamp, openIdsQueue);
        flag[0] = true;
        try {
            openIdsQueue.put(Collections.emptyList());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        while (!openIdsQueue.isEmpty() || !flag[1]) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!pushDataError && !flag[2]) {
            try {
                log.info("delete unsubscribe fans from local, appId={}, compareTime={}", (Object)appId, (Object)timestamp);
                this.fansMapper.deleteAppFansBeforeCompareTimeMark(Collections.singletonList(appId), timestamp);
            }
            catch (Exception e) {
                log.error("update unsubscribe fans error", (Throwable)e);
            }
        }
        Long currentTimestamp = new Date().getTime();
        log.info("appId:{}\uff0c\u6bd4\u5bf9\u7c89\u4e1d\u4efb\u52a1\u8017\u65f6:{}\u79d2", (Object)appId, (Object)((currentTimestamp - timestamp) / 1000L));
    }

    private boolean pushDataToQueue(Long bizId, String corpId, String appId, Long timestamp, ArrayBlockingQueue<List<OfficialAccountFans>> openIdsQueue) {
        String nextOpenId = null;
        do {
            try {
                List subOpenIds;
                String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
                UserListResp userList = this.wxUserAPI.getList(accessToken, nextOpenId);
                nextOpenId = userList.getNextOpenId();
                UserListResp.OpenIdData openIdData = userList.getData();
                if (openIdData == null || !CollectionUtils.isNotEmpty((Collection)openIdData.getOpenId())) {
                    log.info("openId is empty.");
                    continue;
                }
                List openIds = openIdData.getOpenId();
                log.info("fans list from wechat result: total={}, count={}, nextOpenId={}, openIdData.size={}", new Object[]{userList.getTotal(), userList.getCount(), userList.getNextOpenId(), openIds.size()});
                ArrayList tasks = Lists.newArrayList();
                int i = 0;
                while (CollectionUtils.isNotEmpty(subOpenIds = openIds.stream().skip(100L * (long)i++).limit(100L).collect(Collectors.toList()))) {
                    BatchUserInfoReq request = new BatchUserInfoReq();
                    List userInfoReqs = subOpenIds.stream().map(a -> {
                        BatchUserInfoReq batchUserInfoReq = new BatchUserInfoReq();
                        batchUserInfoReq.getClass();
                        return new BatchUserInfoReq.UserInfoReq(batchUserInfoReq, a);
                    }).collect(Collectors.toList());
                    request.setUserList(userInfoReqs);
                    tasks.add(() -> {
                        try {
                            String accessToken1 = this.officialTokenService.getOfficialAccessToken(appId);
                            UserInfoListResp response = this.wxUserAPI.batchGetUserInfo(accessToken1, request);
                            if (response != null && CollectionUtils.isNotEmpty((Collection)response.getUserInfoList())) {
                                Date now = new Date();
                                ArrayList fansList = Lists.newArrayList();
                                for (UserInfo userInfo : response.getUserInfoList()) {
                                    OfficialAccountFans fans = this.constructFans(userInfo, bizId, corpId, appId, now);
                                    fans.setCompareTime(timestamp);
                                    fansList.add(fans);
                                }
                                if (CollectionUtils.isNotEmpty((Collection)fansList)) {
                                    openIdsQueue.put(fansList);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("Failed batch get user info, request={}", (Object)request, (Object)e);
                            return false;
                        }
                        return true;
                    });
                }
                this.batchGetInfoPool.invokeAll(tasks);
            }
            catch (Exception e) {
                log.error("push data to queue error", (Throwable)e);
                Thread.currentThread().interrupt();
                return true;
            }
        } while (StringUtils.isNotBlank((CharSequence)nextOpenId));
        return false;
    }

    private void compareFans(Long compareTime, boolean[] flag, ArrayBlockingQueue<List<OfficialAccountFans>> openIdsQueue) {
        Date now = new Date();
        while (!flag[0] || !openIdsQueue.isEmpty()) {
            try {
                List<OfficialAccountFans> wechatFansList = openIdsQueue.take();
                if (!CollectionUtils.isNotEmpty(wechatFansList)) continue;
                List openIds = wechatFansList.stream().map(OfficialAccountFans::getOpenId).collect(Collectors.toList());
                String appId = wechatFansList.get(0).getAppId();
                List localFansList = this.fansMapper.selectByAppIdOpenIds(appId, openIds);
                Map openId2FansMap = localFansList.stream().collect(Collectors.toMap(OfficialAccountFans::getOpenId, Function.identity()));
                ArrayList saveFansList = Lists.newArrayList();
                ArrayList updateFansList = Lists.newArrayList();
                ArrayList noChangeFansList = Lists.newArrayList();
                for (OfficialAccountFans fans2 : wechatFansList) {
                    if (!openId2FansMap.containsKey(fans2.getOpenId())) {
                        saveFansList.add(fans2);
                        continue;
                    }
                    OfficialAccountFans localFans = (OfficialAccountFans)openId2FansMap.get(fans2.getOpenId());
                    if (!this.equals(fans2, localFans)) {
                        updateFansList.add(fans2);
                        continue;
                    }
                    noChangeFansList.add(fans2);
                }
                if (CollectionUtils.isNotEmpty((Collection)saveFansList)) {
                    ArrayList logs = Lists.newArrayList();
                    saveFansList.forEach(fans -> logs.add(this.constructLog((OfficialAccountFans)fans, now)));
                    this.fansMapper.saveAll((List)saveFansList);
                    this.subscribeLogMapper.saveAll((List)logs);
                    for (OfficialAccountFans fans3 : saveFansList) {
                        this.customerCenterService.pushOfficialFansCustomer(fans3);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)noChangeFansList)) {
                    Lists.partition((List)noChangeFansList, (int)200).forEach(subList -> {
                        List pagedOpenIds = subList.stream().map(OfficialAccountFans::getOpenId).collect(Collectors.toList());
                        this.fansMapper.updateCompareTime(appId, pagedOpenIds, compareTime);
                    });
                }
                if (!CollectionUtils.isNotEmpty((Collection)updateFansList)) continue;
                this.updateFansInfo(updateFansList);
            }
            catch (InterruptedException ie) {
                log.info("consume thread is interrupted");
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                flag[2] = true;
                log.error("compare fans error", (Throwable)e);
            }
        }
        flag[1] = true;
        log.info("compare thread finishes task");
    }

    private void updateFansInfo(List<OfficialAccountFans> updateFansList) {
        log.debug("update fansInfo, newInfos:{}", updateFansList);
        if (CollectionUtils.isNotEmpty(updateFansList)) {
            this.fansMapper.batchUpdate(updateFansList);
            List updateOpenIds = updateFansList.stream().map(OfficialAccountFans::getOpenId).collect(Collectors.toList());
            List existLatestLogs = this.subscribeLogMapper.selectlatestList(updateOpenIds);
            Map fans2LogMap = existLatestLogs.stream().collect(Collectors.toMap(OfficialAccountFansSubscribeLog::getOfficialAccountFansId, Function.identity(), (o, v) -> v));
            ArrayList subscribeLogs = Lists.newArrayList();
            Date now = new Date();
            for (OfficialAccountFans fans : updateFansList) {
                OfficialAccountFansSubscribeLog log = (OfficialAccountFansSubscribeLog)fans2LogMap.get(fans.getUniqueId());
                if (log != null && (!fans.getSubscribeTime().after(log.getOperateTime()) || log.getOperateType().byteValue() != SubscribeEventType.UNSUBSCRIBE.getValue())) continue;
                subscribeLogs.add(this.constructLog(fans, now));
            }
            if (CollectionUtils.isNotEmpty((Collection)subscribeLogs)) {
                this.subscribeLogMapper.saveAll((List)subscribeLogs);
            }
        }
    }

    private OfficialAccountFansSubscribeLog constructLog(OfficialAccountFans fans, Date now) {
        OfficialAccountFansSubscribeLog log = new OfficialAccountFansSubscribeLog();
        log.setBizId(fans.getBizId());
        log.setCorpId(fans.getCorpId());
        log.setOfficialAccountFansId(fans.getUniqueId());
        if (fans.getSubscribe() == 1) {
            log.setOperateType(Byte.valueOf((byte)SubscribeEventType.SUBSCRIBE.getValue()));
            log.setOperateTime(fans.getSubscribeTime());
        } else {
            log.setOperateType(Byte.valueOf((byte)SubscribeEventType.UNSUBSCRIBE.getValue()));
            log.setOperateTime(fans.getUnsubscribeTime());
        }
        log.setCreateTime(now);
        log.setUpdateTime(now);
        return log;
    }

    private boolean equals(OfficialAccountFans wechatFans, OfficialAccountFans localFans) {
        if (null == wechatFans || localFans == null) {
            return false;
        }
        return wechatFans.getAppId().equals(localFans.getAppId()) && wechatFans.getOpenId().equals(localFans.getOpenId()) && wechatFans.getSubscribe().equals(localFans.getSubscribe()) && wechatFans.getNickname().equals(localFans.getNickname()) && wechatFans.getSex().equals(localFans.getSex()) && wechatFans.getProvince().equals(localFans.getProvince()) && wechatFans.getCountry().equals(localFans.getCountry()) && wechatFans.getCity().equals(localFans.getCity()) && wechatFans.getLanguage().equals(localFans.getLanguage()) && wechatFans.getHeadImgUrl().equals(localFans.getHeadImgUrl()) && wechatFans.getSubscribeTime().getTime() == localFans.getSubscribeTime().getTime() && wechatFans.getSubscribeScene().equals(localFans.getSubscribeScene()) && wechatFans.getQrScene().equals(localFans.getQrScene()) && wechatFans.getQrSceneStr().equals(localFans.getQrSceneStr());
    }

    private OfficialAccountFans constructFans(UserInfo userInfo, Long bizId, String corpId, String appId, Date now) {
        OfficialAccountFans fans = new OfficialAccountFans();
        fans.setBizId(bizId);
        fans.setCorpId(corpId);
        fans.setAppId(appId);
        fans.setOpenId(userInfo.getOpenId());
        fans.setSubscribe(Integer.valueOf(userInfo.getSubscribe()));
        fans.setNickname(Optional.ofNullable(userInfo.getNickname()).orElse(""));
        fans.setSex(Integer.valueOf(userInfo.getSex()));
        fans.setCity(Optional.ofNullable(userInfo.getCity()).orElse(""));
        fans.setCountry(Optional.ofNullable(userInfo.getCountry()).orElse(""));
        fans.setProvince(Optional.ofNullable(userInfo.getProvince()).orElse(""));
        fans.setLanguage(Optional.ofNullable(userInfo.getLanguage()).orElse("zh_CN"));
        fans.setHeadImgUrl(Optional.ofNullable(userInfo.getHeadImgUrl()).orElse(""));
        fans.setSubscribeTime(new Date(userInfo.getSubscribeTime() * 1000L));
        fans.setUnionId(userInfo.getUnionId());
        fans.setUniqueId(MD5Utils.MD5((String)(appId + "_" + userInfo.getOpenId())));
        fans.setRemark(Optional.ofNullable(userInfo.getRemark()).orElse(""));
        fans.setGroupId(Long.valueOf(userInfo.getGroupId()));
        fans.setSubscribeScene(Optional.ofNullable(userInfo.getSubscribeScene()).orElse(""));
        fans.setQrScene(String.valueOf(userInfo.getQrScene()));
        fans.setQrSceneStr(Optional.ofNullable(userInfo.getQrSceneStr()).orElse(""));
        fans.setCreateTime(now);
        fans.setUpdateTime(now);
        return fans;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean onSubscribe(String appId, String openId, Long timestamp, String eventKey) {
        UserInfo userInfo;
        log.info("save subscribe fans with appId={}, openId={}, timestamp={}", new Object[]{appId, openId, timestamp});
        OfficialAccount account = this.officialAccountMapper.getByAppId(appId);
        if (account == null) {
            log.warn("OfficialAccount not found with appId={}", (Object)appId);
            return false;
        }
        Long bizId = account.getBizId();
        String corpId = account.getCorpId();
        Date now = new Date();
        timestamp = timestamp / 1000L;
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            userInfo = this.wxUserAPI.getUserInfo(accessToken, openId, "zh_CN");
        }
        catch (WeixinException e) {
            log.error("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return false;
        }
        OfficialAccountFans fans = this.constructFans(userInfo, bizId, corpId, appId, now);
        fans.setLatestSubscribeEventTime(timestamp);
        OfficialAccountFans existFans = this.fansMapper.getFansByAppIdAndOpenId(appId, openId);
        if (existFans == null) {
            this.fansMapper.insertSelective((Object)fans);
            OfficialAccountFansSubscribeLog subscribeLog = this.constructLog(fans, now);
            this.subscribeLogMapper.insertSelective((Object)subscribeLog);
            this.customerCenterService.pushOfficialFansCustomer(fans);
            this.saveSubscribeEvent(eventKey, fans, subscribeLog.getOfficialAccountFansId(), subscribeLog.getOperateTime());
            return true;
        }
        if (timestamp > existFans.getLatestSubscribeEventTime()) {
            fans.setId(existFans.getId());
            fans.setUpdateTime(new Date());
            OfficialAccountFansSubscribeLog subscribeLog = this.constructLog(fans, now);
            this.fansMapper.updateByPrimaryKeySelective((Object)fans);
            this.subscribeLogMapper.insertSelective((Object)subscribeLog);
            this.customerCenterService.pushOfficialFansCustomer(fans);
            this.saveSubscribeEvent(eventKey, fans, subscribeLog.getOfficialAccountFansId(), subscribeLog.getOperateTime());
            return true;
        }
        return false;
    }

    private void saveSubscribeEvent(String eventKey, OfficialAccountFans fans, String fansId, Date operateTime) {
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.FANS_SUBSCRIBE.getCode());
        eventReq.setSource("scrm");
        eventReq.setEventTime(new Date());
        eventReq.setBizId(fans.getBizId());
        eventReq.setCustomerNum(fans.getCustomerNum());
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        EventModule eventModule = new EventModule();
        eventData.setModule(eventModule);
        eventModule.setType(ModuleType.OFFICIAL.getCode());
        eventData.setFansId(fansId);
        eventData.setAppId(fans.getAppId());
        eventData.setOpenId(fans.getOpenId());
        eventData.setName(fans.getNickname());
        eventData.setAvatar(fans.getHeadImgUrl());
        eventData.setOperateTime(operateTime);
        eventData.setState(eventKey);
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("save fans subscribe event error: ", (Throwable)e);
        }
    }

    private void saveUnsubscribeEvent(OfficialAccountFans fans, String fansId, Date operateTime) {
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.FANS_UNSUBSCRIBE.getCode());
        eventReq.setSource("scrm");
        eventReq.setEventTime(new Date());
        eventReq.setBizId(fans.getBizId());
        eventReq.setCustomerNum(fans.getCustomerNum());
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        eventData.setFansId(fansId);
        eventData.setAppId(fans.getAppId());
        eventData.setOpenId(fans.getOpenId());
        eventData.setName(fans.getNickname());
        eventData.setAvatar(fans.getHeadImgUrl());
        eventData.setOperateTime(operateTime);
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("save fans unsubscribe event error: ", (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean onUnsubscribe(UnsubscribeEvent event) {
        log.info("del unsubscribe fans with event={}", (Object)event);
        String openId = event.getFromUserName();
        String appUserName = event.getToUserName();
        Long timestamp = event.getCreateTime();
        OfficialAccount officialAccount = this.officialAccountMapper.getByUserName(appUserName);
        if (officialAccount == null) {
            log.warn("OfficialAccount not found with userName={}", (Object)appUserName);
            return false;
        }
        String appId = officialAccount.getAppId();
        OfficialAccountFans existFans = this.fansMapper.getFansByAppIdAndOpenId(appId, openId);
        if (existFans == null) {
            log.warn("Try to record unsubscribe event but not fans found with appId={}, openId={}", (Object)appId, (Object)openId);
            return false;
        }
        if (timestamp > existFans.getLatestSubscribeEventTime()) {
            existFans.setUpdateTime(new Date());
            existFans.setLatestSubscribeEventTime(timestamp);
            existFans.setUnsubscribeTime(new Date(timestamp * 1000L));
            existFans.setSubscribe(Integer.valueOf(0));
            this.fansMapper.updateByPrimaryKeySelective((Object)existFans);
            OfficialAccountFansSubscribeLog subscribeLog = this.constructLog(existFans, new Date());
            this.subscribeLogMapper.insertSelective((Object)subscribeLog);
            this.saveUnsubscribeEvent(existFans, subscribeLog.getOfficialAccountFansId(), subscribeLog.getOperateTime());
            return true;
        }
        return false;
    }
}

