/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.syncdata.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.syncdata.service.OfficialAccountSyncService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OfficialAccountSyncServiceImpl
implements OfficialAccountSyncService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountSyncServiceImpl.class);
    @Value(value="${wx.component.appid}")
    private String componentAppid;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;

    @Override
    public void syncAll() {
        List list = this.officialAccountMapper.queryServiceAccount();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        log.info("sync all official account, appIds={}", list.stream().map(it -> it.getAppId()).collect(Collectors.toList()));
        for (OfficialAccount account : list) {
            this.sync(account);
        }
    }

    @Override
    public void sync(String appId) {
        OfficialAccount account = this.officialAccountMapper.queryServiceAccountByAppId(appId);
        if (account == null) {
            log.warn("official account not found, appId={}", (Object)appId);
            return;
        }
        this.sync(account);
    }

    private void sync(OfficialAccount account) {
        int function;
        int serviceType;
        int verifyType;
        String appId = account.getAppId();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        AuthorizerInfoResp authorizerInfoResp = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppid, appId);
        AuthorizerInfo appInfo = authorizerInfoResp.getAuthorizerInfo();
        boolean isChanged = false;
        if (!Objects.equals(appInfo.getNickName(), account.getNickName())) {
            account.setNickName(appInfo.getNickName());
            isChanged = true;
        }
        if (!Objects.equals(appInfo.getAlias(), account.getAlias())) {
            account.setAlias(appInfo.getAlias());
            isChanged = true;
        }
        if (!Objects.equals(appInfo.getHeadImg(), account.getHeadImg())) {
            account.setHeadImg(appInfo.getHeadImg());
            isChanged = true;
        }
        if (!Objects.equals(appInfo.getPrincipalName(), account.getPrincipalName())) {
            account.setPrincipalName(appInfo.getPrincipalName());
            isChanged = true;
        }
        if (!Objects.equals(appInfo.getQrcodeUrl(), account.getQrcodeUrl())) {
            account.setQrcodeUrl(appInfo.getQrcodeUrl());
            isChanged = true;
        }
        if (!Objects.equals(appInfo.getUserName(), account.getUserName())) {
            account.setUserName(appInfo.getUserName());
            isChanged = true;
        }
        if (!Objects.equals(verifyType = appInfo.getVerifyTypeInfo().getId().intValue(), account.getVerifyType())) {
            account.setVerifyType(Integer.valueOf(verifyType));
            isChanged = true;
        }
        if (!Objects.equals(serviceType = appInfo.getServiceTypeInfo().getId().intValue(), account.getServiceType())) {
            account.setServiceType(Integer.valueOf(serviceType));
            isChanged = true;
        }
        if (!Objects.equals(function = appInfo.getBusinessInfo().getOpenStore() << 4 + appInfo.getBusinessInfo().getOpenScan() << 3 + appInfo.getBusinessInfo().getOpenPay() << 2 + appInfo.getBusinessInfo().getOpenCard() << 1 + appInfo.getBusinessInfo().getOpenShake(), account.getBusinessInfo())) {
            account.setBusinessInfo(Integer.valueOf(function));
            isChanged = true;
        }
        if (isChanged) {
            log.info("update official account info, appId={}, nickname={}", (Object)appId, (Object)account.getNickName());
            account.setUpdateTime(new Date());
            this.officialAccountMapper.updateByPrimaryKeySelective((Object)account);
        }
    }
}

