/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.scrm.weixin.autoreply.service.ActivityAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.ChatGptAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.KeywordAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.RecvMsgAutoReplyService;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.material.service.FansMediaUploadService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import cn.kinyun.scrm.weixin.sdk.emoji.WxEmojiUtils;
import cn.kinyun.scrm.weixin.sdk.emoji.WxExpressionUtils;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.BaseReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.ImageReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.LinkReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.LocationReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.ShortVideoReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.TextReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.VideoReqMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.req.VoiceReqMsg;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.callback.service.ReceiveMessageService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.syncdata.service.OfficialFansSyncService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveMessageServiceImpl
implements ReceiveMessageService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMessageServiceImpl.class);
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialAccountFansMapper officialAccountFansMapper;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ActivityAutoReplyService activityAutoReplyService;
    @Autowired
    private KeywordAutoReplyService keywordAutoReplyService;
    @Autowired
    private RecvMsgAutoReplyService recvMsgAutoReplyService;
    @Autowired
    private ChatGptAutoReplyService chatGptAutoReplyService;
    @Autowired
    private FansMediaUploadService fansMediaUploadService;
    @Autowired
    private OfficialFansSyncService officialFansSyncService;
    @Autowired
    private RecommendService recommendService;

    @Override
    public void receiveText(TextReqMsg msg) {
        log.info("receive text msg={}", (Object)msg);
        String content = msg.getContent();
        content = WxExpressionUtils.decode((String)content);
        content = WxEmojiUtils.decode((String)content);
        msg.setContent(content);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveImage(ImageReqMsg msg) {
        log.info("receive image msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveVoice(VoiceReqMsg msg) {
        log.info("receive voice msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveVideo(VideoReqMsg msg) {
        log.info("receive video msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveShortVideo(ShortVideoReqMsg msg) {
        log.info("receive shortvideo msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveLocation(LocationReqMsg msg) {
        log.info("receive location msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    @Override
    public void receiveLink(LinkReqMsg msg) {
        log.info("receive link msg={}", (Object)msg);
        this.dispatch((BaseReqMsg)msg);
    }

    private void dispatch(BaseReqMsg msg) {
        String openId = msg.getFromUserName();
        String userName = msg.getToUserName();
        Long msgId = msg.getMsgId();
        if (this.messageService.msgExist(msgId)) {
            log.info("\u63a5\u6536\u5230\u5df2\u5b58\u5728\u7684\u6d88\u606f msgId={}", (Object)msgId);
            return;
        }
        OfficialAccount officialAccount = this.officialAccountMapper.getByUserName(userName);
        if (officialAccount == null) {
            log.warn("OfficialAccount not found with userName={}", (Object)userName);
            return;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)officialAccount.getAppId()), (Object)"\u516c\u4f17\u53f7\u7684appid\u4e3a\u7a7a");
        String appId = officialAccount.getAppId();
        OfficialAccountFans fans = this.officialAccountFansMapper.queryByAppIdOpenId(appId, openId);
        if (fans == null) {
            log.info("\u6536\u5230\u7c89\u4e1d\u6d88\u606f\u4f46\u662f\u672c\u5730\u627e\u4e0d\u5230\u7c89\u4e1d\uff0c\u5c1d\u8bd5\u4ece\u5fae\u4fe1\u670d\u52a1\u5668\u62c9\u53d6\u3002appId={},openId={}", (Object)appId, (Object)openId);
            if (this.officialFansSyncService.onSubscribe(appId, openId, new Date().getTime(), null)) {
                fans = this.officialAccountFansMapper.queryByAppIdOpenId(appId, openId);
            } else {
                log.warn("\u516c\u4f17\u53f7:{}, \u7c89\u4e1d:{} \u4ece\u5fae\u4fe1\u670d\u52a1\u5668\u62c9\u53d6\u4e0d\u5230\u4fe1\u606f!", (Object)appId, (Object)openId);
                this.generateRecord(msg, appId, officialAccount.getBizId(), officialAccount.getCorpId());
                return;
            }
        }
        if (fans.getIsInBlacklist() == 1) {
            log.warn("\u516c\u4f17\u53f7:{}, \u7c89\u4e1d:{} \u5df2\u7ecf\u88ab\u62c9\u9ed1\uff0c\u6d88\u606f\u5165\u5e93\uff0c\u4e0d\u5206\u914d\u5ba2\u670d!", (Object)officialAccount.getNickName(), (Object)fans.getNickname());
            this.generateRecord(msg, appId, officialAccount.getBizId(), officialAccount.getCorpId());
            return;
        }
        this.generateRecord(msg, appId, officialAccount.getBizId(), officialAccount.getCorpId());
        if (officialAccount.getVerifyType() != 0) {
            log.warn("\u516c\u4f17\u53f7\u672a\u7ecf\u8fc7\u5fae\u4fe1\u8ba4\u8bc1\uff0c\u65e0\u6cd5\u4f7f\u7528\u5ba2\u670d\u6d88\u606f\u529f\u80fd\u3002appId={}, serviceType={}, verifyType={}", new Object[]{officialAccount.getAppId(), officialAccount.getServiceType(), officialAccount.getVerifyType()});
            return;
        }
        if (officialAccount.getServiceType() != 2) {
            log.warn("\u516c\u4f17\u53f7\u7c7b\u578b\u4e0d\u662f\u670d\u52a1\u53f7\uff0c\u65e0\u6cd5\u4f7f\u7528\u5ba2\u670d\u6d88\u606f\u529f\u80fd\u3002appId={}, serviceType={}, verifyType={}", new Object[]{officialAccount.getAppId(), officialAccount.getServiceType(), officialAccount.getVerifyType()});
            return;
        }
        this.recommendService.trigger(officialAccount, openId, Integer.valueOf(BehaviorType.SEND_MSG.getValue()), "");
        if (!(msg instanceof TextReqMsg)) {
            return;
        }
        TextReqMsg textMsg = (TextReqMsg)msg;
        String content = textMsg.getContent();
        if (this.activityAutoReplyService.onRecvMsg(appId, openId, content)) {
            return;
        }
        if (this.keywordAutoReplyService.onRecvMsg(appId, openId, content)) {
            return;
        }
        this.recvMsgAutoReplyService.onRecvMsg(appId, openId, content);
        if (this.chatGptAutoReplyService.onRecvMsg(appId, openId, content)) {
            return;
        }
    }

    private void generateRecord(BaseReqMsg req, String appId, Long bizId, String corpId) {
        MsgData msgData = new MsgData(req);
        OfficialAccountMessage message = new OfficialAccountMessage();
        message.setBizId(bizId);
        message.setCorpId(corpId);
        message.setOpenId(req.getFromUserName());
        message.setAppId(appId);
        message.setMsgId(Long.valueOf(req.getMsgId()));
        message.setMsgType(req.getMsgType());
        message.setContent(JacksonUtil.obj2Str((Object)msgData));
        message.setSendType(Integer.valueOf(MsgSendType.RECV.getValue()));
        message.setCreateTime(new Date(req.getCreateTime() * 1000L));
        message.setServantSessionId(Long.valueOf(-1L));
        message.setUserId(Long.valueOf(-1L));
        boolean needSync = this.fansMediaUploadService.needSync(message.getMsgType());
        if (needSync) {
            message.setSyncStatus(Integer.valueOf(MsgSyncStatus.PENDING.getValue()));
        } else {
            message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
        }
        this.messageService.saveMsg(message);
        if (needSync) {
            this.fansMediaUploadService.asyncUpload(message, msgData);
        }
    }
}

