/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.resp.EventKeyDto;
import cn.kinyun.scrm.weixin.autoreply.service.ActivityAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.ClickEventReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.SubscribeAutoReplyService;
import cn.kinyun.scrm.weixin.channel.service.ChannelQrcodeService;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.message.service.MassMessageService;
import cn.kinyun.scrm.weixin.message.service.TemplateMsgService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.LocationEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.LocationSelectEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.PicPhotoOrAlbumEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.PicSysPhotoEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.PicWeiXinEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.ScanCodePushEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.ScanCodeWaitMsgEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.ScanEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.SubscribeEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.UnsubscribeEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.MassSendJobFinishEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.TemplateSendJobFinishEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.menu.ClickEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.menu.ViewEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.menu.ViewMiniProgramEvent;
import com.kuaike.scrm.callback.service.ReceiveEventService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.syncdata.service.OfficialFansSyncService;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReceiveEventServiceImpl
implements ReceiveEventService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveEventServiceImpl.class);
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialFansSyncService officialFansSyncService;
    @Autowired
    private MassMessageService massMessageService;
    @Autowired
    private TemplateMsgService templateMsgService;
    @Autowired
    private SubscribeAutoReplyService subscribeAutoReplyService;
    @Autowired
    private ClickEventReplyService clickEventReplyService;
    @Autowired
    private ActivityAutoReplyService activityAutoReplyService;
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private ChannelQrcodeService channelQrcodeService;

    @Override
    public void onSubscribe(SubscribeEvent event) {
        log.info("Receive subscribe event={}", (Object)event);
        String openId = event.getFromUserName();
        String userName = event.getToUserName();
        Long timestamp = event.getCreateTime() * 1000L;
        OfficialAccount officialAccount = this.officialAccountMapper.getByUserName(userName);
        if (officialAccount == null) {
            log.warn("OfficialAccount not found with userName={}", (Object)userName);
            return;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{officialAccount.getAppId()}), (Object)"\u516c\u4f17\u53f7\u7684appid\u4e3a\u7a7a");
        String appId = officialAccount.getAppId();
        String eventKey = event.getEventKey();
        if (this.officialFansSyncService.onSubscribe(appId, openId, timestamp, eventKey)) {
            if (!this.isOfficialActivity(eventKey, event.getTicket())) {
                event.setEventKey(eventKey);
            }
            boolean channelQrSubscribe = false;
            if (eventKey != null && eventKey.startsWith("qrscene_") && this.channelQrcodeService.onScan(officialAccount, openId, eventKey = eventKey.substring(8), true)) {
                channelQrSubscribe = true;
            }
            if (!channelQrSubscribe) {
                this.recommendService.trigger(officialAccount, openId, Integer.valueOf(BehaviorType.SUBSCRIBE.getValue()), "");
            }
            if (this.activityAutoReplyService.onSubscribe(appId, openId, eventKey, timestamp)) {
                return;
            }
            this.subscribeAutoReplyService.onSubscribe(appId, openId, timestamp);
        }
    }

    @Override
    public void onUnsubscribe(UnsubscribeEvent event) {
        log.info("Receive unsubscribe event={}", (Object)event);
        this.officialFansSyncService.onUnsubscribe(event);
    }

    @Override
    public void onScan(ScanEvent event) {
        log.info("Receive scan event={}", (Object)event);
        String openId = event.getFromUserName();
        String userName = event.getToUserName();
        Long timestamp = event.getCreateTime() * 1000L;
        OfficialAccount officialAccount = this.officialAccountMapper.getByUserName(userName);
        if (officialAccount == null) {
            log.warn("OfficialAccount not found with userName={}", (Object)userName);
            return;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{officialAccount.getAppId()}), (Object)"\u516c\u4f17\u53f7\u7684appid\u4e3a\u7a7a");
        String appId = officialAccount.getAppId();
        this.activityAutoReplyService.onScan(appId, openId, event.getEventKey(), timestamp);
        this.channelQrcodeService.onScan(officialAccount, openId, event.getEventKey(), false);
    }

    @Override
    public void onLocation(LocationEvent event) {
        log.info("Receive location event={}", (Object)event);
    }

    @Override
    public void onLocationSelect(LocationSelectEvent event) {
        log.info("Receive location_select event={}", (Object)event);
    }

    @Override
    public void onPicPhotoOrAlbum(PicPhotoOrAlbumEvent event) {
        log.info("Receive pic_photo_album event={}", (Object)event);
    }

    @Override
    public void onPicSysPhoto(PicSysPhotoEvent event) {
        log.info("Receive pic_sys_photo event={}", (Object)event);
    }

    @Override
    public void onPicWeixin(PicWeiXinEvent event) {
        log.info("Receive pic_weixin_event event={}", (Object)event);
    }

    @Override
    public void onScancodePush(ScanCodePushEvent event) {
        log.info("Receive scancode_push event={}", (Object)event);
    }

    @Override
    public void onScancodeWaitMsg(ScanCodeWaitMsgEvent event) {
        log.info("Receive scancode_waitmsg event={}", (Object)event);
    }

    @Override
    public void onClick(ClickEvent event) {
        log.info("Receive click event={}", (Object)event);
        this.clickEventReplyService.onClick(event);
    }

    @Override
    public void onView(ViewEvent event) {
        log.info("Receive view event={}", (Object)event);
        String openId = event.getFromUserName();
        String userName = event.getToUserName();
        String eventKey = event.getEventKey();
        OfficialAccount account = this.officialAccountMapper.getByUserName(userName);
        if (account == null) {
            log.warn("\u4e0d\u5b58\u5728\u6b64\u516c\u4f17\u53f7:{}", (Object)userName);
            return;
        }
        this.recommendService.trigger(account, openId, Integer.valueOf(BehaviorType.CLICK_MENU.getValue()), eventKey);
    }

    @Override
    public void onViewMiniProgram(ViewMiniProgramEvent event) {
        log.info("Receive view_miniprogram event={}", (Object)event);
        String openId = event.getFromUserName();
        String userName = event.getToUserName();
        String eventKey = event.getEventKey();
        OfficialAccount account = this.officialAccountMapper.getByUserName(userName);
        if (account == null) {
            log.warn("\u4e0d\u5b58\u5728\u6b64\u516c\u4f17\u53f7:{}", (Object)userName);
            return;
        }
        this.recommendService.trigger(account, openId, Integer.valueOf(BehaviorType.CLICK_MENU.getValue()), eventKey);
    }

    @Override
    public void onMassSendJobFinished(MassSendJobFinishEvent event) {
        log.info("Receive mess_send_job_finished event={}", (Object)event);
        this.massMessageService.massMessageEventCallback(event);
    }

    @Override
    public void onTemplateSendJobFinished(TemplateSendJobFinishEvent event) {
        log.info("Receive template_send_job_finished event={}", (Object)event);
        this.templateMsgService.onTemplateSendJobFinish(event);
    }

    private boolean isOfficialActivity(String eventKey, String ticket) {
        log.info("parse scan event key={}, ticket={}", (Object)eventKey, (Object)ticket);
        EventKeyDto dto = EventKeyDto.unpack((String)eventKey);
        return dto != null && ClickEventBizType.OFFICIAL_FISSION.getKey().equals(dto.getType());
    }
}

