/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.scrm.weixin.sdk.entity.component.TicketMsg;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.callback.service.ComponentTicketService;
import com.kuaike.scrm.dal.official.base.entity.PlatformInfo;
import com.kuaike.scrm.dal.official.base.mapper.PlatformInfoMapper;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComponentMsgServiceImpl
implements ComponentTicketService {
    private static final Logger log = LoggerFactory.getLogger(ComponentMsgServiceImpl.class);
    @Autowired
    private PlatformInfoMapper platformInfoMapper;

    @Override
    public void verifyTicket(TicketMsg msg) {
        String appId = msg.getAppId();
        String verifyTicket = msg.getComponentVerifyTicket();
        log.info("refreshVerifyTicket with verifyTicket={},appId={}", (Object)verifyTicket, (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)verifyTicket), (Object)"verifyTicket is null!");
        PlatformInfo platformInfo = this.platformInfoMapper.getByAppId(appId);
        if (platformInfo != null) {
            platformInfo.setVerifyTicket(verifyTicket);
            this.platformInfoMapper.updateByPrimaryKeySelective((Object)platformInfo);
        } else {
            platformInfo = new PlatformInfo();
            platformInfo.setAppId(appId);
            platformInfo.setVerifyTicket(verifyTicket);
            platformInfo.setAccessToken("");
            platformInfo.setCreateTime(new Date());
            this.platformInfoMapper.insertSelective((Object)platformInfo);
        }
    }
}

