/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.ActivityDto;
import cn.kinyun.scrm.weixin.activity.service.OfficialActivityService;
import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.NewsMaterialResp;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.SimpleMaterialDto;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.channel.service.ChannelQrcodeService;
import cn.kinyun.scrm.weixin.common.dto.AppIdAndNameDto;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgContentFormat;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.enums.biz.SystemParamName;
import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.enums.biz.recommend.RecommendStatus;
import cn.kinyun.scrm.weixin.enums.biz.recommend.TriggerWay;
import cn.kinyun.scrm.weixin.enums.message.SendWay;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.menu.dto.req.AppIdReq;
import cn.kinyun.scrm.weixin.menu.service.MenuManageService;
import cn.kinyun.scrm.weixin.message.service.ServantSessionService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.recommend.RecommendConf;
import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.dto.Op;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActExpOpType;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityMode;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityStatus;
import cn.kinyun.scrm.weixin.recommend.common.enums.OpStatus;
import cn.kinyun.scrm.weixin.recommend.dto.RecommendActivityDto;
import cn.kinyun.scrm.weixin.recommend.dto.RecommendContentDto;
import cn.kinyun.scrm.weixin.recommend.dto.SendResult;
import cn.kinyun.scrm.weixin.recommend.dto.StatisticDayDto;
import cn.kinyun.scrm.weixin.recommend.dto.req.GraphModReq;
import cn.kinyun.scrm.weixin.recommend.dto.req.IdsReq;
import cn.kinyun.scrm.weixin.recommend.dto.req.RecommendAddOrModReq;
import cn.kinyun.scrm.weixin.recommend.dto.req.RecommendListReq;
import cn.kinyun.scrm.weixin.recommend.dto.req.RecommendStatReq;
import cn.kinyun.scrm.weixin.recommend.dto.req.StatisticReqDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.GraphStatisticRespDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.OpLogRespDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.RecommendBaseDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.RecommendDetailResp;
import cn.kinyun.scrm.weixin.recommend.dto.resp.RecommendListResp;
import cn.kinyun.scrm.weixin.recommend.dto.resp.RecommendOpLogResp;
import cn.kinyun.scrm.weixin.recommend.service.BehaviorProcess;
import cn.kinyun.scrm.weixin.recommend.service.GraphDefineService;
import cn.kinyun.scrm.weixin.recommend.service.OpRecordService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuInfo;
import cn.kinyun.scrm.weixin.utils.AcitivityGraphUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.enums.EnumService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.RedisDistributedLock;
import com.kuaike.scrm.dal.activity.dto.OpLog;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.channelQrcode.entity.OfficialChannelQrcode;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActi;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.smartPush.dto.RecommendQueryParam;
import com.kuaike.scrm.dal.official.smartPush.entity.OfficialWiseRecommend;
import com.kuaike.scrm.dal.official.smartPush.entity.OfficialWiseRecommendRecord;
import com.kuaike.scrm.dal.official.smartPush.mapper.OfficialWiseRecommendMapper;
import com.kuaike.scrm.dal.official.smartPush.mapper.OfficialWiseRecommendRecordMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecommendServiceImpl
implements RecommendService {
    private static final Logger log = LoggerFactory.getLogger(RecommendServiceImpl.class);
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private GraphDefineService graphDefineService;
    @Autowired
    private BehaviorProcess behaviorProcess;
    @Autowired
    private OfficialActivityService officialActivityService;
    @Autowired
    private OpRecordService opRecordService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private LogicAutoReplyService logicAutoReplyService;
    @Autowired
    private RedisDistributedLock lock;
    @Autowired
    private OfficialAccountFansService fansService;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Autowired
    private MenuManageService menuManageService;
    @Autowired
    private ChannelQrcodeService channelQrcodeService;
    @Autowired
    private ServantSessionService servantSessionService;
    @Resource
    private OfficialWiseRecommendMapper recommendMapper;
    @Resource
    private OfficialWiseRecommendRecordMapper recommendRecordMapper;
    @Resource
    private OfficialActiMapper officialActiMapper;
    @Value(value="${recommend.period:172800}")
    private Long recommendPeriod;
    private static final Integer ACTIVITY_MODE = ActivityMode.SINGLE.getValue();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(RecommendAddOrModReq req) {
        log.info("addOrMod wide recommend rule with req={},operatorId={}", (Object)req, (Object)LoginUtils.getCurrentUserId());
        req.validate();
        List<String> appIds = this.operatorService.getCurrentManagerAppIds();
        if (!appIds.contains(req.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u516c\u4f17\u53f7\u64cd\u4f5c\u6743\u9650");
        }
        OfficialWiseRecommend recommend = this.buildRecommendRule(req);
        if (req.getId() == null) {
            this.recommendMapper.insertSelective((Object)recommend);
            this.startActivityGraph(req.getContentList(), recommend);
            this.recommendMapper.updateByPrimaryKeySelective((Object)recommend);
        } else {
            OfficialWiseRecommend existRecommend = (OfficialWiseRecommend)this.recommendMapper.selectByPrimaryKey((Object)req.getId());
            if (existRecommend == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f16\u8f91\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            BeanUtils.copyProperties((Object)recommend, (Object)existRecommend, (String[])new String[]{"id", "graphId", "status", "createTime", "creatorId", "isDel"});
            this.recommendMapper.updateByPrimaryKey((Object)existRecommend);
            this.modActivityGraph(req.getContentList(), existRecommend);
        }
    }

    private void startActivityGraph(List<RecommendContentDto> contentList, OfficialWiseRecommend recommend) {
        if (CollectionUtils.isEmpty(contentList)) {
            return;
        }
        GraphModReq graphModReq = this.buildGraphModReq(contentList, recommend);
        Long graphId = this.graphDefineService.addGraph(graphModReq);
        recommend.setGraphId(graphId);
    }

    private void modActivityGraph(List<RecommendContentDto> contentList, OfficialWiseRecommend recommend) {
        if (CollectionUtils.isEmpty(contentList)) {
            return;
        }
        GraphModReq graphModReq = this.buildGraphModReq(contentList, recommend);
        graphModReq.setId(recommend.getGraphId());
        this.graphDefineService.modGraph(graphModReq);
    }

    private GraphModReq buildGraphModReq(List<RecommendContentDto> contentList, OfficialWiseRecommend recommend) {
        GraphModReq graphModReq = new GraphModReq();
        graphModReq.setPermanent(recommend.getIsPermanent());
        graphModReq.setBizId(LoginUtils.getCurrentUserBizId());
        graphModReq.setBeginTime(recommend.getBeginTime());
        graphModReq.setEndTime(recommend.getEndTime());
        graphModReq.setActivityPeriodTime(this.recommendPeriod);
        graphModReq.setRepeatable(recommend.getRepeatable());
        graphModReq.setActivityMode(ACTIVITY_MODE);
        graphModReq.setActGraph(this.buildGraph(contentList, recommend));
        return graphModReq;
    }

    private Graph buildGraph(List<RecommendContentDto> contentList, OfficialWiseRecommend recommend) {
        Graph graph = new Graph();
        this.setGraphTriggers(graph, recommend);
        TreeMap delay2ContentsMap = Maps.newTreeMap();
        for (RecommendContentDto contentDto : contentList) {
            List contents;
            if (contentDto.getSendWay().intValue() == SendWay.INSTANT.getValue()) {
                contents = delay2ContentsMap.getOrDefault(0L, Lists.newArrayList());
                contents.add(contentDto);
                delay2ContentsMap.put(0L, contents);
            }
            if (contentDto.getSendWay().intValue() != SendWay.DELAY.getValue()) continue;
            contents = delay2ContentsMap.getOrDefault(contentDto.getDelayTime(), Lists.newArrayList());
            contents.add(contentDto);
            delay2ContentsMap.put(contentDto.getDelayTime(), contents);
        }
        ArrayList nodes = Lists.newArrayList();
        int nodeId = 1;
        Node startNode = AcitivityGraphUtils.buildNode(nodeId++, this.buildOps((List)delay2ContentsMap.remove(0L)));
        nodes.add(startNode);
        ArrayList edges = Lists.newArrayList();
        if (MapUtils.isNotEmpty((Map)delay2ContentsMap)) {
            int edgeStartNodeId = startNode.getId();
            Set entries = delay2ContentsMap.entrySet();
            for (Map.Entry entry : entries) {
                Long delay = (Long)entry.getKey();
                List contents = (List)entry.getValue();
                nodes.add(AcitivityGraphUtils.buildNode(nodeId, this.buildOps(contents)));
                Condition condition = AcitivityGraphUtils.buildCondition(1, AcitivityGraphUtils.buildExp("timeOut", ActExpOpType.GE.getType(), Lists.newArrayList((Object[])new String[]{String.valueOf(delay * 60L)})));
                edges.add(AcitivityGraphUtils.buildEdge(edgeStartNodeId, nodeId, 2, condition));
                edgeStartNodeId = nodeId++;
            }
        }
        graph.setNodes(nodes);
        graph.setEdges(edges);
        graph.setStartNodeId(startNode.getId());
        return graph;
    }

    private void setGraphTriggers(Graph graph, OfficialWiseRecommend recommend) {
        ArrayList triggers = Lists.newArrayList();
        if (recommend.getBehaviorType().intValue() == BehaviorType.ALL.getValue()) {
            for (BehaviorType type : BehaviorType.values()) {
                if (type == BehaviorType.ALL) continue;
                recommend.setBehaviorType(Integer.valueOf(type.getValue()));
                this.setGraphTrigger(triggers, recommend);
            }
            recommend.setBehaviorType(Integer.valueOf(BehaviorType.ALL.getValue()));
            graph.setConditionRelation(1);
        } else {
            this.setGraphTrigger(triggers, recommend);
            graph.setConditionRelation(2);
        }
        graph.setTriggers(triggers);
    }

    private void setGraphTrigger(List<Condition> triggers, OfficialWiseRecommend recommend) {
        Condition cond = null;
        if (recommend.getBehaviorType().intValue() == BehaviorType.CLICK_MENU.getValue()) {
            cond = AcitivityGraphUtils.buildCondition(4, AcitivityGraphUtils.buildExp("appId", ActExpOpType.EQ.getType(), Lists.newArrayList((Object[])new String[]{recommend.getAppId()})));
            if (!recommend.getTriggerCondition().equals(TriggerWay.ALL.name())) {
                cond.getExps().add(AcitivityGraphUtils.buildExp("menuKey", ActExpOpType.EQ.getType(), Lists.newArrayList((Object[])new String[]{recommend.getTriggerCondition()})));
            }
        } else if (recommend.getBehaviorType().intValue() == BehaviorType.SUBSCRIBE.getValue()) {
            cond = AcitivityGraphUtils.buildCondition(2, AcitivityGraphUtils.buildExp("appId", ActExpOpType.EQ.getType(), Lists.newArrayList((Object[])new String[]{recommend.getAppId()})));
        } else if (recommend.getBehaviorType().intValue() == BehaviorType.SEND_MSG.getValue()) {
            cond = AcitivityGraphUtils.buildCondition(3, AcitivityGraphUtils.buildExp("appId", ActExpOpType.EQ.getType(), Lists.newArrayList((Object[])new String[]{recommend.getAppId()})));
        } else if (recommend.getBehaviorType().intValue() == BehaviorType.SCAN_QR.getValue()) {
            cond = AcitivityGraphUtils.buildCondition(5, AcitivityGraphUtils.buildExp("appId", ActExpOpType.EQ.getType(), Lists.newArrayList((Object[])new String[]{recommend.getAppId()})));
            if (!recommend.getTriggerCondition().equals(TriggerWay.ALL.name())) {
                List markIds = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)recommend.getTriggerCondition());
                cond.getExps().add(AcitivityGraphUtils.buildExp("qrId", ActExpOpType.IN.getType(), markIds));
            }
        }
        if (cond != null) {
            triggers.add(cond);
        }
    }

    private List<Op> buildOps(List<RecommendContentDto> contents) {
        ArrayList ops = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(contents)) {
            for (RecommendContentDto dto : contents) {
                for (AutoReplyMsgDto msgDto : dto.getMsg()) {
                    HashMap context = Maps.newHashMap();
                    context.put("content", JacksonUtil.obj2Str((Object)msgDto));
                    ops.add(AcitivityGraphUtils.buildOp(3, context));
                }
            }
        }
        return ops;
    }

    @Override
    public List<RecommendListResp> list(RecommendListReq req) {
        log.info("query recommend list with req={}, operatorId={}", (Object)req, (Object)LoginUtils.getCurrentUserId());
        StopWatchDto timer = new StopWatchDto("recommandList", true, log);
        timer.start("getCurrentManagerAppIds");
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        timer.stop();
        if (CollectionUtils.isEmpty(managerAppIds)) {
            timer.print();
            return Collections.emptyList();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{req.getAppId()})) {
            if (!managerAppIds.contains(req.getAppId())) {
                timer.print();
                return Collections.emptyList();
            }
            managerAppIds = Collections.singletonList(req.getAppId());
        }
        PageDto pageDto = req.getPageDto();
        RecommendQueryParam queryParam = RecommendQueryParam.builder().appIds(managerAppIds).bizId(LoginUtils.getCurrentUserBizId()).query(req.getQuery()).pageDto(pageDto).build();
        timer.start("queryList");
        List recommendList = this.recommendMapper.queryList(queryParam);
        timer.stop();
        if (CollectionUtils.isEmpty((Collection)recommendList)) {
            if (pageDto != null) {
                pageDto.setCount(Integer.valueOf(0));
                pageDto.setCurPageCount(Integer.valueOf(0));
            }
            timer.print();
            return Collections.emptyList();
        }
        if (pageDto != null) {
            timer.start("count");
            pageDto.setCount(this.recommendMapper.count(queryParam));
            timer.stop();
            pageDto.setCurPageCount(Integer.valueOf(recommendList.size()));
        }
        timer.start("queryByAppIds");
        Map<String, OfficialAccount> officialAccountMap = this.officialAccountService.queryByAppIds(managerAppIds);
        timer.stop();
        StatisticReqDto reqDto = new StatisticReqDto();
        List<Long> graphIds = recommendList.stream().map(a -> a.getGraphId()).collect(Collectors.toList());
        timer.start("graphStatistics");
        List<GraphStatisticRespDto> data = this.opRecordService.graphStatistics(LoginUtils.getCurrentUserBizId().toString(), graphIds);
        timer.stop();
        HashMap statMap = Maps.newHashMap();
        statMap.putAll(data.stream().collect(Collectors.toMap(a -> a.getGraphId(), Function.identity())));
        ArrayList result = Lists.newArrayList();
        recommendList.forEach(a -> result.add(this.buildRecommendListResp((OfficialWiseRecommend)a, officialAccountMap, statMap)));
        timer.print();
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        log.info("del recommend with id={}, operatorId={}", (Object)id, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        OfficialWiseRecommend recommend = (OfficialWiseRecommend)this.recommendMapper.selectByPrimaryKey((Object)id);
        if (recommend == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672c\u5730\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        Long endTime = Optional.ofNullable(recommend.getEndTime()).map(a -> a.getTime()).orElse(Long.MAX_VALUE);
        if (new Date().getTime() <= endTime && recommend.getStatus() != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u63a8\u9001\u5904\u4e8e\u5f00\u542f\u72b6\u6001\u4e14\u5728\u6709\u6548\u671f\u5185\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        recommend.setIsDel(Integer.valueOf(1));
        recommend.setUpdatorId(LoginUtils.getCurrentUserId());
        this.recommendMapper.updateByPrimaryKeySelective((Object)recommend);
        this.graphDefineService.del(recommend.getGraphId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(Long id, Integer status) {
        log.info("change recommend status with id={}, status={}, operatorId={}", new Object[]{id, status, LoginUtils.getCurrentUserId()});
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        Preconditions.checkArgument((RecommendStatus.getByValue(status) != null ? 1 : 0) != 0, (Object)"status is null");
        OfficialWiseRecommend recommend = this.checkRecommend(id);
        recommend.setStatus(status);
        recommend.setUpdatorId(LoginUtils.getCurrentUserId());
        this.recommendMapper.updateByPrimaryKeySelective((Object)recommend);
        this.graphDefineService.changeStatus(this.mapStatus(status, recommend), recommend.getGraphId());
    }

    @Override
    public void activityCallBack(RecommendActivityDto activityDto) {
        SendResult sendResult;
        OfficialWiseRecommend recommend;
        log.info("activity callback with activityDto={}", (Object)activityDto);
        if (activityDto == null || !activityDto.validate()) {
            log.warn("\u6d41\u7a0b\u64cd\u4f5c\u53c2\u6570\u4e0d\u5408\u6cd5");
            return;
        }
        Long activityId = activityDto.getGraphId();
        if (activityId == null || (recommend = this.recommendMapper.getByGraphId(activityId)) == null) {
            log.warn("graphId={} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u63a8\u9001\u89c4\u5219", (Object)activityId);
            this.opRecordService.callBack(activityDto.getOpId(), OpStatus.FAIL.getStatus(), "\u6d41\u7a0b\u5bf9\u5e94\u7684\u89c4\u5219\u4e0d\u5b58\u5728");
            return;
        }
        if (3 == activityDto.getOpConfId() && (sendResult = this.responseMsg(activityDto, recommend)) != null) {
            this.opRecordService.callBack(activityDto.getOpId(), sendResult.getStatus(), sendResult.getMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendResult responseMsg(RecommendActivityDto activityDto, OfficialWiseRecommend recommend) {
        Map<String, String> context = activityDto.getContext();
        String appId = context.get("appId");
        String openId = context.get("openId");
        String content = context.get("content");
        String nickname = context.get("nickname");
        Long bizId = recommend.getBizId();
        String corpId = recommend.getCorpId();
        activityDto.setCorpId(recommend.getCorpId());
        String lockKey = String.format("recommend_%s_%s", appId, openId);
        try {
            int settingNum;
            this.lock.lock(lockKey, "", 100, 60L, 50L);
            OfficialWiseRecommendRecord recommendFans = new OfficialWiseRecommendRecord();
            recommendFans.setOpRecordId(activityDto.getOpId());
            int fansOpRecordCount = this.recommendRecordMapper.selectCount((Object)recommendFans);
            if (fansOpRecordCount > 0) {
                log.warn("\u64cd\u4f5copRecordId={} \u6d88\u606f\u8bb0\u5f55\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u91cd\u590d\u64cd\u4f5c", (Object)activityDto.getOpId());
                SendResult sendResult = null;
                return sendResult;
            }
            if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)openId) || StringUtils.isBlank((CharSequence)content)) {
                log.warn("\u4e0d\u5408\u6cd5\u7684\u4fe1\u606f:{}", context);
                this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), "\u53c2\u6570\u4e0d\u5408\u6cd5");
                SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), "\u53c2\u6570\u4e0d\u5408\u6cd5");
                return sendResult;
            }
            OfficialAccountFans fans = this.fansService.queryByFansId(appId, openId);
            if (fans != null && fans.getIsInBlacklist() == 1) {
                log.warn("\u7c89\u4e1d\u88ab\u62c9\u9ed1\uff0c\u4e0d\u8fdb\u884c\u667a\u80fd\u63a8\u9001\uff1a{}", context);
                this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u88ab\u62c9\u9ed1");
                SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u88ab\u62c9\u9ed1");
                return sendResult;
            }
            if (this.servantSessionService.getServingConversation(appId, openId) != null) {
                log.warn("\u7c89\u4e1d\u6b63\u5728\u88ab\u63a5\u5f85\uff0c\u4e0d\u8fdb\u884c\u667a\u80fd\u63a8\u9001\uff1a{}", context);
                this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u6b63\u5728\u88ab\u63a5\u5f85");
                SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u6b63\u5728\u88ab\u63a5\u5f85");
                return sendResult;
            }
            Date now = new Date();
            int count = this.recommendRecordMapper.countByFansAndDate(appId, openId, DateUtil.getStartOfDay((Date)now), DateUtil.getEndOfDay((Date)now));
            if (count >= (settingNum = this.settingService.getIntegerOrDefault(recommend.getBizId(), SystemParamName.WISE_RECOMMEND_NUM_PER_DAY.getKey(), Integer.valueOf(10)).intValue())) {
                log.info("\u7c89\u4e1d\u5f53\u5929\u53ef\u63a5\u6536\u7684\u63a8\u8350\u6761\u6570\u4e3a{}\u6761\uff0c\u5df2\u53d1\u9001{}\u6761\uff0c\u4e0d\u518d\u63a8\u9001", (Object)settingNum, (Object)count);
                this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u5f53\u65e5\u63a5\u6536\u6761\u6570\u8d85\u8fc7\u9650\u5236");
                SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), "\u7c89\u4e1d\u5f53\u65e5\u63a5\u6536\u6761\u6570\u8d85\u8fc7\u9650\u5236");
                return sendResult;
            }
            AutoReplyMsgDto msgDto = (AutoReplyMsgDto)JacksonUtil.str2Obj((String)content, AutoReplyMsgDto.class);
            if (msgDto.getType().intValue() == AutoReplyMessageType.TEXT.getValue()) {
                msgDto.setContent(this.handleTextMsgContent(msgDto.getContent(), nickname));
            }
            if (this.logicAutoReplyService.send(msgDto, appId, openId, bizId, corpId)) {
                this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.SUCCESS.getStatus(), "");
                SendResult sendResult = new SendResult(OpStatus.SUCCESS.getStatus(), "");
                return sendResult;
            }
            this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), "\u56de\u590d\u5931\u8d25");
            SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), "\u56de\u590d\u5931\u8d25");
            return sendResult;
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5931\u8d25", (Throwable)e);
            this.recordRecommend(appId, openId, recommend.getId(), content, activityDto, OpStatus.FAIL.getStatus(), e.getMessage());
            SendResult sendResult = new SendResult(OpStatus.FAIL.getStatus(), e.getMessage());
            return sendResult;
        }
        finally {
            this.lock.unlock(lockKey);
        }
    }

    private String handleTextMsgContent(String content, String nickname) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{content})) {
            Pattern pattern = Pattern.compile("\\$\\{([a-z]+)}");
            Matcher m = pattern.matcher(content);
            HashSet formats = Sets.newHashSet();
            while (m.find()) {
                formats.add(m.group(1));
            }
            if (CollectionUtils.isNotEmpty((Collection)formats)) {
                for (String format : formats) {
                    if (!MsgContentFormat.NICKNAME.getValue().equals(format)) continue;
                    return content.replaceAll(MsgContentFormat.NICKNAME.getReplaceRegex(), StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nickname}) ? nickname : "");
                }
            }
        }
        return content;
    }

    private void recordRecommend(String appId, String openId, Long recommendId, String pushContent, RecommendActivityDto activityDto, Integer opStatus, String errorMsg) {
        OfficialWiseRecommendRecord recommendRecord = new OfficialWiseRecommendRecord();
        recommendRecord.setAppId(appId);
        recommendRecord.setBizId(activityDto.getBizId());
        recommendRecord.setCorpId(activityDto.getCorpId());
        recommendRecord.setOpenId(openId);
        recommendRecord.setWiseRecommendId(recommendId);
        recommendRecord.setOpTime(new Date());
        recommendRecord.setRecommendContent(pushContent);
        recommendRecord.setBehaviorType(Optional.ofNullable(RecommendConf.getBehaviorType(activityDto.getBehaviorConfId())).map(BehaviorType::getValue).orElse(0));
        recommendRecord.setCallbackContext(JacksonUtil.obj2Str(activityDto.getContext()));
        recommendRecord.setOpRecordId(activityDto.getOpId());
        recommendRecord.setOpConfId(activityDto.getOpConfId());
        recommendRecord.setOpStatus(opStatus);
        recommendRecord.setErrorMsg(errorMsg);
        this.recommendRecordMapper.insertSelective((Object)recommendRecord);
    }

    private OfficialWiseRecommend checkRecommend(Long id) {
        OfficialWiseRecommend recommend = (OfficialWiseRecommend)this.recommendMapper.selectByPrimaryKey((Object)id);
        if (recommend == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672c\u5730\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (!managerAppIds.contains(recommend.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u516c\u4f17\u53f7\u7ba1\u7406\u5458\uff0c\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        return recommend;
    }

    private Integer mapStatus(Integer status, OfficialWiseRecommend recommend) {
        RecommendStatus openStatus = RecommendStatus.getByValue(status);
        if (openStatus == RecommendStatus.FORBIDDEN) {
            return ActivityStatus.FORBBIDEN.getStatus();
        }
        if (openStatus == RecommendStatus.NORMAL && recommend.getIsPermanent() == 0) {
            Date now = new Date();
            Date beginTime = recommend.getBeginTime();
            Date endTime = recommend.getEndTime();
            if (now.before(beginTime)) {
                return ActivityStatus.WAIT.getStatus();
            }
            if (now.after(endTime)) {
                return ActivityStatus.EXPIRED.getStatus();
            }
        }
        return ActivityStatus.PROCESSING.getStatus();
    }

    private RecommendListResp buildRecommendListResp(OfficialWiseRecommend recommend, Map<String, OfficialAccount> officialAccountMap, Map<Long, GraphStatisticRespDto> statMap) {
        RecommendListResp resp = new RecommendListResp();
        this.buildCommonFields(recommend, resp, officialAccountMap.get(recommend.getAppId()));
        resp.setOpenStatus(EnumConstant.from((EnumService)RecommendStatus.getByValue(recommend.getStatus())));
        GraphStatisticRespDto graphStat = statMap.get(recommend.getGraphId());
        resp.setMsgNum(Optional.ofNullable(graphStat).map(a -> a.getFrequency()).orElse(0));
        resp.setPeopleNum(Optional.ofNullable(graphStat).map(a -> a.getNumber()).orElse(0));
        return resp;
    }

    private void buildCommonFields(OfficialWiseRecommend recommend, RecommendBaseDto resp, OfficialAccount app) {
        if (app != null) {
            resp.setAppInfo(new AppIdAndNameDto(app.getAppId(), app.getNickName(), app.getHeadImg()));
        }
        resp.setId(recommend.getId());
        resp.setBeginTime(recommend.getBeginTime());
        resp.setEndTime(recommend.getEndTime());
        resp.setTheme(recommend.getTheme());
        resp.setRepeatable(recommend.getRepeatable());
        resp.setUnlimitedTrigger(TriggerWay.ALL.name().equals(recommend.getTriggerCondition()) ? 1 : 0);
        resp.setBehaviorType(EnumConstant.from((EnumService)BehaviorType.getByValue(recommend.getBehaviorType())));
        resp.setIsPermanent(recommend.getIsPermanent());
        resp.setCondition(recommend.getConditionDisplay());
        this.checkCondition(recommend, resp);
    }

    private void checkCondition(OfficialWiseRecommend recommend, RecommendBaseDto resp) {
        try {
            if (!recommend.getTriggerCondition().equals(TriggerWay.ALL.name())) {
                if (BehaviorType.CLICK_MENU.getValue() == recommend.getBehaviorType().intValue()) {
                    MenuInfo menuInfo = (MenuInfo)JacksonUtil.str2Obj((String)recommend.getConditionDisplay(), MenuInfo.class);
                    AppIdReq req = new AppIdReq();
                    req.setAppId(recommend.getAppId());
                    req.setOperatorId(LoginUtils.getCurrentUserId());
                    List<MenuInfo> menuInfos = this.menuManageService.flatAllEventMenu(req);
                    if (CollectionUtils.isNotEmpty(menuInfos)) {
                        List keyMatchedMenuInfo = menuInfos.stream().filter(a -> a.getKey().equalsIgnoreCase(menuInfo.getKey())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(keyMatchedMenuInfo)) {
                            resp.setCondition(null);
                        } else {
                            List keyAndPathMatchedMenuInfo = keyMatchedMenuInfo.stream().filter(a -> a.getPath().equalsIgnoreCase(menuInfo.getPath())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(keyAndPathMatchedMenuInfo)) {
                                resp.setCondition(JacksonUtil.obj2Str(keyMatchedMenuInfo.get(0)));
                            } else {
                                resp.setCondition(JacksonUtil.obj2Str(keyAndPathMatchedMenuInfo.get(0)));
                            }
                        }
                    }
                } else if (BehaviorType.SCAN_QR.getValue() == recommend.getBehaviorType().intValue()) {
                    IdsReq dto = (IdsReq)JacksonUtil.str2Obj((String)recommend.getConditionDisplay(), IdsReq.class);
                    List<Long> ids = dto.getIds();
                    List<OfficialChannelQrcode> channelQrcodes = this.channelQrcodeService.queryByIds(ids);
                    Set qrIds = channelQrcodes.stream().map(a -> a.getId()).collect(Collectors.toSet());
                    ids.retainAll(qrIds);
                    resp.setCondition(JacksonUtil.obj2Str((Object)dto));
                }
            } else {
                resp.setCondition("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OfficialWiseRecommend buildRecommendRule(RecommendAddOrModReq req) {
        OfficialWiseRecommend recommend = new OfficialWiseRecommend();
        recommend.setAppId(req.getAppId());
        recommend.setTheme(req.getTheme());
        recommend.setBehaviorType(req.getBehaviorType());
        recommend.setBizId(LoginUtils.getCurrentUserBizId());
        recommend.setCorpId(LoginUtils.getCurrentUserCorpId());
        recommend.setBeginTime(req.getBeginTime());
        recommend.setEndTime(req.getEndTime());
        recommend.setContent(JacksonUtil.obj2Str(req.getContentList()));
        if (req.getBehaviorType().intValue() == BehaviorType.ALL.getValue() || req.getUnlimitedTrigger() != null && req.getUnlimitedTrigger() == 1) {
            recommend.setTriggerCondition(TriggerWay.ALL.name());
            recommend.setConditionDisplay("");
        } else {
            recommend.setConditionDisplay(Optional.ofNullable(req.getCondition()).orElse(""));
            this.setTriggerCondition(recommend, req.getCondition(), req.getBehaviorType());
        }
        recommend.setIsPermanent(req.getIsPermanent());
        recommend.setRepeatable(req.getRepeatable());
        if (req.getId() == null) {
            recommend.setCreateTime(new Date());
            recommend.setCreatorId(LoginUtils.getCurrentUserId());
            recommend.setStatus(req.getStatus());
        }
        recommend.setUpdatorId(LoginUtils.getCurrentUserId());
        recommend.setUpdateTime(new Date());
        return recommend;
    }

    private void setTriggerCondition(OfficialWiseRecommend recommend, String condition, Integer behaviorType) {
        if (BehaviorType.CLICK_MENU.getValue() == behaviorType.intValue()) {
            MenuInfo menuInfo = null;
            try {
                menuInfo = (MenuInfo)JacksonUtil.str2Obj((String)condition, MenuInfo.class);
            }
            catch (IOException e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u6761\u4ef6\u9519\u8bef");
            }
            recommend.setTriggerCondition(menuInfo.getKey());
        } else if (BehaviorType.SCAN_QR.getValue() == behaviorType.intValue()) {
            IdsReq dto = null;
            try {
                dto = (IdsReq)JacksonUtil.str2Obj((String)condition, IdsReq.class);
            }
            catch (IOException e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u6761\u4ef6\u9519\u8bef");
            }
            HashSet qrIds = Sets.newHashSet(dto.getIds());
            List<OfficialChannelQrcode> channelQrcodes = this.channelQrcodeService.queryByIds(qrIds);
            if (CollectionUtils.isEmpty(channelQrcodes) || channelQrcodes.size() < qrIds.size()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u542b\u6709\u4e0d\u5b58\u5728\u7684\u6e20\u9053\u4e8c\u7ef4\u7801");
            }
            recommend.setTriggerCondition(Joiner.on((String)",").skipNulls().join((Iterable)channelQrcodes.stream().map(OfficialChannelQrcode::getMarkId).collect(Collectors.toList())));
        }
    }

    @Override
    public List<StatisticDayDto> opStatistic(RecommendStatReq req) {
        log.info("statistic recommend with re={}, operatorId={}", (Object)req, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((req.getBehaviorType() != null ? 1 : 0) != 0, (Object)"\u884c\u4e3a\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getBeginDay() != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getEndDay() != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getId() != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        OfficialWiseRecommend recommend = this.checkRecommend(req.getId());
        StatisticReqDto reqDto = new StatisticReqDto();
        reqDto.setGraphId(recommend.getGraphId());
        reqDto.setBizId(String.valueOf(LoginUtils.getCurrentUserBizId()));
        reqDto.setBeginDay(req.getBeginDay());
        reqDto.setEndDay(req.getEndDay());
        reqDto.setBehaviorConfId(RecommendConf.getBehaviorConfId(req.getBehaviorType()));
        List<StatisticDayDto> data = this.opRecordService.statistics(reqDto.getBizId(), reqDto.getGraphId(), reqDto.getBeginDay(), reqDto.getEndDay(), reqDto.getBehaviorConfId());
        return data;
    }

    @Override
    public void trigger(OfficialAccount account, String openId, Integer behaviorType, String condition) {
        log.info("trigger wise recommend with appId={},openId={},behaviorType={},condition={}", new Object[]{account.getAppId(), openId, behaviorType, condition});
        String appId = account.getAppId();
        OfficialAccountFans fans = this.fansService.queryByFansId(appId, openId);
        if (fans == null) {
            log.warn("\u516c\u4f17\u53f7:{}, \u7c89\u4e1d:{} \u4e0d\u5b58\u5728\u8ba2\u9605\u5173\u7cfb!", (Object)appId, (Object)openId);
            return;
        }
        Behavior behavior = new Behavior();
        behavior.setBehaviorTime(new Date());
        behavior.setBizId(account.getBizId());
        behavior.setCorpId(account.getCorpId());
        behavior.setConfId(RecommendConf.getBehaviorConfId(behaviorType));
        behavior.setObjectId(Joiner.on((String)"_").join((Object)account.getAppId(), (Object)openId, new Object[0]));
        HashMap context = Maps.newHashMap();
        context.put("appId", account.getAppId());
        context.put("openId", openId);
        if (BehaviorType.CLICK_MENU.getValue() == behaviorType.intValue()) {
            context.put("menuKey", condition);
        } else if (BehaviorType.SCAN_QR.getValue() == behaviorType.intValue()) {
            context.put("qrId", condition);
        }
        context.put("nickname", fans.getNickname());
        behavior.setContext(context);
        this.behaviorProcess.process(behavior);
    }

    @Override
    public List<RecommendOpLogResp> opLogs(RecommendStatReq req) throws IOException {
        log.info("query recommend op logs with req={}, operatorId={}", (Object)req, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((req.getId() != null ? 1 : 0) != 0, (Object)"id is null");
        OfficialWiseRecommend recommend = this.checkRecommend(req.getId());
        StatisticReqDto apiParams = new StatisticReqDto();
        apiParams.setBizId(LoginUtils.getCurrentUserBizId().toString());
        apiParams.setGraphId(recommend.getGraphId());
        apiParams.setBeginDay(req.getBeginDay());
        apiParams.setEndDay(req.getEndDay());
        apiParams.setPageDto(req.getPageDto());
        apiParams.setOpStatus(OpStatus.SUCCESS.getStatus());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{req.getQuery()})) {
            HashMap context = Maps.newHashMap();
            context.put("nickname", req.getQuery());
            apiParams.setFuzzyMatchContext(context);
        }
        OpLogRespDto respDto = this.opRecordService.opLogs(apiParams);
        PageDto pageDto = req.getPageDto();
        List<OpLog> opLogs = respDto.getOpLogs();
        if (respDto == null || CollectionUtils.isEmpty(opLogs)) {
            if (pageDto != null) {
                pageDto.setCurPageCount(Integer.valueOf(0));
                pageDto.setCount(Integer.valueOf(0));
            }
            return Collections.emptyList();
        }
        req.setPageDto(respDto.getPageDto());
        ArrayList materialIds = Lists.newArrayList();
        ArrayList officialFissionIds = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (OpLog opLog : opLogs) {
            result.add(this.newRecommendOpLogResp(opLog, recommend, materialIds, officialFissionIds));
        }
        HashMap materialMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)materialIds)) {
            materialMap.putAll(this.commonMaterialService.queryMaterialMap(materialIds));
        }
        HashMap officialFissionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)officialFissionIds)) {
            List actiList = this.officialActiMapper.queryByIds((List)officialFissionIds);
            for (OfficialActi acti : actiList) {
                ActivityDto activityDto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
                officialFissionMap.put(acti.getId(), activityDto);
            }
        }
        this.setRecommendInfo(result, materialMap, officialFissionMap);
        return result;
    }

    private void setRecommendInfo(List<RecommendOpLogResp> list, Map<Long, MaterialResultDto> materialMap, Map<Long, ActivityDto> officialFissionMap) {
        for (RecommendOpLogResp resp : list) {
            ActivityDto activityDto;
            if (resp.getMsgType().intValue() == AutoReplyMessageType.MATERIAL.getValue()) {
                SimpleMaterialDto material = resp.getMaterial();
                Long materialId = material.getId();
                MaterialResultDto materialDto = materialMap.get(materialId);
                if (materialDto == null) continue;
                material.setTitle(materialDto.getTitle());
                material.setType(materialDto.getmType());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialDto.getTranscodeUrl()})) {
                    material.setUrl(materialDto.getTranscodeUrl());
                } else {
                    material.setUrl(materialDto.getUrl());
                }
                if (!materialDto.getmType().equals(MaterialType.NEWS.getValue())) continue;
                ArrayList newsMaterialRespList = Lists.newArrayList();
                List subNews = materialDto.getSubNews();
                subNews.forEach(news -> newsMaterialRespList.add(new NewsMaterialResp(news.getId(), news.getTitle(), news.getAuthor(), news.getCover(), news.getDigest(), news.getContent())));
                resp.setNewsMaterialInfo(newsMaterialRespList);
                continue;
            }
            if (resp.getMsgType().intValue() != AutoReplyMessageType.OFFICIAL_FISSION.getValue() || (activityDto = officialFissionMap.get(Long.parseLong(resp.getMessage()))) == null) continue;
            HashMap map = Maps.newHashMap();
            map.put("autoResp", activityDto.getAutoResp());
            map.put("cover", activityDto.getCover());
            map.put("actiName", activityDto.getName());
            resp.setMessage(JacksonUtil.obj2Str((Object)map));
        }
    }

    @Override
    public RecommendDetailResp detail(Long id) {
        log.info("query recommend detail with id={},operatorId={}", (Object)id, (Object)LoginUtils.getCurrentUserId());
        OfficialWiseRecommend recommend = this.checkRecommend(id);
        RecommendDetailResp resp = new RecommendDetailResp();
        OfficialAccount app = this.officialAccountService.queryByAppId(recommend.getAppId());
        this.buildCommonFields(recommend, resp, app);
        try {
            resp.setContentList(JacksonUtil.str2List((String)recommend.getContent(), RecommendContentDto.class));
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u5185\u5bb9\u89e3\u6790\u5f02\u5e38");
        }
        return resp;
    }

    private RecommendOpLogResp newRecommendOpLogResp(OpLog opLog, OfficialWiseRecommend recommend, List<Long> materialIds, List<Long> officialFissionIds) throws IOException {
        RecommendOpLogResp resp = new RecommendOpLogResp();
        Map behaviorContext = opLog.getOpContext();
        if (MapUtils.isNotEmpty((Map)behaviorContext)) {
            resp.setNickname((String)behaviorContext.get("nickname"));
        }
        resp.setUuid(UUID.randomUUID().toString());
        resp.setBehaviorTime(opLog.getBehaviorTime());
        resp.setBehaviorType(EnumConstant.from((EnumService)RecommendConf.getBehaviorType(opLog.getBehaviorConfId())));
        resp.setCondition(recommend.getConditionDisplay());
        resp.setSendTime(opLog.getOpTime());
        if (opLog.getOpConfId() == 3) {
            Map opContext = opLog.getOpContext();
            String msgJson = (String)opContext.get("content");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgJson})) {
                AutoReplyMsgDto msgDto = (AutoReplyMsgDto)JacksonUtil.str2Obj((String)msgJson, AutoReplyMsgDto.class);
                resp.setMsgType(msgDto.getType());
                if (msgDto.getType().intValue() == AutoReplyMessageType.MATERIAL.getValue()) {
                    Long materialId = Long.parseLong(msgDto.getContent());
                    materialIds.add(materialId);
                    SimpleMaterialDto dto = new SimpleMaterialDto();
                    dto.setId(materialId);
                    resp.setMaterial(dto);
                } else if (msgDto.getType().intValue() == AutoReplyMessageType.TEXT.getValue()) {
                    resp.setMessage(this.handleTextMsgContent(msgDto.getContent(), resp.getNickname()));
                } else if (msgDto.getType().intValue() == AutoReplyMessageType.OFFICIAL_FISSION.getValue()) {
                    resp.setMessage(msgDto.getContent());
                    officialFissionIds.add(Long.parseLong(msgDto.getContent()));
                } else if (msgDto.getType().intValue() == AutoReplyMessageType.TEMPLATE_MSG.getValue()) {
                    resp.setMessage(msgDto.getContent());
                } else if (msgDto.getType().intValue() == AutoReplyMessageType.NEWS.getValue()) {
                    resp.setMessage(msgDto.getContent());
                }
            }
        }
        return resp;
    }
}

