/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.common.component.DistributedLock;
import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.dto.Op;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityMode;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityStatus;
import cn.kinyun.scrm.weixin.recommend.common.enums.OpStatus;
import cn.kinyun.scrm.weixin.recommend.common.enums.RepeatableEnum;
import cn.kinyun.scrm.weixin.recommend.common.enums.SysBehavior;
import cn.kinyun.scrm.weixin.recommend.common.utils.GraphUtils;
import cn.kinyun.scrm.weixin.recommend.dto.BehaviorMatchResult;
import cn.kinyun.scrm.weixin.recommend.dto.GraphInstanceInfo;
import cn.kinyun.scrm.weixin.recommend.dto.RecommendActivityDto;
import cn.kinyun.scrm.weixin.recommend.service.ActivityService;
import cn.kinyun.scrm.weixin.recommend.service.BehaviorMatchService;
import cn.kinyun.scrm.weixin.recommend.service.BehaviorProcess;
import cn.kinyun.scrm.weixin.recommend.service.BehaviorRecordService;
import cn.kinyun.scrm.weixin.recommend.service.ConfService;
import cn.kinyun.scrm.weixin.recommend.service.GraphDefineService;
import cn.kinyun.scrm.weixin.recommend.service.OpRecordService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.scrm.dal.activity.entity.Activity;
import com.kuaike.scrm.dal.activity.entity.ActivityGraph;
import com.kuaike.scrm.dal.activity.entity.BehaviorConf;
import com.kuaike.scrm.dal.activity.entity.BehaviorMatch;
import com.kuaike.scrm.dal.activity.entity.OpRecord;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BehaviorProcessImpl
implements BehaviorProcess {
    private static final Logger log = LoggerFactory.getLogger(BehaviorProcessImpl.class);
    @Autowired
    BehaviorRecordService behaviorRecordService;
    @Autowired
    GraphDefineService graphDefineService;
    @Autowired
    ActivityService activityService;
    @Autowired
    BehaviorMatchService behaviorMatchService;
    @Autowired
    OpRecordService opRecordService;
    @Autowired
    DistributedLock distributedLock;
    @Autowired
    ConfService confService;
    @Value(value="${spring.redis.key.prefix}")
    String prefix;
    @Autowired
    private RecommendService recommendService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void process(Behavior behavior) {
        block16: {
            log.info("process behavior with behavior={}", (Object)behavior);
            boolean isActivityBehavior = false;
            String objectKey = String.format("%s-%s", this.prefix, behavior.getObjectId());
            try {
                int maxPriory;
                this.distributedLock.lock(objectKey);
                int graphPriority = -1;
                int activityPriority = -1;
                List<ActivityGraph> graphList = this.graphDefineService.matchBehavior(behavior);
                List<Activity> activityList = this.activityService.matchBehavior(behavior);
                if (CollectionUtils.isNotEmpty(graphList)) {
                    graphPriority = graphList.get(0).getPriority();
                    isActivityBehavior = true;
                }
                if (CollectionUtils.isNotEmpty(activityList)) {
                    activityPriority = activityList.get(0).getPriority();
                    isActivityBehavior = true;
                }
                if (isActivityBehavior) {
                    this.behaviorRecordService.addBehavior(behavior);
                }
                if ((maxPriory = Integer.max(graphPriority, activityPriority)) == graphPriority && CollectionUtils.isNotEmpty(graphList)) {
                    Set<Long> graphIds = graphList.stream().map(a -> a.getId()).collect(Collectors.toSet());
                    Map hasInstance = this.activityService.hasInstance(graphIds, behavior.getObjectId()).stream().collect(Collectors.toMap(a -> a.getGraphId(), Function.identity()));
                    for (ActivityGraph actGraph : graphList) {
                        this.dealWithActGraph(actGraph, behavior, (GraphInstanceInfo)hasInstance.get(actGraph.getId()));
                    }
                }
                if (maxPriory != activityPriority || !CollectionUtils.isNotEmpty(activityList)) break block16;
                List<String> lockKeys = activityList.stream().map(a -> String.format("%s%d", this.prefix, a.getId())).collect(Collectors.toList());
                try {
                    this.distributedLock.multiLock(lockKeys);
                    for (Activity activity : activityList) {
                        this.dealWithActivity(activity, behavior);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.distributedLock.unlockMultiLock(lockKeys);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            finally {
                this.distributedLock.unlock(objectKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTimeOutBehavior() {
        log.info("processTimeOutBehavior task start");
        List<Activity> activityList = this.activityService.queryListWithTimeoutbehavior();
        if (CollectionUtils.isNotEmpty(activityList)) {
            List<String> lockKeys = activityList.stream().map(a -> a.getId().toString()).collect(Collectors.toList());
            try {
                this.distributedLock.multiLock(lockKeys);
                for (Activity activity : activityList) {
                    this.dealWithActivityTimeout(activity);
                }
            }
            catch (InterruptedException e) {
                log.error("process timeOut behavior error: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.distributedLock.unlockMultiLock(lockKeys);
            }
        }
        log.info("processTimeOutBehavior task end");
    }

    @Transactional(rollbackFor={Exception.class})
    public void dealWithActivityTimeout(Activity activity) {
        log.info("dealWithActivityTimeout, activityContent={}", (Object)activity.getActContent());
        Graph graph = (Graph)JSONObject.parseObject((String)activity.getActContent(), Graph.class);
        Date now = new Date();
        Node node = graph.getNode(graph.getNearestNodeId());
        Behavior behavior = new Behavior();
        behavior.setBizId(activity.getBizId());
        behavior.setCorpId(activity.getCorpId());
        behavior.setConfId(SysBehavior.TIME_OUT.getId());
        behavior.setBehaviorTime(now);
        behavior.setContext(Maps.newHashMap());
        behavior.getContext().put(SysBehavior.TIME_OUT.getField(), String.valueOf((now.getTime() - node.getActivationTime().getTime()) / 1000L));
        if (this.activityService.matchActivity(this.activityService.getActivity(activity.getId()), behavior)) {
            behavior.setObjectId(activity.getObjectId());
            this.behaviorRecordService.addBehavior(behavior);
            BehaviorMatchResult matchResult = GraphUtils.match(graph, behavior);
            if (matchResult != null) {
                if (matchResult.getNode() != null) {
                    this.op(graph.getContext(), matchResult.getNode(), activity, behavior, matchResult.getFromId());
                    graph.setNearestNodeId(matchResult.getNode().getId());
                    matchResult.getNode().setActivationTime(new Date());
                    matchResult.getNode().setStatus(ActivityStatus.FINISHED.getStatus());
                    if (!graph.hasNextNode(matchResult.getNode().getId())) {
                        activity.setActStatus(Integer.valueOf(ActivityStatus.FINISHED.getStatus()));
                    }
                }
                this.updateFromGraph(activity, graph);
                this.activityService.updateActivity(activity);
                this.behaviorMatchService.addBahaviorMatch(behavior.getBizId(), activity.getCorpId(), behavior.getId(), behavior.getConfId(), behavior.getObjectId(), activity.getGraphId(), activity.getId(), matchResult.getFromId(), matchResult.getToId());
            }
        }
    }

    private Behavior getOpBehaior(Node node, Integer fromNodeId, Behavior behavior, Long activityId) {
        if (behavior.getConfId().intValue() != SysBehavior.TIME_OUT.getId()) {
            return behavior;
        }
        Map<Integer, BehaviorConf> map = this.confService.getBehaviorMap();
        Map<Integer, List<BehaviorMatch>> matchGroup = this.behaviorMatchService.matchRecord(activityId).stream().collect(Collectors.groupingBy(a -> a.getToId()));
        List<BehaviorMatch> matchList = matchGroup.get(fromNodeId);
        while (CollectionUtils.isNotEmpty(matchList)) {
            int nodeId = 0;
            for (BehaviorMatch behaviorMatch : matchList) {
                nodeId = behaviorMatch.getFromId();
                if (behaviorMatch.getConfId().intValue() == SysBehavior.TIME_OUT.getId()) continue;
                Behavior result = new Behavior();
                result.setId(behaviorMatch.getRecordId());
                result.setConfId(behaviorMatch.getConfId());
                return result;
            }
            matchList = matchGroup.get(nodeId);
        }
        return null;
    }

    private void dealWithActivity(Activity activity, Behavior behavior) {
        Graph graph;
        BehaviorMatchResult matchResult;
        if (this.activityService.matchActivity(this.activityService.getActivity(activity.getId()), behavior) && (matchResult = GraphUtils.match(graph = (Graph)JSONObject.parseObject((String)activity.getActContent(), Graph.class), behavior)) != null) {
            if (matchResult.getNode() != null) {
                this.op(graph.getContext(), matchResult.getNode(), activity, behavior, matchResult.getFromId());
                graph.setNearestNodeId(matchResult.getNode().getId());
                matchResult.getNode().setActivationTime(new Date());
                matchResult.getNode().setStatus(ActivityStatus.FINISHED.getStatus());
                if (!graph.hasNextNode(matchResult.getNode().getId())) {
                    activity.setActStatus(Integer.valueOf(ActivityStatus.FINISHED.getStatus()));
                }
            }
            this.updateFromGraph(activity, graph);
            this.activityService.updateActivity(activity);
            this.behaviorMatchService.addBahaviorMatch(behavior.getBizId(), activity.getCorpId(), behavior.getId(), behavior.getConfId(), behavior.getObjectId(), activity.getGraphId(), activity.getId(), matchResult.getFromId(), matchResult.getToId());
        }
    }

    private void dealWithActGraph(ActivityGraph actGraph, Behavior behavior, GraphInstanceInfo instanceInfo) {
        boolean hasInstance = Optional.ofNullable(instanceInfo).map(a -> a.isHavingInstance()).orElse(false);
        boolean hasActiveInstance = Optional.ofNullable(instanceInfo).map(a -> a.isHavingActiveInstance()).orElse(false);
        if (actGraph.getRepeatable().intValue() == RepeatableEnum.UNREPEATABLE.getType() && hasInstance) {
            return;
        }
        if (actGraph.getActivityMode() != null && actGraph.getActivityMode().intValue() == ActivityMode.SINGLE.getValue() && hasActiveInstance) {
            return;
        }
        Graph graph = (Graph)JSONObject.parseObject((String)actGraph.getActContent(), Graph.class);
        BehaviorMatchResult matchResult = GraphUtils.match(graph, behavior);
        if (matchResult != null) {
            if (matchResult.getNode() != null) {
                graph.setNearestNodeId(matchResult.getNode().getId());
                matchResult.getNode().setActivationTime(new Date());
                matchResult.getNode().setStatus(ActivityStatus.FINISHED.getStatus());
            }
            if (graph.getContext() == null) {
                graph.setContext(Maps.newHashMap());
            }
            graph.getContext().putAll(behavior.getContext());
            Activity activity = this.buildFromGraph(actGraph, graph, behavior);
            this.activityService.addActivity(activity);
            if (matchResult.getNode() != null) {
                this.op(graph.getContext(), matchResult.getNode(), activity, behavior, matchResult.getFromId());
            }
            this.behaviorMatchService.addBahaviorMatch(behavior.getBizId(), activity.getCorpId(), behavior.getId(), behavior.getConfId(), behavior.getObjectId(), actGraph.getId(), activity.getId(), matchResult.getFromId(), matchResult.getToId());
        }
    }

    private Activity buildFromGraph(ActivityGraph actGraph, Graph graph, Behavior behavior) {
        Activity activity = new Activity();
        activity.setBizId(actGraph.getBizId());
        activity.setCorpId(actGraph.getCorpId());
        activity.setGraphId(actGraph.getId());
        activity.setObjectId(behavior.getObjectId());
        activity.setPriority(Integer.valueOf(actGraph.getPriority()));
        if (actGraph.getActivityEffectivePeriod() != null) {
            activity.setExpireTime(DateUtil.getDiffDateTime((Date)new Date(), (int)actGraph.getActivityEffectivePeriod().intValue(), (int)13));
        }
        if (CollectionUtils.isNotEmpty(graph.getEdges())) {
            activity.setActStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
        } else {
            activity.setActStatus(Integer.valueOf(ActivityStatus.FINISHED.getStatus()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(",");
        if (graph.getNearestNodeId() != null) {
            List<Condition> conditions = graph.filterConditions(graph.getNearestNodeId());
            boolean timeTrigger = false;
            for (Condition condition : conditions) {
                sb.append(condition.getBehaviorConfId()).append(",");
                if (condition.getBehaviorConfId() != SysBehavior.TIME_OUT.getId()) continue;
                timeTrigger = true;
                activity.setTimeTrigger(Integer.valueOf(1));
                if (!CollectionUtils.isNotEmpty(condition.getExps()) || !CollectionUtils.isNotEmpty(condition.getExps().get(0).getValues())) continue;
                int secDiff = Integer.valueOf(condition.getExps().get(0).getValues().get(0));
                Node node = graph.getNode(graph.getNearestNodeId());
                Date timeOut = DateUtil.getDiffDateTime((Date)node.getActivationTime(), (int)secDiff, (int)13);
                activity.setTimeOut(timeOut);
            }
            if (!timeTrigger) {
                activity.setTimeTrigger(Integer.valueOf(0));
            }
        } else {
            boolean timeTrigger = false;
            for (Condition condition : graph.getTriggers()) {
                sb.append(condition.getBehaviorConfId()).append(",");
                if (condition.getBehaviorConfId() != SysBehavior.TIME_OUT.getId()) continue;
                timeTrigger = true;
                activity.setTimeTrigger(Integer.valueOf(1));
                if (!CollectionUtils.isNotEmpty(condition.getExps()) || !CollectionUtils.isNotEmpty(condition.getExps().get(0).getValues())) continue;
                int secDiff = Integer.valueOf(condition.getExps().get(0).getValues().get(0));
                Node node = graph.getNode(graph.getNearestNodeId());
                Date timeOut = DateUtil.getDiffDateTime((Date)node.getActivationTime(), (int)secDiff, (int)13);
                activity.setTimeOut(timeOut);
            }
            if (!timeTrigger) {
                activity.setTimeTrigger(Integer.valueOf(0));
            }
        }
        activity.setTriggerBehaviors(sb.toString());
        activity.setActContent(JSONObject.toJSONString((Object)graph));
        return activity;
    }

    private Activity updateFromGraph(Activity activity, Graph graph) {
        StringBuilder sb = new StringBuilder();
        sb.append(",");
        if (graph.getNearestNodeId() != null) {
            List<Condition> conditions = graph.filterConditions(graph.getNearestNodeId());
            boolean timeTrigger = false;
            for (Condition condition : conditions) {
                sb.append(condition.getBehaviorConfId()).append(",");
                if (condition.getBehaviorConfId() != SysBehavior.TIME_OUT.getId()) continue;
                timeTrigger = true;
                activity.setTimeTrigger(Integer.valueOf(1));
                if (!CollectionUtils.isNotEmpty(condition.getExps()) || !CollectionUtils.isNotEmpty(condition.getExps().get(0).getValues())) continue;
                int secDiff = Integer.valueOf(condition.getExps().get(0).getValues().get(0));
                Node node = graph.getNode(graph.getNearestNodeId());
                Date timeOut = DateUtil.getDiffDateTime((Date)node.getActivationTime(), (int)secDiff, (int)13);
                activity.setTimeOut(timeOut);
            }
            if (!timeTrigger) {
                activity.setTimeTrigger(Integer.valueOf(0));
            }
        } else {
            boolean timeTrigger = false;
            for (Condition condition : graph.getTriggers()) {
                sb.append(condition.getBehaviorConfId()).append(",");
                if (condition.getBehaviorConfId() != SysBehavior.TIME_OUT.getId()) continue;
                activity.setTimeTrigger(Integer.valueOf(1));
                timeTrigger = true;
                if (!CollectionUtils.isNotEmpty(condition.getExps()) || !CollectionUtils.isNotEmpty(condition.getExps().get(0).getValues())) continue;
                int secDiff = Integer.valueOf(condition.getExps().get(0).getValues().get(0));
                Node node = graph.getNode(graph.getNearestNodeId());
                Date timeOut = DateUtil.getDiffDateTime((Date)node.getActivationTime(), (int)secDiff, (int)13);
                activity.setTimeOut(timeOut);
            }
            if (!timeTrigger) {
                activity.setTimeTrigger(Integer.valueOf(0));
            }
        }
        activity.setTriggerBehaviors(sb.toString());
        activity.setActContent(JSONObject.toJSONString((Object)graph));
        return activity;
    }

    private void op(Map<String, String> context, Node node, Activity activity, Behavior behavior, int fromNodeId) {
        RecommendActivityDto activityDto = new RecommendActivityDto();
        activityDto.setBizId(activity.getBizId());
        activityDto.setCorpId(activity.getCorpId());
        activityDto.setActivityId(activity.getId());
        activityDto.setGraphId(activity.getGraphId());
        if (CollectionUtils.isNotEmpty(node.getOps())) {
            Behavior triggerBehavior = this.getOpBehaior(node, fromNodeId, behavior, activity.getId());
            int now = Integer.parseInt(DateUtil.getDayStr((Date)new Date()));
            for (Op op : node.getOps()) {
                HashMap allContext = Maps.newHashMap();
                allContext.putAll(context);
                if (op.getContext() != null) {
                    allContext.putAll(op.getContext());
                }
                OpRecord opRecord = this.build(activity, node, triggerBehavior, op, allContext, now);
                activityDto.setOpId(opRecord.getId());
                activityDto.setOpConfId(op.getConfId());
                activityDto.setBehaviorConfId(opRecord.getBehaviorConfId());
                allContext.putAll(context);
                if (op.getContext() != null) {
                    allContext.putAll(op.getContext());
                }
                activityDto.setContext(allContext);
                try {
                    this.recommendService.activityCallBack(activityDto);
                }
                catch (IOException e) {
                    log.error("recommend service activity callback error: ", (Throwable)e);
                }
            }
        }
    }

    private OpRecord build(Activity activity, Node node, Behavior triggerBehavior, Op op, Map<String, String> context, int now) {
        OpRecord record = new OpRecord();
        record.setActivityId(activity.getId());
        record.setBizId(activity.getBizId());
        record.setCorpId(activity.getCorpId());
        record.setGraphId(activity.getGraphId());
        record.setNodeId(Integer.valueOf(node.getId()));
        record.setObjectId(activity.getObjectId());
        record.setBehaviorId(triggerBehavior == null ? null : Long.valueOf(triggerBehavior.getId()));
        record.setBehaviorConfId(triggerBehavior == null ? null : triggerBehavior.getConfId());
        record.setConfId(Integer.valueOf(op.getConfId()));
        record.setOpContext(JSONObject.toJSONString(context));
        record.setOpStatus(Integer.valueOf(OpStatus.WAITING.getStatus()));
        record.setOpDay(Integer.valueOf(now));
        this.opRecordService.insert(record);
        return record;
    }
}

