/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.dto.req;

import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityStatus;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.activity.entity.ActivityGraph;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GraphModReq
implements Serializable {
    private static final long serialVersionUID = -3948721333034224805L;
    private SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Long id;
    private Long bizId;
    private Graph actGraph;
    private Date beginTime;
    private Date endTime;
    private Date expiredTime;
    private int permanent;
    private int repeatable;
    private int priority;
    private int activityMode;
    private Long activityPeriodTime;

    public void validate() {
        if (this.permanent == 0) {
            Preconditions.checkArgument((this.beginTime != null ? 1 : 0) != 0, (Object)"beginTime is null!");
            Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)"endTime is null!");
        }
        Preconditions.checkArgument((this.bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Graph.validateGraph(this.actGraph);
    }

    public ActivityGraph to(ActivityGraph graph) {
        if (graph == null) {
            graph = new ActivityGraph();
        }
        graph.setId(this.id);
        graph.setBizId(this.bizId);
        graph.setPermanent(Integer.valueOf(this.permanent));
        graph.setPriority(Integer.valueOf(this.priority));
        graph.setBeginTime(this.beginTime);
        graph.setEndTime(this.endTime);
        graph.setActivityEffectivePeriod(this.activityPeriodTime);
        graph.setActContent(JSONObject.toJSONString((Object)this.actGraph));
        graph.setRepeatable(Integer.valueOf(this.repeatable));
        graph.setActivityMode(Integer.valueOf(this.activityMode));
        StringBuilder sb = new StringBuilder();
        sb.append(",");
        for (Condition condition : this.actGraph.getTriggers()) {
            sb.append(condition.getBehaviorConfId()).append(",");
        }
        graph.setTriggerBehaviors(sb.toString());
        if (this.permanent == 0) {
            Date now = new Date();
            if (this.beginTime.after(now)) {
                graph.setGraphStatus(Integer.valueOf(ActivityStatus.WAIT.getStatus()));
            } else if (this.endTime.after(now)) {
                graph.setGraphStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
            } else if (this.expiredTime != null && this.expiredTime.before(now)) {
                graph.setGraphStatus(Integer.valueOf(ActivityStatus.EXPIRED.getStatus()));
            } else {
                graph.setGraphStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
            }
        } else if (this.permanent == 1) {
            graph.setGraphStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
        }
        return graph;
    }

    public SimpleDateFormat getSf() {
        return this.sf;
    }

    public Long getId() {
        return this.id;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Graph getActGraph() {
        return this.actGraph;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getExpiredTime() {
        return this.expiredTime;
    }

    public int getPermanent() {
        return this.permanent;
    }

    public int getRepeatable() {
        return this.repeatable;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getActivityMode() {
        return this.activityMode;
    }

    public Long getActivityPeriodTime() {
        return this.activityPeriodTime;
    }

    public void setSf(SimpleDateFormat sf) {
        this.sf = sf;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setActGraph(Graph actGraph) {
        this.actGraph = actGraph;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setExpiredTime(Date expiredTime) {
        this.expiredTime = expiredTime;
    }

    public void setPermanent(int permanent) {
        this.permanent = permanent;
    }

    public void setRepeatable(int repeatable) {
        this.repeatable = repeatable;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setActivityMode(int activityMode) {
        this.activityMode = activityMode;
    }

    public void setActivityPeriodTime(Long activityPeriodTime) {
        this.activityPeriodTime = activityPeriodTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphModReq)) {
            return false;
        }
        GraphModReq other = (GraphModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPermanent() != other.getPermanent()) {
            return false;
        }
        if (this.getRepeatable() != other.getRepeatable()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.getActivityMode() != other.getActivityMode()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$activityPeriodTime = this.getActivityPeriodTime();
        Long other$activityPeriodTime = other.getActivityPeriodTime();
        if (this$activityPeriodTime == null ? other$activityPeriodTime != null : !((Object)this$activityPeriodTime).equals(other$activityPeriodTime)) {
            return false;
        }
        SimpleDateFormat this$sf = this.getSf();
        SimpleDateFormat other$sf = other.getSf();
        if (this$sf == null ? other$sf != null : !((Object)this$sf).equals(other$sf)) {
            return false;
        }
        Graph this$actGraph = this.getActGraph();
        Graph other$actGraph = other.getActGraph();
        if (this$actGraph == null ? other$actGraph != null : !((Object)this$actGraph).equals(other$actGraph)) {
            return false;
        }
        Date this$beginTime = this.getBeginTime();
        Date other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Date this$expiredTime = this.getExpiredTime();
        Date other$expiredTime = other.getExpiredTime();
        return !(this$expiredTime == null ? other$expiredTime != null : !((Object)this$expiredTime).equals(other$expiredTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphModReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPermanent();
        result = result * 59 + this.getRepeatable();
        result = result * 59 + this.getPriority();
        result = result * 59 + this.getActivityMode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $activityPeriodTime = this.getActivityPeriodTime();
        result = result * 59 + ($activityPeriodTime == null ? 43 : ((Object)$activityPeriodTime).hashCode());
        SimpleDateFormat $sf = this.getSf();
        result = result * 59 + ($sf == null ? 43 : ((Object)$sf).hashCode());
        Graph $actGraph = this.getActGraph();
        result = result * 59 + ($actGraph == null ? 43 : ((Object)$actGraph).hashCode());
        Date $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Date $expiredTime = this.getExpiredTime();
        result = result * 59 + ($expiredTime == null ? 43 : ((Object)$expiredTime).hashCode());
        return result;
    }

    public String toString() {
        return "GraphModReq(sf=" + this.getSf() + ", id=" + this.getId() + ", bizId=" + this.getBizId() + ", actGraph=" + this.getActGraph() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", expiredTime=" + this.getExpiredTime() + ", permanent=" + this.getPermanent() + ", repeatable=" + this.getRepeatable() + ", priority=" + this.getPriority() + ", activityMode=" + this.getActivityMode() + ", activityPeriodTime=" + this.getActivityPeriodTime() + ")";
    }
}

