/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.utils;

import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.enums.Relation;
import cn.kinyun.scrm.weixin.recommend.common.utils.MatchUtils;
import cn.kinyun.scrm.weixin.recommend.dto.BehaviorMatchResult;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class GraphUtils {
    public static BehaviorMatchResult match(Graph graph, Behavior behavior) {
        BehaviorMatchResult bebaviorResult = new BehaviorMatchResult();
        if (graph.getNearestNodeId() == null) {
            for (Condition condition : graph.getTriggers()) {
                if (!MatchUtils.match(null, condition, behavior)) continue;
                if (graph.getMatchBehaviors() == null) {
                    graph.setMatchBehaviors(Lists.newArrayList());
                    graph.setMatchTriggers(Lists.newArrayList());
                }
                graph.getMatchBehaviors().add(behavior);
                graph.getMatchTriggers().add(condition);
                break;
            }
            graph.getTriggers().removeAll(graph.getMatchTriggers());
            bebaviorResult.setToId(graph.getStartNodeId());
            if (graph.getConditionRelation() == Relation.OR.getType()) {
                bebaviorResult.setNode(graph.getNode(graph.getStartNodeId()));
                return bebaviorResult;
            }
            if (CollectionUtils.isEmpty(graph.getTriggers())) {
                bebaviorResult.setNode(graph.getNode(graph.getStartNodeId()));
                return bebaviorResult;
            }
            bebaviorResult.setToId(graph.getStartNodeId());
            return bebaviorResult;
        }
        Map nodeMap = graph.getNodes().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        List<Edge> edgeList = graph.filterEdges(graph.getNearestNodeId());
        if (CollectionUtils.isNotEmpty(edgeList)) {
            for (Edge edge : edgeList) {
                boolean flag = false;
                for (Condition condition : edge.getConditions()) {
                    if (!MatchUtils.match(null, condition, behavior)) continue;
                    if (edge.getMatchBehaviors() == null) {
                        edge.setMatchBehaviors(Lists.newArrayList());
                        edge.setMatchConditions(Lists.newArrayList());
                    }
                    edge.getMatchBehaviors().add(behavior);
                    edge.getMatchConditions().add(condition);
                    flag = true;
                    break;
                }
                if (!flag) continue;
                edge.getConditions().removeAll(edge.getMatchConditions());
                if (CollectionUtils.isNotEmpty(edge.getConditions())) {
                    bebaviorResult.setToId(edge.getToNodeId());
                } else {
                    bebaviorResult.setToId(edge.getToNodeId());
                    bebaviorResult.setNode((Node)nodeMap.get(edge.getToNodeId()));
                }
                bebaviorResult.setFromId(edge.getFromNodeId());
                return bebaviorResult;
            }
        }
        return null;
    }
}

